#pragma once
#include <finance-enums/common.hpp>
#include <finance-enums/helpers/enum.hpp>
#include <finance-enums/helpers/exports.hpp>
#include <iostream>
#include <vector>

using namespace std;

namespace finance_enums {

// https://en.wikipedia.org/wiki/ISO_3166-1
static str_t CountryStandard = "ISO3166";

str_t inline country_standard() { return CountryStandard; }

enum class LIB_EXPORT CountryCode {
  AD,
  AE,
  AF,
  AG,
  AI,
  AL,
  AM,
  AO,
  AQ,
  AR,
  AS,
  AT,
  AU,
  AW,
  AX,
  AZ,
  BA,
  BB,
  BD,
  BE,
  BF,
  BG,
  BH,
  BI,
  BJ,
  BL,
  BM,
  BN,
  BO,
  BQ,
  BR,
  BS,
  BT,
  BV,
  BW,
  BY,
  BZ,
  CA,
  CC,
  CD,
  CF,
  CG,
  CH,
  CI,
  CK,
  CL,
  CM,
  CN,
  CO,
  CR,
  CU,
  CV,
  CW,
  CX,
  CY,
  CZ,
  DE,
  DJ,
  DK,
  DM,
  DO,
  DZ,
  EC,
  EE,
  EG,
  EH,
  ER,
  ES,
  ET,
  FI,
  FJ,
  FK,
  FM,
  FO,
  FR,
  GA,
  GB,
  GD,
  GE,
  GF,
  GG,
  GH,
  GI,
  GL,
  GM,
  GN,
  GP,
  GQ,
  GR,
  GS,
  GT,
  GU,
  GW,
  GY,
  HK,
  HM,
  HN,
  HR,
  HT,
  HU,
  ID,
  IE,
  IL,
  IM,
  IN,
  IO,
  IQ,
  IR,
  IS,
  IT,
  JE,
  JM,
  JO,
  JP,
  KE,
  KG,
  KH,
  KI,
  KM,
  KN,
  KP,
  KR,
  KW,
  KY,
  KZ,
  LA,
  LB,
  LC,
  LI,
  LK,
  LR,
  LS,
  LT,
  LU,
  LV,
  LY,
  MA,
  MC,
  MD,
  ME,
  MF,
  MG,
  MH,
  MK,
  ML,
  MM,
  MN,
  MO,
  MP,
  MQ,
  MR,
  MS,
  MT,
  MU,
  MV,
  MW,
  MX,
  MY,
  MZ,
  NA,
  NC,
  NE,
  NF,
  NG,
  NI,
  NL,
  NO,
  NP,
  NR,
  NU,
  NZ,
  OM,
  PA,
  PE,
  PF,
  PG,
  PH,
  PK,
  PL,
  PM,
  PN,
  PR,
  PS,
  PT,
  PW,
  PY,
  QA,
  RE,
  RO,
  RS,
  RU,
  RW,
  SA,
  SB,
  SC,
  SD,
  SE,
  SG,
  SH,
  SI,
  SJ,
  SK,
  SL,
  SM,
  SN,
  SO,
  SR,
  SS,
  ST,
  SV,
  SX,
  SY,
  SZ,
  TC,
  TD,
  TF,
  TG,
  TH,
  TJ,
  TK,
  TL,
  TM,
  TN,
  TO,
  TR,
  TT,
  TV,
  TW,
  TZ,
  UA,
  UG,
  UM,
  US,
  UY,
  UZ,
  VA,
  VC,
  VE,
  VG,
  VI,
  VN,
  VU,
  WF,
  WS,
  XX, // INVALID
  YE,
  YT,
  ZA,
  ZM,
  ZW,
};

static const std::vector<str_t> CountryCode_names = {
  "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB",
  "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY",
  "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX",
  "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK",
  "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS",
  "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR",
  "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA",
  "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK",
  "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE",
  "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM",
  "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG",
  "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TF",
  "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY",
  "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "XX", "YE", "YT", "ZA", "ZM", "ZW",
};
static std::unordered_map<str_t, CountryCode> _CountryCode_mapping = {
  {"AD", CountryCode::AD},
  {"AE", CountryCode::AE},
  {"AF", CountryCode::AF},
  {"AG", CountryCode::AG},
  {"AI", CountryCode::AI},
  {"AL", CountryCode::AL},
  {"AM", CountryCode::AM},
  {"AO", CountryCode::AO},
  {"AQ", CountryCode::AQ},
  {"AR", CountryCode::AR},
  {"AS", CountryCode::AS},
  {"AT", CountryCode::AT},
  {"AU", CountryCode::AU},
  {"AW", CountryCode::AW},
  {"AX", CountryCode::AX},
  {"AZ", CountryCode::AZ},
  {"BA", CountryCode::BA},
  {"BB", CountryCode::BB},
  {"BD", CountryCode::BD},
  {"BE", CountryCode::BE},
  {"BF", CountryCode::BF},
  {"BG", CountryCode::BG},
  {"BH", CountryCode::BH},
  {"BI", CountryCode::BI},
  {"BJ", CountryCode::BJ},
  {"BL", CountryCode::BL},
  {"BM", CountryCode::BM},
  {"BN", CountryCode::BN},
  {"BO", CountryCode::BO},
  {"BQ", CountryCode::BQ},
  {"BR", CountryCode::BR},
  {"BS", CountryCode::BS},
  {"BT", CountryCode::BT},
  {"BV", CountryCode::BV},
  {"BW", CountryCode::BW},
  {"BY", CountryCode::BY},
  {"BZ", CountryCode::BZ},
  {"CA", CountryCode::CA},
  {"CC", CountryCode::CC},
  {"CD", CountryCode::CD},
  {"CF", CountryCode::CF},
  {"CG", CountryCode::CG},
  {"CH", CountryCode::CH},
  {"CI", CountryCode::CI},
  {"CK", CountryCode::CK},
  {"CL", CountryCode::CL},
  {"CM", CountryCode::CM},
  {"CN", CountryCode::CN},
  {"CO", CountryCode::CO},
  {"CR", CountryCode::CR},
  {"CU", CountryCode::CU},
  {"CV", CountryCode::CV},
  {"CW", CountryCode::CW},
  {"CX", CountryCode::CX},
  {"CY", CountryCode::CY},
  {"CZ", CountryCode::CZ},
  {"DE", CountryCode::DE},
  {"DJ", CountryCode::DJ},
  {"DK", CountryCode::DK},
  {"DM", CountryCode::DM},
  {"DO", CountryCode::DO},
  {"DZ", CountryCode::DZ},
  {"EC", CountryCode::EC},
  {"EE", CountryCode::EE},
  {"EG", CountryCode::EG},
  {"EH", CountryCode::EH},
  {"ER", CountryCode::ER},
  {"ES", CountryCode::ES},
  {"ET", CountryCode::ET},
  {"FI", CountryCode::FI},
  {"FJ", CountryCode::FJ},
  {"FK", CountryCode::FK},
  {"FM", CountryCode::FM},
  {"FO", CountryCode::FO},
  {"FR", CountryCode::FR},
  {"GA", CountryCode::GA},
  {"GB", CountryCode::GB},
  {"GD", CountryCode::GD},
  {"GE", CountryCode::GE},
  {"GF", CountryCode::GF},
  {"GG", CountryCode::GG},
  {"GH", CountryCode::GH},
  {"GI", CountryCode::GI},
  {"GL", CountryCode::GL},
  {"GM", CountryCode::GM},
  {"GN", CountryCode::GN},
  {"GP", CountryCode::GP},
  {"GQ", CountryCode::GQ},
  {"GR", CountryCode::GR},
  {"GS", CountryCode::GS},
  {"GT", CountryCode::GT},
  {"GU", CountryCode::GU},
  {"GW", CountryCode::GW},
  {"GY", CountryCode::GY},
  {"HK", CountryCode::HK},
  {"HM", CountryCode::HM},
  {"HN", CountryCode::HN},
  {"HR", CountryCode::HR},
  {"HT", CountryCode::HT},
  {"HU", CountryCode::HU},
  {"ID", CountryCode::ID},
  {"IE", CountryCode::IE},
  {"IL", CountryCode::IL},
  {"IM", CountryCode::IM},
  {"IN", CountryCode::IN},
  {"IO", CountryCode::IO},
  {"IQ", CountryCode::IQ},
  {"IR", CountryCode::IR},
  {"IS", CountryCode::IS},
  {"IT", CountryCode::IT},
  {"JE", CountryCode::JE},
  {"JM", CountryCode::JM},
  {"JO", CountryCode::JO},
  {"JP", CountryCode::JP},
  {"KE", CountryCode::KE},
  {"KG", CountryCode::KG},
  {"KH", CountryCode::KH},
  {"KI", CountryCode::KI},
  {"KM", CountryCode::KM},
  {"KN", CountryCode::KN},
  {"KP", CountryCode::KP},
  {"KR", CountryCode::KR},
  {"KW", CountryCode::KW},
  {"KY", CountryCode::KY},
  {"KZ", CountryCode::KZ},
  {"LA", CountryCode::LA},
  {"LB", CountryCode::LB},
  {"LC", CountryCode::LC},
  {"LI", CountryCode::LI},
  {"LK", CountryCode::LK},
  {"LR", CountryCode::LR},
  {"LS", CountryCode::LS},
  {"LT", CountryCode::LT},
  {"LU", CountryCode::LU},
  {"LV", CountryCode::LV},
  {"LY", CountryCode::LY},
  {"MA", CountryCode::MA},
  {"MC", CountryCode::MC},
  {"MD", CountryCode::MD},
  {"ME", CountryCode::ME},
  {"MF", CountryCode::MF},
  {"MG", CountryCode::MG},
  {"MH", CountryCode::MH},
  {"MK", CountryCode::MK},
  {"ML", CountryCode::ML},
  {"MM", CountryCode::MM},
  {"MN", CountryCode::MN},
  {"MO", CountryCode::MO},
  {"MP", CountryCode::MP},
  {"MQ", CountryCode::MQ},
  {"MR", CountryCode::MR},
  {"MS", CountryCode::MS},
  {"MT", CountryCode::MT},
  {"MU", CountryCode::MU},
  {"MV", CountryCode::MV},
  {"MW", CountryCode::MW},
  {"MX", CountryCode::MX},
  {"MY", CountryCode::MY},
  {"MZ", CountryCode::MZ},
  {"NA", CountryCode::NA},
  {"NC", CountryCode::NC},
  {"NE", CountryCode::NE},
  {"NF", CountryCode::NF},
  {"NG", CountryCode::NG},
  {"NI", CountryCode::NI},
  {"NL", CountryCode::NL},
  {"NO", CountryCode::NO},
  {"NP", CountryCode::NP},
  {"NR", CountryCode::NR},
  {"NU", CountryCode::NU},
  {"NZ", CountryCode::NZ},
  {"OM", CountryCode::OM},
  {"PA", CountryCode::PA},
  {"PE", CountryCode::PE},
  {"PF", CountryCode::PF},
  {"PG", CountryCode::PG},
  {"PH", CountryCode::PH},
  {"PK", CountryCode::PK},
  {"PL", CountryCode::PL},
  {"PM", CountryCode::PM},
  {"PN", CountryCode::PN},
  {"PR", CountryCode::PR},
  {"PS", CountryCode::PS},
  {"PT", CountryCode::PT},
  {"PW", CountryCode::PW},
  {"PY", CountryCode::PY},
  {"QA", CountryCode::QA},
  {"RE", CountryCode::RE},
  {"RO", CountryCode::RO},
  {"RS", CountryCode::RS},
  {"RU", CountryCode::RU},
  {"RW", CountryCode::RW},
  {"SA", CountryCode::SA},
  {"SB", CountryCode::SB},
  {"SC", CountryCode::SC},
  {"SD", CountryCode::SD},
  {"SE", CountryCode::SE},
  {"SG", CountryCode::SG},
  {"SH", CountryCode::SH},
  {"SI", CountryCode::SI},
  {"SJ", CountryCode::SJ},
  {"SK", CountryCode::SK},
  {"SL", CountryCode::SL},
  {"SM", CountryCode::SM},
  {"SN", CountryCode::SN},
  {"SO", CountryCode::SO},
  {"SR", CountryCode::SR},
  {"SS", CountryCode::SS},
  {"ST", CountryCode::ST},
  {"SV", CountryCode::SV},
  {"SX", CountryCode::SX},
  {"SY", CountryCode::SY},
  {"SZ", CountryCode::SZ},
  {"TC", CountryCode::TC},
  {"TD", CountryCode::TD},
  {"TF", CountryCode::TF},
  {"TG", CountryCode::TG},
  {"TH", CountryCode::TH},
  {"TJ", CountryCode::TJ},
  {"TK", CountryCode::TK},
  {"TL", CountryCode::TL},
  {"TM", CountryCode::TM},
  {"TN", CountryCode::TN},
  {"TO", CountryCode::TO},
  {"TR", CountryCode::TR},
  {"TT", CountryCode::TT},
  {"TV", CountryCode::TV},
  {"TW", CountryCode::TW},
  {"TZ", CountryCode::TZ},
  {"UA", CountryCode::UA},
  {"UG", CountryCode::UG},
  {"UM", CountryCode::UM},
  {"US", CountryCode::US},
  {"UY", CountryCode::UY},
  {"UZ", CountryCode::UZ},
  {"VA", CountryCode::VA},
  {"VC", CountryCode::VC},
  {"VE", CountryCode::VE},
  {"VG", CountryCode::VG},
  {"VI", CountryCode::VI},
  {"VN", CountryCode::VN},
  {"VU", CountryCode::VU},
  {"WF", CountryCode::WF},
  {"WS", CountryCode::WS},
  {"XX", CountryCode::XX}, // INVALID
  {"YE", CountryCode::YE},
  {"YT", CountryCode::YT},
  {"ZA", CountryCode::ZA},
  {"ZM", CountryCode::ZM},
  {"ZW", CountryCode::ZW},
};

ENUM_FROM_STRING(CountryCode)
ENUM_TO_STRING(CountryCode)

enum class LIB_EXPORT CountryCode3 {
  AND,
  ARE,
  AFG,
  ATG,
  AIA,
  ALB,
  ARM,
  AGO,
  ATA,
  ARG,
  ASM,
  AUT,
  AUS,
  ABW,
  ALA,
  AZE,
  BIH,
  BRB,
  BGD,
  BEL,
  BFA,
  BGR,
  BHR,
  BDI,
  BEN,
  BLM,
  BMU,
  BRN,
  BOL,
  BES,
  BRA,
  BHS,
  BTN,
  BVT,
  BWA,
  BLR,
  BLZ,
  CAN,
  CCK,
  COD,
  CAF,
  COG,
  CHE,
  CIV,
  COK,
  CHL,
  CMR,
  CHN,
  COL,
  CRI,
  CUB,
  CPV,
  CUW,
  CXR,
  CYP,
  CZE,
  DEU,
  DJI,
  DNK,
  DMA,
  DOM,
  DZA,
  ECU,
  EST,
  EGY,
  ESH,
  ERI,
  ESP,
  ETH,
  FIN,
  FJI,
  FLK,
  FSM,
  FRO,
  FRA,
  GAB,
  GBR,
  GRD,
  GEO,
  GUF,
  GGY,
  GHA,
  GIB,
  GRL,
  GMB,
  GIN,
  GLP,
  GNQ,
  GRC,
  SGS,
  GTM,
  GUM,
  GNB,
  GUY,
  HKG,
  HMD,
  HND,
  HRV,
  HTI,
  HUN,
  IDN,
  IRL,
  ISR,
  IMN,
  IND,
  IOT,
  IRQ,
  IRN,
  ISL,
  ITA,
  JEY,
  JAM,
  JOR,
  JPN,
  KEN,
  KGZ,
  KHM,
  KIR,
  COM,
  KNA,
  PRK,
  KOR,
  KWT,
  CYM,
  KAZ,
  LAO,
  LBN,
  LCA,
  LIE,
  LKA,
  LBR,
  LSO,
  LTU,
  LUX,
  LVA,
  LBY,
  MAR,
  MCO,
  MDA,
  MNE,
  MAF,
  MDG,
  MHL,
  MKD,
  MLI,
  MMR,
  MNG,
  MAC,
  MNP,
  MTQ,
  MRT,
  MSR,
  MLT,
  MUS,
  MDV,
  MWI,
  MEX,
  MYS,
  MOZ,
  NAM,
  NCL,
  NER,
  NFK,
  NGA,
  NIC,
  NLD,
  NOR,
  NPL,
  NRU,
  NIU,
  NZL,
  OMN,
  PAN,
  PER,
  PYF,
  PNG,
  PHL,
  PAK,
  POL,
  SPM,
  PCN,
  PRI,
  PSE,
  PRT,
  PLW,
  PRY,
  QAT,
  REU,
  ROU,
  SRB,
  RUS,
  RWA,
  SAU,
  SLB,
  SYC,
  SDN,
  SWE,
  SGP,
  SHN,
  SVN,
  SJM,
  SVK,
  SLE,
  SMR,
  SEN,
  SOM,
  SUR,
  SSD,
  STP,
  SLV,
  SXM,
  SYR,
  SWZ,
  TCA,
  TCD,
  ATF,
  TGO,
  THA,
  TJK,
  TKL,
  TLS,
  TKM,
  TUN,
  TON,
  TUR,
  TTO,
  TUV,
  TWN,
  TZA,
  UKR,
  UGA,
  UMI,
  USA,
  URY,
  UZB,
  VAT,
  VCT,
  VEN,
  VGB,
  VIR,
  VNM,
  VUT,
  WLF,
  WSM,
  XXX,
  YEM,
  MYT,
  ZAF,
  ZMB,
  ZWE,
};

static const std::vector<str_t> CountryCode3_names = {
  "AND", "ARE", "AFG", "ATG", "AIA", "ALB", "ARM", "AGO", "ATA", "ARG", "ASM", "AUT", "AUS", "ABW", "ALA", "AZE", "BIH",
  "BRB", "BGD", "BEL", "BFA", "BGR", "BHR", "BDI", "BEN", "BLM", "BMU", "BRN", "BOL", "BES", "BRA", "BHS", "BTN", "BVT",
  "BWA", "BLR", "BLZ", "CAN", "CCK", "COD", "CAF", "COG", "CHE", "CIV", "COK", "CHL", "CMR", "CHN", "COL", "CRI", "CUB",
  "CPV", "CUW", "CXR", "CYP", "CZE", "DEU", "DJI", "DNK", "DMA", "DOM", "DZA", "ECU", "EST", "EGY", "ESH", "ERI", "ESP",
  "ETH", "FIN", "FJI", "FLK", "FSM", "FRO", "FRA", "GAB", "GBR", "GRD", "GEO", "GUF", "GGY", "GHA", "GIB", "GRL", "GMB",
  "GIN", "GLP", "GNQ", "GRC", "SGS", "GTM", "GUM", "GNB", "GUY", "HKG", "HMD", "HND", "HRV", "HTI", "HUN", "IDN", "IRL",
  "ISR", "IMN", "IND", "IOT", "IRQ", "IRN", "ISL", "ITA", "JEY", "JAM", "JOR", "JPN", "KEN", "KGZ", "KHM", "KIR", "COM",
  "KNA", "PRK", "KOR", "KWT", "CYM", "KAZ", "LAO", "LBN", "LCA", "LIE", "LKA", "LBR", "LSO", "LTU", "LUX", "LVA", "LBY",
  "MAR", "MCO", "MDA", "MNE", "MAF", "MDG", "MHL", "MKD", "MLI", "MMR", "MNG", "MAC", "MNP", "MTQ", "MRT", "MSR", "MLT",
  "MUS", "MDV", "MWI", "MEX", "MYS", "MOZ", "NAM", "NCL", "NER", "NFK", "NGA", "NIC", "NLD", "NOR", "NPL", "NRU", "NIU",
  "NZL", "OMN", "PAN", "PER", "PYF", "PNG", "PHL", "PAK", "POL", "SPM", "PCN", "PRI", "PSE", "PRT", "PLW", "PRY", "QAT",
  "REU", "ROU", "SRB", "RUS", "RWA", "SAU", "SLB", "SYC", "SDN", "SWE", "SGP", "SHN", "SVN", "SJM", "SVK", "SLE", "SMR",
  "SEN", "SOM", "SUR", "SSD", "STP", "SLV", "SXM", "SYR", "SWZ", "TCA", "TCD", "ATF", "TGO", "THA", "TJK", "TKL", "TLS",
  "TKM", "TUN", "TON", "TUR", "TTO", "TUV", "TWN", "TZA", "UKR", "UGA", "UMI", "USA", "URY", "UZB", "VAT", "VCT", "VEN",
  "VGB", "VIR", "VNM", "VUT", "WLF", "WSM", "XXX", "YEM", "MYT", "ZAF", "ZMB", "ZWE",
};

static std::unordered_map<str_t, CountryCode3> _CountryCode3_mapping = {
  {"AND", CountryCode3::AND},
  {"ARE", CountryCode3::ARE},
  {"AFG", CountryCode3::AFG},
  {"ATG", CountryCode3::ATG},
  {"AIA", CountryCode3::AIA},
  {"ALB", CountryCode3::ALB},
  {"ARM", CountryCode3::ARM},
  {"AGO", CountryCode3::AGO},
  {"ATA", CountryCode3::ATA},
  {"ARG", CountryCode3::ARG},
  {"ASM", CountryCode3::ASM},
  {"AUT", CountryCode3::AUT},
  {"AUS", CountryCode3::AUS},
  {"ABW", CountryCode3::ABW},
  {"ALA", CountryCode3::ALA},
  {"AZE", CountryCode3::AZE},
  {"BIH", CountryCode3::BIH},
  {"BRB", CountryCode3::BRB},
  {"BGD", CountryCode3::BGD},
  {"BEL", CountryCode3::BEL},
  {"BFA", CountryCode3::BFA},
  {"BGR", CountryCode3::BGR},
  {"BHR", CountryCode3::BHR},
  {"BDI", CountryCode3::BDI},
  {"BEN", CountryCode3::BEN},
  {"BLM", CountryCode3::BLM},
  {"BMU", CountryCode3::BMU},
  {"BRN", CountryCode3::BRN},
  {"BOL", CountryCode3::BOL},
  {"BES", CountryCode3::BES},
  {"BRA", CountryCode3::BRA},
  {"BHS", CountryCode3::BHS},
  {"BTN", CountryCode3::BTN},
  {"BVT", CountryCode3::BVT},
  {"BWA", CountryCode3::BWA},
  {"BLR", CountryCode3::BLR},
  {"BLZ", CountryCode3::BLZ},
  {"CAN", CountryCode3::CAN},
  {"CCK", CountryCode3::CCK},
  {"COD", CountryCode3::COD},
  {"CAF", CountryCode3::CAF},
  {"COG", CountryCode3::COG},
  {"CHE", CountryCode3::CHE},
  {"CIV", CountryCode3::CIV},
  {"COK", CountryCode3::COK},
  {"CHL", CountryCode3::CHL},
  {"CMR", CountryCode3::CMR},
  {"CHN", CountryCode3::CHN},
  {"COL", CountryCode3::COL},
  {"CRI", CountryCode3::CRI},
  {"CUB", CountryCode3::CUB},
  {"CPV", CountryCode3::CPV},
  {"CUW", CountryCode3::CUW},
  {"CXR", CountryCode3::CXR},
  {"CYP", CountryCode3::CYP},
  {"CZE", CountryCode3::CZE},
  {"DEU", CountryCode3::DEU},
  {"DJI", CountryCode3::DJI},
  {"DNK", CountryCode3::DNK},
  {"DMA", CountryCode3::DMA},
  {"DOM", CountryCode3::DOM},
  {"DZA", CountryCode3::DZA},
  {"ECU", CountryCode3::ECU},
  {"EST", CountryCode3::EST},
  {"EGY", CountryCode3::EGY},
  {"ESH", CountryCode3::ESH},
  {"ERI", CountryCode3::ERI},
  {"ESP", CountryCode3::ESP},
  {"ETH", CountryCode3::ETH},
  {"FIN", CountryCode3::FIN},
  {"FJI", CountryCode3::FJI},
  {"FLK", CountryCode3::FLK},
  {"FSM", CountryCode3::FSM},
  {"FRO", CountryCode3::FRO},
  {"FRA", CountryCode3::FRA},
  {"GAB", CountryCode3::GAB},
  {"GBR", CountryCode3::GBR},
  {"GRD", CountryCode3::GRD},
  {"GEO", CountryCode3::GEO},
  {"GUF", CountryCode3::GUF},
  {"GGY", CountryCode3::GGY},
  {"GHA", CountryCode3::GHA},
  {"GIB", CountryCode3::GIB},
  {"GRL", CountryCode3::GRL},
  {"GMB", CountryCode3::GMB},
  {"GIN", CountryCode3::GIN},
  {"GLP", CountryCode3::GLP},
  {"GNQ", CountryCode3::GNQ},
  {"GRC", CountryCode3::GRC},
  {"SGS", CountryCode3::SGS},
  {"GTM", CountryCode3::GTM},
  {"GUM", CountryCode3::GUM},
  {"GNB", CountryCode3::GNB},
  {"GUY", CountryCode3::GUY},
  {"HKG", CountryCode3::HKG},
  {"HMD", CountryCode3::HMD},
  {"HND", CountryCode3::HND},
  {"HRV", CountryCode3::HRV},
  {"HTI", CountryCode3::HTI},
  {"HUN", CountryCode3::HUN},
  {"IDN", CountryCode3::IDN},
  {"IRL", CountryCode3::IRL},
  {"ISR", CountryCode3::ISR},
  {"IMN", CountryCode3::IMN},
  {"IND", CountryCode3::IND},
  {"IOT", CountryCode3::IOT},
  {"IRQ", CountryCode3::IRQ},
  {"IRN", CountryCode3::IRN},
  {"ISL", CountryCode3::ISL},
  {"ITA", CountryCode3::ITA},
  {"JEY", CountryCode3::JEY},
  {"JAM", CountryCode3::JAM},
  {"JOR", CountryCode3::JOR},
  {"JPN", CountryCode3::JPN},
  {"KEN", CountryCode3::KEN},
  {"KGZ", CountryCode3::KGZ},
  {"KHM", CountryCode3::KHM},
  {"KIR", CountryCode3::KIR},
  {"COM", CountryCode3::COM},
  {"KNA", CountryCode3::KNA},
  {"PRK", CountryCode3::PRK},
  {"KOR", CountryCode3::KOR},
  {"KWT", CountryCode3::KWT},
  {"CYM", CountryCode3::CYM},
  {"KAZ", CountryCode3::KAZ},
  {"LAO", CountryCode3::LAO},
  {"LBN", CountryCode3::LBN},
  {"LCA", CountryCode3::LCA},
  {"LIE", CountryCode3::LIE},
  {"LKA", CountryCode3::LKA},
  {"LBR", CountryCode3::LBR},
  {"LSO", CountryCode3::LSO},
  {"LTU", CountryCode3::LTU},
  {"LUX", CountryCode3::LUX},
  {"LVA", CountryCode3::LVA},
  {"LBY", CountryCode3::LBY},
  {"MAR", CountryCode3::MAR},
  {"MCO", CountryCode3::MCO},
  {"MDA", CountryCode3::MDA},
  {"MNE", CountryCode3::MNE},
  {"MAF", CountryCode3::MAF},
  {"MDG", CountryCode3::MDG},
  {"MHL", CountryCode3::MHL},
  {"MKD", CountryCode3::MKD},
  {"MLI", CountryCode3::MLI},
  {"MMR", CountryCode3::MMR},
  {"MNG", CountryCode3::MNG},
  {"MAC", CountryCode3::MAC},
  {"MNP", CountryCode3::MNP},
  {"MTQ", CountryCode3::MTQ},
  {"MRT", CountryCode3::MRT},
  {"MSR", CountryCode3::MSR},
  {"MLT", CountryCode3::MLT},
  {"MUS", CountryCode3::MUS},
  {"MDV", CountryCode3::MDV},
  {"MWI", CountryCode3::MWI},
  {"MEX", CountryCode3::MEX},
  {"MYS", CountryCode3::MYS},
  {"MOZ", CountryCode3::MOZ},
  {"NAM", CountryCode3::NAM},
  {"NCL", CountryCode3::NCL},
  {"NER", CountryCode3::NER},
  {"NFK", CountryCode3::NFK},
  {"NGA", CountryCode3::NGA},
  {"NIC", CountryCode3::NIC},
  {"NLD", CountryCode3::NLD},
  {"NOR", CountryCode3::NOR},
  {"NPL", CountryCode3::NPL},
  {"NRU", CountryCode3::NRU},
  {"NIU", CountryCode3::NIU},
  {"NZL", CountryCode3::NZL},
  {"OMN", CountryCode3::OMN},
  {"PAN", CountryCode3::PAN},
  {"PER", CountryCode3::PER},
  {"PYF", CountryCode3::PYF},
  {"PNG", CountryCode3::PNG},
  {"PHL", CountryCode3::PHL},
  {"PAK", CountryCode3::PAK},
  {"POL", CountryCode3::POL},
  {"SPM", CountryCode3::SPM},
  {"PCN", CountryCode3::PCN},
  {"PRI", CountryCode3::PRI},
  {"PSE", CountryCode3::PSE},
  {"PRT", CountryCode3::PRT},
  {"PLW", CountryCode3::PLW},
  {"PRY", CountryCode3::PRY},
  {"QAT", CountryCode3::QAT},
  {"REU", CountryCode3::REU},
  {"ROU", CountryCode3::ROU},
  {"SRB", CountryCode3::SRB},
  {"RUS", CountryCode3::RUS},
  {"RWA", CountryCode3::RWA},
  {"SAU", CountryCode3::SAU},
  {"SLB", CountryCode3::SLB},
  {"SYC", CountryCode3::SYC},
  {"SDN", CountryCode3::SDN},
  {"SWE", CountryCode3::SWE},
  {"SGP", CountryCode3::SGP},
  {"SHN", CountryCode3::SHN},
  {"SVN", CountryCode3::SVN},
  {"SJM", CountryCode3::SJM},
  {"SVK", CountryCode3::SVK},
  {"SLE", CountryCode3::SLE},
  {"SMR", CountryCode3::SMR},
  {"SEN", CountryCode3::SEN},
  {"SOM", CountryCode3::SOM},
  {"SUR", CountryCode3::SUR},
  {"SSD", CountryCode3::SSD},
  {"STP", CountryCode3::STP},
  {"SLV", CountryCode3::SLV},
  {"SXM", CountryCode3::SXM},
  {"SYR", CountryCode3::SYR},
  {"SWZ", CountryCode3::SWZ},
  {"TCA", CountryCode3::TCA},
  {"TCD", CountryCode3::TCD},
  {"ATF", CountryCode3::ATF},
  {"TGO", CountryCode3::TGO},
  {"THA", CountryCode3::THA},
  {"TJK", CountryCode3::TJK},
  {"TKL", CountryCode3::TKL},
  {"TLS", CountryCode3::TLS},
  {"TKM", CountryCode3::TKM},
  {"TUN", CountryCode3::TUN},
  {"TON", CountryCode3::TON},
  {"TUR", CountryCode3::TUR},
  {"TTO", CountryCode3::TTO},
  {"TUV", CountryCode3::TUV},
  {"TWN", CountryCode3::TWN},
  {"TZA", CountryCode3::TZA},
  {"UKR", CountryCode3::UKR},
  {"UGA", CountryCode3::UGA},
  {"UMI", CountryCode3::UMI},
  {"USA", CountryCode3::USA},
  {"URY", CountryCode3::URY},
  {"UZB", CountryCode3::UZB},
  {"VAT", CountryCode3::VAT},
  {"VCT", CountryCode3::VCT},
  {"VEN", CountryCode3::VEN},
  {"VGB", CountryCode3::VGB},
  {"VIR", CountryCode3::VIR},
  {"VNM", CountryCode3::VNM},
  {"VUT", CountryCode3::VUT},
  {"WLF", CountryCode3::WLF},
  {"WSM", CountryCode3::WSM},
  {"XXX", CountryCode3::XXX},
  {"YEM", CountryCode3::YEM},
  {"MYT", CountryCode3::MYT},
  {"ZAF", CountryCode3::ZAF},
  {"ZMB", CountryCode3::ZMB},
  {"ZWE", CountryCode3::ZWE},
};

ENUM_FROM_STRING(CountryCode3)
ENUM_TO_STRING(CountryCode3)

CountryCode3 inline CountryCode_to_CountryCode3(CountryCode& code) { return static_cast<CountryCode3>(code); }
CountryCode inline CountryCode3_to_CountryCode(CountryCode3& code) { return static_cast<CountryCode>(code); }

static const vector<str_t> CountryFlags = {
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAXVBMVEXSEDRvOkEAak7WKUrVIELxtsGHQzkzfj7UHD7vp7T54OX+/f30xM7hXnfnaRz/zgDVIUP++Pn////rl6fWJET42t/qjZ7vq7i3Viuaph/WJEXTEzbWJ0jtghXGkxomgcviAAAAVklEQVQY03XORw6AMAxE0SGU0EPvcP9jYqFsjCZv4cWXZRnwIqN8LeY9SWVkVgHyoqzqBq1TZLPrhxGkT/OyAtuuSD9OXPwf9uftPb87jgt2y8Fwof4CGe0LXp2aNUwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAn1BMVEXppSbnfiHneiHjBhPiGBPeYRrkHhXiJRPjOhXjTRfldBnjUBfjNBbjLBTiXxflfhzjZhnjZBjkbxrkfBriZRfiZRrmnSG5dzCXfESrdTjmnyLiaxrhURbjkR2kgTyvgTe7hjHklBziOBThLRTiMRTZihyZiSfZjx3XThzaQhrjERPhcRfjUhnllh/jVRjbWx3fMhfjFBTjLRbieRriNBTDvIBbAAAAA3RSTlPp4eC7Kg8kAAAAXElEQVQY02NgYMQGGBiYmLEBJiRxFlY2LOLsHJxc3Dy8GOJ8/AKCQsIiGOKiYuISklLSGOIysnLyCopKGOLKKqpq6hqaGOJa2jq6evoGmO40NDI2wep+VH/hCAcAtckHktksxBYAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAMFBMVEXOESaaFzYAKGgBKWlIZZNyiKwCKmmwvND///+vvNBWcZtVcJqEl7aDlrZxh6tHZJI1QmCYAAAAOElEQVQI12NgIA4IIoAAgxIQKLs6gygFMCe9ozMJzlnR0bEJzjnR0XEJuwyKHmW/zxDTUOwhDgAAdZIWfkb/TMAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAaVBMVEXQHB8AqVwWrVQZrVMCqltKtkG5yhkDqlsMq1hfujo4s0jc0A1huzkLq1iSwydauTwSrFZbujuRwygRrFbWzw/JzRNZuTwerlEQq1bV0A8TrFWpxx/+1wD/1wCnxyAir1Bkuzh3vjFjujifcOLoAAAAXElEQVQY02NgoBJgxA6QxZkwxJlZgAQrGyuQZGdGEufgBBJc3FxAkocX2Rw+fkZGASBkFBRCMV9YRFRMXEKcX1RSAtVeKWkZWVlZGTkBDPfIKygqyWN1J4r7qQQAYmgD7oPPC0EAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAQlBMVEUAZ8ZVmtlWmtf////+/fn7+Ovn8ej69uf9/Pf69ubZ2LautIvP1Lb7+Oz//v2duWycvF2buG7+/fr59uX6+OpXmtU2HIGUAAAAOklEQVQY02NgoDFgRAAmJDYDMwywsLKxc8B5CHFOLm4eXizifPwCgnxYxIWEOURYEOJIdoki20tjAABHIAICwZQoOQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMAgMAAAD0Vc5rAAAACVBMVEWeMDmxWWH///9esxiOAAAAGUlEQVQI12NgwANCQSCEYRUIrIBRUEE8AAD1fgvvEXjSsQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAPFBMVEXfGiPfHyjmUFbfISrqZWv////iLTTzr7LtjJHypar54OHujpPqZWzqaXDmTVTpYWfmSVHfIiqWOysAfjxSQ00pAAAAMklEQVQY02NgYGBkYmZgYGFFBQwMDGzsHFjFObm4ebCJ8/LxC2ATFwQjGgMhYVRALXEAgwEGmmcNouoAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAABU1BMVEUAAABGCwbTIBFGXSoAejbTIhPVKRrXMybWLyHUIxXYOCrZPzLeWEzYOSzaQzbYNigJCQl+VVDXNynUJRfVKhvdVUnUJhh+jmkJfz1YWFehg3/cTkLeVkvbSj7dUUXcTUKhrJFYqHoGBgZRUVCDW1fkdWvjcGXjcmjgY1jgZFnXNiiDkm9RpHUGfTsQEBCKiolfLCfwtK7oioHYOy7ws61fc0eJwaEPgkINDQ1zc3KEXVjyvrnoiH/gYVXgYlbibGHibmOEk3FztpAOgUFubm2PbGjcTD/ial/hZ1zjc2nrmpPZPC/cTUGPnX1wtI1WVlWxmZbeWk7ibGLfXFDkdGrbRjreW0+xu6VbqX0ZGRl3TEfjcGbmg3nbRzvaRzrcTEB3iGIUhEYBAQFfLCjnhn3ql4/hZVreVUrhZlvqlIwBezdaJiHaQjXaRTjibWLgYFRab0GGNEfHAAAAsklEQVQY02NggABGJghgZoEABrg4Kxs7ByemOBc3Fw8vHz+auICgkLCIKJuYkLgEirikFJO0jKycPJOCIrK4krIKl6qauoamlraOLpK4nr6BoZGmsbqMiamZOZK4haWVtY2tnb2DtaOTM7I5Lq5u7h6eXt4+vn7I5jD4BwQGBWuGhIaFR6C4JzIqOiY2Lj4mOiERRTwpOSU1LT0jM8U0C9W/2Tl2abl5+TkFGOGDK9xQxQEcYB4Qh7LU8AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAjVBMVEX////9+fT67t/++vbrvYPux5b//v335MzwzqPz2rn24sjvzaDkp1neljj46db78eXrv4fVeADYghP//fztxZLbiiLsw47lrGPswov78uf+/Pn68OPhn0rWfAjXfgzgmkDmrWX138L19fPV2M/35c79/f3JzcDa3dT5+fjw8e7V2M7Gyr3P08fl5+DLz8IOWkvGAAAAbElEQVQY02NgoBQwMmETZWZhZUMVYefg5OLm4eVDFeVnFxAEAiFhVGERUUEIEEMVF4eISkhKoYpLy8jKySsoYjhDSZlNhRnEUFZCEVdVU9cAUhrqaqqoGjS1tHUYdLS1NDGMUtXV01VlIBcAAApnB1p8Go3VAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAFVBMVEUAh1HKwiL80RbCdSrycSG6KTToES33NjLHAAAAIElEQVQI12NgAAJGJTBQYKA+h9kFDBzAHNY0MEigLgcAsc8b1oqc6n4AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAe1BMVEUbL0wiNlInOlXR1dooO1ebpLD///+ao7BEVWz7/Pz8/f1HV24dMU3M0dfQ1Np5hZZ4hJUwQlzw8fPy8/QxQ152gpTCyM/+/v7R1duEjp6iqrY+T2eDjp39/f5OXXRKWnHW2d8fMk8eMU7T191/ipuAi5vz9PZJWXD4+Pk/yruNAAAAbElEQVQY023LWRKCQAxF0aBwcUDFbhVlEGfd/wodu7BI7tfLqYpIVyRmg2FsekJq8WjMZKo5mwHzTPmCd3mfl+7jfhWAb269KWC7c787OKVUdSUlfW/2r+e2Uc7hKKcz2rnIFctvd286j7/9BA4EBx5PEZhsAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAATlBMVEXuHCXuICTvLyL3mhHvKiP3jxLxQR/vLCLyURzvJST4ow//+gH+7QP0bRjvLiLzWRv82gb7zAjwPSDuIiTwOiDxQB/1eBb2hxTvKSPwNyEjGS+cAAAAQ0lEQVQY02NggABGBkzABMTMLJjirGxA9ewcaKKcXNw8vAwMfPzoytkEBGGmoQAhYRFOBgZRMQZsQFwCqzCDJMPQBABQIAFYGvdm3AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEX/zQB/fkQAMIeXGETIEC7O58xQAAAAIElEQVQI12NgoB0QRAABBiUEUMDDMUYAAwYXBHDAzQEAyKURcz9mVxIAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABDlBMVEUHOZQVcFwcikJBlEAAIa0HPZEXdVdXmUCZqz0AIqwJRIkYelIei0Fdmz8njUK/tTxFlUAtSLs6U8AAIq0YfFAfikI1kUFZmz/WuzvUuzprnz8nQ7oBI6sLS4IrhUvavDv/xjm1szsuj0EsjkHpwTnXuztqnz9cccsBIq17c3ONqD2Epj4+k0CHpz5ElUC8tTthnT8ii0ICI65xg9FZbsoEJK53cHPJuDtzoT+zsjyHo0Atj0FKlkFUmUBSmEBPl0ADJK5DW8MhPrgwS7wULqPTqk3ZvDrCpk0VNZwPWXQbh0UCI6wcM6ADLKERYG0ciUQJKbAELp8ciENFXcNsf9AFMpsTZ2YciUMGOJUVb14a8NrMAAAAqUlEQVQY02NgYGRCA8wggoGFhZUNVZydAyLOwsnFjRDl4eXjF4CICwoJc4kwMYmK8YAkxCUkpSDi0oIsLDKycvIKikogCWUVVTWwOBCoa7Boamnr6ILE9fQNDJkYjIyBwhompixm5haWVtY2tnb2YPc4OGqwODkD5Vxc3dw9PL2g1oPN0QCb5e3jzcLi6+cPF9cIYEECgX5BUPHgEBYUEBoWDnMPGoiIBACj2hMeX9PcLQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAA0lBMVEVeFh4AAABgFx/KEicoAwcZFAIzKwQlAwfJEyjOESaxDyEMAQIkHgMrJARaSwiWfQ0KAQKuDiCQDBsBAABFOQaReA3kvRTuxhWLCxpdCBEBAQCbgQ7huxT80RZeCBHLESUxDx0ADxoOGhtGSCCFfiXbxS0uEBzJESa7GjUUabcAcsYSabi4GzeZKk4CccSWK1JqQHRrQHTOEifZqbfe7fjarbvOEyjRITT54OP////54+XSJDfYQlP++Pn++vvZRlfjdYHidIDtp6/urbTQHDDvsrjLLe4NAAAApElEQVQY023IhRKCQBSF4V37qFiEBSphK3a34vu/kqwgiPLP3JlzP0JoWBESjbkzThP2OSVTBOnMe2a5XD7HZd+7UAQBSjzbgiiVJVFgk6+AOaqU1oS6rCiKXBdqlDbgeLOlarrRZhm6pna6rqPXH/gNR/g4xqbH5gS+Y+r5DN8+XyydVuuAY7PdsfYHBB3Hk83nC34dV9tv+Hfcdw+EufW0/OcFXgIZ2YtMjaAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA9lBMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBU4kHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAIWneb4HMIDzXUGZvSHUFJGsSMHMMK285ZJURqMESgZQfZW4Qm7NRq8RneqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYI4ZZYAor00p7hFgW0CnbNLqsTdsL7Tg5duY44hPXyipsDnnapIR3w5ZZcNpb5PmW8AobdLqsM3YpRDopULez0AnaRMqcMbN3aaRRW2TwgpbRmESw1udnlseICbRhV8Xhh+clYUMnMpRH1JYYgEJGtcBNjcAAAAi0lEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExZHFxEJCQBJFS7OzSMkAgiykuJ6+gqKQMNkdFVU2dVUNTS1sHaI6unr6BoRFI3NjEFGyvmbmFJTu7lZ61ja0dSJwdBdjrOTg6OWOKu7i6uXt4Yoqze3n7+PphEWf3DwhkxyYO8xcOcQCpXRQhBXIZvAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAaVBMVEUARq5UdHX/0gDdTB/MCS/rwgDHoQqaexTEnwd+XDHNpwd0WR2xVR+qQRmyVh9dTyJ+TieTbxCAUCh4XCH2ywBORx9TXER0byVRYFV8aBh8WA5zZDaXYgyLbhX+0QC0kQtxVie1kgv1ygD1Cp3CAAAAS0lEQVQY02NggABGJghgZoEABsLirGxYxdk5OLnYsYhz8/DycWMR5xcQFBIWwRQXFROXEMaiXlJKWkYWi7icvIKiHFb3K5HmLxRxAEc7BHEfDmPRAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAXVBMVEUZigBVhgBwhQA9iABZhgAgiQBLhwBrhQAziAAiiQCFgwDLfwDqfQDvfQDSfgCMgwAhigB4hAAjigAaiQA0ewKYRgpUPAUJMQB7bQCjgQBDdAPeIBB0EQgAAACxXQBAhysEAAAAP0lEQVQY02NgIA4wMjGzsLKxc6CLc3Jx8/Dy8Qtg0cIuKITVKGEsYiKiomLi4hKSkmjiUtLSMrKycry8Q10cAKV6CWBWGusIAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAQlBMVEXaJR3mbxPbLhz87QLcLhz//wDmbhPjXRb42AX64gT98QLfRBn30AbmbRPztQr64wTpehLxrQvcNBvcMRvvnw3aKB2b5GW5AAAARklEQVQY02NgoD5gxC7MxMyCXTkrG6YgOwcnFysXJwc7ugQ3DysrKw83pg42oDgvFuP5+AX4+bC4RlCIQVgE00WiSCQVAQDlXgGDeHdG3QAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAllBMVEUAJlTv8fT////UMELOESZtYX4TNmHw8vXXP1DSIzZuY38FKlcMMFwiQ2sILVkHLFkSNWCYp7rM1N3AydWSorZ+kagvTnQPM15/kqnV2+NCXoA/XH5vhJ4DKVYgQWnFztiQobWDlazJ0dugrr+aqbvz9ffr7vKJm7AVOGKKm7FuhJ4UN2EpSW8NMV2RobUXOmNjepZKZYbAcZUJAAAAbUlEQVQY02NgYGBgZGJiZmFhZUAHNBVnY2NjZ2Li4OTkwhCHAG4gh4cXCPgwDOQXEBQSFuHjRxcXFROXkJSSlkEXl5WTV1BUEpDFMEhZRVVNWZ0BE2hoamljEdaR0JXV08ciwWBgyIAV8EFdDwA8NwZYKvlnewAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJmRUXEP+ywDZTCDGDDDiAHeyAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAk1BMVEXtHCTyVVvpWVr////C6tUptG2l4ML8/v3x+vU7u3kar2MdsGXX8eT7/vxuzJwVrV8SrF0gsWdgyJPr+PHE6tdPwocGqFUUrV8Cp1IqtW7V8OKt4schsmgNq1oTrV4ttnCZ27n2/Pmg3r6c3LtOwYYAplGJ1q6e3b3p9/Dl9u180aZNwYaF1Kz+//7pWFvsV1vqV1uIj283AAAAXElEQVQY02NgoBJgRAAmJDYDMxywsLKxwzkIcQ5OLm4eTHFePn4BQSFhDHERUTFxCUkpDHFpGX5ZOXkFdHFFJWUVVTV1BQ0MezW1tHV0EfbCXazHyKhvgHA/lQAAzMkGTbzaxBoAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAD1BMVEXtKTnzcHv///9VwOkAod6qmx01AAAAIElEQVQI12NgIAMIIoAAgxICKBDLMUYAAwYXBHAgkgMAec0WNTyZViAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAclBMVEVYfKTm6/H///8RRX4gUYagtcv+/v5TeaLj6fAaTIOQqMP9/v5IcJza4usZTIP8/f0+aJbQ2+YbSH/Hfovrio02PGuwHi7XFBoYRHt7K0nUFRs/Ome4HCoYQ3rVFRtIOGLAGiYdQniIKELWFBpRNl3FGCRTCUILAAAAWklEQVQY023IRxKCQAAEwJVBwiI5jCtZ8f9f5ERBFdPHNubhKQb+M5APhJF+xDaRD7xS/chsLh8oSv2o6uZ0ftvx4vi3+1B8P5D3H91E8fNC3n/9/ih++1PZAWgjD4MpRGkiAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMBAMAAAB7FTvLAAAAFVBMVEX/AADAHAwAcy//Pz/////AAAAAAACPTp2UAAAAIElEQVQI12NgYGBUggIFBqI5zC5Q4EA8hzUNChKI5AAAoCwcpYQRjwsAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAKlBMVEUAel5EWEzOESbtkhz80RbSICXQGiXVKyTtkRzPFybqhRzgXCDjZh/OEyagvH7SAAAAL0lEQVQI12NgYGBgVFJSUnZxcXFgIJujisRRqyhDcDSXrERStmcTEufSJQothXIAS0kcFoqy1Q4AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAArlBMVEX////+/PznmKXLHTnIEC6Nz37x+e/56OvbY3dDsCpQtTiu3aP+/v3xxMvROFHQM0zwvMX+//664rFStzxpwFXY79P++/vLGzjaYHT10tj77/H00dfaXnLKGDXkiJf9+fnd8NhuwlpEsSyO0H/1+vP88fPz8urNfXz77vD3+/ab1Y1GsS1WuEDF5r3z8OvRj4zE5r2GzHbJmY3l2M6FzHXLj4fq1tD00Nb0z9XZXHCAuQcHAAAAl0lEQVQY03XQ1xKCMBAF0EuQslZiF7GhYotIEdT//zFloo5xJvfxPOzdXcBgZk2NyQzAsuG4CrsObAtUbzTRan+144F3ewQi6g8wZKPxxJ8Gs/kCy9XLKqdwvcEW0S7CHofjiT5OJM5AfImBREh4O6WQSenPeZYjz/hVdZGgKFEW6hzZW0XplXsGN//++NlTc5fuD5q/PQGhkxBhLkpJ7gAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAJ1BMVEV0rN+iyOr///////7+9N386b7/+vDxzHjlpBvyz3v/+vHooxzxzXmOxmdwAAAAKklEQVQI12NgIAMIIoAAgxIQKLs6gygFMEetYhaCozX7GIIDV4ZiABkAALRkCnDC80XRAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABAlBMVEUAAGYQAWE/BU9zDkC5RVsIAWMyBFRlCUKlLUrXcHrpr7Xy5+f///8DAGUmA1lYB0WaLE7TaHPln6b45uf+/v7GurNuRjGZioECAGWVIUXPX2z24OK3rqlNNihXKxJDJRCnpaLa2toZAlxMBkqEFkHFT2Dgj5fyz9P//v5ELh89IBAzHxBBJxaSjInAwMATAl92E0S/TmHeiJDtv8T++vv6+vqlo6JTRTc6JBNQQTe8R1vcgIno5NmynWa0qIjY0L1dRi6oop35+fi1rJ2pnoCQgFOMeEmun3qolmiBYhyUeTejj1z39/XezL+8tKK4rYz19fX78PERAWBCBk51Dj+5RVpfBpLmAAAAjklEQVQY02NgwASMTMws6GKsbOwcnFzcPMhivHz8AoJCwiKiYuJwcQk+fkkpIWkeHh4ZWTl5BUWwoJKyiqqaugYPGGhqaevo6jHoMxkYGhmb8MCAqZm5hSUPD0jcyhohbmNrZ+/gyMODbo6Ts4urmzsPpr0enl7ePjxY3Onr5x+AKo7wVyCGOAgEBYeEAgBY8hNzRgcIXAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAANlBMVEX//////f31xsLmcGjbLCDaKRz+/PvvoJr++vrtlY/eQDT76ejum5XeQjf65ePrjYbpf3jaLB/lYaGsAAAAQklEQVQY02NgAAFGJmYWVhTAAAVs7CxYxDk4uVixqufm4cVuDh8/VnMEBLGbA3SQIAniOM3BYS8ud+L0F45wwAw3AGf1BUHP8JrdAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAPFBMVEUAOaZVe8T///8BOqZcgMYSR6xSecPm7PbBz+kiU7IQRayxwuSVrdoJQKkKQamMS25sMmOWU3LrlY/XKx9khW8/AAAAOUlEQVQY02NggABGJlQAEmPGIc7CilWcjZ2DE5s4FzcPVvW8zHzYzcfqHn4BMBAUQgUMwtjBYBMHAFivDsTcsiecAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAPCAMAAADXs89aAAAAmVBMVEUQBp/11Ab+3QD91QLVADLuzyHtzSbRs13Rs1ntziPv0B/fwEPZfFnciFDinSjioCzhwz3ryx7Gqnbsn2Pql2LqjxLrlRTyzRj10wfTtVvmmyLkmSXjqibmqyTUtljz0wvKrW/pkhTqkRTpsBPoqhjKrm770wbz0wrMrme/oGnAn2jDpWrAomzLrmf93AH41wzWuFbXuVT52AucGRN3AAAAV0lEQVQY02NggABGJjBgZoEABqoKs7Kxc3ByYQhz8/Dy8QugCwsKCYuIigmJowlLSEpJy8jKoauWV1BUUlZRVUMTVtfQ1NLW0UUXZtTTNzA00qONL1GFAZFEB4tSoY/5AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABBVBMVEUAM6EBNKEQPKMnUq9bfMFtertLb73bwNjEl5zSpbjXsr6Yp8wSQKcbSKq9l5rAuqyhq8xro3q3r8HRmqO5pswRPKK2pMfOqqhRj3C8wsHC07hddqmRs5XYradKbbkCNaLQqr2drc8KP5Zyhaaur68mSZAiU5/Xs7Ojq8QBNKCOh29ohcEsUZ/AxdPz8/OTosASPZu7u9pviZQDOZoGOpmZqJnFuK8TQqewucv5+flkeaMuV7HVyb6OobkNPKJ8icG5opCzr7W5vcSztbSRm67Jt6jDs6UwY5QGN6KHprWtnZnHzNOxtLN7d3zFt66QnMEFOJ0DNp4IOaSFmb2Djp5CW40XQKYS9vo1AAAAeElEQVQY02NgIAAYmZhZWLGIs7FzcHJx86AL8/LxCwgKCYugCYuKiUtISknLyMqhissrKCopq6iqqWugimtqaevo6ukbGBoZo4ibmJqZW1haWdvY2qFqsHdwdHJ2cXVzR7PYw9PL28fXzz8A3aGBQcEhoYxhhLwPAPcVDp+C6v47AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAD1BMVEX9uROqnyMAakSBPTXBJy29EYwLAAAAIElEQVQI12NgIAMIIoAAgxICKBDLMUYAAwYXBHAgkgMAec0WNTyZViAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAFVBMVEX////+v7v8PTLVyr1+Xjar1b4Afjpw8UlkAAAAIElEQVQI12NgYGBgVIIABQaqc5hdIMABxGFNg4AE6nIA288f0iiBr6QAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAb1BMVEVmzP+b3v9x0P/T19pz0P+o3/svLy+n3/qdqa4AAACfqq+I1/9LS0tMTEyv0uQPDQStjw8RDgSt0OJtzv+AgoSniw/80RaBhIRuz/+g3/6EcR6Cbx24vJn2zBX4zha5vJaD0+/21z330ib00Sby0SYESuZvAAAAUUlEQVQY02NgIAwYsQszMbNgFWdlY8cqzsHJhU2Ym4eTlxuLOB+/gKAQprCwiKiYgLgEhriklJiYmLQkhriMLFBcTh5dWEFRSVlFWUlRgYDfAUE1A+LkVEvpAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAaVBMVEXjChflGSbpPEbmJjHjDRryj5X+9/j4wsXua3PlHyvyi5H////kFCDjCxjkER3kEBz+9vf5x8rjDBn0nqPsXGTnKTT0nKHyjJLxhYvkDxz5yMvyipDubXXkFSHyjpT4wsbykJXoOkTmJTB42cNaAAAAWUlEQVQY02NgoCpgZGLGIsrCysbOysGJIc7FzQEkeXj5UIX5BQTBtJCwCAuyuCi3GIjiEeeWQFEvKSCFVT2DNLcMkJRFN59BSI5NXkEG0z1A9ysqUTdAYAAADE4DOE3oR/cAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEUAW7uAmF3/1QAtK7fLAAAAFklEQVQI12NgIBWEgkAIwyoQWEE8BQATGR3UH+9XwAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA/FBMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBkMMAnN4QoNAHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAXqMlpb69zTkLn9Teb4HMIDzXUGZqiLMVocwNn9MnprwRoc86q6wmpr3BzTUIntdneqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYIipMCnx0wHntgYosndsL7Tg5duY44hPXyipsDnnqtIhLYKn9UDndsrp7nJzy6CvmxxuXwhpcGox0sPoNEJntYfpMMOn9IUoc07q6sFndoyqLItp7cop7u/zTeixVAbosZ0unlbs49YspGdJfUOAAAAoUlEQVQY02NgYGRiZmFlY+fg5OLmgQFeHgY+fgFBIVZhEVExcQmYsKSUNIMMCMjKgUh5iKi0gqISD4a4soqqmjoP0BwNTS1tVh1dPX0DsDmGRsYmQIrB1MwcbK+FpZU12BgbkCQPAw8KsLUFydjZS6OJOzjy8Dg5u7iiq3dzl/bg9QSZjyzqxePt4+tnzIMmruwfEBjEY8KDLs4TbOwFYwIARMsZQSVZ5k8AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAB7FBMVEX////39Oru59D7+fbt5Mru59H38+nz8OjatEPduU7gxXrl0JL08ej8/PvPunrftDvv5sv08enm0ZXctEPy7+fs4cHUrT/SqTXUrTrpvjzfvmPy6Mvn0pb0xT3kzozy6MzgwGTpvj3UrjnSqjXUrT718OLZuV/QqDXasTjfszi/sYpmcJRmZW5ESGZqaXFpcZe9r4vZsDnYuF707+G/1eHp7/LD2eXe5OLXxIfHozjVrTrBnz8WJme/nj/VrjrJpDjdyYz7+vfX5OrZ5euNv9rG2+dkpMayyrZym3fm3L3UrDbJqUuUbIGFV26TXXeMW3KZcIXLq0zVrDfR0LnA2Obm6+6qzuG00+Pf6e5qp8h3sdDP29FeimWuxbHx69vk1Ki7f4+vZny+cIiuY3q8f4/i0qZjpMdZlrmvy9k/lcPC2ebz9fSApoVnk23s8O3bw3rJp2utZHqtY3nLqG/bw3lzoLh7rMa10+O+1eHt8vSauZ9Wjl6etJPHqEvOuoCzjWW2d4WxjGTQvH/l5txck7PT4+vX5evb5+3v8/C1sHjAr1Tt6dvOqkHLpDPGp0zKozPOqUHu6tudmmLBuIz7+vmhw6Lu8u7l16/XrjfVtFPi1K52r84Kc6rq4cTbwnzt8/YnhLYff7Dv8/Pn7fEQJjpMAAAA6klEQVQY02NgwAUYmaAMZhaYECsbkGDn4OTi5mFg4OXjFwByBYW4OIVFQLKiYuISklLSDDKycgzyCopKyiqiEG2qauoamlraOrp6+gaahupGxmBRE1MzcwtLK2sbELC1s3dwZHByBoq7uLq5e3h6efv4+vkHBAYFh4QyhIUDxSMio6JjYuPiExKTklNS49LSMyDiDJlZ2Tm5efkFhUlFxSUMpWXlUPGKSoaq6prauvqGxibv5pZWBoa2dqhHOjq7unt6+/onTJw0GcXTU6ZOmz5j5oxZs+dMwQiQufPmzl+wEHtgLVrMgB8AAPZ1Oc30PPcZAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAOVBMVEX////66Ov77u/niZXPFCv++/v88vT55un+/Pz39/fy8vL99vf77vD76uz29vb6+fn54+f98vT77O5thl2kAAAAMElEQVQY02NgYGBkYoAAZhYEAHJZ2bCJs3NwcnFjEefh5eMXwGqOoBB28+FgJIgDAJwAA2bbrSWKAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPBAMAAAD5dJlYAAAAJFBMVEW6DC/NT2iuuMsAIFtoe57gkaHUZ33gkKDsusSPnbdidpo7VIFeYyUVAAAAMElEQVQI12NgYGBUdmWAAdLYaWnpyh5pIJDAMHPmzMU7Z4LABAZjODBAEUdWT4G9AL+iG6ltY7JXAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABMAAAAPAgMAAAB7Khy/AAAACVBMVEXOESbmiJL///+5ZgD4AAAAFklEQVQI12NgIBqEAkEIwyogWEEMCQAyDhjZv5ZnnwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQAgMAAABinRfyAAAADFBMVEXaKRztlI7////2yseOQnozAAAAIElEQVQI12NgQANsE5AJxritDgxMq1Y1QAgwF00JKgAAhfMJ2dEJifUAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAANlBMVEVBj95CkN6Yoc5xm9bbb4FaldtCj96Toc/QcYnuO0nFfJh+n9VJkt3IiqNyntjgxyWApZSgsG+XAyaDAAAANUlEQVQY02NgYGBgZMAOmLALM7OwYhFlY+fg5OLGpp6HF4f5fAwDAPixAwYB7IBBEDsg1VoA2MUEutTEezgAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAxlBMVEXZDxlkE2UXFpYmJp0cG5iDj7G+1bjK4b291LWEjrUbGpiVp67C17Sjw4uhwYGpvIHE2beap7lJTKTN3r3YuKbGwaOjt3imo362mJC/2K1HSqV/hrjZ6M7n29Lp2dD26Mfcx6vYy8fW58t8hLR9hLfc69P29vX08vLf4tr068zd7NV8hLZJSaq+2q6oxIuNtHBBkKmLuHG506LF3rZHR6qcp73P4bvNyK7c3K7KxKvR4b6WpbWFjrfC1r3D3bTA1byEjLkmJZ28SCGBAAAAb0lEQVQY02NgwAEYsQMGJgRgRmLDxVlY2dg5OLkwxLl5ePn4BQTRxYWERUTFxCUkpdDEpWVk5eQVFJWU0cRVVNXUNTTVtLTRxHV09fQNDI2MTdDtNTUzt7C0ssZ0p42tnb0DpjuBwBHZX7jCAQcAALfSCgm/YQw/AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA/FBMVEXZiJrYtMFecqAEJGs2T4jROVK7hp0BIWklPXuudZDmm6ikbo3IEC4HJm18Y4vZg5XTs8N5irC/iJ+cbY7ijp29s8c1TohkGUzeb4HMIDzXUGa4Z4LQMUvigJDgeInfdIbYV2z////vvsbGLkj+/P366OtneqXgsr/PfJCDeZ6/iaCKk7bnprLBdo0+SoPs3t3VmZDBe1vet7L65unesb/Tg5duY44iPnyipsDnnqurX33c49G8v3l+vcuawbn45ebbkHrdxW6RaU3TuaXrpa/JWWO/1K/o6dPs8fDM06+qv5fDHzZxiFJVfStrq1VpbTqWfVyyUE2fc1rALT2R2bf6AAAAjElEQVQY02NgYGRiZmFlY+fg5OLmQQAGXj5+AUFWIWERUTFxZHEJEJCUApHSPDwysrJysvKY4gqKSsoqqmBz1NQ1NFm1tHV09YDmKOgbGBoZg8RNTM3A9ppbWFoBxa1tbO3sQeI8KEDBwdHJ2QVT3NXN3cPTC1Pc28fXzz8AU5yHJzAomAebOMxfOMQBSxcXzrZ7VqgAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEX3fwD6qVT///9VvpUAnmCSMtlPAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAFVBMVEXqKDm2JkYaIG2Mejf/1QBAsT0ApVF1LMggAAAAKklEQVQI12NgIA4IIoAAgxICKODhGCOAAYMLAjjg4YQiQABDGgIk4OYAAB9hI7DJ6TK7AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAmVBMVEVZWIQ+PXBaWYRYV4NAP3FUU4BEQ3SfNUy4M0RRUH1bWoRZWYRhYIpXVoJjYotdXIdTUn/Ovcnz3eBHRnZQT3xbWoVMS3pcW4apUGXEVWNfXodlZI1YWIRdXIVkY4xdXIZYV4LForDnu8FGRXZIR3dZWIOya37Qd4JUVIBcXIZYWINjY4u8h5jcmqKTcIuSboqSb4qTb4vNkZ2nKdJNAAAAb0lEQVQY023IxxKCQBAFwMcsCCJJEFZMBAOYBvH/P87rWDV9bMAh45K3ID+QsAxXEcVJmq1zCQVtqKysLba1hNjs9ofjqWm7XgKdm/Rir1V5GySM5p60jyeNr7cEnpg/PM/8/f9Bh16HWodch0D3A2OzHE9RW7KIAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAXVBMVEUAAJV+AEv+AAAtLahOTrUiIqMMDJoxMamXl9TKyum4uOFdXbsFBZcBAZVTU7fIyOj////+/v8aGqAqKqa2tuHg4POFhc0JCZlfX7ySktJ+fskNDZoDA5YWFp6+ACXIZxTWAAAASUlEQVQY02NgQABGJgQACzCzsLJhEWfn4OTi5sEQ5+XjFxDkEMJULywiKCrGiykuLiEpJc2DxV4ZWQYZdHsZEUAOWZwJOxhs4gA+8gQh9y2bmwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEXOESb///8AAAAfv2a4AAAAFklEQVQI12NgIAxCQSAEL7UKBFbgowBmmx3UA+477wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAWlBMVEUAAAACAAAYAgQpAwkXAgQrBAlbCBBPBg9QBw9aBxA0BApTBw8fAwVFBQ1jCBIgAwU0BAkPAQNYBxAfAwagDR7OESZZCBAkAwYpBAdBBgyACxgiAwYWAgQznjXkalk/AAAASElEQVQY02NggAFGJmYWRgYMwMrGzsHOyYouzMXNw8vHy88tgCosKCQsIioqKiIsJogiLi4hKQUCktIyUBFR7IDm4rLYAa3FAYAJGRUqWUeJAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEWuHCj///8hRottIBdsAAAAFklEQVQI12NgIAxCQSAEL7UKBFbgowBmmx3UA+477wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAS1BMVEUAFIl/icRweKz////CwsJ5eXnDw8O+vr5QUFC/v7+hoaEBAQHMzMwNDQ0AAABYWFhEREQ/Pz9CQkJjY2N/zKFusItinnxusYwAmkT4qX4BAAAAQUlEQVQY02NgoDFgRAAmJDYDMxywsLIhOEji7BycWMW5uLmwifPw8vHyYBHnFxAUEkaIi8CBqJg4gsMggR1QSxwA0QkMhlq67zwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAPCAMAAADXs89aAAAAV1BMVEXTIBHw5Tzv5UDr4EadnT+dnkHv5EHjw0TWkzSRnlp3kE7UmkHjxUTfhCfMtDOXrGeYsGrLszPbjCnapTFzoG1gkFXapDDbiynp3TrChC+imD6hlz0AcC1ma6HZAAAAPUlEQVQY02NgoD9ghAImZhZWNiYYDy7MzsHJxc2DIczLxy8gyIshLCQsIiomjiEsISklLSkBF5bBCmgpDAD3GQ4SQjEiDwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAQMAAAA1YcYVAAAABlBMVEXIEC7///94b0yLAAAAEklEQVQI12NgwAL+//+HgbEAAL/4Du0JSfZYAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA/1BMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBU4kHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAIWknQn9oe6YhPXwTMXTeb4HMIDzXUGZvSHUNK3AqRYGOnb1CWo93iK5DWpAiPnwaN3ePnb0HJmwCImo3UIl2h65neqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYIJKG6Rn74PLXFbcJ9LYZXdsL7Tg5duY46hpcDnnapIR3xGXZIoRIAWM3Wrts5FXJF+jrNTaJlSaJlAWI4gPHtrfacSMHNugKlfc6AuSINHXpKwutERL3Jkd6MwSoVIX5PTyeXUAAAAo0lEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExIF9cXEJSCiQuDQIysiBSjl1eQVFBSVlFFV1cTV2DnV1TSxtkjo6unj6rgaGRsYmYqZk5yGxNC0t2BitrG7C9krZ29uwOmmBLVR3ZGZDcwO7kDBF3cUUVZ3dRBVNuTmji7h6mQNLTyxtNnN3HV8LPPyCQHV2cXT4oOATsX3bsAAC/0hZ0AfWwIwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAASFBMVEXgb3TjfIHcW2LOFyDhcXbplZneY2jhcHbieX/dXmTXP0bbU1rWPUXrn6LganDhc3jhbnTpl5veYWeSW0cAfDCXcV2YdmKWbVnzs2u1AAAAQUlEQVQY02NgYGRixgIYWFjZsIqzc3BiFefi5sEqzsvHj1VcQFCIJHFc5nBxC4tgAUB3imIVZ2EVwyrOwCiOTRwAXXUJqXvcnGMAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAxlBMVEXkgJfesMBecqADI2o2T4jpLFDEgZwBIWkkPHu4bo/yk6Zvcp0HJm2CX4rme5PZsMJ5irDJhJ+laI3vh5y/scY0TYcaN3hbb57vZX/mETnrRGSeZYsfO3thdaEQLnJneqXnrr7cdI6IfqTIhJ+Kk7bwoLHNb4w+SIIKKW6ap8RAWI7krL3gfJVzYI4hPXyjpcDyl6mDX4oUMnSfq8cFJGsGJWxPZZczTYYCImo5Uorn6vGgrMdJYJPl6PCnsssRL3IoQ4AnQn+rTNqoAAAAiklEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVGwgJg4RFwCBCSlQKQ0SEBGFrs4EMgxg8yRV1BUYlVWUVVTZ2fXYAGJa2oBxbV1dMH26ukbGLIbGZsAxU1NgeLsGMAMbD6IMDFntkCTBItbWlmzYxO3sbWzhwnA3A8mHRzhCmHuZ8cOAEtZEAuc6acEAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABPlBMVEX34ib34Bf////+++D89Kr67Xz550734Rz//vX9+Mn88pv662345DXxwRrGxsb39/f+++fni3b67Ir56FX34SAAAAAEBAQqKipmZmahoaHU1NT+/v765efeW2nXOEndVGP54OP///v++tn67HT45T734BgPDw9dPD+UZGm1oKLo0tTup6754+X32dzzxMn31dn+/e799rz774r56Vi0pzd+djJJRSQTEgsCAACHCxlIBg0CAgJpISliYmKxamzQVGL8+vreyRWllQ9rYQo5NAViCxJgFxBdFQ9rCBReFg9nHw9dCBELCwk7Ozhubm7g4ODs0RfMSh/CTB61MR+pMxyUFRsGAAEeHQ5XUzCNiF323BjvuxrroRzniB7soRzdqhismhF7cAtKQwcPDgH03RfNuhOcjQ8xLQUCAgDn0ha6kmd4AAAAoElEQVQY02NgYMQKGJiYWVjZ2LGIgwAHJxc3DyMvsjgfPxMUCAgKCYvAxUXFxCUkpaSZmGRk5eQVFJVYlFVUweJgoKauoamlraOrpw/UaGBoZMxgYmpmDpSwsLSytrG1s3eAGgp2pqOTs4urm7uHp5e3j6+fpD9MHAQCAoOCQ0LDwKaGR0TCxaOiY2Lj4hMSk5LBUpjeTUlNc07PwBEMmQAZSxhdUtMxfgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAPFBMVEXBJy29KC1iRDCwLC5SSTCuLS6/KC1rQjB2PjBVSDG+KC13PjBjRDCwLC1fRTBHTDFzPzBpQjCqLi6jMC5S+Ih0AAAAPUlEQVQY02NgoD5gxCHOhF2YmYUVU5CNnYMTCNnZ0CW4uHkYeLi5MHXw8vHz8WIxXkBQSFAAi7gwFNMHAADZHgFVpeHZFQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAvVBMVEXXh5nYtMFecqADI2o2T4jSOlO6hZ0BIWkkPHuudJDmmqdtc50HJm18Y4vZg5XTs8N5irC/iZ+cbY7ijp29s8c0TYcoPn7ecILMIT3XUWeVaoxQV4rJZoACImoGJmwTMXNneqXgsr/PfJCFf6S+iZ+Kk7bnprLBdo09SYIMKm9kZ5MUMXQKKG7GepEOLHHdsL7Tg5duY44hPXyipsDnnap9Y4rIZn4cM3YJKW0aNXdhYI/NWXEIJ20jOXowRX/3OrJCAAAAdklEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVGIiBhEXBwEJCRBpBRIQFpGFqu4nBy7PNgcBUUlZVYVVTV1DXZ2TS1tdnYdXT2guL6BIdheI2MTU3ZmM3OgWguQenbsgHhxS+ziVtY2WMVt7fCaDwD1rg7FPBvszQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAARVBMVEUAKGheGU2/CjBbdZ4BKWl7iKr56u1WcJv6+/zCy9sPNXFkL1/LN1YUOXO3wtSClbV2cpjuvshqRXLWY3uMnru2l6/ikaLPgMbuAAAAQ0lEQVQY023MORaAIADE0Ii74oIo9z+qYjlvfpkiUDVBfbHt6AcF4zQva1Sw7QdnUv+eKyvu6imK4pE9kkf0GDyC9wIzdg0wUr0dbwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAPFBMVEXSEDTKFDSdLDavIjUAfjopk1qgz7U1mWIJgkAJgkHS6Nwij1QMhEPo8+3R59sjkFUoklmfz7Q2mmQJg0GY96tnAAAAOklEQVQY02NgoB5gZEIFjFBxZhZUwIwqzsrGzsGJRZyLG6t6Hl4c5vDxYxcXEBQSxmY+hntwuZ8aAADCFAKMMG11hwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA0lBMVEVGXIoAKGgAKGhNTnvaiJXZtL9ddp8CKmk1VYfWOku9iJoAKGgjQnqwdo3pmqQGLWx9ZojchJHUtMF4jq/CjJyecIzlj5m9tcYzU4bhb3zRITTbUGBwS3Jyd2R/f11/fl02TGZmfqThs73SfIyFg6LBjJ2Kl7bppq/Ed4o8T4DEokb9sXTlshPHjRBTYF/fsbzWhZNuZowgQ3uiqMDpnqesm0P2uULThBfbqRFMXGCDgVGvviZloDPjwSYhPWclQGWEqjpesTZ2elkkP2VXY18BKWnEAyisAAAABHRSTlPs+/rwxUX/AAAAAHdJREFUGNNjYGFlY+fg5OLm4eVj4EYABn4BQSFhThFRMXEJRmRxSRCQkgaRMnjEZeXk5RXA5igqKatwqqqpa2gyAfla2jq6eiBxfQNDsL1GxibMQL6pmbmFJUicGxVYWdvY2mERt3dwdOLGIs7t7OKKVRzmThLFAWmrE3IYeqaoAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAV1BMVEUAAAB+bgL83ATZAADbDQ3vkJDIk33ukJDbDAzwmprb2tqYlZP////wmZltAADo1tbJycmAhH/gmJeZmZnn5+eRkZHqmJiXl5cMDAyOjo6hoaGPj4/rbgKqEgxKAAAAS0lEQVQY02NgIBEwYgcMTNgBTnFmGGBhZWPngPMQ4pxc3Dy8CHE+GOAXEBTih/MQDhMWERUTx+JgCUkpaQkEl1R3ymAHCHeiAlziAE5rBtPVNvf5AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAA9lBMVEXqfo25uLgNDQ0AAAABAQF/f3/xp7HbHjjaGjXmYnTJw8QXFxdubm7zvsbcJj/iS2Hbzc8oKChQUFDuztLeMkrfOVDoztI+Pj43NzfkztLgP1XdK0Tvw8lZWVkiIiLWy83jU2fbITvysboSEhLCvr7na3zaHTfvnambm5sEBAQHBwepqKjtjZqwr68KCgoDAwOSkpLwpbDmZHbIw8MWFhbyt77bIz3iTGHazc4nJydSUlLuyM3dLkbfOlI9PT04ODjlztLgPVTwxctXV1cjIyPXzM7jUWXcJD7zucF3d3cTExPEwMDnaXvvn6qQkJACAgILCwuysbFpXHFVAAAAl0lEQVQY013OxRbCAAxE0UKADu7FHYoVd3f3//8ZwpJkNee+TRTFZCayWG0q/k6B3eEkIpfbIxxen59DIBgSjrAW4RCNxYUjkUxxSGeywpHLWzkUiiXh0MuVKlGtbgjn0WgStdodVTi6vf7v38FQOEbjCYfpbC4cC23JYbXeCEdiu+OwPxyF43S+cLje7sKhP54vovfH+AJdDBQcG/IV/AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOAQMAAAD+PRWwAAAABlBMVEX////cFDzQkLT4AAAAEUlEQVQI12NgwAP+//+HCwMAJMYU5aFypMwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAA0lBMVEXGNjzGNzzAST3JQULfh1jRZkvPiFjfh1nPV0nLTEbbgUPYbTvdiUHchEDUaEXTezjmnzHjqzXhozPHOjwMQHaUUWXVbmTjnovfi4vSaUjae38dP3DYvsXxzM7mpKP34eHdhIT56uvEoKr24+TYdnrlpKbmpqfy1dbDnqj14OLjmp7vycrimZz13d63jJruxMTagYXmpqjlpqfvyMkZP3L////psKvbekruy8z99vbWbFHagGP89vbZek7surX02dvYeUztv7n9+PjtwcLrtrn24OFiPoPsAAAAd0lEQVQY02NgwA8YmbCJMrOwsrFzYIpzcnHz8PJh0cAvICgkjCIiAgKiYuISklLSIggAEZeRlZNXUMQUV1JWUVVTxxTX0NTS1tHFFNfTNzA0MjZBFjcFATNzC0sra1MkABG3sbWzd3DEFDd1cnZxNcUijgFwiQMAPl8kN9UqPeQAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAPFBMVEX/mTP////KyuacnNPLy+bFxeO5ud60tNy3t93Hx+SWls+2tt1ubsOWltDGxuO4uN60tN22tt7NzecSiAd2iPNoAAAANUlEQVQY02NgGCDACAdMzCwIDkKclY2dgxOLOBc3DzcvFnE+fgFBbOoZWZiFkMwXxg5oLQ4Ax8YJrQwHUxwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAJFBMVEX/////9vb/AAD/t7f/vLz/u7v/tLT/UVH/VVX/ubn/UFD/VFSdQDd7AAAAMklEQVQI12NgAAJGJUUGKDABc1gNQGy2igkgzowyMGcFmDN7GYYyZAOUEEABD4eqlgIAJT8Szc0NSEoAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAJ1BMVEUNXq+dvt////8ocLgzd7xelMqCrNauyeTf6vS3z+eHr9eLstlakcg2fn2aAAAASElEQVQI12NgYFRmQAAgxzUUDALAnCQlMFBgKK/QLF8KkwEJbUDWA1cG4hwvB4MCBhSjQQaUw2SUEECBAQWEIkAAqjIUGWQAAA+uIB3x19KXAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABJlBMVEXZiJrYtMFecqAEJGs2T4jSOlO7hp0BIWklPXuudZDmm6htc50FJGgIJmgHJm18Y4vZg5XTs8N5irC/iJ+cbY7ijp29s8c1TogDImlPSVAQLGfecILMIT3XUWeVaowOLHEyK0ZRMi8LKm8FJGsMK2+FlbgtOn9FSHtVZK8hPXxneqXgsr/PfJCDeZ6/iaCKk7bnprLBdo0+SoMrPopCSp5lY3UVHKYDGk7esb/Tg5duY44iPnyipsDnnqt9Y4oHJmpgandfeHFjf1Rpe6QWHCssRHJNUFF2j49+nDZneqQCBAhMV2pjY2aGjZqApJ9IYJZITl4pNVtRRT5CQ0Egb2OZoLRtbn0BIGcEIGebaCKHcClzYzCigB9eQDxhRDs4P1JQO0Q7Ok6s71g6AAAAmklEQVQY02NgYGRiZmFlY+fg5OJmBwIeXhDJzsDHLyAoxCosIiomDuJLSEpBxKVBQEYWRMoB+fIKikrKmOIqqmrqGppgc7S0dXRZ9fQNDI1A+o1NTM3MQeIWllZge61tbO3Y2e0dHJ2cXUDi7CjA1c3dw9MLU9zbx9fPPwBTPDAoOCQ0LBxDPCIyKjomFlM9e1w8e0IiFnEYAAB1vBj/cZUwaAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAvVBMVEXOESbeViDXOSLRHCXjZh/OEibKIifVSyPTPyXeaCHAGCk6jk3AvCf80RbHvyVCkUsAel5DkUvNwSTTwyFUl0YBe14Ce13YxCDexh5lnUEDe10OfloGfF0FfFzjyR3vmRviZB/vmhvoyxt2ozwIfVw8j03fxR4riVIXd1fZSyLwnxraSyIWeFgoiFK7mSlIkUoWdlfUNyTypRoZeFcLflvvnBvfWCDvnRvaWSLSPyTMKibeZyHaQyLWMyPiZR9CXwAXAAAAn0lEQVQY03WQ1xKCQAxFA8iC2KJiwYa9N6yA4P9/ltllGeGBO5PMzXlIAxBSVACtpAGoCkjpjGSYlMoUpsFLnbhVqdbyqjcszhGbrQxt2x2UHLt2T9K+M6Ba8OGI3NiZuNPZfLFETPlqveF+u9sfjoh/fjpfuL96N++e5fhI+jxf71yforlFexbcJf7gB4yFn5CxwE//IBTFlL4UcZSAHzl0E0VM9uySAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAACVVBMVEXXh5nYtMFecqADI2o2T4jSOlO6hZ0BIWkkPHuudJDmmqeenrr09fnK0eBOZJZ1hq3Z3ul5ibBRZ5iwutH3+PrJ0N8HJm18Y4vZg5XTs8N5irC/iZ+cbY7ijp29s8c0TYc0TogIJ20wSoWst86FlbcaRGYHOVJti5mjssVJYJMGJWwdOXnecILMIT3XUWezhJ7v8fXIz99LYpQ/el6sxbllpGcweEZHZYmuuM/x8/fGzd2nepcKKW4yTIaqtslQhWwIYh0JXxMsez15oZFMYpUfO3tneqXgsr/PfJCFf6S+iZ+Kk7bnprLBdo09SYJVbJzu8PXEzNxCYoVQe3s7iz4/hTNJYZCrts7x8/bdsL7Tg5duY44hPXyipsDnnaqVeJkLKm9UiHMgRG8WVSFiiodynoiJmbpQZpibp8Tq7fLU2eVabp1wgqrP1uJTaJmeq8Xt7/TCyttGXZJtf6nV2eDewoF3hauptMzw8vZ7i7G4wdURL3IrRoKtuM+WpMEvSYS1v9NccJ8NK3A3UImzvdKTobrSlGHWlUTFs5ckP359jbI+Vo2Pnb3l6PDN0+JidaJBWY+bqMTq7fO/x9lDWpBqfKflqzHQmyuki22mssvs7vR+jrO6w9ZpfKYTMXQsRoKvudCYpcIxS4UMK2+3wNUPLXE5UopEWo5xZnSMm7snQn88VIyNnLzj5+/L0uBHXpJfc6Dr7vM/V42ZpsPo6/G9xthoe6bO1OLNqpVEW5CksMmAkLS+xtkXNHZ/kLQSMHM9VYySoL80NVq2v9RWa5sOLHEqRYFI4ccVAAABHklEQVQY02NgYGRiZmFlY+fg5OLm4eXjF+ARFBIWEWUQE5eQlGKVlpGVk1dQVFJWUVVT19DU0mbQAQFdPRCpb2BoZGxiamZuYWmFLG5tY2tn7+Do5Owi5sog5ubu4cnq5e3j6+cfEBgUHBJqHBYeEcgQGRUNtjcmNi4+QV44MSk5JZVPMYYhLT0jMys7J9cyLS+/oLCouKS0TLO8opChssqtuqa2rt6msqGxqbmlta29Q1jIppOhq7unt0+z37Cga8LESZOnTJ02fUbRzFmTGWbPmTtv/oKFixZ3LWFauqyhZ/mKlS15i1cxVK5es3bd+g1WGys3bd6ydcK27TuKd+6atJVh957ivfUtE+WX7pvTv/9A1cH5h9YcPnL0GAA3X2Mlk4qcMQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAolBMVEXuHCXxQUn7w8byTFP82dv82tzzYmnzZGryTlXvLTb+9fb95eb0dHr5tLf4n6PwMjr4oaT94uP80tT5sbT0anD83N7+6ur95uf7y83xRUz96ur+8/T3jJHyR1D1foP2hov1eH3vIyzuHif1f4T1eoD4pKj4nqL+7/DwPUXvJi794+T7ysz81tj1gIX2iIz//PzxQ0vzXGP+9PXzWV/uICjyUln/mF9zAAAAWklEQVQY02NgoDpgZGLGKs7CyoYpyM7BycXNw8vHjyYuICgkLCIqJi6BJi4pJS0jKyevoKiEJsGvrKKqpq6BYYGmuBaTto4uhrievo6BoZExpotMgNiU6oECAImXBezlsrTxAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAYFBMVEUCT6LzZ27tHCfzZGz4kpf1hozuJC/0dXz////yW2P+9fb6vsH5pqnwQkzuHSfuLjf2j5TvOEH70dP3mZ/tHCjwPEbvN0D0c3r1foT6zM70dXv6ub3zYmr4pqr1hIruIy7XNkFbAAAARElEQVQY02NgIBEwYgcMTGDAzMLKxoQMIOLsHJxc3FjEeXj5+AUEMcWFhEVEOcQwxcUlJKWksZjDJCMrJ48qjsudJAIAkNwC/G7V+x0AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAnFBMVEX/AAD/AQD/BwD/AgD/LQD/cgD/iQD/YwD/LwD/QQD/tgD/xwD/zgD/swD/OQD/FgD/kgD/sgD/awD/bwD/aQD/sQD/nQD/DgD/GgD/xgD/dAD/TQD/cwD/rwD/wwD/LgD/MwD/wgD/dwD/eAD/uwD/dQD/GwD/ngD/mAD/mgD//wD/lgD/lwD/PwD/ogD/OwD/MAD/iAD/dgD/LAB+VdSxAAAAZklEQVQY02NgIBswMmETZWZhZWPnYMYQ5+Ti5uHm5WNEE+YXEBQSFhEVE0cTl5AUlJKWkZWTRxNXUFRSVlFW5VZDExdX19DU0tYR4Ed3pC4vr54glz6mOw3YDY2MMd0JBEyMDGQDAINfBfk2r6SaAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAANCAMAAAB1uQVvAAAASFBMVEUAR6uqwuOvw9Www9Ouw9n//////fTZ5Nj47MHZ59z/++vw9d2bwKSAv6Sgwqr29+D/++2j0Z2tybmo0qD//PGowMqKt76pwMtHFZsrAAAANklEQVQY02NgoDFghAMmZhYEh4EVBtjYOTi54DyEODcPLx8/FnEBQSFhEYQ4wkhRMXEk82kMAFM1AkVD4QrKAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAqFBMVEUAVDAHWTYJWjcMXDoIWTYXY0ITYUATYEAUYkABVTEEVzNPiHBMh25xoIw3eVxakHlbkHlIhGo0dllckns8fGEeaEhVjHZwn4p2o5BiloBRinIydVlelH1bkno+fmJCgGVRi3IqcFIGWDVdkntbkHpLhmxVjXVBgGVKhmxHhGo3eF0VYkEvdFYcZ0cdaEclbU4ZZEQkbE0bZkUmbU9EgmdbkXpCgGYFVzSDTme7AAAAYUlEQVQY02NgoCpgZGJmZGZhZWNn5OBEEubi5uHl4xcQ5BYSFhFFVi8mLiEpJS0jKyevoIgkrKSsoqiqJiGprqGppY2sXkdXV1FP38DQkNmIMocam4CBqRl2aRZz6oYLAwCsqAfxrwfEtQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABHVBMVEUAPYikomb82VXwmUPbKiXZIiNIann711XqdzsLQ4bbxVz5ylHiUTCPlWv0rkndNCg1Xn3511bukEHaJiTdPD3pgYL309MEP4fNu1/70lPmZzbcMjPoenv2y8v//v7///98iW/2v07fQizbMDHnc3P0vL3+/PwmVIH01FbyokbbLibaKivkZGXytbb++voBPoe7sWL82FXrhD3ZJCTZJSbjXV7xrq799PT5/PrU6d6hzrZ3uJVMonQZh0xmfHP5zFLiVTDZJCXiVVbun5/87e37/fzd7eWy18N/vJxVpnsqkFoCezsAejkZTIPmrlDeOinfRkftmJj76enl8eu73MqQxaldq4EzlWEIfj+Zf1+2kH6WuZ9us447mWcNgUMR34yVAAAAo0lEQVQY013IVbbCMBQAwBC4uLsHd3d4D3co7rr/ZUBa5ND5HIQ4AswSioDzajG7EinAz8vktBVK4L2KtloDvNfqnq03fNJoMtO2WDG22d/pcLrchND3YOz1cekPBEOEenY4gqMxmvFEMkVeEEpnsrk8QKFYKrNTqdb+/usINZotaHe6PUL6g+FoPJkyFJrNF8vVerPd7Q9H5gudzpfr7c7wPQAd+x77LgVUZwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAYFBMVEVyZz0AlznvM0BuaTzuNEBhbjzvNEC2hSiSuRjvND/6mxb/0QDFoQDvNj/6oRPvxACMcwApIgDVrwB6ZAA2LACcgAD9zwAAAABcSwABAQDbswC2lQDUrgCmiADIpADTrQC2FjWHAAAAWUlEQVQY02NgYMQKGJiYcYizsGIXZ2Jj58AEQHEmTi5uMOBBIkHiTLx8QBa/gKAAP7eQsIioGIo4t6i4KJCUkJSCqYeaIy0jDSRl5eSh4jjsxeVOHP7CEQ4AgqkGZsn8XnAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAe1BMVEUAAAArKysBAQEqKipwcHAtAAC9R0csAABxcXEpKSl/f3+AfHyzEhLfiIizERGBfHzNRESlKSm7AADfh4dAAAC0AADORUWzAABBAAArAACjAADkmZnNRUV/sn93i3OyGRKzFxF1iXAAZgAOYw4pZSktTgC+UUcsTgABZgFE9ywxAAAAZklEQVQY052MRQ6AUAwFi7t93F3uf0JY0PKDbJjFS2bSFOAngniMKDy6JCuqphvkJmLZjuuRgY8ELGQBGTAkipM0I7t6XpRF/tKjuOLvv/7XSNM6XU8Gw8k4zcs6jajUN275fuOr70fvGDJ2E7pkAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAb1BMVEXPFCvNHzXNHDLNFizSX2PQO0rTPjfPTVbMHzXOGC3Vko7Vlp7irZ3lsbfWaHPNUVzOFCvUNyrGPEjIr5DJRFDeqbDLGC7NGS7pwsfMmYfs3+Hmzq/UWF/s08DMGjHSZnTTgIrULijWfn7NLjrKL0LXcCKvAAAARklEQVQY02NgoC5gZGJmYWVgY+dAE+fk4ubhZeDjF0DXIMggJCwiKoZpkriEpJQ0FhtkZOWw2iwgr6CI3U1KytjFVYjwDwBKWAKr4CnZVgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAA1VBMVEX///+7u7v29vbf399PT09fX1+8vLzh4eH9/f1UVFRRUVFXV1esrKz67O311dj66uuxsbFjY2NnZ2dsbGzExMRbW1tlZWX77O7YXmjOMDzNLjrNLzvedHz88/OUlJTT09N1dXXv7++8TWDdcHjS3+7HLzyiM0+ZNFTLMDz44uS7zuZ+N2F+SnYAR6BPPnnyys3a5PEDR58uQYklQo0HRpz33d9PgL1La6lcXFzw9PlWhcABSKAFS6JbicKBgYGrq6vm7fbM2uzp7/ewsLBmZmaQkJDi4uIWoPMUAAAApUlEQVQY04WQ5w6CQBCEBwUE+ymgnkqxt7MXsPf3fyQlASTE6PyafMnOzi7wS1wssDHug+O8IHpWFPiEjyU5mUoDmWwOyJNCUfK4QlQNpXKFVmt16CpR/AHDtNCgrpqwTCO8udV+00631480GgwpHTE2nkT4dDZfMMaWqzB089fM1SacrxBbg7Pdsf3BgW4HfST5qJ6A8+UK3O6PoH/k3uff/3zRC5XAD1j4FRHxAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAqFBMVEXX6vmFwOtqsuf////+/v/J4/Z3uen4+/612fNvtOjr9fyby+/f7vqMxOz//v799fX+///N5fd9vOr3zc/wp6r5/P652/RytujzuLrbKjDZHyXunaDX7+ZHtI8+sIniVVnhTlP88PH2/PeQ2ZwesTYSrSv++fn99PT++/v+//6w5Lgwt0bM7dFIwFvf9ONgyHH0+/WJ1pUZsDL9/v2p4bIntD686MM6u0/kz7/mAAAAeUlEQVQY023JRw4CQQxE0YYiDKnJOQwNFEPO4f43Ay9AGtl/UZaenctkrRxy+YLpQDEqmQ6UK7YD1Zrhvg40mi3l7Y5st9dP+2A4Gnv5TKazX+I+nofvWSxX/Ce+TjYB292eTLt0OJLaT2dS++V6o/b740mde71p9QGmkhhgP1Q6jgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAgVBMVEUmi08+mgACdMgykygAc84JebE6mAwTfpA+mQEiiV0Edc/C3vP///////H//9j//8gYgNPm8frb4ttZtFix1bFwsOTU4NS8tqTg5eD9/f3q6urFtqnr6+v7+/v8/Pzx8fHw8PD+/v5+RWnjIRhFWpbiIRkgaLTWJiMHcMm2MjuMQF4JUv9QAAAAa0lEQVQY02NgYMQKGJiYsYuzsLJhF2dh58AuzsKJQ5yLmwcIePn4+Xh5YAAkziIgCGIKCYvwoIqziIKYYuISPFjUS0pJy8iiiEPMl5ORV1BEEVdSxgRAcRVVrOJq6srYxDU0lbGKa2EVVgYAIWYVicEIGJMAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABQAAAAPBAMAAAAWtvJmAAAAFVBMVEXIEC7kjJr////srLbnmab0zdT32+ClUFYUAAAAIklEQVQI12NgYGAQMmCAAXKYLi4uQSkuIMCgBAfIohRbAQBEPAoZMZOreAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAKlBMVEX////1m6foES3pJCvqLCrsRyf53RbqLir2pbDwaHrrMSnsOyjsRSjsRCgRQbbQAAAASUlEQVQI12NgAAJGJUUGOGA0MUTihAUiccoKsXA6gKCzrBJENTAoKWltcTl2xGWXkpICkKObBgK5EA6SDIoe3EZjugDFbVBXAwCpGB6Ziv0y+AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPBAMAAAD5dJlYAAAAKlBMVEX///9niNUAOLg/acqsvuj09vzd5Payw+o1Ycft8fo6ZciZr+NxkNeou+eI2VcqAAAAO0lEQVQI12NgQAKCcCDAoAQHCgzGcGAAUegA18Ka3p4KY3Mu3rwSLnGW9wA2cWT1cHOQzUe2F9k9SAAALtsRk/KMpisAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABRFBMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBU4kHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAIWkILF8iLlsDIWjeb4HMIDzXUGZvSHUFJGczS1UoQmBBTWoVLmwJK2EFJ2QbNmA0XD8QOVRHXllgdE0oP1uJjDoZR0dneqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYIONlYpYy8ZQU9lYV94hUI6V0mknzJlbkjdsL7Tg5duY44hPXyipsDnnapIR3wvTFGVpDpcb2VsbnNTfTE6WEgSL2QGKGN+iTYXbIE4g5NPjnIPbZssUUY7V0o/Yz0QYoWMsIOzyaIXcJZXbz1FVVJtdUVGcVdcjCB6nB1Hdk0dT0EDI2hFWU1YgyWCnR44Uk4hO10hOl4LL14cQFQfOF8NKmU6d4GjAAAAo0lEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExkIC4hCRYXAoEpGVApCy7nDy7gqKSsgq6uKqauoamlrYOyBxdPX0DVkMjYxNTMXYzcwtLK2sbW6C4nb0D2F5HJ2cXdnZXN3cPTy9voDg7MvDx9fMPCAwKRhdnDwkNC4+IjMIQj46JjYtPUMEQT0xKTklNY8cQZ0/PyMzKxiIOAwBVaRzQF4D8HwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABAlBMVEUAUbosb8ZMeInPuS/avyARXL7s8vlyn9hhktXt8/oVX8A6bpS/sTrhwx55iygkXTI6ecoPXL4aY8EnbMQ/e8o1bJiyq0HqyByIkyYoXzIhWzMBUrrF2PDU4fMDU7sqZp+ppkjvyxuVmSUtYTElasQ4d8k6eckgYaaYnlOVmSYwYzEQXL7q8fpunNhdkdTs8/oUXr8cX6iQmlvxyxujoSQ2ZjBLhM4xcscrbsZPhs8UW62GlWDwyhurpiQ+ai8NWLJ3jWztyR2yqSRCbC4KVrR2jW3syR7BsSJLci0GVLdlhXjkxSLItiFWeCwCUrlUfIPbwCfMtyJaeizXvynTuiFjfytYc/lxAAAAlklEQVQY023IVQ7CABRE0Snurg8pxd3d3V32vxXaBtqkcD4mkwsw4IkjUak10Or0gMFokqvZYrXZAQfjdLk9UvX6/IEgEf9C4Uj0W9kYF08QCT2JVJofQSbL5fIkQqFYAsqVKlCrN5ot+gDaHaDbQ38wHI2J5C6aTGfzBZGiL1frzZZI0Xf7w/FECjhfrrc7/cDj+aI/3posGaEuVQWgAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAANCAMAAAB1uQVvAAAAP1BMVEXVKx7xuLTutrLgsa3////+/v7V19bX4tvQ09Du7u6+18fy9tG51cPv7+/f4N/a8ePd4N6rveKpu9+mtNQAOKgKPDesAAAAOklEQVQY02NgoDFghAMmZiYEh4EFBljZ2DlY4TyEOCcXNw8vFnFWPn4BJPWCcCAkLITgMIhgB9QSBwDtvAo8yXe05AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEX///8AOabVKx69XQKiAAAAFklEQVQI12NgIAxCQSAEL7UKBFbgowBmmx3UA+477wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAQlBMVEUAKRQAcTgAej0AAAAACwYAVysAMRgAdToAFAoAYjFAQED///8hAwalDh7OESYBAABSBw/FECQTAgSSDBtIBg3AECPwjUBLAAAAPElEQVQY063IORKAIAADwGDwADUewP+/ijWT0i0XCJMDxtk/uaz+uSX/zPvo1z9Ojb6/7kfm3yIDtblWB32PCP28EBo5AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAKlBMVEUALWIINGf////QGC3OESaptLexnZ23raigs6CaiY2Jq46de3O3kpKLdGca2uM+AAAAL0lEQVQI12NgAAJGJWUXIHBgoJijBAJhRSBSAcLpXITE2XMJwgEpdlZSBOulmAMADykagEpJssQAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAUVBMVEVJl9CGuuD////5+/fH07zn3bK4voLo7ubO2cS9y6z7+ezv3pHa4MS/zbO+zK/Vw6XWw4i4vJnAyq/T0sSvsove6NyiqHzY2M34+vf9/f319/M8ak2oAAAAPElEQVQY02NggABGJghgZEAF1BRnxirOwsrGzoFFnJOLm4cXizgfv4CgEBZxYRFRMXFs9kpIStHWX8jiAD1tAg38qwmYAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA/1BMVEXXUWfzy9H09fmIl7kSMHMBIWlsfqjbY3fIEC4OLHGAfaLZbYHVSWDxwMihj6vZX3P00Nbu8PV6irAMK2+AgabaeYvTQVntr7n7+/yap8QhPXyhjKnaYHPaYHT32+Dr7vN4ia8JKG4HJm1rdZ/Yg5XSPFXpn6v9+/yqtc0nQn8rRoKxkanWT2X43+Pi5u6nssufp8PVjZ/TQFj++/y7xNcyTIb0z9XYU2n+/PzWgpSpr8idqcXd4ev55ejecIK+lqyZpsP8+/zTP1fZeIp9gadneqXm6fD44eXXU2iwk6z7/P3wv8fURFzXan6Bf6T219zWUGaji6jaboKOiqvx8/euwUIwAAAApklEQVQY02NgYGRiZmEFAjZ2DnY2EIOTi5uHl4GPn0FAUEgYLi4sIiomLiHJwColLSMrJ6+gCBZXUlZRVVPX0GRlAGrU0taR1dXTB4obGBqpGZuYAsUYzODAnMMcwWHgwA5wiuMyB2SvhoW4mKUV0F5rG1s7HnuwvaxSDo7iTs4uUHe6urnbeXgC3Snp5e3j64fkLyFBf9mAQAZenqBgtHBQCGFkAABJ1Ryv4PDW2gAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAYFBMVEWfI0ZsJVdvJVYAKXsTKnZLRn+GlqtPSn8vOHt1sbY+pF98tsE0OX1rbJ2Vze2ItL6VzO1sbZ1oa52gzeqXq7yaxuN2cp4sPIFsj6Y4krtzjIgxP4JJUYqok3hgXoQSK3f0VHLIAAAASElEQVQY02NgYMQGGBiYmLEBJmRxFuzirGzs2MQ5OLm4ebCI8/LxCwhiERcSFhEVwyIuLiEpJY3NXhlZOezulMfhfhR/4QgHAFEyBF992r2cAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAA2FBMVEXPFi3TJjztpa7//v7//////fX/+dv/9Lb10NXZRljPFCvZRFb1ztP71Ez5xjX81Ez21dnaSlzYP1L0ys///f3soarSIjfQGC7keYb88vPeeDLkeRfgaDb99fbniZXQGjDRHjTpkZz+/P366evhanjPFSzUK0DtqLHjhC/skRDpgyvxuL/UL0PdWmr65OfzxcvXPE/bT2D32NzplH/jfhfokoP43uHcVWbWNkryvsX++vvqmaPRHzXQGS/jd4XplJ/mh5TQGjHRHDL++fn54uXeXW3QFy377O5Tvh7EAAAAqElEQVQY04VQxxaCQAwMEFDX3rFh7733Dvr/f+RuEFAvziHJzHtpAyDJCgqomk9TqVJkCcAfYMEQ0XAkSjkWZ4kkYCqdyeo5zvOFIo8lo1yp1hB4WW80W20FO90eYn/AhiOuAbWOJ2w6my+WqzXbbEmxddztD8fT+XK9GXf81BFNiz2YZTr0jy7m6E/jdw7t5fl77/tOgnen+5cN5y/PBwe2D65vHoRvL+q6Ff6IsAd1AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAxlBMVEXkgJfesMBecqADI2o2T4jpLFDEgZwBIWkkPHu4bo/yk6Zvcp0HJm2CX4rme5PZsMJ5irDJhJ+laI3vh5y/scY0TYcaN3hbb57vZX/mETnrRGSeZYsfO3thdaEQLnJneqXnrr7cdI6IfqTIhJ+Kk7bwoLHNb4w+SIIKKW6ap8RAWI7krL3gfJVzYI4hPXyjpcDyl6mDX4oUMnSfq8cFJGsGJWxPZZczTYYCImo5Uorn6vGgrMdJYJPl6PCnsssRL3IoQ4AnQn+rTNqoAAAAiklEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVGwgJg4RFwCBCSlQKQ0SEBGFrs4EMgxg8yRV1BUYlVWUVVTZ2fXYAGJa2oBxbV1dMH26ukbGLIbGZsAxU1NgeLsGMAMbD6IMDFntkCTBItbWlmzYxO3sbWzhwnA3A8mHRzhCmHuZ8cOAEtZEAuc6acEAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAb1BMVEXtKTnuM0L4rLL2m6LvQlDwTFrtKjr4qbD5ur/uOEftLT31hI3uNUTtLDv96uz0eoTzb3rwTVryZXHxVmT71dj2j5ftLj7yZG/uNEPyYW385+nvQ1HyaXTtKzvyZ3LwSFb1gYrxXGjtLz/2lJz///8R4OADAAAARUlEQVQY02NgwAkYmZhZWNkwxdk5OLm4eXgxxPn4BQQZhIQxxEVExcQlJDHNEZeSlpGVw2KxvIKiEoagMnbAoIIdDDZxAAntHDQVlGXOAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAflBMVEX///+/z8YBQRwAQRwZUzFhinMIRiIhWTjC0skHRSFTfmUwZEa5y8F6m4g9blHt8u9zloH+/v5bhGxXgWk1aEp9nYre5uILSCUDQx+4ysCvw7gNSidJd1wgWDjj6ubm7OmNqpppjnmIppWjuq0YUjCTr5/5+/rV4Np2mIQGRSCmRd3BAAAAZElEQVQY02NgAAFGJnTAQJw4MzZxFlY2bOrZOTiBJBc3ujgPL5Dg4xdAE2cRFAIJCLOjiYswiGJ1D4ugmDhYSALNfEkGKWkgxSaDJi4rxyCvoKikzInufhVVOTV1DU1SwoGgOAAbzAVTPYyXQQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAASFBMVEU3fj/////ZhJbahZS0Ci3PZSW2Eyy7JCu+Lirrwx21DSzQaSXrxh7syB3rxh3UdiO2Dy3emSG5GSvZhSO7ISzWgCO4GivahpNAStE9AAAASklEQVQY02NgoBJgxA4YmBCAGYnNwIIArEhsuDgbOwcnBzsbhjgXNw8vH78AhjgLiyCfIBZzWISERUTFEOJwF4hDMdQ9uNxPJQAAN0ADTQspKCgAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAFVBMVEUAaqfPuh/+zAAQcJ1mkmTiwhNwlV5PgRZyAAAAKElEQVQI12NgYGBgVDJggAOSOS4uLq5KKS4g4MCghAAKqBwUZZRaCgCMOgzBTZFQ2wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAWlBMVEX////78fPceJDFIUi9BTHFIknceZH88vT77vHILFG8AC3ILVL77/LXZoHXaIP+/P2/DDe/DTj66+/67O/ADjnXZ4LYaYPILlP78PPcepG+BjLFI0rce5L88/UUixQWAAAAUUlEQVQY02NgoDJgZGJmYWVjRxfm4OQCAW4eNHFeLgjgQxXmF4CKC/KjiAtxwYAwqnpBqLAIqnoGUai4GJq9PNxgYXEJdIeyS7JKScvIUjtYAIGVA+G1KEWYAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAM1BMVEXOESbdUCD80RZ+ChfGECVxCRUIAQEiAwaiDR7JESUHAQEkBAaKPzEAnkm0DyGxDiGZDRw2SUCIAAAAMElEQVQY02NggABGJlTAQEVxZhas4qxs7BzYxDm5uBkYeHhRAVCcj18AqzgY0EocACIcBgHfy+uqAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAclBMVEV9CxEHAQEAAADEERueDhYZAgO1EBk3BQjDERtpCQ4CAADVV1777/D////zz9Hssrb55ufMMzv11df//v7bbHHghInzztHcb3XiiI3WWF/78PHss7b55+hpQioCeT0Aej21GR43XTSeJSIZbDh3OigGdzx2YbBOAAAAWElEQVQY023M1w5AUBBF0cvojN7bqP//i4hEgrMf18NWStNRigwTO1k2dnJcDzqRHzBzGMX8dDslKWd5UWbIq/rnTXt9uv79cYZRvp0+zSLAl1WQbztiOQAY8g/AtR/zFAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAdVBMVEUAZjN/spn///8SXjOQj4T77O8JYzOILjTNEjS3RFTngJPuprP99PWRKzTLEzQxUjP+9/n98vQgWDPSEDR4NTSKnYzxtcDog5Y9TTNUQzR/sZjYMVDWJ0jxt8IfWTN5NDSQKzQyUjOHLjPnf5IRXzOQkYT87vFlICbWAAAAWklEQVQY02NgQABGJgRgIF+cmYUVizgbOwcnFzcPhjgvHz8jk4AguriQsAiDqJg4hjkSwpIMUtIysujicsLyWNUzKPApYjOfgU2Jg1MZi3sYGFRU1agSDijiACMABNR24FcfAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABQAAAAPAgMAAACZ9gfGAAAACVBMVEUAnmD80RY6dcR21W9yAAAAFElEQVQI12NgwAtCQQAnuQoEcJEAbwcY6B4ms/YAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAdVBMVEUEajjwxwMHBwXw9vMnWDfWMSelFDLWPmGCnByGlR3JEy+0FTK3MWizETTIEy+FlR1/ZgCXSQ6yEjPVADNYVWzICzqWSg5/f3+XXGrVADJUS1BdPDWXXWuCtZyGrJfJFj6xFi6yPCGQIzLIFj6FrZfWMiekFDHPYIBaAAAAU0lEQVQY02NggANGJmYGbIBEcRZWNnYWBJcDCji5uHl4+fhhXAYBKBAUEhYRFRKDcRnEoUBCSFJKWkgGxmWQhQI5eQVFJWUVGBfJXlU1ZHup5C8AA3UHwe9lRS4AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMBAMAAAB7FTvLAAAAG1BMVEUAvOT////3/f7G8Pn9/v/J8fn+///A7vjH8Plve+N1AAAAKUlEQVQI12NgIAMICgoKGQoKGgFpARBHJDA9MQTGETKUQJYRFITIkAEAp2MFalniWtkAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAUVBMVEVNTi3LEzPSEDQAcikoXyu3HTIQayqYLDEBciliRC7QETRLm2ju9vH///8khkfS5tlMnGnv9vIAPRYAAQAAAAAAaiYAIAsAXCEADwUARRkABAFulXIjAAAASElEQVQY02NgYGTCBhiYWVixizOzsWMXZ+bg5MIqzszMzcOLBiDizHz8JIkLCGI1R0hYBB0AxUXFRESwiItLiGATl5TCJiwCACYlC4S3tMoUAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAATlBMVEUAo+ABo98GpNoDo90bpsZIrJo6qacOpdIHpNlUrY68uCmrtzk5qqgEpNxBq6GttzebtkonqLoCo94Spc4qqLcMpdV9u3D60gFWfC4gYD0DjYfQAAAAQUlEQVQY02NgIBYwMjEzYhNmYWVjxyLOwcnFzYNFAy8fv4CgEBZzhHlERLFaDLFWDDtgEMcOSBaXwA4YJLEDUsUBMr8SDhLntjcAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAhFBMVEW7yuj0yMwiU7QAOKj+8bf38daAnNQIPqv//vn////c5PNLc8L+99azxOUhUrP//O/+7qv+6pP+8r7/+Nz2+Pz+99f95Hj80Rb83l3+9c/h4MpKcsH+5Hr93ln427vcVmXOESb+6ZD+87/99/fniJPQGC3wuL7UMEL43uHcV2b98NLVMUPZ2sZoAAAAAnRSTlP06KiSg8sAAABoSURBVBjTY2BgYsYGGFhY2dixiXNwcnJxYxHn5OTk4eTlwxTnFxAUEhZBN4yBU1RMXEKSk19KGl1cRlwWKC4nr4AMQOYoKgkrq6gqoImD7FVTV0ADIHdqaCpgAAYWLXQjIOKM2grYAAC4UBL7wX2mzgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAb1BMVEUeRY4CCRcAAAAPR68ORKkIJFgAAgUNPZcEFTMpUJlbYnBmZmY8Y48lVaAXTKkWRqx5RX3bQ03iQ0odUKaHlFvhzBxpgG8sQJqfIkXaEhoraaJeqYlquIMOUJ4JdlUHiTAOSasLaHAHhzMfZJgIgEGiIGMNAAAAVElEQVQY03XMRxKAMBADwQWRc85g0v/fiH0Ds+7jVElEls0hOK7HdsAP+A6EUayRPUkz5EVZfRDqpu3kpB/GN3M3/SjTvGhUXzfxQ9iPUzD9ugXnAYMuEcki7Ux0AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAJBAMAAAAr2Kp4AAAAD1BMVEX////9+vvPoK6VLEyKFTi5MywGAAAAFElEQVQI12NgYGAQMnEBAwcGOnEANqcTD7fVKCAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEXZECPmYGz///+RSO3zAAAAEklEQVQI12NgYFy1kgEIaE0BABapE+2PhiKAAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAflBMVEU/O7DDDivuAAAAUPACT+5XM5jZBxYLTOV3KHjnAwgdZPKhvvn+/v////82dfPF1/xZjfUBUfBVivXf6f05d/NOhvXm7v5Ef/QucPMITehvK4DhBA0mavLT4fy70PsWX/EwQMDiBAy0zPuow/qTtfkCUfAna/IpbPJDOazGDSiUm2f/AAAAZUlEQVQY03WQxw6AMAxDC2bvvffm/3+QCk5FaaRcXiLHMWOKShWDphskB0zLJjnguJ4v1seBICR4xDtO0h/P8qKs+KRuWkG/6/1hfMWmWbi7rBuI/f3ASenL/Uj80/9K8rluMs8H+b0KR6DEEDcAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAANlBMVEX///+FcuwaGusmJvXn1OxwVONVVf8ZGf/jx+MAAP9PMuLu7v+rnvIQAO8TA++Kad5NLN7/AAAH02ScAAAAMklEQVQY02NgIAMwMjGzYBNnZWPnQBfjBAIubh5eTlQAFufjF+DEJo4F4BQXxA6oJQ4AKUUJmf1vhdkAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAANlBMVEUAIJ+MmtTG0OSHraHF0OOvuN/DvcnY2rrFvsvSEDTvrruajn7HfmafjHypjXhullxvklWpjHgdfuL3AAAAMElEQVQY02NgGGjAyMTMwohFnJWNnYMVweWEAS5uHl4uOA8hzscvwC+IRRwV0FocABKaBf8MHJHJAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAflBMVEXGCx7UORb/xAD6wgLklBHNhhXchRH5vQblqATXfwvKfBrSnzjwtQv0vAH9vwHVmD67YRPFgE7anrbcqE3rsiD4tgLWlVG8aSd5UVrGjHPZn1Dknyj8vwHevkK9bCG7Yja0SxLdqT3rux77wgbcuSr2vQznwTbzuhvqvBrsvhU0E+vRAAAATklEQVQY02NgoBJgxA4YmCCAmQkVQMVZWNnYsYhzcHJx8/BiiPPxCwgKCYtgiIuKiUtISkljiMvIyskrKCphiCurqKqpa2iiiONyP5UAAMCPBH1vEdrAAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAflBMVEX////++vvwvMXmk6HnlaLyxcz//v7zzNPQM0zIEC7TQFj33OH219zLHDnOKEP66OvYU2necYL88vTJEzDMIz7lj53ljZvigJDLHTn+/P377O/vu8PpnqrRN1D55unNJkLTQVn32+D0zdTQMkzJFDHXUWfhe4vgeYrVSF/IES8TRPUBAAAAa0lEQVQY053LxxKCQBRE0SFKkyQ4SFaR+P8/KKgPaphiw12e6mbsVIqq6YYp8cXCnO3s2PXwzb+KHuBfKHAUk9825Jwn9zVOsXmVZjTK6YjFUZCXolfRj+uH6Hi+Fm7e2Dnarh/GCZJLHfkH/5kKG9YgUSwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAADFBMVEXOESbW2ewMHIw6dygSYlkVAAAAHUlEQVQI12NgIAxCQSCEYRUIrECjoHL/QeAPPgoATe4tvKdIBBMAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA9lBMVEXUEiuuOyuDaipVnSpDsCrkACvPFyukRit5dSpOpCriAirDIyqZUitugSpIqirmDCvwVyvsPSvuSivrNyvhAytGrCr1eiztRSvqLyvuTSv3iSvpIivdCCu5LyuOXipkjStEryrlCiv2iCzlCSvtQyvrMyvxXyvVECurPSuCaytYmSv5mSzvVCvvTivvVCzuTCzxYCvWDDmuMGeCVpZWfMb2hCvyZCv4lSzqLivdBjO4JluNTIpicrtCjt1Bj97oHiv1gSvxZivzcyvkASvhAi3DHU6YQ39taa5EjNrmEyviAi1Gi9jPE0OjOXN3X6JMhdLUDz5Tf8s3YM3mAAAAlklEQVQY02NgYGRiZsEEDKxAwMbOwYlNHAi4uHl4+dDE+QUEhYSBtAhQThRJXExcQlJKGqJPRlZOXgEirqikrKKiqsYKB+oamlogcW0dXT19A4S4oZGxCcgcUzNhfXMLiJillbWNrZ2dHUjc3sHRScCZldXF1c3dww4CIO70VPQCinnbIQBY3MfXz98OFTAEGBkH2mECAOSTHmEXKaRzAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAFVBMVEX///9if6QAL2zG0d4WQXkINnERPXZBswPCAAAAKElEQVQI12NgYGAQUjJggAOSOS4uLkFKKS4g4MCghAAKqBwUZZRaCgDT0A2FJrZ8kgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEUAcs4AAAD////xir3pAAAAFklEQVQI12NgIAxCQSAEL7UKBFbgowBmmx3UA+477wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAABWVBMVEUAlzkJmTeIsxvZsQFBNAAAAAA7oyzVwgmIbQAJBwAOmjaWtxfQqAAzKQARDgBJpynewwYODQhvb29OTk4iIiJMPQDhsQIQmzWZtxfNpgAxJwAUFBTg4ODy8vIPDw8WEgChgQDyogvRLSdNpyjcwAZ3YAADAgBLS0uhoaGrq6tWVlZWRQHptgLiaRnIEi7IEC4XmzSruxPDnQAnHwAnJycxLRuvjQDwmA3PJyhVqSbevgRuWAACAgABAQBdSwDrtAPeXBzIES4anTOwvBK2kgAiHQUBAQEhGwC8lwDvlQ7OJCkBlzlmrSLjvgNmUgCVlZV3d3dAQEDuswTcVh0injG9vw+yjwAaFQAoKCjW1tb///9JSUkrIwDIoQDtjg/MHyrguQJURAAbGxuamppEQ0F5YgPyswXYRiEDAwNNRSHRpwDogBPLGiv0sQbWQSI6LwDXqwDpgRLKGCw768TXAAAAzElEQVQY02NgQAWMTMwsrECAJszGzsHJiiHOxc3DCxZl5UMW5hfgEBQSFgEKi4ohRMUlJKVYpWVk5VjlFRSV4MLKKqpqrKzqGppa2jq6evpQUQNDI2OwwSamZuYW+vpQcUsraxuwsK2dvYOjPlTcydnFldUNJOzu4emlrw8R9/bx9WP1DwhkZbXxCwrWhwKGkNCwcNaIyKho1pjYuHh9uHhCIlB/klZySmpauj4CMPCB7cvIzMrO0UcWBwtzcuTm6etjiOcXFBahCusDAGkxKqefEuGNAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMAgMAAAD0Vc5rAAAACVBMVEXOKTn///9HcFDpgHEQAAAAFklEQVQI12NgwANCQSAEO7UKBFZgpQAtSBfdnXT9/AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAATlBMVEXNESX////Y6+HX6uG+3c7+/v75/Pq02Ma83Mzn8+3K5NeBvp+l0Lt4uZj9/v2hzrdpsYyp0r5ztpRytZOdzLTM5diJwqWezbX6/PsAAABnxhImAAAAOElEQVQY02NgGCDAiB0gxJmYWVjZ2DnQxDm5uHl4+fgFBNHEhYR5eUVExXjFJdDNQTNfEjugtTgAwMIM55VOkngAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA/FBMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBU4kHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAIWneb4HMIDzXUGZvSHWmpJrfzIxLXoYZPHUre0YObDldi31neqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYJ5a5DBk5C9joqyh5LdsL7Tg5duY44hPXyipsDnnapIR3zFeoTji0Xbbj/VUT4RL3KdrMKKnoOZp7GRpJINK3AaNnK7pbGJnICLoISSp6B7XHzCk4bZyX/E0NaUqY7e2bTXuH5XSHk8UnuCjIjIxovNz5e2uYpnd4oFJWuyxkhuAAAAh0lEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExZHFxEJCQBJFSIAFpGVls4nLyCooQc5SUVVRZ1dQ1NLVA5mjr6OrxgMT1DQzB9hoZm5gC+WbmFpZWIHF2VGBtY2tnjynu4Ojk7OKKKe7m7uHp5e2DIe7r5x8QGBSMaT7cXzjEAQQTFDDne6XdAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA/1BMVEXXUWfzy9H09fmIl7kSMHMBIWlsfqjbY3fIEC4OLHGAfaLZbYHVSWDxwMihj6vZX3P00Nbu8PV6irAMK2+AgabaeYvTQVntr7n7+/yap8QhPXyhjKnaYHPaYHT32+Dr7vN4ia8JKG4HJm1rdZ/Yg5XSPFXpn6v9+/yqtc0nQn8rRoKxkanWT2X43+Pi5u6nssufp8PVjZ/TQFj++/y7xNcyTIb0z9XYU2n+/PzWgpSpr8idqcXd4ev55ejecIK+lqyZpsP8+/zTP1fZeIp9gadneqXm6fD44eXXU2iwk6z7/P3wv8fURFzXan6Bf6T219zWUGaji6jaboKOiqvx8/euwUIwAAAApklEQVQY02NgYGRiZmEFAjZ2DnY2EIOTi5uHl4GPn0FAUEgYLi4sIiomLiHJwColLSMrJ6+gCBZXUlZRVVPX0GRlAGrU0taR1dXTB4obGBqpGZuYAsUYzODAnMMcwWHgwA5wiuMyB2SvhoW4mKUV0F5rG1s7HnuwvaxSDo7iTs4uUHe6urnbeXgC3Snp5e3j64fkLyFBf9mAQAZenqBgtHBQCGFkAABJ1Ryv4PDW2gAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAZlBMVEXAJS0OAwPtLjjkLDYrCQrsLjjrLjdaERXtLjjtLjiaHyXtLjjsQUv86+ztND77ztDuNkD82drsTlX+8/PtLjiHWjjqMDlKdjndNDghiDiyRzgHkjkAAADtLjgLCQn///8BlTkAljnOpWVVAAAAHHRSTlPN+/bi7fj03fr+0PzX+Ojm4u3U+v3R7+Hc8cr9aTGF8gAAAFJJREFUGNNtzDcCgDAMBEGRMSbndID+/0kMpawtp1ii4NSiMIpVT5BmmueAKS7fLVxldYvIfI66kf4z2k71fvA+I2Cnh2XO54VZ8XVjzfdDY34BV/0ewll6G1AAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAjVBMVEXOESbaTVz/////+vL0xJrakZn/0pP/9+z/9OTysnPtrIbPKj31vH/0snD/9OX/0pTfiHbvtIvLITTrs4niim//xXThhXTOq63NrrLPqqvkiGz/xna8yeS0hJu2Xmijmra6XGeriKa7yOPs8Pd9mcuBlMJyjsZ+jb92lMjx8/vn6/Wfs9iGoM+Zr9bj6fNa3M4OAAAAVElEQVQY02NgoBJgxA4YmGCAmYWVjR3Og4tzcHJx8/DyYYjzCwgKCYuwYYiLiolLSEpJY4jLyMrJKygqYYgrq6iqqWtoYogzaWnr6Ooh3IPL/VQCAFqSBVOmNA8LAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPBAMAAAD5dJlYAAAAJFBMVEW6DC/NT2iuuMsAIFtoe57gkaHUZ33gkKDsusSPnbdidpo7VIFeYyUVAAAAMElEQVQI12NgYGBUdmWAAdLYaWnpyh5pIJDAMHPmzMU7Z4LABAZjODBAEUdWT4G9AL+iG6ltY7JXAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEX/AAD/f3////9miK+BAAAAFklEQVQI12NgIBWEgkAIwyoQWEE8BQATGR3UH+9XwAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPBAMAAAD5dJlYAAAAJFBMVEUCUpwhZ6j1v8bcHjXxpa4/e7Qtb61FgLZekcDztLztipbqeIaLwT0iAAAAMElEQVQI12NgYGBUdmWAAdLYaWnpyh5pIJDAMHPmzMU7Z4LABAZjODBAEUdWT4G9AL+iG6ltY7JXAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAANlBMVEXOESb////79+338uDo2KL17NPz6s7awGrv473av2nz6s3y6Mrz69D+/fr07NLx58X069AAAADdu11VAAAANElEQVQY02NgGCDAiABMSGyEODMLKwszFnE2dg5ONiziXNw83FxYxHn5+AV4EeKC2AGtxQF+Tgi4/zoFJwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABCFBMVEXZiJrYtMFecqAEJGs2T4jSOlO7hp0BIWklPXuudZDmm6hsc50HJm18Y4vZg5XTs8N5irC/iJ+cbY7ijp29s8c1TogAIWnecILMIT3XUWeVaowdPoVMc7RigLQ1asI0XqsjSJJyhrDMysnHyMm5vcIzb89neqXgsr/PfJCDeZ6/iaCKk7bnprLBdo0+SoMiSJIufvW/v7+rrrKurK40cdHesb/Tg5duY44iPnyipsDnnqt8Y4ozVpqhxviUn5CjpJOesaF5oN8rSotzp/i7m2LRoEqMmKNbhs2TqtSzk2+qloWofUpRZZhLR17CmXaDgJC3ilWjiIS4kWsbKmCfcFzBq4a2nX5+U1B4z8+gAAAAjklEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExZHFxEJCQBJFS7OzSMrJycvKY4gqKSsoqqmBz1NQ1NFm1tHV09YDm6BsYGhmbgMRNzczB9lpYWlmzs9vY2tk7OILE2VGAk7OLq5s7pji7h6eXtw+muK+ff0BgEKZ4cEhoaFg4FnPg/sIhDgA6XhXKMajLpAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA+VBMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdyncditeUHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcxa6feb4HMIDzXUGagkrNks+B4n8RvqNFsoMjZcEvYkQ7niRPojBK4Z29neqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYJop8/NonzOlHjYelu7moKpn5jdsL7Tg5duY44hPXyipsDnnap5kbplrNW82cfN3M7aeYah1Lemy9lppMzaYHTZWm/QM0zYXnKyhJthsd/a5Ob99fbceIeSyIWRu9VxtNvDx9HNbXyDtsJitORlq9cKyHJOAAAAiklEQVQY02NgYGRiZmFlY+fg5OLmQQAGXj5+AUFWIWERUTFxZHEJEJCUApHSPDwyskAghykur6CopKwCNkdVTV2DVVNLW0cXaI6evoGhkTFI3MTUDGyvuYWlFQ+PtY2tnb0DSJwHBTg6Obu4umGKu3t4enn7YIrz+Pr5BwRiEefhCYK4nwc7wCUOAEVcF1ylmDb+AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEXOESbdUSD80RZTqEcAlGDQMwcOAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAvVBMVEVEHRiypXeIt3swlWoqk2qjGic9Cw5vOxvtz3Pc2ZeqxotDm26+Hi2FFR80DguraxH/yi7923Tn25K5zJFXpHK2HStfDxZDGQzcmw//wg7/xyD/1l7s2obL1JeCtXwsk2ucGSU1Cgx4Pg/6vA//xBb/0k723Yba2pyXvoM2l2u9Hi14Exw3EAu5eRD/zDf623fd142yyY9QoXCxHCpTDhRRIg3lpRD/ySr+2W3q3JDH0plsrHaxpXiEtX0vlGuBewK2AAAAdUlEQVQY02NgYGRiZsEEDKxs7BycXNwY4jw8vHz8AoJCwiLo4jyiYuISklLSMrJy8ijiPDwKikrKkpIqqmrqGprI4jxa2jq6kiCgp29gaIQQ5+ExNjE1A8tImltYWlkTEMdhDnZ7cbgTu79whQODja0dlnADAInSFUCbssbLAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAANCAMAAAB1uQVvAAAAolBMVEUjn0BCrVtQs2dKsGJNsWVNsWNOsmVMsWRLsGNPsmZKsGNMsGNLsWLD5cvJ58/H587I5s7G5s/I58/G58/I5s/E5cv////3xsbxo6P87e3ukZHvjo7vkpL97u72xcXnW1v2x8f2vLz2wMD2vr72v7/1vr72vb31v7/2wcH1urrfISHiNTXgLCzhMzPhLy/gMDDhMjLhMTHgLy/hMDDgKSnaAABaHuESAAAAfUlEQVQY02NgoBJgZGJmYWVjZ+Lg5GLjZmFn4+DkYWJmYmTg5ePnEwBCQSF+IWEgGwiFRPhEGcTgQFxCHMFBiEtKScvIYhEXk5NXQFKvqKSspKKkBCRV1dSVVJXUNVQ1VDQ0GbS0dXT1gFDfQM/QyNgQCAyA2ITBFDsgVRwAFwYd4K1EW74AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAz1BMVEVMpyjeyQf/0QAAljkJmDd/sx34zwIknzG4wRAJmkA8r2gipFNMrk7i33f/6H84rWTZ7+FWuXxHtHERnUYLm0KIzqP7/fz///8ImT/l9Otuw44nplcKmkEvqV3F59JDsm0aoU1Zu34BljpdvIHq9u9CsWwboU5Xun0YoEwBlTlXcjvbO0DvM0BvxI8jpFQsgzq5ST43rWTY7+FYun1bvIAgo1IKkjp/YT3rNEA6rmYjekppQ2x3OHMAikgAVocAPaUAkz0AaW8AP6IAe1oASJeEZS3hAAAAiUlEQVQY023PxRrCMBCF0YELFChSNEFb3IK7Bnv/ZyKsaEPO8l/M/YYoFDYhRKIxYwesuLEnknYqndEQsk4uXyiWyiyAeKWKWh1oNIPdZR5anlppd7r+3mN9DIaqj8YT8aPuTDHjwHwh/AjL1Xqz3e0PQuvgR/t0vmi+f11v8g/h/nhKQ3+9pckHVmAmtEXFSgoAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMBAMAAAB7FTvLAAAAD1BMVEUWm2JkvJb/////r37/iD6zcmdnAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGFwcAJtrEwlJBT0KAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAolBMVEUKrbwotasAq8IrtqmHznMjtK17ynoLr7scsrEGrb4ntat9y3gErMAes7FfxIuRz21XwpASsLd9ynk6uqDy6TX/7C3T4UYxt6UqtqmEzXUDrME5uqFAu5326jLa40I4uaI9up8Frb+Z0mk2uKNmxYef1WZew4xEvZmc0mcyt6Uwt6U/up1FvZpCvJxEvJoitK8vuKZOv5UktK0Bq8Eis64MrrsMrgvDAAAAZElEQVQY02NgYGTCBhiYWbCLs7LB2ewcnAhxLm4eKJOXj19AEKFeCCYuLCIqJg4Xl5CEMKSkZWRF5eQV0MUVlZRVVNXUNTDM0dTS1tHVk8C0l0HfwJAZbr4Rwp3GJqaE/YUjHAAYdAfyBLJkmQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAK39UY1z80RbdUCDOESaXqmfeAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAmVBMVEX////+8/P6wsX7x8r93N3uHCX2h4zzWV/wO0MLTqJpbKD3kZX7ys36v8H0b3XwMDkxZaxwa533mJz5srX4nqL1gIXvKDE+aqxubqDxQEj1fIHyVVzwOkLvLDQ6aKw6ZanfN0XDJjx4X42YR2y6KEHRV2gQUaR9dKEOTqENTqIWVaVpb6TuIy2jcJAdV6YyYae8YnvUT2DfQE/VqrkzAAAAaElEQVQY02NgoB5gZAIBZgxxFlZWNnZWDlRBTk5OLlZuHl4+fgFOJAASF2QVEhYRFRNHF5dglZSSlpGVQxeXV1BUUlZRVUMX51TX4NTU0uZEEWcFAh1dPX0DVhTAAKEMjViximMAUsUBjisJ7nhJbJ0AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABQAAAAPCAMAAADTRh9nAAAAolBMVEVMBg7FECTOESYAAAAgAwaqDh/QGSXRHCUHAQF8ChfulhvaRCLVLiPfVyD5wxfxpBrbSSEHBwcmCg3XOSPxoRr2uhf80Rb5xhfTJCR5eXnfViDpgh30rxn2uRjwnhraRSIYGBjWNSPskBvTJiTbRiEODg4QEBDVMSTjZh8DAwOoqKhISEiCgoLPFSUcHBwVFRUGBgbQGCbOEiYjIyMJAQKACxiaTslvAAAAkklEQVQY02WP1xKCMBBFo9cuFixRLBRBbKgo+v+/JmE36wP3JZMzmTMnSjWatSm02v9bp8sQvb7AwdBCgBXOaDyZCnRnRjFfLLVerS30PKPYbHd67wcWhiEpooMfJwSPJU5TqohO5wperjcgy6ji7vDLxxPIc654va0TRVEd9iOU5IJHH+EkyEyFJMlKhUJtn+8PyOcKF1tGu6UAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAulBMVEUAZgDMFAD/AAA1hgDeZAD/DAAygwGVwBFrphHsqhH/iBH/ZghPlQDx9xT8ZxH/QC/9ZRf9TxT+mET/nwCOuwDb6RT/KBz09vuyv9//g3v/bUn/iQDE3ACYwBT8YhWludmZq9PRiXH+gkL/1QD/AwB/swBCjQL9QCL019Kwv93/Yjv/rEL/lgApfwDR5ADHpzb+PCX/Jyf/hj3/3QP/wAAygwCMugBrpQXvtRL/hAD/ZwAwgwDdYgD/CwDrllqeAAAAY0lEQVQY02NggAFGJmTAQK44MwsrFnE2dg5OLm4McR5ePn4BQSFhdHERUTFxCUkpaXRxGVk5eQVFJWUVNHFVNXUNTS1tHXT1unr6BoZGxiYY7jE1M7ewtMLmfmsbW6qEA5o4AGUCCMFSyLj+AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAARVBMVEVBid1Cid2OuetNkN/2+f1Okd+Csemz0PHP4ff////P4fZCit2Yv+3+/v/9/v9MkN/7/f77/P6GtOm61PNQkt+tzPBTlOBy7rKjAAAAPElEQVQY02NgoD5gxCHOhF2YmYUViygbOwcnFzsbhjg3Dy8fLw83pgZ+AUFBfiwGCQmLiAphEReDYvoAAOqhAXfw3naiAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAA3lBMVEXzsrTeJSrcFx3////74uPkSk/++vvui47cGR/0ubvfKC79+/f35aH36bL75ublT1T63+DTi4TNelrOfFvYiYv++PjcGiD75udxoH2Xyt+OxeqhlrP2xsfgMDb//fD62qadutn3+/30+v2Viaj987X///7p3eV0KlluIVL79Mvsyoeqr8nX6vXU5/SphJzo2Xf///zAyuEcQZQBKofk2Hn01Gnsr4ryuozp0Gfp3pOAlcMELYj+87jw5ZH26ZXo48A/XqSxvtoUOpD4+fxwh7sCK4fZ3+0yU56hsNMNNI3zeJ2wAAAAgElEQVQY023IVQKCABAFwNWnYqJiYoAFdq6d2Hr/C/kLsvM5RIGghBAKy4+IEhUfiMWlTyRTatr/mayWyxeU4v+XynqlCtTq3jfMRrPV7liwuz0X6g+Go/FkOpsv2I2s5Wq92e72B/Y+cDydLw6z74HrjYW/P54s/OvNAvp8peYfGwMlIika+NwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAaVBMVEX/AAD2EhfoLDP3FBZUkrF3G2Q6fn9PQmhXmbj/AQFdqNeeSXyJgZWFZI+jgZT/////WVn/vb3/Pz//ubn/TU3/ysr/urr/VVX/Njb/u7v/QkL/1dUXF5ZCJYv0rrT/MTH0rbNBJIsmG5Hh2QJMAAAAWElEQVQY02NgIAgYmRixiDKzsLKxczBjiHNycfPw8nHC+fwwICAoJCgA5yHEhUVERcSwiIsLSgiKYxGXlJKWkkSIy8CArJy8giKchxCXkVFCYiOLyxAhDgCRhxB33+mm4QAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABSlBMVEXIEBDJExDRMw3TPQzLHA/miAbXTQvLGg/PLg7aWwrmkQX3zQDupgTPKw7NJg7QLg3KFhDRNQ3hcwjmiQbidQfRNA3PKg7okgXvqQPxswPuqQPnjAXPLA3IERDYTwvtpAT40ADYTQvp3uPLsLzGqbbl2N728vTdy9PCorDSu8Xw6ezy7uzb2cbKx6rc2sfy7+zx6+vdzNPHqrYxR4Bhcp1peKI5TYQkOndEWItwf6ZWZ5YpQHspP3pRY5NygKhSZJRFWYxod6Fic57r7fO+xde3v9Pn6vDv8PXb3+mwuM7K0N7O0+GttczP1OHs7vMqQHtPYpJXaJcqQXwwRn8zSIFeb5tDV4srQXs/U4hgcJxAVIlQYpPu8PTS1uPd4erDydrn6fDh5OzAx9gaMnE9UYccM3IYMHAjOndLXY8sQnxNYJEtQ31MXpA+UoipwtHtAAAAzUlEQVQY02NggAJGJmYWVjZ2BnTAwcnFzcPLgAXw8QtgExYUEhYRxRQWE5eQlJKWQReWlZNXUFDgUZSFCSgpq6iqqWtoamnr6OrpG2hqGKqpGikrMRibmJqZW1haWdvY2tnbWFtZOpibOToZMzi7uLq5e3h6ubt7+/i6u3t5eri7ubr4MfgHBAYFh4SG+YdHREaF+4eFhgRbB0b7M8TEernHOcfHuSUkJiUmuMXFO8fFeMXGMCSnWKSmpWcEp6VlZmWnpQXnpKelhuUmAwBc3yoMaqSMDQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAhFBMVEX/uBzTrSRVjDoAd0lEiD3MqyVgRQvfoRjEqSc/hz4AAAAFBAFmSgvlpRm7pyg1hEAug0GqoyvqqRp3Vg0IBgEKBwFvUAzpqBowhEApgkH+txztqxqAXA4NCQEPCwKCXg7yrxv9uB2joSwVDwKNZg/3shsTDgKIYg/2shv5tBuZbhEYEQNuKtjUAAAAeUlEQVQY03XQ1w6CUAyA4V9B4NSBoOBm43z/97MoJpJwetevSRcwmTrDcGeA50Ng/tQE4HvIfLGEVdjrOoJ4sxVEJEl3WtmrHqIjp/NFrXORLC8oK1OVFHn2ka+L1E2rw9qm7vOfX2939cfzNfDxPuNzLXva7rL84Q1xTQt8Zct6eAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAnFBMVEX/3QDnyQ3WvB7ZvBz11Qn21gOrjxaXfiGWhlOScxyxkxf41gP32RPZxBzLvyCVikni0hfZwxvqyxjBxB2Rtpt+vqiAq5GhuSWBllGKmEqRgEuitJ+hvKyeuZuRgUqJl0oDTqIRVpljdWVllIojfpNsl5AHUaKsrj+OgGSLiV6EcFaqrTcJUqMZW6FFdHtRVXM4bIOzKUS3KUDtHCRZUO1CAAAAZElEQVQY02NgoDZgZGJgZsEUZmVj5+Dk4sYQ5+Hl4xcQ5MEQFxIWERUTF4LzJaBAUkpaRlZOHsZlUIACRSVlFVUlRRgXLq6mrqGppa2GIa6jq6dvoKsDFzdEACMkNoMxdkCqOADHyR7oHwtclgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAnFBMVEUHiTAKc1sOUZwSSqoOUpsKc1oKbmUfUaQVSqtdeHgKbmT83Qns0xQaTqcPR684YJJogHA4YZEbTqbt0xO5szd0h2iDkF5Ha4dwhWp4iWUgUqS6szccT6UxXJd8jGNGaol3iGUUSqxvhGxmfnNwhWsTSazu1BLaEhqFKVglVaAcT6YtWpokVKEiUqKHKFaXI0sxPpYbSKcxPpWYI0vHLaUGAAAAY0lEQVQY02NgIBcwMjGzsGIKs7FzcHKwc8H53BDAw8vHLyDIJyQM5cPERdhFxcQlJKWk0cVlZOXkFWRl0MV5ZBSVlFVUZdRg4upQoKGppa2jqwfjwsXV9Q0MjYzVMcVRAS5xABraFGXfxQikAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPBAMAAAD5dJlYAAAAIVBMVEX///+50+xMUJLvM0CORHFzp9ifwuRIi8xpS4OUQ265PFvkmLzCAAAAMElEQVQI12NgYGBUdmWAAdLYaWmpyu5pIJDA0NHRMXlFBwg0MBjDgQGKOLJ6CuwFADteGjGlp1FgAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAb1BMVEUDLqE6IoLgACXoQl7nOVXgASbhDC/98/XhCi7hDDD62d3oPlvqWXH98fTqWG/qU2z87u/63OD+/f3////73uT87vDqUWvmME3++fn62N385ur+/v772t/mLkv4ydHkHz/zmaj5ydHzm6r5y9PkHj9WhOCEAAAAW0lEQVQY02NgoBJgxA4YmBCAGYkNF2dhZWPnYGVBF+fk4ubh5ePm4kQT5xcQFBIWEhEVQxMXl5CUkpaSkZBFFWeVE4YAOVYUcXkFRSUFZQUlRQUVqDgu91MJAAAzyQVRHE2jXQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAM1BMVEXOESb////z+fZvtJH5/Pr6/PtxtZP1+vdnsIsDfD8zlWTW6uC22cdQpHpus5Hs9fEAAAB3OvgcAAAAPklEQVQY02NgGCDACAFMaDRMnJkFTLGyoYizc3BycQNpbi5ODnZk9Ty8fGCaj5cHxRx+IESmGRkEsANaiwMAj4MIhPJB/IwAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAKlBMVEUAhT9UqUD970LrYi3jGyOszUHJ2UK40kEXjz/f40E3nD9bq0BXqUDU3kEiXB7mAAAAL0lEQVQI12NgYGBgVFJSUnZxcXFgIJujisRRqyhDcDQXrERStmcTEufSJQothXIAScEcEqMB04gAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAWlBMVEUAmf8Bmf4lqNopqdYDmvxavaXi8x3//wDr9xRuxZFgv59+y4EGm/n5/QYXougzrcxRua4yrc0Fm/rq9xX4/AcWoulev6F7yoRXvKjg8x/p9hZrxJQkp9soqdfWyJFdAAAAUElEQVQY02NgIBMwMjGzYBFmZWNn5+BkRBfmYgcDbjRhHg6IOC8fqjg/OxQIoIoL4hAXEoYIi4iiWSAGERfHcKeEJDu7lDQ2f8nIYvMXsQAAxD4C/47KB2YAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEUetTr///8Acsbqz0S8AAAAFklEQVQI12NgIAxCQSAEL7UKBFbgowBmmx3UA+477wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAANlBMVEV1st2cyOaWxOX5+/6VxeV+t9+BuN93st15tN7c7Pa31u221+3c6/Z5td7d7Pa31+231e3b7Pbs6MbuAAAAPElEQVQY02NgIAwYsQszMbNgFWdlY8UUZEejoYCDkwtMc/Pwoojz8vGDaQFBDqLMwWkvELAwM5HkLxQAAH8yAOPzV7rEAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAe1BMVEX////75OX0sLTrmp7UUVjsnKD++/vaLjjPgISoAAnYh4v98vOCGR/OgIVBAAPWh4ztg4m+MzzfQkvOO0TgQ0zihInaAAzIEx7FERvXeX45AAOjAAkVFRWxMzrFKCi9WSDbChbdGRXnXxLdFhbnTw3dGA3nYgzeHAzlUQ2kBZ0zAAAAYElEQVQY02NgIAAYmZhZWJkYMcTZ2Dk4udjZMMS5eXj5+Hm4McQFBIWERQQFMMRFxcQlxMVEMcQlpaRlpKUkMdXLysnLySLUK8CBopIygsMghgAqSGwkcVU17OLqGkjiAL+nDFLjvwfJAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAD1BMVEUAAABKAADdAAD0igD/zgDupiNjAAAAIElEQVQI12NgIAMIIoAAgxICKBDLMUYAAwYXBHAgkgMAec0WNTyZViAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAANlBMVEXOESb80Raniw/6zxbrwxXjvRQWEgKfhA4MCgEAAAAJBwGOdgxURgdTRQf0yhWBawvxyBUAaz+6ANkjAAAAOUlEQVQY02NgGCDAiABMSGy4ODMLKxsrCzOGOCM7BycXN6Z6RkYeDl4s5jDy8Qvw8yHEBbEDWosDAIG/CLp2tC7JAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAYFBMVEWeDR0yBAkAAADOESaXDBwoAwfNESaJCxkfAwbMESYbAgXPFyvicH366Or////OEyjlgYzQGC3QGy/lg4787/HmhZDQHTHMEiaJNC0bbDoAej0fazqXLSwoZTiYLSwtYzjsJTTkAAAAVUlEQVQY03XO2xJAMAxF0XBQFHVXcfv/v1SedBr7cWXmTIiiWIqAJJUdmcpFBwpVig7oqm6+OTdt91z6YfRdT7Pofzuuxa7s9/5pN+bQ94PD6LxY6gaMCw1bSUqdAgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEVtwJXVSVMAkkb////OKzfuqNogAAAAAnRSTlPHx/co26IAAAAYSURBVAjXY1BSUlIwNjY2dHFxcWAYkhwAXWgjZRRslzUAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAclBMVEXrhIh+jKjpdXl+jaj////aEhr+/v7siIycp7z5+vv6+/yFk60hOmlPY4jQ1t/Y3OUdN2ZecJLy9PbL0dyLmLG9m6jrgYUHI1eDkav64OH64eL1vsDmYGX40NH++Pn86+viRErxp6rrfYHukZX2xMb//f2eVwmUAAAABHRSTlP35ej1XHsluAAAAF9JREFUGNNjYEEABlYEYACLsIFJdgxxDk5s4lzcPLx82NTzCwhiNYdfSBi7+SyY9jKKwIGoGBwwMYgjgASyXzDEJbGKS0nLyMphEZdXYFXEao6SsgpWcVUgRBNnRnIPAEKPD06PEfQbAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAA5FBMVEU+XrlidZbrpgOxDAyUNTVcQEDFmJjgoKDJVVWrGRlKOjowMDArKyvJycn////rwsK5JSW4ISG1FxezEQzEPAnNVQi7XCAoJSNXV1dISEhJSUkWFhaoqKiwsLD56d/TbCjZf0jain3AOzu0Nw6ERR+3TA7LUAhBODMAAAA3Nzc0NDQBAQGqqqrLy8vIyMjx0b7MUQnKUAmJQxutQhCJHBxCQkKYFBSlIyMoIyNPT0/139+7KiqkEBBAPT1tIiKYFRWwDAxNOjr4+PjrwMC5JCSbFRWsDg6XNDRdQEBJOTmtenrIU1MbQzI+AAAAi0lEQVQY02NgIBEwYgcMTNgBAzMMsLCysXPAeTBxTi5uHl4+Pn4BZmZBIai4sIiomLiEpJS0jKyMnLyCohJEXFlFVU1dQ1NLU1tHV49P38DQyBgsbmJqxmxuIWEpIQVUb2XNbGNrBzHH3gFovqOGhqkTn7MLkO/qhrCXmdndw9PLG+EeXO7H5V8SAQAIig4hoQ5ilgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABQAAAAPCAMAAADTRh9nAAAAulBMVEX////79u389u3TyrTApnHBqHGzo3imhjimhTiyoXfz9PO9w7yXgVCLcDCKcDGTgE6dqJr7+/uZpZWRmYWNdTyKoKKLo6aJdDt8hXWVnoev2/J1kYxTaFyNfUymwM+qwtGOf1BPZlVbdmxetuRJfohCYVd+dUefvbGgvrN5c0ZBYE9LiJ5aq9NDYVhVbV93gU54g09RaVxJbGdeteJztNW1ytaptrmntLi3zNdys9FgtuNfs99dsdtestwZW3dmAAAAa0lEQVQY02NgIB0wMmGKMbOwMmMIsrFzcKIJcXHz8PLxCwiiCAoJi4iKiUtIQrlSYCAtIysnr6CoBOExKIOBiqqauoamljaEBxXU0dXTNzA0MkYRVDYxNTO3sFRGFbSytrG1tkITRAHECwIAYfwYJ3qKSc8AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAflBMVEXnABPqGyzsOUjoDiD2oKf95ef5vMH95Ob2n6b3qa/0j5fpGiv1kJj4srf4trv3rbPrLDz82t3nAxb5wcb4sbf71dj95ejrKzvuTlv3rLLnAhX86OnvWWX84eP719r82975u8DrKjr3qK7pGSr1j5f3paz2nqX5vcL2naToDR9s6ynSAAAAWklEQVQY02NgoDpgZGLEIsrMwsrGzsGMIc7Jxc3Dy8ePLiwgKMQmLCIqJo4mLiEpJS0jJSsnga5eXkgBqJ5VEd0gJR5lFV4+VUz3qLGqs2poYnEpNxM39QMFAMCQBEl4RPdlAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUUtTpgvi780RbdUSDOESbLdO2WAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAk1BMVEUAlUM6pkTt2kr73krqfEA8pkXu20nqeT/aGjU+p0Tv20r73UrocD9GqkXy20nocD5IqkXz3ErobT5KqkX03Ernaz5TrUX23Ur720rnYz1VrkX33UrmYj1YrkbmYDxhsUb53Ur62knlWTxjskXkVzxms0b63kr62UnkVTtwtUb61knjTjtzt0b51UnjTDp7uUbiSzvIokWjAAAAcklEQVQY01XQxxaCQBQE0UFUWoliAFSSWZL8/9d5znuz6VreZRlDOQtXWjKv1soeiDdbUT8AeRgpxyBPdsopyPcH5SPIT5lwXoD8fFG+gry0XIG8boTbG8jvlh8gf76E3x+Qf5W7HuSDLhknkP8sz8T4A+cWCcOogSp8AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAJFBMVEUAZK3syg3pXQ3aDhX5sQSAnFa1szL60QPawxnxhwjjPxDtcwqf/mcLAAAAMklEQVQI12NgYGBgVHZlgAOSOWlpaenKHmkgkMAwEwgW7wSRMycwGCOAAaoMih5KXQAAYx4d2v+SY1EAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAflBMVEXMCS/gVR3wlA3NDy7VKSfXNCT1pArjYhn1pwnQFyviXBvkZBnNDi7UJyjWMCXUKCjlaRhmBRiwZQyLNRKGLxO7cgsAAAAmHgDJoABgTAABAQCefgBKOwBfTAA2KwAMCgCGagCjggBqVAB+ZADEnACkgwBDNQCMbwArIgBkUACWoOicAAAAWklEQVQY02NgoD5gZGLGKs7CyoZNmJ2Dk4sbU5iHl4+BXwDOFYQBIWFBQRFRGI9BDAbEJSSlpGVgPLi4rJy8gqKSGIa4nLKKqpq6BoY4GEhpqmEVFxMTI1McAHtdEMrKun+mAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAABR1BMVEX/zQD/xAP/iRX/zQL/qwr/bx3/Zx//0A7/3VH/4WT/0Rf/zgX/zS//hxX/0BL/5X3/8bb//PD//ffy7NL/2p3/sYj/djT/0x3/9cf//PP/++f//fj/yJr/vJz/ejv/0x7/8rz///7/fTj/vZ7/kl7/aSP/3lb/4GX/3Ez/zkv/8eb/59v/7eX/39D/38//sYz/5Hr//fb/+d//+fH/387/9fD/49X/mWr/cjD/aSL/0Rb/8r//34z/jDj/oHL/s4//7OL/p37/bSj/2Ur/+vL/ya//wqX/ci//djX/upr/yK7/wKP/vJ3/aCH/zwr/20X/4JX/4s//xan/w6f/uJb/ez3/u5z//v7/czH/zgb/2lD/7dT/0Ln/j1r/iVL/1sP/ilL/bCf/eTn/uib/o2n/aiP/3Mv/kFv/xgL/kBP/aB//rgn/chxWoJIzAAAArklEQVQY02NgwAYYmbAIMjOwsLKhiLBzcHIxcPPwsrGhiPPxCwgKCYuIiqGJi0tISknLyMqxoYnLKyiKKMkqq6iiiKupa2hqaevo6umjqDcwNDI2MTUzt7BkQxa3sraxtbN3cGRzYkMRd3ZxdXP38PTy9vFFiPv5BwQGBYeEAvlh4RFw8cio6JjYuPgEED8xCWFOckoqG1tCWjobEmBgyMjMAjFUHX1RxLNz2LABACaQGq0g4IlEAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAVFBMVEUAJn9VW2L/xyb9xSb7xCV8YBKJaxSNbhXPoh80KQiMbRXyvSQ8LwlFNgptVRDmsyJLOgvlsyJuVhChfhhlTw9AMgpkTg+jfxjClx1PPgxZRQ3ksiIKgt1UAAAAUklEQVQY02NggABGJghgZEAF5IgzYxNnYWJiZWJiwRBnY+fg5OBiwxDn5mHiZeLhxjSfj19AUAiLvcIiomLiWMQFJSQlBLG6UwqH+6WpFA7I4gCsNQKJMHjvEgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAVFBMVEUAMIIjRXABMYFYI2HSEDQ2Uma3oiWGgz4SPHkCMoHOrxmRijg/Y6FGZ5tKaZhQbJN9QHP////sm6qTy5OtfWsolyhvXy3JxBzJwArNdhz/zgDsfxaYW2erAAAAXUlEQVQY05XKuxKAIAxE0VXwHRURQeT//9MUhrGg4RaZ2TMBgKblA6W1VvjV9cNY8mleCv9E67YTZ9gNSTgky27zqvZTcuwuL1ySZ/d5VXu4vyJ7lBHwSIk95VXrL5giFHB3jJwlAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAbFBMVEX+ywD+zxX/7q7+1Cv////+1Co0sjOa2ZmZ2Jlpxmi75bq75bv0+/Rsx2vr9+vu+e5yynFGuUXg8+D+//7j9ONJukjb8dvqKDntSVf7297xbHf719rtS1n0kZn3qbDrMEHrLj71m6P0j5jtRVMPaCIhAAAAZ0lEQVQY053Mxw6AIBBFUdRxLGBXsNf//0c1sSDKxrsgeScTCPmfoXHzmy2wpYVXDrj3ONzzKWXAKPW9h2MQwl4UP+8RkxQyyAtUHfl2zu//xVEJVd1Ae87Lu34Q4zS/fJFe2ZV0vgLVpg3noIhakwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAATlBMVEUAK38LMn0hQHYDLX9jb2ZscFhvclh0emENNHwVOHnApzyhiSiWgSzKqzI0TXMKMXzNrznQsDLJqjHJqjInRHQTM2sWK04WKkwYM2LOESYCwxHtAAAANElEQVQY02NgwAMYmbCJMrOwsrFzYIpzcnHz8PJhivMLCAoJi2AxSFRMXIKBWCCJHQw2cQBCAhDmaSBrfgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAABQVBMVEUANYABNoBmhrPpsb7XKkrSEDQBNn8RP3cjUZHAu9DhYXgOPXlrdkqLiDp3fEUEOIJ2krvppbPVIkPSEjbldYo6WGOyoSf/zgC7pSJnc00sWJbKwdPgW3TYMVDku79evIhNY1m4oyTGrB11e0YCN38FOYJ4krrqpLLVIULTFDfld4ys1LoUnVIAlUMhSW+Cgz+glTCMiTkrT2owW5jOvtDeT2naOljixcdQtn4IOXwJPISJoMLrnq3UGz7TFTjngJOj07cRnFA8ZZ7Xvc3cRGDbPlvbxsVDsXQOQIeSpcbpjp/TFzrUGDuZ0rMMmkxIbqTfv87bQF3dSGTUy8U3rGwQQoibqcjoh5nUHT/plqWJzKYHmEhNcqbhucfZNVTfVG7R0cgyqmjpprJ2xpoEl0bG1MYopmDWJkbprbd3xpsClkTpRCQIAAAA1ElEQVQY02NgQAOMTMwsrKysICYbOxtcmIOTi5UVIs7Nw8vHDhHlFxAUAokKiwA5omLiEpJgYSlpGbBiWTl5IE9BUVxJWYWBQVVNXQMkqqmlraMLFNfTNzA0YmAwNjEFKzYzt9DVBYkzWOpZMlhZ29iCRO3sHRx1oeJA4OTsAlbs6uauqwsX9/D08gaJ+nj5+ukixP0DAsGKg4JDdHXh4qFh4XYg0YjIqGhdhHhMbBxYcXxCoi4SYBARBokKJSWn6KKIgxVzpabp6mKIp2dkZqEJ6wIAzjgpcTTEcooAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAxlBMVEWFM0cKbWUAcWjSEDSyHzwmYF7LEzVbR1KOMEUMa2XTFjK/JUJogoVPnZe9EC/nfRnOEDPCDzDNETRyHi4oKCjVHzBmFRV6LROhiAOLHh3WLC2PCyMOAQMAAADVHDG1cxGNi3CLiXjh14fneRrSEjSYDCYBAADPEDN9Hi7EvZ7l4b/GspbCETLQEDTCPCLtlRPZMivvohDHFDBzHy8qKirUGjHTFDPaNzb1wUr96k/gVCP51QP84QDphhfZMCz1uwniXiH62AJmMP8cAAAAgElEQVQY023OxxaCQBBE0dZSwTEh5ogRMOfcpv//KTmunLHf8p5aFFEsLkVIJGVHypIdsNOiK2SyOaPI8wWn6JbKelSp1uqNpkKr3fmNul6vPxiOgLGveRBOprM5/vaL5Wq92bq7vR7hABxP54vR9//1xmaRqzuz4I8nS/56S8wfTGkns8Dt5O0AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMBAMAAAB7FTvLAAAAJFBMVEX////xxMT339/llZXBAADFEhLffHzuurrQPz/CBATIHx/TSUnUj9wOAAAAJUlEQVQI12NgYBBiYHYBAwcGBoYwJE7FrA04OCjKkA1wQQDKOQDsPiJ/CeKFDQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABBVBMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBU4kHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAIWneb4HMIDzXUGZvSHUFJGsjP30YNXchPnssaicPZypPbjg0bihOiG5neqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYIhPXs1bSgkcTi8zLs9cCjdsL7Tg5duY44hPXyipsDnnapIR3wgPns1cChLglDBzbxDcSlMhnAhP3snaSdpllXW5dxDcihQh20gO3hWfzo+hlX8/fxQfTFhj4HWwHzWu2VdlmoxfUSgsIDpwVBdaoGTj37Rr1XeuVTJrWI+UXvZcUAaAAAAjUlEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExZHFxEJCQBJFS7OzSMkAgiykuJ6+gqKQMNkdFVU2dVUNTS1sHaI6unr6BIVjcyNgEbK+pmbkFO7ullbWNrR1InB0F2Ds4Ojm7YIq7url7eHphinv7+Pr5BwRiiPMEBYeEhjFjiCP8hUMcAABfFXHFy8y1AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAQlBMVEX/zAAAJH0dPYwOL4QfP42wvdavutYgPYyvu9YhQI1sgLSImcMSM4aHl8FsgrUePoyXpMkMLoMRMoU/W54+W57PFCs28LkwAAAAPklEQVQY02NgGCDACAdMzEwIDlychZWNnY2DE12ci5sHSPLw8qGK8wsIgmlBARYUcSFhqDoRHqi4KHZAa3EAKoMK3yejrMQAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAABEVBMVEUetTphvS/gyhmGbwwGBQEAAAAyuDeyxyLGpBEqIwRwvy3jxxdxXQoDAgA8MgU4uTa9ySDBoBEnIAMKCAHWyDIftTp3wSzkxBdtWgkCAgBGOgbctxWXvmULpdQ8uTXDyh+0lRAeGQMQDQGXfQ3QyDg1rLMAo90gtjrjwxZlVAlLPgfcuReGu3MHpdhEujTNyx2wkg8aFQIWEgKfhA7NyTwxrLYitTmGwyngvRVTRQdURgfhvxp2uYADo9pHujPRyx2oiw8TEAIZFAKtjw/Cx0Qoqr0mtjmUwyfgvBVNQAcBAQBcTAjiwRwCpNvbzBsNCwEhGwO6mhC1xE4eqcbhxiNdtJSxxFEbqMgEAwB2Ygrfxyd+oc7DAAAAqUlEQVQY02XKVRLCQBAA0UUWDcHdbXB3d3eX+x8EakiQ0J+vmhBBIrFESikVqEyuUFL65yo1o0Fmv1Wr0xtQjRLTR80Wq82O7HC63G/2eH1+1EAwFAbgNGKJxlBpPJFMAe/pTDaHmi8USwCclyvV2muuN5ot4L3d6fZQ+4PhCLjIeDKdoc4Xy+YK3r4ObpC3u/0BPhEWVcMcT/AdQVYqzhf48+vt/js/ewAcih8xD+d9pQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAABFFBMVEUAhD1BbjiXXjR4YUKbbGuWYUg2bTmZc2WHXlpyXk6UaE4ilFcChT8NikdDcDifUzmWXFSaTzSiXjIGh0Inl1slllkUjkxLqHY9bjiIVzWGWzaAYjqDTTchlFYklVgJiER+wZ04bjh9VzaPTzWHUzdoTTYLiUUfk1WSyqwsmV5GcDi4TzGoPjC3OzCwYjEEhkAxnGIQjEk4bThwWjSHSz99TTuHTDM6bjlzVDaBTkF1SzaMTzRFcDi+TzHLRTDSPi+vYDFCbDduZzlgXUFYZ0CfVzNBbzmlUTJvVTxyVji7UTGlWTqdbkehcmymXjY0bTmke2CfXl+daV+ZY00ybTnCRDimcmamWDXCQzHZPy/aQy/COjDGiRK9AAAAjUlEQVQY023ORRYCARBDweDuroO7u7u7w8D978G6obOsxX8BIJHK5Ar8T6lSa7SATm+gbjSZLVbY7A6ni7jb4/X5EQhCCBEPR6KxOJBIptLEM9lcvgAUS2Xar1Rr9Qbzp9lqd7qM9/qD4Yjx8WQ6mzO+WK7WG66z3e0PjB9P58uV8dv98XxxLorvzy9+ARbZEUSyDfEEAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAANCAMAAAB1uQVvAAAAbFBMVEUAaEdUmoT////eYG7OESb7+fj+/v3iy6izg1l7Vjvu6OP28+jMvJuTcE59TzKefWno6drS1cvaxZSKbFaGb16/tKjo6dj8/PrL1b6NvcCAqpWQtanWzrj7+/rq69zO2cO+vaHL18bo6tz9/f1MFQ++AAAARklEQVQY02NggABGJghgZoEABgrEWbGKs7FzcHJhEefm4eXjxxQXEBQSFhEVwxAXl5CUkpaRxTRHTl5BUQmre5Sp5C9kcQCMIASF9CNkhQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAACsAAAAMCAMAAADMKrR8AAAAtFBMVEVbSGaXVjdGaDgAlUMAJlTt8PP////VNEXOESYANa0DNawANKggQXSAgid8dQmQixJbZz4GNZoqR2jczQX65gBuZQDz4ACOjB4ENJ/tQTXjPjO/nAdBPACvoQCxYxbqQjW2QST24gBVTgCtngC4iQu3QSS3pwDkPjO/mwfw3QBEPgCZjACxYhYAlUMqgSnazgL14QBrYwDLuwCNnAwEjj4fgS5QXwkZGAEkJQJVgBcGijwAkUEWpRm7AAAABHRSTlO3mnH8QZ3bHwAAAIBJREFUKM+NytcWwUAUBdAhSPTgCKNFCtGu3hL//1+MlyyWkbuftyi8FUuKaSmi/FtF6G+VfWv1RtNusW67g66DXj/j5qSUgyGc0RiYyJSruVMP8AMgZNyZunPejRZYrtbAJuPm6WW72x+OOJ0pZeguXa63e5wQ6xI96NO/+814AtSHI3b0uhgaAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAjVBMVEUPdWITd2AZe14bel/OyDASd2GVrkAdfWs7il8dfmwkflyNq0B5sqje7Ol5sqcefGWky8P///+jysMphHOUwrmmzMWex8Cdx8AohHMyiXnA29Xu9fTZ6ebv9vS/2tUxiXgbfGpzr6OXwruaxb1+t6ybxr2Xwroae2kuh3ZPmowthnY7jn93saaQv7Y6jn5VYFs1AAAAZUlEQVQY02NgIB8wYhVlYmZhZsIUZmVj5+BkY0UX5uJm4OHlY+DmQlfOzyAgKMTAj65BWERUTFBcVEQCTVxSSlBaRlZQTh5NXEFRSVlFVU1RHd1iDU0Q0MJ0qLaOro4eBaGCHQAARFoFxeV4UfsAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABFFBMVEX/viksXEEcWEbgegntfAX+uie7WTOuRzWaKTiZKTisRDW6VzMRVkgAU07ccgXrdACtRDWzTjSNFTqxaCmLGDaaNDKoUyyYPS/AdCvDdyqPHjaxSjWrQTabKTiMJDPWjyrcmSjztSjwsyfUmiS4diaqXyixZimhSyyVITmWNTHTiCu0diLnqibapCO7fCSzXi6oWymuYCqsVi6aQi3OgyqePDHmqiXprybusCfvrSj0syn7uymgQzCSNTC2eCTfmimzXC+SLTPLhSfqqSj9vSn7uindlSrLhCjwsCiOJDSVMjGwWy6NIDXFcyzXjyntrCjppiifPzCtRDa0TzSPJzTSiiqhQDGdRC7JgynSiimNITWrQzX4HB3IAAAAk0lEQVQY02NgwAUYmZiYWVhY2dg5ODmggIsbKM7Dy8vHz88qICgkLCIqJi4hKSUkLYMQlxWSk1dQVFJWUVVTF9JAFtfU0tbR1dM3MDRCFTc2MTUzt7C0srZBFbe1s4e4xAFV3NHJ2cXVzd2DwRNV3Mvbx9dPSMo/IBBZPChYSCgkNEwoPCIyCuxOhL/gIJobZygAAECcFnxHsGdaAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABQAAAAPCAMAAADTRh9nAAAAkFBMVEUAf/8Bf/4+lcXNrjvbSx5doKgYiOiesWnich3QFiHOECHRyDsljN0EgPtspZrhlyTUKyBxp5Xz1Rz31hiqu2APhfHhlyOErYTNxz8ZiOeismbicx3QFyGisWeluWVNmre0vlcUh+wFgfpvp5cShu4DgfwQhfCutlsdieTRsDZEl8A8lMfLrjzjmCJ8qosGgfph8GzqAAAAiUlEQVQY032O2RaCMAxEp1BRoixaRREVBPeN//872ipY+sC8JJmTmwkAMJhyXK7KyLC88cQn1UxnrRWEUUxEYPOFEMtVS0orTmS7Fht9Nd1mPtEu26dyOOTFESirRJHcddQCO+F86ciq7GdK8nqDlcnvj/9rz5cm3596iATMzE42+TUtUquX+VMDz9YJsjhLMQoAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPCAMAAAA8hHRZAAAAh1BMVEX/AAD+AADxAADzAADyAACkAAChAABuAAAqAADmAAC6AAB3AAALAACHAAAYAAAKAAB4AACpAABZAAAAAACqAAC4AABvAAC5AADOAAB7AABOAAAVAABPAAB8AACzAAC/AACJAABWAAAQAABVAAC+AACfAACVAABzAAD8AAB+AAAiAAA0AAD4AAAWjPKjAAAAb0lEQVQY05XQNQ7AMAxAUafMkJQZU7z/+QpTXXXpXyy9wZIN8DsCggiidM5nsqJquqYqMlLDtGzHdj0DqU/ZFQ2QhtGtUYw0SbOc5UWZIK3qpu36ZqiQxiOf2MRHvGEGsqwLOecraRO+7tv/v+TqAOvNBnfe0swXAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAADFBMVEVtqdKkyeM/Pz8AAADCPMBnAAAAHklEQVQI12NgIAxCQSCEYRUIrGD4DwJ/YDyoHGEAAKwjEeaqweYiAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAD1BMVEUAFImrstj////zuLPaKRzEt5klAAAAJ0lEQVQI12NgwAkEEUCAQQkBFBiMEcCAwQUBHIjloBiAYjSKpTgBAOY1FjWvI5p9AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABUAAAAPBAMAAAD5dJlYAAAAJFBMVEW6DC/NT2iuuMsAIFtoe57gkaHUZ33gkKDsusSPnbdidpo7VIFeYyUVAAAAMElEQVQI12NgYGBUdmWAAdLYaWnpyh5pIJDAMHPmzMU7Z4LABAZjODBAEUdWT4G9AL+iG6ltY7JXAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMAgMAAAD0Vc5rAAAACVBMVEXZABIAM6DyqACw8tlJAAAAFklEQVQI12NgwANCQSAEO7UKBFZgpQAtSBfdnXT9/AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAM1BMVEUAteLvM0DxT1r4pKn1fYbwQEz5ub7wPUn4rLHzZW75uL3wPUrxTln4pKr1fYXwQE1Qni8KzPeqAAAALUlEQVQY02NgoDFghAEmZhZWOIcRIc7GzsjBiUWcixu7OA8vHz+SOQLYAbXEAYaBBpWr6mJlAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAmVBMVEUAI5U/Wa9DXbEwTKlsalb+ywCWhj0lQ6Tl6fQfPqJxbVMHKZgMLZqElcxRabeBeElKY7Q4U6yIfUXT2e0WNpyVhT0KLJkQMJyXpdQ6VayaiTpXbrkrSKcxTaemkTNjeL67xOMSMZexmS0LLJoXN5+frNcvS6O1mytofcAjQaQvSqC/oiWAkcqjsNkWM5HIpyAhP6MsRpdpaVhrzaL2AAAAY0lEQVQY023IRxKCUAAE0SEHAYmiiIJ8giQB7384qliwml51PQCQZEXVznScGaZlM784rnclDviBEjKHHMUJ81t6f2TEgWf+ejNHUX4q5qJu2o448O2HkTmm+bcwF+u8/Y/bAfvwBptQtfS7AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAY1BMVEXaIDGRN1wAZrLfOSrbJDDaHzHoYx/fOircKi71pA3rcBveMyzvhhXtexfgPinpax3qbxziSiXvhRXkUSTqcRrnXSH9yQP0nQ/4tArykBPzmxDughfqaxz1oA7tfRfaIjHhQijaxn+BAAAAS0lEQVQY023QNQLAMAwEQTkOSGFm+v8rU7hIs1tOdycSclHIyZ+P0ZM0Q1fL0YuyIq+btuvBBxunmXxZN/T9ONHtusnV6/PiXvrhA6QuA24u3iJRAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAq1BMVEXXh5nYtMFecqADI2o2T4jYUka9iJkBIWkkPHuudJDmmqfAsVT+3QAHJm18Y4vZg5XTs8N5irDaWkLBip2cbY7ijp29s8c0TYd/fzTeb4HecIDkgWvKaX1+dzeCU1fgdHvifXHupkDlh2XJaH9qZz9/Tlngd3fjfm9neqXgsr/PfJCFf6TBi5yKk7bnprLBdo09SYLdsL7Tg5duY468h5shPXyipsDnnarHpUe2gSPUAAAAYElEQVQY02NgYGRiZmFlY+fg5OLmQQAGXj5+AUEhYRFRMXEJZHFJKWlJGVk5SXkFSUUUcUklSWUVVUk1dVRxXg1NLW1WHV09fQMUcwyNjJlZhEzYTc3MLZDFebCDgRIHAENpEPTI6yb4AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAhFBMVEUAAGYXEl0HBmNpEUTTIyMQDWCnhiNUQ0QgGlkMCmEcFlsBAWZ4W47wtraGazBQQEYNCmGDaTK4kxwpIVYCAmVxNmnibGyyjh8eGFo0KlHbrw79ygFwWjl2XjdiTj8LCWKggCYnH1aOci1pVDwqIlUeAFeLbZj42trFMzzQPkLaSEjpkZFAccNjAAAAZ0lEQVQY03XNyRKCQAxF0UfLoDSTIvOooI3t//8fYZUqaM4iVbmLBCCW2CYuNqPVcb3rzZdAEDLqUYzk/kifyHJGvShR1U0r973rMbTj63BHvKdZOHL398O+imFhP83wNzvt2gzKbAUuRRxHmUu+CAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAe1BMVEVaOw/bTB/aKRwAAAAxJgjViSLhSCATDwO4jyDzkybgQR8BAQB3XRX9wyzfPx4fHx8kJCQXFxdLOw3uuin+wyzwhyXeOR1BQUHq6uqBgYEkHAbSpCT/xyz9wCvufSTcMx0LCwtkZGSYmJgGBgZMTExMOw3vuylgPg/bSh+HHxTJAAAAWElEQVQY02NgYGTCBhiYWVjZsIozs3NwcmETZ+bm4eXkwxDnFxBkFhIWERVDExeXkGRmlpKWkZWTRxZXUJRQUsYizsyswsysqoZpDi57cbkTh7/UNbCGAwCEJAZprzyjpgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAOVBMVEUAK39DY6EPN4dnHlPOESYDLYECLYAvUpcIMoMgRo8/X588XZ1Xc6sBLH82WJpNa6YTO4lTcKkXPovZT/b2AAAAOElEQVQY02NgAAFGJhDJzIIAID4rGzsHJxumOBc3AwMPL6Y4EPBhM4eBgV8Au7igEIY4C3YwUOIAEqQD7R0LCWAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAADFBMVEWlGTHMh5T09fgtKkofTsIZAAAAIUlEQVQI12NgQAGhIBDCsAoEVsCo/yDwBy+FqgFqCgoAADLcMbZbUxlVAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAflBMVEUAeTT////+/v7K49Xx+PRqsYjm8uuOxKUskFet1L75/PpNoXE0lF1RpHTk8erE4NA2lV8Mfz6jz7bG4dJGnmwljFEnjVOVx6u32cYZhkgji1Btsov4+/nO5dhHnm0IfToii08QgUFosIf0+faUx6qGv5+fzbPX6t/v9/Lf7uZfdh5YAAAAWUlEQVQY02NggABGIGACEQyoACTEjF2chZUNqzg7Byc2cS5uHl4+LOL8AgKCQljEhUVExcSxiEvwSEpJy2CIy8rJKygqyWKIK6uo8qipa2DzlzQO/2oiiQMAnvcD/F87dnkAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMBAMAAAB7FTvLAAAAJ1BMVEXnABMAAAAhISFZWVkdHR2Ojo47OzuBgYECAgI8PDwgICAcHBwjnkZPBQBCAAAAKUlEQVQI12NgIA4IIoAAhKPsiMQJTG9E4kxH4izeiKQMZsAZBDiAmwMArBEk/5a8Pr0AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAA21BMVEXXh5nYtMFecqADI2o2T4jROVK7hp0BIWkkPHuudJDmmqdBU4kHJm18Y4vZg5XTs8N5irDAiaCcbY7ijp29s8c0TYcAIWneb4HMIDzXUGZvSHUKJ2W7t6G5sZvLx7eqrap4fYFneqXgsr/PfJCFf6S/iaCKk7bnprLBdo09SYICImnt59T/xGv/1JP/8dx9hZDdsL7Tg5duY44hPXyipsDnnapIR3zhy53/4bL/6cj/vVtqdIays67/wmf/4LH/7M8/UG9bbIS32Pe02v+1xMUDI2h0hZaswMIfOG4zc2OlAAAAeklEQVQY02NgYGRiZmFlY+fg5OJmRwAGHl4+fgFWQSFhEVExZHFxEJCQBJFSuMWlZWTl5BXA5igqKauwqqqpa2gCzdHS1tHV0weJGxgage01NjE1A/LNLSytrEHi7KjAxtbO3gGLuKOTs4srFnF2N3cPdmziMHeSKA4AR80RHvVyYUsAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABYAAAAPCAMAAADXs89aAAAA3lBMVEUAmzoHnTg9qyzU1Ara1ghErSsRoDaYxBf43ALLuhj53AKpyRMVoDUBmzpetCXp2gWzqCMaOmoAJ3YbO2q1qiLt2gRvuSECnDolpTK6zQ/+3wDNuxcYOn0JL3sEKXTJuRnBzw4rpzAInTh/vR333QKLnJBmjqVulKmAnrZ9n7JafqYCKXdQYVH53gGQwhkLnjcDnDm2zBAsRmIONX9FapKHp7hWb39XaFkfRoAFLHsXPn8UO38UOYOBkYMMMXkQN4AIL3wgR38lSIHKuhi0qSIBKHcwTXu2qyHMuxf63AJ+pYy9AAAAk0lEQVQY02NgIAQYGbGJMjGzsGIIsrFzcHJycfOgCPLy8QsICgkJi4iKiSNEJSSlpGVkhYSE5OSlFBShgkrKKlJSqmrqGppa2jpSUrp6+iBRA0MpIDASMhYSMjE1A7ENDeCqzS0srayFbGzhqqFm29k7GDs6OSPMhrjERdjV1c0dxSVgd3N5eHiiuRunL3GGCQoAAE7IEHTWnWDIAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAaVBMVEUAOJMPQYtNaGwHPJBgc2NLZm4DOZEnUH8hTYL//////vr87KD988D++NrYS1HaUE/ZTk/ppqrppqjrro3rrJTqqaKUq9KstaOlsbOcrsJacGUJPY9kdWERQ4sCOpJse1wIPY8MP40BOZJaAyGNAAAAXUlEQVQY02NgoBNgxCrKxMzCzMqGKc4OxBwoIpxAwMUNIjl5eDnhgIEPBPjBpIAAHxwwCAKBkDCIFBQRFYQDBjEQEAeTEpJicAC1RUqamUFGGtM9snLyCopKRHgTANUoBwVSbXq0AAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAAABTSAz92iXzazfvM0AvrHG5AAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAATlBMVEXfYVj++/vVKx7////gYFbql5H5393rmZL//fz88vHVLB/tpaDlfnbaRDjrm5XpkYvvrajWLyLWLiLtpqHhZl3eWE7eWlD//v7zxcHvr6pP4x2+AAAAAnRSTlP5/XDhGW0AAABiSURBVBjTbdDXDoAgDAVQLMgeDnD8/4+KYKJpvUlLch6aUgZ3GH/DurQumoytC+RSgZLUtbFgjcbuvAoQlHfII/RE5OnxhOdPc32Xle6Ty1byz547P2pR5/wk/+p3GD53uAA/4wQ9GK/2VQAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAAYFBMVEUAak49WkqKRkeeQEZ6SkggYUwEaU6cQUb0KkHtLEFbU0l9SkfwK0E1XEsJZ03pLUKmPkUyXUvbMUIxXUsIaE57SUgzXUwDaU6aQkbsLEFZUko7WkuJR0adQUZ5S0ceYk06TX2AAAAAUUlEQVQY02NgIBMwMjGzsGKIsrFzAAEnF7o4NwcY8PCiCvPxQ8Q5BFDFBaHCHEKo4sI4xEVwmMMgCrVXDE1cXAIkLCmF6S9pGVk5eXIDhYEBACMWA7Zt1riSAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAP1BMVEUAK39BYaAzVpn09/lLaKUPN4Y2V5keRI8FL4IwU5gkSZHH0ePq7fREY6HH0OPn6/MWPosSOoicojz56BQ+WmQEj9FkAAAAOUlEQVQY06XOJwIAIAACQNx7+/+3WoyYvAgBgCfBY6k0zY11PtAmplxoURuf6MPj1+SwOGzu+8d1AMPkBcEPB4OiAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAM1BMVEUAIykAZ3gAd4sAAAAABAUAO0UAc4cAEBMAVGIAaHkJBwJ/Yxb3wSv/xywkHAa1jR8AJCrWrOx8AAAAPUlEQVQY02NgYGTCBhiYWVjZsIozM7NzYBdnZmbgxC7OzMXNw4sCoOLMzHz8pIjjMAe7vdjdicNfAtjDAQDteAVNxBEJUAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMAgMAAAD0Vc5rAAAACVBMVEUAh1FVr4v////L7QErAAAAEklEQVQI12NgYFy1kgEIqEgBAJ3qD/Ed6kmhAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAt1BMVEXfUCjxuiz46S710y3fUijYISboiirfTSj0zy3xwCzgVijyxS345y7qkirZJSbhWyjhWijYJCfohSr45i3zyi3jZCjYIibYIybxvSzcOyfaKyb34y7aLCfbNyfxuCzlcSnZJCbzyy3jZSnpjCviXijzzC3nfynZKCfdQCfaKSfohirngyriXyjtpSvngyn23S3zyCzvsyzsnivoiSrmdinfSij35C7fSyjgSyjiXinnhCrmeCn35S47otqiAAAApklEQVQY03WQSRKCQAxF22AQQVFARG0UcQRkBgfU+5/Lti3ADVkk9V9V8pMQ0gOhj98QQeR1IMFQJoiyMhqrTE9gyrKmGzNzjoyjZUqLJeKK2ojrjeBsGSO8VXXcHeIe8XA8nTkhns+rHVzCKIwDmyvfIwBJmuVFGV5vQO9hWeRZmgD8cQr00fJmTlxF1bOdU/uaP1+39u3eU1YMXWvusl5vflfHHz4yXBRG4CQt5AAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABAAAAAUCAMAAACzvE1FAAABRFBMVEUAAAAAOJMAN5JPKnMAOJQAAP+gHlQoMoQAOZVjJ2wGN48AK4CwG04vMIEAOJRuJmgLNI0AOY68GUk5LnwANpOHIl0WM4sAPJbHF0NELnkAOZKXH1gAN5MAO5NMLHUAOZIAOJIAOpVIK3ZJLHYANZRGLXcAOJVALnoAOpI+L3sANpM4LX4AOpQ4L303MH0AOpcAOJMAM5lJLHZdKG7cFDzVFT/ZFD3eIUffK0/vlqbuip/eJEnoaILthZr//////v7sfZLmVXLbFD3dHEP3yNL+9/j99Pbyrr3cFT3gLFDHKFKTIFlCLXnaFDzcFz7aFT3oZX/vj6PlUG7ZFT3jQGH1uMTzr7zgLVHYFD3pbof74OX4y9TWFT71v8r0s8DgLlHpbYbwmqvvk6XlVHHUFT/fJkvdGUDTFj/QFkAlMoRYKnBGLHfiUBDQAAAAMnRSTlMAsxz4ZAH9zST8ggb93TL9jQn+6UL+pRH+8179rxr+dUQ19/Qr9CnvI+4h7B/o5BbSFJf7XhAAAAC/SURBVBjTY2BkYkAFRswsrCgCxiZs7ByoAiamnFzcKAImJjy8fKgCJmb8AoIwAXMLSytrcxMhYRGogI2tnb2Do4mJk6iYOFjA2cXVzd0DpE9CUgpihqeXNAR4+8jIgg31lZNXgAJFkIC5n78SsrUBgbZBwcoqcIGQUDv7sPAIVTWYQGSUnV20o0mMugZMRaydXVy8iUmMphbUjITEpGSQM1K0dSACHqlpYHeZpOvKwj0HARl6+gwMmVlIINvAEAC1vC37qINHkwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAhFBMVEX/4AD////8+fH///7p0o7x4LL379327tXkyXjr1Zb17dP39vTm5eLk27j379zz6s/hy4vv37D6+vr18+7my7nr0Zz06cf+/Pj38N3w5cXlqGbfxsTx7eT6+fXq1ZnozJX/2dn/5eTq5OPs7Oz59OX56tv/0dD/5eX28e37+fX8sKr/7OqoZsgUAAAAUUlEQVQY02NggAJGKGAgSYCJGVWAmYUVRYCNnYOTixtJgIeXj19AEElASFhEVEwcSUBCUkpaRhZJQE5eQVFJGUlARVVNXUMTxR1a2iQ7HbsAANs4BAoFnMiAAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAS1BMVEUAmbU+ssY8scYHnLgvrcETobtmwtIKnrgsqcEtqsEtq8ENnrlxxtYToLsOn7shg549k6tKpbw7k61Elq5Fl6777e////86mzcetTp0M2LrAAAARUlEQVQY05XMNxKAQAzAQAEmHMkEE/7/Umjx+Aq2VCGgKCtEBKduaLvUJ9+HkWl+uay6rNtuZvrBEeOMZXvuc8W4Y3/7A7Y/ElqCuUGkAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAmVBMVEVZWIQ+PXBaWYRYV4NAP3FUU4BEQ3SfNUy4M0RRUH1bWoRZWYRhYIpXVoJjYotdXIdTUn/Ovcnz3eBHRnZQT3xbWoVMS3pcW4apUGXEVWNfXodlZI1YWIRdXIVkY4xdXIZYV4LForDnu8FGRXZIR3dZWIOya37Qd4JUVIBcXIZYWINjY4u8h5jcmqKTcIuSboqSb4qTb4vNkZ2nKdJNAAAAb0lEQVQY023IxxKCQBAFwMcsCCJJEFZMBAOYBvH/P87rWDV9bMAh45K3ID+QsAxXEcVJmq1zCQVtqKysLba1hNjs9ofjqWm7XgKdm/Rir1V5GySM5p60jyeNr7cEnpg/PM/8/f9Bh16HWodch0D3A2OzHE9RW7KIAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAt1BMVEUBIWkDI2sEJGuToL4qPlhvbTwGJGcPKmOQhC77zwJJU0sPLXF1h64FJWtYXUXmwAr/0QAVLmGOnL0TMXMWL2CrlyMXMGBOVknqwwlCTk4FI2eIfjH+0AAbM17ApRrxyAYTLmINK3Cos8xLVEuejignQHeOgy9ybzoEI2iHfjKkkiabjCmaiyqjkSalkyWhkSecjSmfjyh9dzYnPFkRLGISLWIeNV0jOVszRFQ0RFQ4R1JFUE0aMl9WS52GAAAAhElEQVQY02NgAAJGBqyAiRmJw8LKhkUJOwcnF5TJDSJ4eMFsPn4BAUGouJAwTLGIqAAQiKGbIS4BEhaQRBWVkpYBCwtwoAjLyglAgbwCTExRiUFZQgAOVOCKVdVkBJCAOlRYQ1NLS1sHCHT19A2AwNDIGCJhYmpqZg4CFpZAYGVtbcMAAHnHDXhep7UjAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAV1BMVEUAJnQ+UF/80CI/kSsAfC76zyJpninQwSTTwyRrnynMwCQDfS1CkitGkyoCfS7IvyV/pigIfy7vyyIZhCx0oik8kCtxoigXhC3tyyO0tyVzoygFfi67uiU3WnXOAAAAU0lEQVQY02NgAAFGJgRgZgEBBqqLs0IxujgbOxMHJ6Y4FzcPEy8fP4a4AIsguyCLAIa4kLCIqJi4BKb5klIsUpLY3MnMwozV/VzS/Nj9JUNBOAAA72wEgtLdE90AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAh1BMVEWipaIJUgkAZAD////P0M5BWiFJgwDt7ex/dUf1ygD/0gD1xsb65+eaj4jGTgLmWgD98fH53d3zojHsjYy8rq6WERHUAAD99fXkX1/wiwDxkAHqgXn+/Pzb29s4LS0eAAD41dX7vwL1pQX99fT0v7/74LT40q/30tK7s7OWEBD+/v6bn5sIUggRqhCpAAAAW0lEQVQY03XQRwKAMAgEQBR7j733rv9/n15NcI57YAEASaYAKqpGAETdMC3Bm9uO6/k8CFgYsThJOZDlRVnVTdt9AfbDOCGRz8u67YcwBxFPqvd3z5+7rpv8wwNVGw9ENY7DrgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMBAMAAAB7FTvLAAAAKlBMVEUAK3+AeE6CelGHgFg/X5/J0uSLn8UPN4cDLYF6kLz////e5O4fRY8ELoHunveJAAAAKElEQVQI12NgoBQIIoAAkKOsCOcwMLimI9RxzNqDpAtZhuH6BawmAwAu1QYWxcdWWwAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABIAAAAPBAMAAAAbqIIhAAAAKlBMVEXgUgb////87ebvpHzvpX387uf//PvkayrlbCv759376N7vpX787+gNsCv6nqIeAAAAKUlEQVQI12NgIBkICgoKmQQCSRArnaENyprAwIUhJrr7IIh1FwaIZQEApwUtdAz6L1wAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAXVBMVEWOHDobJ38AKo/LFRXEFRlmIFIGKozEKS+pf5uaq9PaW1v44eH////cX1/NHR3MdX/Nz+PN1enPKSnpnp754+PhenrLFhauGCY7JGvlior77u7TNzfVQkLOISHSNjZJne48AAAATklEQVQY03WQNxKAQAzEDCLnnOH/z2Su5LBVqlh7VyQINYQoTlQPaZb/cB6KsvJwvoam7foPwjBO8wLr5ufvx4nmr/vRcuy7+p9GL2OHF4AmCBF74rUTAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPAgMAAABywbzFAAAACVBMVEWuHCj///8hRottIBdsAAAAFklEQVQI12NgIAxCQSAEL7UKBFbgowBmmx3UA+477wAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAANlBMVEXvKy30cyPyWif0YSb7xRj0YiXzWid4ZTuKczbwxhn70RaLczYAnkm+xCPJxiG6wyQ0qT80qD+fwBvMAAAAMklEQVQY02NgGHjAiFWUiZmFlQ3BZYcBDk4uTm44j4EHDnj5+BEcJHEBHkGs4iiA1uIADjYIXhHR070AAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOBAMAAAA23ZrAAAAAD1BMVEX///+q3M8Alm6QSjDWJhI7AIbzAAAAIElEQVQI12NgIAMIIoAAgxICKBDLMUYAAwYXBHAgkgMAec0WNTyZViAAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAq1BMVEUAgAAKhAAHggABgACStwD73gDGzAB5rQAZiQBaogBRngDn1wBKnAAtkQDKzAA2lAAeiwBgpACDsQDAyQB9rwBDkwCMtQBopwA5lQBxqgA3lQAPhQACgQD/4ADu2gDXqgD33QBbogDa0gAmjgAFgQA0lAA1lACaugA/lwCRtgDvzwDgugB4rQDNzQBhpAAUhwCfvAAEggAGggDMzQBOngDZ0gAojwAtkAA4lQCWLblvAAAAfUlEQVQY02NgYGBgZGLAAphZWNnYEVwOTiiDi5uHl48fLi4gCGUICYuIiokDGRKSUhARaRmwelk5eQWgekUlZRVVNZCIugbYfE0tbR0gravHwKBvYAhkqahA9DEagUhjoDgziGGC6i5OUzMjc2wOtpDkZ8AN4O5HA3D3YwcApG8HaL5sIQMAAAAASUVORK5CYII=",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAABGlBMVEUAOJMCOpQXPoN9WkABOZMaTJ4aP4LVcwXddQALQZg8Z6xmiL4rWqUFPJUcQIHWcwXddgHmmUI9aK3H0+f19/uyw94uXKYdQX+FXDvadALgghjttXf67Nv///8ZTJ5jhb3y9fni6PNQdrUVSJwmQnqRYDPbdAHddgLmmkT00ar+/Pr7/P0mVqOnutrf5vGWrdMXSp0oQ3iMXzbadQLggxr77d7u8viqvdtdgboRRZoEO5UoV6RIcLEqQ3eTYTHcdwT+/fvd5PGQqNBEbbASRpszRnGaYyzhhBz77+H8/f7M1+l/m8kqWaWbZTDoo1X22rv09fmodEPvv4jb29+Zr9RMc7MGPZY7SW60jGPFubN/msgzYKlyepNafLQNxpQRAAAAqUlEQVQY02NgAAJGBjTAxAwiWVhZUETZmNk5gBQnFzcPL0KUj5mfQ0AQqFpIWERUDCYqLiHJISUtI8vAIievIKuopAwWVVFVU9fQ1JKV1Qaq19HV0zcAiRoaGZtIm8rKmplbWAK5VtY2BlYMDLZ29hqaDrKOTs5wy1wYGFzd3KU9PL28fVBc5urr5x8gym2A6gvXwKDgkNAwNL+FR0RGRTNggJhYFwYsAABwIBQEctPXdgAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAw1BMVEUAd0kEeUx3tp728/Hul5HgPjPgPDEHeUgpjWbF4Nb409DlW1HbryI/hz4BeEpmrZLy8u/ulpDgPzRNOAjkpBmZni4MekcgiGC62s7529nmYlkAAAAQDAKZbhHfsCFEiD1VpIbs8e7wn5nhQTZINAjhohmqoysSfEYYhFqt08T///8OCgKRaRDisSFNizt9Wg7/uBxZjTpFiT3o8PCBi8UGGowAFInLz+cuPp7q8fJ2gcAEGIvFyuQoOZzt8vR3gsACFooie8SHAAAAjklEQVQY03WQ1RLCUAxEF3d3AhR3aLHg8v9fRVoG2nunnMezmcwmAALBUDgS1UAMQDyRTOk+nZEgm8sXiqovlStVSWr1RlPx1Gp3DAnQ7fUHXk80HI0nEkxncxfb02K5WkODHExr4+P/zPvvlz5bp89uf+Afbv/jiT187z1frqz4z39ud1aB/c/H86VpfgM38h/ovgvjDAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPCAMAAAA4caRkAAAAhFBMVEX////9/Pvu48zj0a7t3sT+/v7X4PGqveLStX/Hn0S/kifRsmbr3cKEn9UAOKjr3sLIn0LFkw/YqhLBkB3dxY78+/rp2rzJoTzVpxHluBLAjxfIpVf17+fu4c3PrmKxgCPAkRzCljfq27f8+vf07eLdxJHZwIrgzKD17uOtv+NUesX7+fbjZKDmAAAAXUlEQVQY03XPRQ7AMBADQBdTZmbG//+vUm9RsnP2Wl6ApKiabsBkHMCwbMf14AccIIziJM1yIV+UVd20nVDfD+M0L6vQg20/zgv3w/lPXsnKRw6BHPktkyN7qDzhAyrrD7DyNXvrAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAPBAMAAAD9gUllAAAAD1BMVEUAJlRUbYz////eYG7OESZmtw3fAAAAGElEQVQI12NgYGBgVFJSUnZxcXFgGJIcANJDF8sUY7+rAAAAAElFTkSuQmCC",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAOCAMAAADzLXfBAAAA3lBMVEUxBAyfDCfSEDS9mg4+MgQ4BA6qDSocFwKYfAu3lQ0zKANGBRG0DiwAAAAgGgKXewunhwwpHwRNBhO3Di0OCwEMCgErIwOmhwygggslGwNUBhW+Di9XRwavjgxJPAU3LAS2lA0eFANJBRKTCyWcDCeIbwoyKQQlHgKpiQw7MAS7mA6ykQ1nVAhdTAdcSwdeTAZgTwariwwvJgPNpw82LAQYFwQANBcAaC8AbzIHBgAGBQAhHgQAPBsAhz0AlUMmIgQANhgAgjoxKQQAMhYAfzk4LQQAKBIAeDYAJxIAdTUecIAlAAAAiElEQVQY023PRRbCQBBF0cIT4BPc3d1dCrf9b4jkMGhI9x2+QQmRw6lCLrfHq+o+TfcHgnIHQkY4Eo3JPZ5IptKZbM7W80ahiFJZq1RrdYHQaLbaADrdXn8gEIaj8UTVMZ3NrTmL5WotmH2zNffu9gf+9b3zeDrzP+uvy/XGdqTfH0+W0evNKh+yEyl2qr7/SAAAAABJRU5ErkJggg==",
  "iVBORw0KGgoAAAANSUhEUgAAABcAAAAMCAMAAAC+5dbKAAAAPFBMVEXMAADpkZHqkoz///////398sj+9tj+9NH855n//vz+9dP//fj87bf855v76aGSvpKVv4+qv3Cev4EAZgDBcqXWAAAAQ0lEQVQY02NgoBJgRAAmJDYDMwywsLKxssB5CHF2Zg4gxhDn5OLm4ebixFTPxsvHy4ZQzw8DAoJCggJwHoMwdkCqOAAUSggc7yfNgAAAAABJRU5ErkJggg==",
  "", // TODO
};

str_t inline CountryCode_to_flag(CountryCode& code) { return CountryFlags[static_cast<int>(code)]; }
str_t inline CountryCode3_to_flag(CountryCode3& code) { return CountryFlags[static_cast<int>(code)]; }

static const std::vector<str_t> CountryNames = {
  "Andorra",
  "United Arab Emirates",
  "Afghanistan",
  "Antigua and Barbuda",
  "Anguilla",
  "Albania",
  "Armenia",
  "Angola",
  "Antarctica",
  "Argentina",
  "American Samoa",
  "Austria",
  "Australia",
  "Aruba",
  "Åland Islands",
  "Azerbaijan",
  "Bosnia and Herzegovina",
  "Barbados",
  "Bangladesh",
  "Belgium",
  "Burkina Faso",
  "Bulgaria",
  "Bahrain",
  "Burundi",
  "Benin",
  "Saint Barthélemy",
  "Bermuda",
  "Brunei Darussalam",
  "Bolivia",
  "Bonaire",
  "Brazil",
  "Bahamas",
  "Bhutan",
  "Bouvet Island",
  "Botswana",
  "Belarus",
  "Belize",
  "Canada",
  "Cocos (Keeling) Islands",
  "Democratic Republic of the Congo",
  "Central African Republic",
  "Congo",
  "Switzerland",
  "Côte d'Ivoire",
  "Cook Islands",
  "Chile",
  "Cameroon",
  "China",
  "Colombia",
  "Costa Rica",
  "Cuba",
  "Cabo Verde",
  "Curaçao",
  "Christmas Island",
  "Cyprus",
  "Czechia",
  "Germany",
  "Djibouti",
  "Denmark",
  "Dominica",
  "Dominican Republic",
  "Algeria",
  "Ecuador",
  "Estonia",
  "Egypt",
  "Western Sahara",
  "Eritrea",
  "Spain",
  "Ethiopia",
  "Finland",
  "Fiji",
  "Falkland Islands",
  "Micronesia",
  "Faroe Islands",
  "France",
  "Gabon",
  "United Kingdom of Great Britain and Northern Ireland",
  "Grenada",
  "Georgia",
  "French Guiana",
  "Guernsey",
  "Ghana",
  "Gibraltar",
  "Greenland",
  "Gambia",
  "Guinea",
  "Guadeloupe",
  "Equatorial Guinea",
  "Greece",
  "South Georgia and the South Sandwich Islands",
  "Guatemala",
  "Guam",
  "Guinea-Bissau",
  "Guyana",
  "Hong Kong",
  "Heard Island and McDonald Islands",
  "Honduras",
  "Croatia",
  "Haiti",
  "Hungary",
  "Indonesia",
  "Ireland",
  "Israel",
  "Isle of Man",
  "India",
  "British Indian Ocean Territory",
  "Iraq",
  "Iran",
  "Iceland",
  "Italy",
  "Jersey",
  "Jamaica",
  "Jordan",
  "Japan",
  "Kenya",
  "Kyrgyzstan",
  "Cambodia",
  "Kiribati",
  "Comoros",
  "Saint Kitts and Nevis",
  "North Korea",
  "South Korea",
  "Kuwait",
  "Cayman Islands",
  "Kazakhstan",
  "Laos",
  "Lebanon",
  "Saint Lucia",
  "Liechtenstein",
  "Sri Lanka",
  "Liberia",
  "Lesotho",
  "Lithuania",
  "Luxembourg",
  "Latvia",
  "Libya",
  "Morocco",
  "Monaco",
  "Moldova",
  "Montenegro",
  "Saint Martin",
  "Madagascar",
  "Marshall Islands",
  "North Macedonia",
  "Mali",
  "Myanmar",
  "Mongolia",
  "Macao",
  "Northern Mariana Islands",
  "Martinique",
  "Mauritania",
  "Montserrat",
  "Malta",
  "Mauritius",
  "Maldives",
  "Malawi",
  "Mexico",
  "Malaysia",
  "Mozambique",
  "Namibia",
  "New Caledonia",
  "Niger",
  "Norfolk Island",
  "Nigeria",
  "Nicaragua",
  "Netherlands",
  "Norway",
  "Nepal",
  "Nauru",
  "Niue",
  "New Zealand",
  "Oman",
  "Panama",
  "Peru",
  "French Polynesia",
  "Papua New Guinea",
  "Philippines",
  "Pakistan",
  "Poland",
  "Saint Pierre and Miquelon",
  "Pitcairn",
  "Puerto Rico",
  "Palestine",
  "Portugal",
  "Palau",
  "Paraguay",
  "Qatar",
  "Réunion",
  "Romania",
  "Serbia",
  "Russian Federation",
  "Rwanda",
  "Saudi Arabia",
  "Solomon Islands",
  "Seychelles",
  "Sudan",
  "Sweden",
  "Singapore",
  "Saint Helena, Ascension and Tristan da Cunha",
  "Slovenia",
  "Svalbard and Jan Mayen",
  "Slovakia",
  "Sierra Leone",
  "San Marino",
  "Senegal",
  "Somalia",
  "Suriname",
  "South Sudan",
  "Sao Tome and Principe",
  "El Salvador",
  "Sint Maarten",
  "Syrian Arab Republic",
  "Eswatini",
  "Turks and Caicos Islands",
  "Chad",
  "French Southern Territories",
  "Togo",
  "Thailand",
  "Tajikistan",
  "Tokelau",
  "Timor-Leste",
  "Turkmenistan",
  "Tunisia",
  "Tonga",
  "Türkiye",
  "Trinidad and Tobago",
  "Tuvalu",
  "Taiwan",
  "Tanzania",
  "Ukraine",
  "Uganda",
  "United States Minor Outlying Islands",
  "United States of America",
  "Uruguay",
  "Uzbekistan",
  "Vatican City",
  "Saint Vincent and the Grenadines",
  "Venezuela",
  "British Virgin Islands",
  "U.S. Virgin Islands",
  "Viet Nam",
  "Vanuatu",
  "Wallis and Futuna",
  "Samoa",
  "Uncategorized",
  "Yemen",
  "Mayotte",
  "South Africa",
  "Zambia",
  "Zimbabwe",
};

str_t inline CountryCode_to_name(CountryCode& code) { return CountryNames[static_cast<int>(code)]; }
str_t inline CountryCode3_to_name(CountryCode3& code) { return CountryNames[static_cast<int>(code)]; }

}

// AD,AND,Andorra,AD,AND
// AE,ARE,United Arab Emirates,AE,ARE
// AF,AFG,Afghanistan,AF,AFG
// AG,ATG,Antigua and Barbuda,AG,ATG
// AI,AIA,Anguilla,AI,AIA
// AL,ALB,Albania,AL,ALB
// AM,ARM,Armenia,AM,ARM
// AO,AGO,Angola,AO,AGO
// AQ,ATA,Antarctica,AQ,ATA
// AR,ARG,Argentina,AR,ARG
// AS,ASM,American Samoa,AS,ASM
// AT,AUT,Austria,AT,AUT
// AU,AUS,Australia,AU,AUS
// AW,ABW,Aruba,AW,ABW
// AX,ALA,Åland Islands,AX,ALA
// AZ,AZE,Azerbaijan,AZ,AZE
// BA,BIH,Bosnia and Herzegovina,BA,BIH
// BB,BRB,Barbados,BB,BRB
// BD,BGD,Bangladesh,BD,BGD
// BE,BEL,Belgium,BE,BEL
// BF,BFA,Burkina Faso,BF,BFA
// BG,BGR,Bulgaria,BG,BGR
// BH,BHR,Bahrain,BH,BHR
// BI,BDI,Burundi,BI,BDI
// BJ,BEN,Benin,BJ,BEN
// BL,BLM,Saint Barthélemy,BL,BLM
// BM,BMU,Bermuda,BM,BMU
// BN,BRN,Brunei Darussalam,BN,BRN
// BO,BOL,Bolivia,BO,BOL
// BQ,BES,Bonaire,BQ,BES
// BR,BRA,Brazil,BR,BRA
// BS,BHS,Bahamas,BS,BHS
// BT,BTN,Bhutan,BT,BTN
// BV,BVT,Bouvet Island,BV,BVT
// BW,BWA,Botswana,BW,BWA
// BY,BLR,Belarus,BY,BLR
// BZ,BLZ,Belize,BZ,BLZ
// CA,CAN,Canada,CA,CAN
// CC,CCK,Cocos (Keeling) Islands,CC,CCK
// CD,COD,Democratic Republic of the Congo,CD,COD
// CF,CAF,Central African Republic,CF,CAF
// CG,COG,Congo,CG,COG
// CH,CHE,Switzerland,CH,CHE
// CI,CIV,Côte d'Ivoire,CI,CIV
// CK,COK,Cook Islands,CK,COK
// CL,CHL,Chile,CL,CHL
// CM,CMR,Cameroon,CM,CMR
// CN,CHN,China,CN,CHN
// CO,COL,Colombia,CO,COL
// CR,CRI,Costa Rica,CR,CRI
// CU,CUB,Cuba,CU,CUB
// CV,CPV,Cabo Verde,CV,CPV
// CW,CUW,Curaçao,CW,CUW
// CX,CXR,Christmas Island,CX,CXR
// CY,CYP,Cyprus,CY,CYP
// CZ,CZE,Czechia,CZ,CZE
// DE,DEU,Germany,DE,DEU
// DJ,DJI,Djibouti,DJ,DJI
// DK,DNK,Denmark,DK,DNK
// DM,DMA,Dominica,DM,DMA
// DO,DOM,Dominican Republic,DO,DOM
// DZ,DZA,Algeria,DZ,DZA
// EC,ECU,Ecuador,EC,ECU
// EE,EST,Estonia,EE,EST
// EG,EGY,Egypt,EG,EGY
// EH,ESH,Western Sahara,EH,ESH
// ER,ERI,Eritrea,ER,ERI
// ES,ESP,Spain,ES,ESP
// ET,ETH,Ethiopia,ET,ETH
// FI,FIN,Finland,FI,FIN
// FJ,FJI,Fiji,FJ,FJI
// FK,FLK,Falkland Islands,FK,FLK
// FM,FSM,Micronesia,FM,FSM
// FO,FRO,Faroe Islands,FO,FRO
// FR,FRA,France,FR,FRA
// GA,GAB,Gabon,GA,GAB
// GB,GBR,United Kingdom of Great Britain and Northern Ireland,GB,GBR
// GD,GRD,Grenada,GD,GRD
// GE,GEO,Georgia,GE,GEO
// GF,GUF,French Guiana,GF,GUF
// GG,GGY,Guernsey,GG,GGY
// GH,GHA,Ghana,GH,GHA
// GI,GIB,Gibraltar,GI,GIB
// GL,GRL,Greenland,GL,GRL
// GM,GMB,Gambia,GM,GMB
// GN,GIN,Guinea,GN,GIN
// GP,GLP,Guadeloupe,GP,GLP
// GQ,GNQ,Equatorial Guinea,GQ,GNQ
// GR,GRC,Greece,GR,GRC
// GS,SGS,South Georgia and the South Sandwich Islands,GS,SGS
// GT,GTM,Guatemala,GT,GTM
// GU,GUM,Guam,GU,GUM
// GW,GNB,Guinea-Bissau,GW,GNB
// GY,GUY,Guyana,GY,GUY
// HK,HKG,Hong Kong,HK,HKG
// HM,HMD,Heard Island and McDonald Islands,HM,HMD
// HN,HND,Honduras,HN,HND
// HR,HRV,Croatia,HR,HRV
// HT,HTI,Haiti,HT,HTI
// HU,HUN,Hungary,HU,HUN
// ID,IDN,Indonesia,ID,IDN
// IE,IRL,Ireland,IE,IRL
// IL,ISR,Israel,IL,ISR
// IM,IMN,Isle of Man,IM,IMN
// IN,IND,India,IN,IND
// IO,IOT,British Indian Ocean Territory,IO,IOT
// IQ,IRQ,Iraq,IQ,IRQ
// IR,IRN,Iran,IR,IRN
// IS,ISL,Iceland,IS,ISL
// IT,ITA,Italy,IT,ITA
// JE,JEY,Jersey,JE,JEY
// JM,JAM,Jamaica,JM,JAM
// JO,JOR,Jordan,JO,JOR
// JP,JPN,Japan,JP,JPN
// KE,KEN,Kenya,KE,KEN
// KG,KGZ,Kyrgyzstan,KG,KGZ
// KH,KHM,Cambodia,KH,KHM
// KI,KIR,Kiribati,KI,KIR
// KM,COM,Comoros,KM,COM
// KN,KNA,Saint Kitts and Nevis,KN,KNA
// KP,PRK,North Korea,KP,PRK
// KR,KOR,South Korea,KR,KOR
// KW,KWT,Kuwait,KW,KWT
// KY,CYM,Cayman Islands,KY,CYM
// KZ,KAZ,Kazakhstan,KZ,KAZ
// LA,LAO,Laos,LA,LAO
// LB,LBN,Lebanon,LB,LBN
// LC,LCA,Saint Lucia,LC,LCA
// LI,LIE,Liechtenstein,LI,LIE
// LK,LKA,Sri Lanka,LK,LKA
// LR,LBR,Liberia,LR,LBR
// LS,LSO,Lesotho,LS,LSO
// LT,LTU,Lithuania,LT,LTU
// LU,LUX,Luxembourg,LU,LUX
// LV,LVA,Latvia,LV,LVA
// LY,LBY,Libya,LY,LBY
// MA,MAR,Morocco,MA,MAR
// MC,MCO,Monaco,MC,MCO
// MD,MDA,Moldova,MD,MDA
// ME,MNE,Montenegro,ME,MNE
// MF,MAF,Saint Martin,MF,MAF
// MG,MDG,Madagascar,MG,MDG
// MH,MHL,Marshall Islands,MH,MHL
// MK,MKD,North Macedonia,MK,MKD
// ML,MLI,Mali,ML,MLI
// MM,MMR,Myanmar,MM,MMR
// MN,MNG,Mongolia,MN,MNG
// MO,MAC,Macao,MO,MAC
// MP,MNP,Northern Mariana Islands,MP,MNP
// MQ,MTQ,Martinique,MQ,MTQ
// MR,MRT,Mauritania,MR,MRT
// MS,MSR,Montserrat,MS,MSR
// MT,MLT,Malta,MT,MLT
// MU,MUS,Mauritius,MU,MUS
// MV,MDV,Maldives,MV,MDV
// MW,MWI,Malawi,MW,MWI
// MX,MEX,Mexico,MX,MEX
// MY,MYS,Malaysia,MY,MYS
// MZ,MOZ,Mozambique,MZ,MOZ
// NA,NAM,Namibia,NA,NAM
// NC,NCL,New Caledonia,NC,NCL
// NE,NER,Niger,NE,NER
// NF,NFK,Norfolk Island,NF,NFK
// NG,NGA,Nigeria,NG,NGA
// NI,NIC,Nicaragua,NI,NIC
// NL,NLD,Netherlands,NL,NLD
// NO,NOR,Norway,NO,NOR
// NP,NPL,Nepal,NP,NPL
// NR,NRU,Nauru,NR,NRU
// NU,NIU,Niue,NU,NIU
// NZ,NZL,New Zealand,NZ,NZL
// OM,OMN,Oman,OM,OMN
// PA,PAN,Panama,PA,PAN
// PE,PER,Peru,PE,PER
// PF,PYF,French Polynesia,PF,PYF
// PG,PNG,Papua New Guinea,PG,PNG
// PH,PHL,Philippines,PH,PHL
// PK,PAK,Pakistan,PK,PAK
// PL,POL,Poland,PL,POL
// PM,SPM,Saint Pierre and Miquelon,PM,SPM
// PN,PCN,Pitcairn,PN,PCN
// PR,PRI,Puerto Rico,PR,PRI
// PS,PSE,Palestine,PS,PSE
// PT,PRT,Portugal,PT,PRT
// PW,PLW,Palau,PW,PLW
// PY,PRY,Paraguay,PY,PRY
// QA,QAT,Qatar,QA,QAT
// RE,REU,Réunion,RE,REU
// RO,ROU,Romania,RO,ROU
// RS,SRB,Serbia,RS,SRB
// RU,RUS,Russian Federation,RU,RUS
// RW,RWA,Rwanda,RW,RWA
// SA,SAU,Saudi Arabia,SA,SAU
// SB,SLB,Solomon Islands,SB,SLB
// SC,SYC,Seychelles,SC,SYC
// SD,SDN,Sudan,SD,SDN
// SE,SWE,Sweden,SE,SWE
// SG,SGP,Singapore,SG,SGP
// SH,SHN,Saint Helena, Ascension and Tristan da Cunha,SH,SHN
// SI,SVN,Slovenia,SI,SVN
// SJ,SJM,Svalbard and Jan Mayen,SJ,SJM
// SK,SVK,Slovakia,SK,SVK
// SL,SLE,Sierra Leone,SL,SLE
// SM,SMR,San Marino,SM,SMR
// SN,SEN,Senegal,SN,SEN
// SO,SOM,Somalia,SO,SOM
// SR,SUR,Suriname,SR,SUR
// SS,SSD,South Sudan,SS,SSD
// ST,STP,Sao Tome and Principe,ST,STP
// SV,SLV,El Salvador,SV,SLV
// SX,SXM,Sint Maarten,SX,SXM
// SY,SYR,Syrian Arab Republic,SY,SYR
// SZ,SWZ,Eswatini,SZ,SWZ
// TC,TCA,Turks and Caicos Islands,TC,TCA
// TD,TCD,Chad,TD,TCD
// TF,ATF,French Southern Territories,TF,ATF
// TG,TGO,Togo,TG,TGO
// TH,THA,Thailand,TH,THA
// TJ,TJK,Tajikistan,TJ,TJK
// TK,TKL,Tokelau,TK,TKL
// TL,TLS,Timor-Leste,TL,TLS
// TM,TKM,Turkmenistan,TM,TKM
// TN,TUN,Tunisia,TN,TUN
// TO,TON,Tonga,TO,TON
// TR,TUR,Türkiye,TR,TUR
// TT,TTO,Trinidad and Tobago,TT,TTO
// TV,TUV,Tuvalu,TV,TUV
// TW,TWN,Taiwan,TW,TWN
// TZ,TZA,Tanzania,TZ,TZA
// UA,UKR,Ukraine,UA,UKR
// UG,UGA,Uganda,UG,UGA
// UM,UMI,United States Minor Outlying Islands,UM,UMI
// US,USA,United States of America,US,USA
// UY,URY,Uruguay,UY,URY
// UZ,UZB,Uzbekistan,UZ,UZB
// VA,VAT,Vatican City,VA,VAT
// VC,VCT,Saint Vincent and the Grenadines,VC,VCT
// VE,VEN,Venezuela,VE,VEN
// VG,VGB,British Virgin Islands,VG,VGB
// VI,VIR,U.S. Virgin Islands,VI,VIR
// VN,VNM,Viet Nam,VN,VNM
// VU,VUT,Vanuatu,VU,VUT
// WF,WLF,Wallis and Futuna,WF,WLF
// WS,WSM,Samoa,WS,WSM
// YE,YEM,Yemen,YE,YEM
// YT,MYT,Mayotte,YT,MYT
// ZA,ZAF,South Africa,ZA,ZAF
// ZM,ZMB,Zambia,ZM,ZMB
// ZW,ZWE,Zimbabwe,ZW,ZWE
