import sys

from robot_base import log_util

from ..__init__ import convert_html_to_markdown, extract_text_and_images


def setup_function():
    log_util.Logger("", "DEBUG")
    sys.path.insert(
        0, r"D:\ProgramData\data\project\be6def2d-813e-4091-9844-b03a88327734\gobot"
    )


def test_convert_html_to_markdown():
    # html_content = """
    # <div class="ContentItem AnswerItem" data-za-index="0" data-zop="{&quot;authorName&quot;:&quot;匿名用户&quot;,&quot;itemId&quot;:3004766880,&quot;title&quot;:&quot;你身边有哪些神奇又好用的民间偏方？&quot;,&quot;type&quot;:&quot;answer&quot;}" name="3004766880" itemprop="acceptedAnswer" itemtype="http://schema.org/Answer" itemscope="" data-za-detail-view-path-module="AnswerItem" data-za-detail-view-path-index="0" data-za-extra-module="{&quot;card&quot;:{&quot;has_image&quot;:false,&quot;has_video&quot;:false,&quot;content&quot;:{&quot;type&quot;:&quot;Answer&quot;,&quot;token&quot;:&quot;3004766880&quot;,&quot;upvote_num&quot;:748,&quot;comment_num&quot;:122,&quot;publish_timestamp&quot;:null,&quot;parent_token&quot;:&quot;57358510&quot;,&quot;author_member_hash_id&quot;:&quot;0&quot;}}}"><div class="ContentItem-meta"><div class="AuthorInfo AnswerItem-authorInfo AnswerItem-authorInfo--related" itemprop="author" itemscope="" itemtype="http://schema.org/Person"><div class="AuthorInfo"><meta itemprop="name" content="匿名用户"><meta itemprop="image" content="https://picx.zhimg.com/v2-d41c2ceaed8f51999522f903672a521f_l.jpg?source=1def8aca"><meta itemprop="url" content="https://www.zhihu.com/people/"><meta itemprop="zhihu:followerCount" content="0"><span class="UserLink AuthorInfo-avatarWrapper"><img class="Avatar AuthorInfo-avatar css-1hx3fyn" src="https://picx.zhimg.com/v2-d41c2ceaed8f51999522f903672a521f_l.jpg?source=1def8aca" srcset="https://picx.zhimg.com/v2-d41c2ceaed8f51999522f903672a521f_l.jpg?source=1def8aca 2x" alt="匿名用户"></span><div class="AuthorInfo-content"><div class="AuthorInfo-head"><span class="UserLink AuthorInfo-name">匿名用户</span></div><div class="AuthorInfo-detail"><div class="AuthorInfo-badge"></div></div></div></div></div><div class="LabelContainer-wrapper"></div><div><div class="css-dvccr2"><div class="css-1lr85n">748 人赞同了该回答</div></div></div><span class="css-z4ujak"></span></div><meta itemprop="image"><meta itemprop="upvoteCount" content="748"><meta itemprop="url" content="https://www.zhihu.com/question/57358510/answer/3004766880"><meta itemprop="dateCreated" content="2023-04-28T06:41:52.000Z"><meta itemprop="dateModified" content="2023-06-07T09:09:56.000Z"><meta itemprop="commentCount" content="122"><div class="RichContent RichContent--unescapable"><span><div class="RichContent-inner"><div class="css-376mun"><span class="RichText ztext CopyrightRichText-richText css-ob6uua" options="[object Object]" itemprop="text"><p data-first-child="" data-pid="Ly59e22c">说一个我正使用的法子，跟鼻炎有关。</p><p data-pid="-An8B1Xq">    某年自行去体检，到了耳鼻喉科，你们懂得，也就是看你听得见吗，看看耳膜破不破啥的就过去了，直到那次那个温婉的女医生（估摸退休了年纪五六十了要）翻了下我的鼻子，来了句，是不是鼻炎挺严重的（后来我度娘知道鼻炎老baby们的鼻腔大多数泛白少毛无毛状态）当下不知道就觉得运气不错，应该是碰到了认真体检的老医生。后面重点来了，她说姑娘你有没有兴趣试个方法，我之前一个病人坚持了五年去根了。我一听，不得感恩戴德死啊。。连忙跪求。她说很简单，就每天洗脸的时候鼻腔吸点冷水，再捏住一个鼻孔，擤另个鼻孔的鼻涕，听着太疑惑了，但本着免费及有五年治根的先例那就试试吧。</p><p data-pid="OJZgorol">   首先，介绍下我鼻炎的症状是一变天就狂塞，有黄浓鼻涕。我之前一直以为是感冒，后来才知道更多还是鼻炎，一碰冷空气就这样。刚开始不会吸，不是呛着就是脑袋里嗡嗡的，慢慢的掌握了节奏，<b>用手心呈碗状捧点凉水，然后鼻子靠近轻轻吸下，能感觉到鼻腔里充满了水，然后再按住一个鼻孔交替擤另个鼻子鼻涕，一定要一个个的擤，一起擤容易受伤。</b></p><p data-pid="lMyRCDFG">   后续的成果实在让我惊呆无比，小小的鼻腔居然那么多垃圾，哪怕你不犯鼻炎，每天都有浓鼻涕（黄色或绿色）擤出来，直到有一天居然擤出来一个近似固状的东西，当时我都吓惨了，还以为脑浆给擤出来了（哈哈，此处不必较真就是感慨下那种震惊），忍着恶心仔细端详了下，应该是鼻涕长年在我鼻腔深处都快固化了。。。就这样天天的擤了很久都有鼻涕，有一天能感受到吸凉水的时候鼻子是可以非常顺畅到喉咙里的时候，就知道开始通了。</p><p data-pid="mKXXjycA"> 我才坚持了一年不到，还是会有些鼻涕出来的，但也不是黄色或绿色的了，是透明丝状了。所以我想估计真正鼻子好的，是擤不出来鼻涕，水是能直接到你喉咙里了吧。你要问什么效果，我只能说发现我这几年每次一到秋冬都一直干咳不止，最近的冬天能咳出痰了，周期也变短了。我的右耳以前时不时经常棉花样堵着，现在这种感觉也变少了，多了通透的感觉。你要说造成这些的根源是不是这个鼻炎，那我不知道，毕竟我还有颈椎病啥的，我只知道我只会坚持下去。。。感恩那个女医生，医德无量！！</p><hr><p data-pid="UrDAL9Zw">今天是2023年6月7日，离上次发布过去了一个多月，有点小欣喜的变化让我忍不住再次更新。自从洗鼻后，我鼻炎犯的少了。这里我要详细讲下我更多是鼻窦炎 症状是先堵，再很多的脓鼻涕，右耳也变成塞棉花感的闷堵。但这次5月底偶然的降温和冷空气突然让我又犯了，我先是鼻子还是微酸，知道自己要鼻子堵了，估计又要不断的擤脓鼻涕吃药了。。回家第一件事就是赶紧用冷水再次吸了擤鼻涕，然后惊奇的是这次跟以往不同，我擤了几次后，居然又擤出来上次我说的近似固体状的组织物（你们想象生蚝的那种手感吧 没那么夸张 但绝对不是脓鼻涕那种），这次并不是从鼻涕出来，是有点大，鼻腔出不来，用劲吸到喉咙里吐出来的（带血丝）。往后2天陆续才擤出平常所见的脓鼻涕。3天鼻涕就没有了，没有吃药，耳朵没有闷堵，我都要哭了。。。</p><p data-pid="nhrl8i1e">看了这么多评论，对其中几点再谈谈自己的想法。</p><p data-pid="tNN-AnVq">1、很多看客是过敏性鼻炎，例如打喷嚏之类，觉得效果可能一般般，我想这种可能更适合我这种鼻子堵、耳朵堵的闷感症状的人，以前看过一个案例，跟我症状相似，他是选择了跑步，跑了很久有一天就大口大口的吐痰，这种我也遇到过，运动久了就会有有痰吐出。所以我想这种洗鼻方法更适合鼻子深处发炎形成的鼻涕、组织物的鼻炎患者。</p><p data-pid="Mx2OgoJd">2、评论里出现的<span><a class="RichContent-EntityWord css-b7erz1" data-za-not-track-link="true" data-paste-text="true" href="https://zhida.zhihu.com/search?content_id=576407191&amp;content_type=Answer&amp;match_order=1&amp;q=%E6%B4%97%E9%BC%BB%E5%99%A8&amp;zhida_source=entity" target="_blank">洗鼻器<svg width="10px" height="10px" viewBox="0 0 16 16" class="ZDI ZDI--FourPointedStar16 css-1dvsrp" fill="currentColor"><path d="m5.068 9.267-3.08-.77a.512.512 0 0 1 0-.994l3.08-.77a2.289 2.289 0 0 0 1.665-1.665l.77-3.08a.512.512 0 0 1 .994 0l.77 3.08c.205.82.845 1.46 1.665 1.665l3.08.77a.512.512 0 0 1 0 .994l-3.08.77a2.29 2.29 0 0 0-1.665 1.665l-.77 3.08a.512.512 0 0 1-.994 0l-.77-3.08a2.289 2.289 0 0 0-1.665-1.665Z"></path></svg></a></span>，首先那个女医生不建议使用，我也深以为然。因为我用过手动的那种，它从一个鼻腔进去再从另个鼻腔出来的时候，我们这种闷堵感症状严重的 初期是很不通畅的，流出的水很小，你也不知道水都到哪去了。脑子涨的慌 ，医生也是担心操作不好会有损伤。可能这种手动洗鼻器更适合平常堵的不严重或仅仅是轻微过敏的人。之后我再也没有用过，据说现在有电动喷雾洗鼻的 ，没用过不发表意见。</p><p data-pid="24tBGiI1">3、评论里说到尽量不要用自来水，这点也挺好的，开始我个人觉得我鼻腔里都是脏东西，自来水比我鼻涕还脏么，不过这种善意的提醒非常好，我也开始用净水器的水洗鼻了。</p><p data-pid="U36zjBvN">4、有个评论说深秋季节用冰水洗，我也觉得非常符合这个初衷，让你鼻腔适应寒冷，不易发炎，就算发炎也能顺利擤出鼻涕，我肯定会试，感谢这位网友！</p><p data-pid="dF_HZJ6p">各位坚持加油！</p></span></div></div></span><div><div class="ContentItem-time"><a target="_blank" href="//www.zhihu.com/question/57358510/answer/3004766880"><span data-tooltip="发布于 2023-04-28 14:41" aria-label="发布于 2023-04-28 14:41">编辑于 2023-06-07 17:09</span></a></div></div><span></span><div><div class="ContentItem-actions Sticky RichContent-actions is-fixed is-bottom" style="width: 694px; bottom: 0px; left: 70px;"><span><button aria-label="赞同 748 " aria-live="polite" type="button" class="Button VoteButton VoteButton--up FEfUrdfMIKpQDJDqkjte"><span style="display: inline-flex; align-items: center;">​<svg width="10" height="10" viewBox="0 0 24 24" class="Zi Zi--TriangleUp VoteButton-TriangleUp" fill="currentColor"><path fill-rule="evenodd" d="M13.792 3.681c-.781-1.406-2.803-1.406-3.584 0l-7.79 14.023c-.76 1.367.228 3.046 1.791 3.046h15.582c1.563 0 2.55-1.68 1.791-3.046l-7.79-14.023Z" clip-rule="evenodd"></path></svg></span>赞同 748</button><button aria-label="反对" aria-live="polite" type="button" class="Button VoteButton VoteButton--down FEfUrdfMIKpQDJDqkjte"><span style="display: inline-flex; align-items: center;">​<svg width="10" height="10" viewBox="0 0 24 24" class="Zi Zi--TriangleDown" fill="currentColor"><path fill-rule="evenodd" d="M13.792 20.319c-.781 1.406-2.803 1.406-3.584 0L2.418 6.296c-.76-1.367.228-3.046 1.791-3.046h15.582c1.563 0 2.55 1.68 1.791 3.046l-7.79 14.023Z" clip-rule="evenodd"></path></svg></span></button></span><button type="button" class="Button ContentItem-action FEfUrdfMIKpQDJDqkjte Button--plain Button--withIcon Button--withLabel fEPKGkUK5jyc4fUuT0QP B46v1Ak6Gj5sL2JTS4PY RuuQ6TOh2cRzJr6WlyQp"><span style="display: inline-flex; align-items: center;">​<svg width="1.2em" height="1.2em" viewBox="0 0 24 24" class="Zi Zi--Comment Button-zi t2ntD6J1DemdOdvh5FB4" fill="currentColor"><path fill-rule="evenodd" d="M12 2.75a9.25 9.25 0 1 0 4.737 17.197l2.643.817a1 1 0 0 0 1.25-1.25l-.8-2.588A9.25 9.25 0 0 0 12 2.75Z" clip-rule="evenodd"></path></svg></span>122 条评论</button><div class="Popover ShareMenu ContentItem-action"><div class="ShareMenu-toggler" id="Popover23-toggle" aria-haspopup="true" aria-expanded="false"><button type="button" class="Button FEfUrdfMIKpQDJDqkjte Button--plain Button--withIcon Button--withLabel fEPKGkUK5jyc4fUuT0QP B46v1Ak6Gj5sL2JTS4PY RuuQ6TOh2cRzJr6WlyQp"><span style="display: inline-flex; align-items: center;">​<svg width="1.2em" height="1.2em" viewBox="0 0 24 24" class="Zi Zi--Share Button-zi t2ntD6J1DemdOdvh5FB4" fill="currentColor"><path d="M19.47 1.914a.8.8 0 0 1 1.204.778l-1.872 16.386a.9.9 0 0 1-1.204.743l-4.615-1.692a.7.7 0 0 0-.831.28l-1.927 3.02c-.43.674-1.474.369-1.474-.43v-3.865a.8.8 0 0 1 .179-.504l5.808-7.148a.595.595 0 0 0-.897-.781l-5.93 6.354a1.1 1.1 0 0 1-1.258.252L2.57 13.46a.8.8 0 0 1-.08-1.415l16.98-10.13Z"></path></svg></span>分享</button></div></div><button type="button" class="Button ContentItem-action FEfUrdfMIKpQDJDqkjte Button--plain Button--withIcon Button--withLabel fEPKGkUK5jyc4fUuT0QP B46v1Ak6Gj5sL2JTS4PY RuuQ6TOh2cRzJr6WlyQp"><span style="display: inline-flex; align-items: center;">​<svg width="1.2em" height="1.2em" viewBox="0 0 24 24" class="Zi Zi--Star Button-zi t2ntD6J1DemdOdvh5FB4" fill="currentColor"><path d="M10.484 3.307c.673-1.168 2.358-1.168 3.032 0l2.377 4.122a.25.25 0 0 0 .165.12l4.655.987c1.319.28 1.84 1.882.937 2.884l-3.186 3.535a.25.25 0 0 0-.063.193l.5 4.733c.142 1.34-1.222 2.33-2.453 1.782l-4.346-1.938a.25.25 0 0 0-.204 0l-4.346 1.938c-1.231.549-2.595-.442-2.453-1.782l.5-4.733a.25.25 0 0 0-.064-.193L2.35 11.42c-.903-1.002-.382-2.604.937-2.884l4.655-.987a.25.25 0 0 0 .164-.12l2.378-4.122Z"></path></svg></span>收藏</button><button aria-live="polite" type="button" class="Button ContentItem-action FEfUrdfMIKpQDJDqkjte Button--plain Button--withIcon Button--withLabel fEPKGkUK5jyc4fUuT0QP B46v1Ak6Gj5sL2JTS4PY RuuQ6TOh2cRzJr6WlyQp"><span style="display: inline-flex; align-items: center;">​<svg width="1.2em" height="1.2em" viewBox="0 0 24 24" class="Zi Zi--Heart Button-zi t2ntD6J1DemdOdvh5FB4" fill="currentColor"><path fill-rule="evenodd" d="M17.142 3.041c1.785.325 3.223 1.518 4.167 3.071 1.953 3.215.782 7.21-1.427 9.858a23.968 23.968 0 0 1-4.085 3.855c-.681.5-1.349.923-1.962 1.234-.597.303-1.203.532-1.748.587a.878.878 0 0 1-.15.002c-.545-.04-1.162-.276-1.762-.582a14.845 14.845 0 0 1-2.008-1.27 24.254 24.254 0 0 1-4.21-4.002c-2.1-2.56-3.16-6.347-1.394-9.463.92-1.624 2.362-2.892 4.173-3.266 1.657-.341 3.469.097 5.264 1.44 1.75-1.309 3.516-1.76 5.142-1.464Z" clip-rule="evenodd"></path></svg></span>喜欢</button><div class="Popover ContentItem-action"><button aria-label="更多" id="Popover24-toggle" aria-haspopup="true" aria-expanded="false" type="button" class="Button OptionsButton FEfUrdfMIKpQDJDqkjte Button--plain Button--withIcon Button--iconOnly fEPKGkUK5jyc4fUuT0QP B46v1Ak6Gj5sL2JTS4PY hIwDV_tcL6XN1HprrnAq"><span style="display: inline-flex; align-items: center;">​<svg width="1.2em" height="1.2em" viewBox="0 0 24 24" class="Zi Zi--Dots Button-zi t2ntD6J1DemdOdvh5FB4" fill="currentColor"><path d="M6 10.5a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3ZM10.5 12a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM16.5 12a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Z"></path></svg></span></button></div><button data-zop-retract-question="true" type="button" class="Button ContentItem-action ContentItem-rightButton FEfUrdfMIKpQDJDqkjte Button--plain fEPKGkUK5jyc4fUuT0QP"><span class="RichContent-collapsedText">收起</span><span style="display: inline-flex; align-items: center;">​<svg width="24" height="24" viewBox="0 0 24 24" class="Zi Zi--ArrowDown ContentItem-arrowIcon is-active" fill="currentColor"><path fill-rule="evenodd" d="M17.776 10.517a.875.875 0 0 1-.248 1.212l-5.05 3.335a.875.875 0 0 1-.964 0L6.47 11.73a.875.875 0 1 1 .965-1.46l4.56 3.015 4.568-3.016a.875.875 0 0 1 1.212.248Z" clip-rule="evenodd"></path></svg></span></button></div><div class="Sticky--holder" style="position: static; inset: auto; display: flex; float: none; margin: 0px -20px -10px; height: 54px; width: 694px;"></div></div></div><div><div><div class=""></div><div class="ModalLoading-content"><svg width="30" height="30" viewBox="0 0 66 66" xmlns="http://www.w3.org/2000/svg" class="CircleLoadingBar  css-1od72gz" aria-hidden="true"><g><circle class="path" fill="none" stroke-width="6" stroke-linecap="round" cx="33" cy="33" r="30"></circle></g></svg></div></div></div></div>
    # """
    with open(
        r"C:\Users\Administrator\Downloads\理解Deepseek的创新点.html",
        "r",
        encoding="utf-8",
    ) as f:
        html_content = f.read()
    convert_html_to_markdown(
        html_content,
        output_dir=r"D:\ProgramData\zhihu\test",
        file_name="test.md",
        base_url="",
        img_dir="images",
    )


def test_extract_text_and_images():
    file_path = r"D:\ProgramData\zhihu\test\test.md"
    texts, images = extract_text_and_images(file_path)
    print(images)
    print(texts)
