# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DelegationControlArgs', 'DelegationControl']

@pulumi.input_type
class DelegationControlArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 delegation_subscription_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 display_name: pulumi.Input[str],
                 notification_message_format: pulumi.Input[str],
                 notification_topic_id: pulumi.Input[str],
                 resource_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 resource_type: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 num_approvals_required: Optional[pulumi.Input[int]] = None,
                 pre_approved_service_provider_action_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 vault_key_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DelegationControl resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains this Delegation Control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegation_subscription_ids: (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        :param pulumi.Input[str] display_name: (Updatable) Name of the Delegation Control. The name does not need to be unique.
        :param pulumi.Input[str] notification_message_format: (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        :param pulumi.Input[str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_ids: (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        :param pulumi.Input[str] resource_type: Resource type for which the Delegation Control is applicable to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description of the Delegation Control.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        :param pulumi.Input[int] num_approvals_required: (Updatable) number of approvals required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pre_approved_service_provider_action_names: (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        :param pulumi.Input[str] vault_id: The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        :param pulumi.Input[str] vault_key_id: The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "notification_message_format", notification_message_format)
        pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        pulumi.set(__self__, "resource_ids", resource_ids)
        pulumi.set(__self__, "resource_type", resource_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_approve_during_maintenance is not None:
            pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        if num_approvals_required is not None:
            pulumi.set(__self__, "num_approvals_required", num_approvals_required)
        if pre_approved_service_provider_action_names is not None:
            pulumi.set(__self__, "pre_approved_service_provider_action_names", pre_approved_service_provider_action_names)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if vault_key_id is not None:
            pulumi.set(__self__, "vault_key_id", vault_key_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that contains this Delegation Control.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @delegation_subscription_ids.setter
    def delegation_subscription_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "delegation_subscription_ids", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the Delegation Control. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="notificationMessageFormat")
    def notification_message_format(self) -> pulumi.Input[str]:
        """
        (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        """
        return pulumi.get(self, "notification_message_format")

    @notification_message_format.setter
    def notification_message_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "notification_message_format", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "resource_ids", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        Resource type for which the Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the Delegation Control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @is_auto_approve_during_maintenance.setter
    def is_auto_approve_during_maintenance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_approve_during_maintenance", value)

    @property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @num_approvals_required.setter
    def num_approvals_required(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_approvals_required", value)

    @property
    @pulumi.getter(name="preApprovedServiceProviderActionNames")
    def pre_approved_service_provider_action_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_service_provider_action_names")

    @pre_approved_service_provider_action_names.setter
    def pre_approved_service_provider_action_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pre_approved_service_provider_action_names", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="vaultKeyId")
    def vault_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_key_id")

    @vault_key_id.setter
    def vault_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_key_id", value)


@pulumi.input_type
class _DelegationControlState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 delegation_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[str]] = None,
                 notification_message_format: Optional[pulumi.Input[str]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None,
                 num_approvals_required: Optional[pulumi.Input[int]] = None,
                 pre_approved_service_provider_action_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_deleted: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 vault_key_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DelegationControl resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains this Delegation Control.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegation_subscription_ids: (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        :param pulumi.Input[str] description: (Updatable) Description of the Delegation Control.
        :param pulumi.Input[str] display_name: (Updatable) Name of the Delegation Control. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        :param pulumi.Input[str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[str] notification_message_format: (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        :param pulumi.Input[str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[int] num_approvals_required: (Updatable) number of approvals required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pre_approved_service_provider_action_names: (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_ids: (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        :param pulumi.Input[str] resource_type: Resource type for which the Delegation Control is applicable to.
        :param pulumi.Input[str] state: The current lifecycle state of the Delegation Control.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_deleted: Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        :param pulumi.Input[str] time_updated: Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] vault_id: The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        :param pulumi.Input[str] vault_key_id: The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if delegation_subscription_ids is not None:
            pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_approve_during_maintenance is not None:
            pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if notification_message_format is not None:
            pulumi.set(__self__, "notification_message_format", notification_message_format)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if num_approvals_required is not None:
            pulumi.set(__self__, "num_approvals_required", num_approvals_required)
        if pre_approved_service_provider_action_names is not None:
            pulumi.set(__self__, "pre_approved_service_provider_action_names", pre_approved_service_provider_action_names)
        if resource_ids is not None:
            pulumi.set(__self__, "resource_ids", resource_ids)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_deleted is not None:
            pulumi.set(__self__, "time_deleted", time_deleted)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if vault_key_id is not None:
            pulumi.set(__self__, "vault_key_id", vault_key_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains this Delegation Control.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @delegation_subscription_ids.setter
    def delegation_subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegation_subscription_ids", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the Delegation Control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the Delegation Control. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @is_auto_approve_during_maintenance.setter
    def is_auto_approve_during_maintenance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_approve_during_maintenance", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter(name="notificationMessageFormat")
    def notification_message_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        """
        return pulumi.get(self, "notification_message_format")

    @notification_message_format.setter
    def notification_message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_message_format", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @num_approvals_required.setter
    def num_approvals_required(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_approvals_required", value)

    @property
    @pulumi.getter(name="preApprovedServiceProviderActionNames")
    def pre_approved_service_provider_action_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_service_provider_action_names")

    @pre_approved_service_provider_action_names.setter
    def pre_approved_service_provider_action_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pre_approved_service_provider_action_names", value)

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_ids", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type for which the Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the Delegation Control.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        """
        return pulumi.get(self, "time_deleted")

    @time_deleted.setter
    def time_deleted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_deleted", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="vaultKeyId")
    def vault_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_key_id")

    @vault_key_id.setter
    def vault_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_key_id", value)


class DelegationControl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 delegation_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 notification_message_format: Optional[pulumi.Input[str]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None,
                 num_approvals_required: Optional[pulumi.Input[int]] = None,
                 pre_approved_service_provider_action_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 vault_key_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Delegation Control resource in Oracle Cloud Infrastructure Delegate Access Control service.

        Creates a Delegation Control.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_delegation_control = oci.delegate_access_control.DelegationControl("test_delegation_control",
            compartment_id=compartment_id,
            delegation_subscription_ids=delegation_control_delegation_subscription_ids,
            display_name=delegation_control_display_name,
            notification_message_format=delegation_control_notification_message_format,
            notification_topic_id=test_notification_topic["id"],
            resource_ids=delegation_control_resource_ids,
            resource_type=delegation_control_resource_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=delegation_control_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_approve_during_maintenance=delegation_control_is_auto_approve_during_maintenance,
            num_approvals_required=delegation_control_num_approvals_required,
            pre_approved_service_provider_action_names=delegation_control_pre_approved_service_provider_action_names,
            vault_id=test_vault["id"],
            vault_key_id=test_key["id"])
        ```

        ## Import

        DelegationControls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DelegateAccessControl/delegationControl:DelegationControl test_delegation_control "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains this Delegation Control.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegation_subscription_ids: (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        :param pulumi.Input[str] description: (Updatable) Description of the Delegation Control.
        :param pulumi.Input[str] display_name: (Updatable) Name of the Delegation Control. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        :param pulumi.Input[str] notification_message_format: (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        :param pulumi.Input[str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[int] num_approvals_required: (Updatable) number of approvals required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pre_approved_service_provider_action_names: (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_ids: (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        :param pulumi.Input[str] resource_type: Resource type for which the Delegation Control is applicable to.
        :param pulumi.Input[str] vault_id: The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        :param pulumi.Input[str] vault_key_id: The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DelegationControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Delegation Control resource in Oracle Cloud Infrastructure Delegate Access Control service.

        Creates a Delegation Control.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_delegation_control = oci.delegate_access_control.DelegationControl("test_delegation_control",
            compartment_id=compartment_id,
            delegation_subscription_ids=delegation_control_delegation_subscription_ids,
            display_name=delegation_control_display_name,
            notification_message_format=delegation_control_notification_message_format,
            notification_topic_id=test_notification_topic["id"],
            resource_ids=delegation_control_resource_ids,
            resource_type=delegation_control_resource_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=delegation_control_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_auto_approve_during_maintenance=delegation_control_is_auto_approve_during_maintenance,
            num_approvals_required=delegation_control_num_approvals_required,
            pre_approved_service_provider_action_names=delegation_control_pre_approved_service_provider_action_names,
            vault_id=test_vault["id"],
            vault_key_id=test_key["id"])
        ```

        ## Import

        DelegationControls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DelegateAccessControl/delegationControl:DelegationControl test_delegation_control "id"
        ```

        :param str resource_name: The name of the resource.
        :param DelegationControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DelegationControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 delegation_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 notification_message_format: Optional[pulumi.Input[str]] = None,
                 notification_topic_id: Optional[pulumi.Input[str]] = None,
                 num_approvals_required: Optional[pulumi.Input[int]] = None,
                 pre_approved_service_provider_action_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 vault_key_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DelegationControlArgs.__new__(DelegationControlArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if delegation_subscription_ids is None and not opts.urn:
                raise TypeError("Missing required property 'delegation_subscription_ids'")
            __props__.__dict__["delegation_subscription_ids"] = delegation_subscription_ids
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_approve_during_maintenance"] = is_auto_approve_during_maintenance
            if notification_message_format is None and not opts.urn:
                raise TypeError("Missing required property 'notification_message_format'")
            __props__.__dict__["notification_message_format"] = notification_message_format
            if notification_topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'notification_topic_id'")
            __props__.__dict__["notification_topic_id"] = notification_topic_id
            __props__.__dict__["num_approvals_required"] = num_approvals_required
            __props__.__dict__["pre_approved_service_provider_action_names"] = pre_approved_service_provider_action_names
            if resource_ids is None and not opts.urn:
                raise TypeError("Missing required property 'resource_ids'")
            __props__.__dict__["resource_ids"] = resource_ids
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["vault_key_id"] = vault_key_id
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_deleted"] = None
            __props__.__dict__["time_updated"] = None
        super(DelegationControl, __self__).__init__(
            'oci:DelegateAccessControl/delegationControl:DelegationControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            delegation_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
            lifecycle_state_details: Optional[pulumi.Input[str]] = None,
            notification_message_format: Optional[pulumi.Input[str]] = None,
            notification_topic_id: Optional[pulumi.Input[str]] = None,
            num_approvals_required: Optional[pulumi.Input[int]] = None,
            pre_approved_service_provider_action_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_deleted: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            vault_id: Optional[pulumi.Input[str]] = None,
            vault_key_id: Optional[pulumi.Input[str]] = None) -> 'DelegationControl':
        """
        Get an existing DelegationControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains this Delegation Control.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegation_subscription_ids: (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        :param pulumi.Input[str] description: (Updatable) Description of the Delegation Control.
        :param pulumi.Input[str] display_name: (Updatable) Name of the Delegation Control. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        :param pulumi.Input[str] lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param pulumi.Input[str] notification_message_format: (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        :param pulumi.Input[str] notification_topic_id: (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param pulumi.Input[int] num_approvals_required: (Updatable) number of approvals required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pre_approved_service_provider_action_names: (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_ids: (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        :param pulumi.Input[str] resource_type: Resource type for which the Delegation Control is applicable to.
        :param pulumi.Input[str] state: The current lifecycle state of the Delegation Control.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_deleted: Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        :param pulumi.Input[str] time_updated: Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] vault_id: The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        :param pulumi.Input[str] vault_key_id: The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DelegationControlState.__new__(_DelegationControlState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["delegation_subscription_ids"] = delegation_subscription_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_approve_during_maintenance"] = is_auto_approve_during_maintenance
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["notification_message_format"] = notification_message_format
        __props__.__dict__["notification_topic_id"] = notification_topic_id
        __props__.__dict__["num_approvals_required"] = num_approvals_required
        __props__.__dict__["pre_approved_service_provider_action_names"] = pre_approved_service_provider_action_names
        __props__.__dict__["resource_ids"] = resource_ids
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_deleted"] = time_deleted
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["vault_key_id"] = vault_key_id
        return DelegationControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains this Delegation Control.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description of the Delegation Control.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the Delegation Control. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[str]:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="notificationMessageFormat")
    def notification_message_format(self) -> pulumi.Output[str]:
        """
        (Updatable) The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        """
        return pulumi.get(self, "notification_message_format")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> pulumi.Output[int]:
        """
        (Updatable) number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @property
    @pulumi.getter(name="preApprovedServiceProviderActionNames")
    def pre_approved_service_provider_action_names(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_service_provider_action_names")

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The OCID of the selected resources that this Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_ids")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        Resource type for which the Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the Delegation Control.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> pulumi.Output[str]:
        """
        Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vaultKeyId")
    def vault_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_key_id")

