# -*- coding: utf-8 -*-
# Generated by Django 1.11.15 on 2019-02-18 15:53
from __future__ import unicode_literals

import django.contrib.gis.db.models.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('popolo', '0017_auto_20190206_1936'),
    ]

    operations = [
        migrations.AddField(
            model_name='area',
            name='geometry',
            field=django.contrib.gis.db.models.fields.MultiPolygonField(blank=True, geography=True, help_text='The geometry of the area', null=True, srid=4326, verbose_name='Geometry'),
        ),
        migrations.AlterField(
            model_name='area',
            name='identifier',
            field=models.CharField(blank=True, help_text='The main issued identifier', max_length=128, verbose_name='identifier'),
        ),
        migrations.AlterField(
            model_name='area',
            name='istat_classification',
            field=models.CharField(blank=True, choices=[('NAZ', 'Country'), ('RIP', 'Geographic partition'), ('REG', 'Region'), ('PROV', 'Province'), ('CM', 'Metropolitan area'), ('COM', 'Municipality'), ('MUN', 'Submunicipality'), ('ZU', 'Zone')], help_text='An area category, according to ISTAT: Ripartizione Geografica, Regione, Provincia, Città Metropolitana, Comune', max_length=4, null=True, verbose_name='ISTAT classification'),
        ),
        migrations.RemoveField(
            model_name='area',
            name='geom',
        ),
        migrations.RemoveField(
            model_name='area',
            name='gps_lat',
        ),
        migrations.RemoveField(
            model_name='area',
            name='gps_lon',
        ),
        migrations.AlterUniqueTogether(
            name='area',
            unique_together=set([('identifier', 'istat_classification')]),
        ),
    ]
