# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-07-24 11:29
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import popolo.behaviors.models
import popolo.models


class Migration(migrations.Migration):

    dependencies = [
        ('popolo', '0020_auto_20190508_1821'),
    ]

    operations = [
        migrations.CreateModel(
            name='OrganizationRelationship',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.CharField(blank=True, help_text='The date when the validity of the item starts', max_length=10, null=True, validators=[django.core.validators.RegexValidator(message='Date has wrong format', regex='^[0-9]{4}(-[0-9]{2}){0,2}$'), popolo.behaviors.models.validate_partial_date], verbose_name='start date')),
                ('end_date', models.CharField(blank=True, help_text='The date when the validity of the item ends', max_length=10, null=True, validators=[django.core.validators.RegexValidator(message='Date has wrong format', regex='^[0-9]{4}(-[0-9]{2}){0,2}$'), popolo.behaviors.models.validate_partial_date], verbose_name='end date')),
                ('end_reason', models.CharField(blank=True, help_text="The reason why the entity isn't valid any longer (eg: merge)", max_length=255, null=True, verbose_name='end reason')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='creation time')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='last modification time')),
                ('weight', models.IntegerField(choices=[(-1, 'Strongly negative'), (-2, 'Negative'), (0, 'Neutral'), (1, 'Positive'), (2, 'Strongly positive')], default=0, help_text='The relationship weight, from strongly negative, to strongly positive', verbose_name='weight')),
                ('descr', models.CharField(blank=True, help_text='Some details on the relationship (not much, though)', max_length=512, null=True, verbose_name='Description')),
                ('classification', models.ForeignKey(help_text='The classification for this organization relationship', on_delete=django.db.models.deletion.CASCADE, related_name='organization_relationships', to='popolo.Classification')),
                ('dest_organization', models.ForeignKey(help_text='The Organization the relationship ends to', on_delete=django.db.models.deletion.CASCADE, related_name='from_relationships', to='popolo.Organization', verbose_name='Destination organization')),
                ('source_organization', models.ForeignKey(help_text='The Organization the relation starts from', on_delete=django.db.models.deletion.CASCADE, related_name='to_relationships', to='popolo.Organization', verbose_name='Source organization')),
            ],
            options={
                'verbose_name': 'Organization relationship',
                'verbose_name_plural': 'Organization relationships',
            },
            bases=(popolo.models.SourceShortcutsMixin, models.Model),
        ),
        migrations.AddField(
            model_name='membership',
            name='appointed_by',
            field=models.ForeignKey(blank=True, help_text='The Membership that officially has appointed this one.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='appointees', to='popolo.Membership', verbose_name='Appointed by'),
        ),
        migrations.AddField(
            model_name='membership',
            name='appointment_note',
            field=models.TextField(blank=True, help_text='A textual note for this appointment, if needed.', null=True, verbose_name='appointment note'),
        ),
        migrations.AddField(
            model_name='membership',
            name='is_appointment_locked',
            field=models.BooleanField(default=False, help_text='A flag that shows if this appointment is locked (set to true when manually creating the appointment)'),
        ),
        migrations.AddField(
            model_name='personalrelationship',
            name='descr',
            field=models.CharField(blank=True, help_text='Some details on the relationship (not much, though)', max_length=512, null=True, verbose_name='Description'),
        ),
        migrations.AddField(
            model_name='post',
            name='appointment_note',
            field=models.TextField(blank=True, help_text='A textual note for this appointment rule, if needed', null=True, verbose_name='appointment note'),
        ),
        migrations.AddField(
            model_name='post',
            name='is_appointment_locked',
            field=models.BooleanField(default=False, help_text='A flag that shows if this appointment rule is locked (set to true when manually creating the rule)'),
        ),
        migrations.AddField(
            model_name='roletype',
            name='is_appointable',
            field=models.BooleanField(default=False, help_text='Whether this is role can be appointed (by appointers)', verbose_name='is appointable'),
        ),
        migrations.AddField(
            model_name='roletype',
            name='is_appointer',
            field=models.BooleanField(default=False, help_text='Whether this is a role able to appoint other roles', verbose_name='is appointer'),
        ),
        migrations.AlterField(
            model_name='personalrelationship',
            name='classification',
            field=models.ForeignKey(help_text='The classification for this personal relationship', on_delete=django.db.models.deletion.CASCADE, related_name='personal_relationships', to='popolo.Classification'),
        ),
        migrations.AlterField(
            model_name='post',
            name='appointed_by',
            field=models.ForeignKey(blank=True, help_text='The Post that officially appoints members to this one (appointment rule), ex: Secr. of Defence is appointed by POTUS', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='appointees', to='popolo.Post', verbose_name='Appointed by'),
        ),
        migrations.AlterUniqueTogether(
            name='personalrelationship',
            unique_together=set([('source_person', 'dest_person', 'classification')]),
        ),
        migrations.AlterUniqueTogether(
            name='organizationrelationship',
            unique_together=set([('source_organization', 'dest_organization', 'classification')]),
        ),
    ]
