from __future__ import annotations
from typing import TypeVar
import enum

import numpy as np


_FloatT = TypeVar('_FloatT', np.dtype[np.float32], np.dtype[np.float64])

_FloatArray = np.ndarray[tuple[int, int], _FloatT]

class AudioReference(enum.Enum):
    dBu = ...
    dBVU = ...
    dBFS_smpte = ...
    dBFS_ebu = ...


class AudioReferenceConverter:
    def __init__(self, reference: AudioReference = AudioReference.dBVU) -> None: ...
    @property
    def reference(self) -> AudioReference: ...
    @reference.setter
    def reference(self, value: AudioReference) -> None: ...
    @property
    def multiplier(self) -> float: ...
    @property
    def divisor(self) -> float: ...
    @property
    def is_ndi_native(self) -> bool: ...
    @property
    def value(self) -> float: ...
    def calc_amplitude(self, value_dB: float) -> float: ...
    def calc_dB(self, amplitude: float) -> float: ...
    def to_other(self, other: AudioReference, value: float, force: bool = False) -> float: ...
    def to_other_array_in_place(self, other: AudioReference, value: _FloatArray, force: bool = False) -> None: ...
    def to_other_array(self, other: AudioReference, src: _FloatArray, dst: _FloatArray) -> None: ...
    def to_ndi_array(self, src: _FloatArray, dest: _FloatArray) -> None: ...
    def from_ndi_array(self, src: _FloatArray, dest: _FloatArray) -> None: ...
