from typing import Any, Callable, ClassVar, Iterator, List, Tuple, Set

from . import Path, StringVector


class Context:
    def __init__(self, command_script: str = "nwscript") -> None: ...


class AssignExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def lhs(self) -> Expression: ...
    @property
    def operator(self) -> NssToken: ...
    @property
    def rhs(self) -> Expression: ...


class AstNode:
    def __init__(self, *args, **kwargs) -> None: ...
    def accept(self, arg0) -> None: ...
    def complete(self, needle: str) -> List[str]: ...


class BinaryExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def lhs(self) -> Expression: ...
    @property
    def operator(self) -> NssToken: ...
    @property
    def rhs(self) -> Expression: ...


class BlockStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, arg0: int) -> Statement: ...
    def __len__(self) -> int: ...


class CallExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, arg0: int) -> Expression: ...
    def __len__(self) -> int: ...
    @property
    def expr(self) -> Expression: ...


class ConditionalExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def false_branch(self) -> Expression: ...
    @property
    def test(self) -> Expression: ...
    @property
    def true_branch(self) -> Expression: ...


class DeclStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, index) -> Any: ...
    def __len__(self) -> int: ...


class Declaration(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def type(self) -> Type: ...


class DoStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def block(self) -> BlockStatement: ...
    @property
    def test(self) -> Expression: ...


class DotExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def lhs(self) -> Expression: ...
    @property
    def rhs(self) -> Expression: ...


class EmptyStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...


class ExprStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def expr(self) -> Expression: ...


class Expression(AstNode):
    def __init__(self, *args, **kwargs) -> None: ...


class ForStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def block(self) -> Statement: ...
    @property
    def increment(self) -> Expression: ...
    @property
    def init(self) -> Expression: ...
    @property
    def test(self) -> Expression: ...


class FunctionDecl(Declaration):
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, arg0: int) -> Declaration: ...
    def __len__(self) -> int: ...
    @property
    def identifier(self) -> NssToken: ...


class FunctionDefinition(Declaration):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def block(self) -> BlockStatement: ...
    @property
    def decl(self) -> FunctionDecl: ...


class GroupingExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def expr(self) -> Expression: ...


class IfStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def false_branch(self) -> Statement: ...
    @property
    def test(self) -> Expression: ...
    @property
    def true_branch(self) -> Statement: ...


class JumpStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def expr(self) -> Expression: ...
    @property
    def operator(self) -> NssToken: ...


class LabelStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def expr(self) -> Expression: ...
    @property
    def label(self) -> NssToken: ...


class LiteralExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def literal(self) -> NssToken: ...


class LiteralVectorExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def x(self) -> NssToken: ...
    @property
    def y(self) -> NssToken: ...
    @property
    def z(self) -> NssToken: ...


class LogicalExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def lhs(self) -> Expression: ...
    @property
    def operator(self) -> NssToken: ...
    @property
    def rhs(self) -> Expression: ...


class Nss:
    def __init__(self, filename: Path, ctx: Context) -> None: ...
    def ast(self) -> Ast: ...
    def dependencies(self) -> Set[str]: ...
    def errors(self) -> int: ...
    def parse(self, *args, **kwargs) -> None: ...
    def process_includes(self, parent: Nss) -> Any: ...
    def resolve(self) -> None: ...
    def type_name(self, node: AstNode) -> str: ...
    def warnings(self) -> int: ...

    @staticmethod
    def from_string(script: str, ctx: Context) -> Nss: ...


class NssLexer:
    def __init__(self, script: str, ctx: Context) -> None: ...
    def current(self) -> NssToken: ...
    def next(self) -> NssToken: ...


class SourceLocation:
    def __init__(self, *args, **kwargs) -> None: ...
    def view(self) -> str: ...
    @property
    def line(self) -> int: ...
    @property
    def column(self) -> int: ...


class NssToken:
    @property
    def type(self) -> NssTokenType: ...
    @property
    def loc(self) -> SourceLocation: ...


class NssTokenType:
    __members__: ClassVar[dict] = ...  # read-only
    ACTION: ClassVar[NssTokenType] = ...
    AND: ClassVar[NssTokenType] = ...
    ANDAND: ClassVar[NssTokenType] = ...
    ANDEQ: ClassVar[NssTokenType] = ...
    BREAK: ClassVar[NssTokenType] = ...
    CASE: ClassVar[NssTokenType] = ...
    CASSOWARY: ClassVar[NssTokenType] = ...
    COLON: ClassVar[NssTokenType] = ...
    COMMA: ClassVar[NssTokenType] = ...
    CONST: ClassVar[NssTokenType] = ...
    CONTINUE: ClassVar[NssTokenType] = ...
    DEFAULT: ClassVar[NssTokenType] = ...
    DIV: ClassVar[NssTokenType] = ...
    DIVEQ: ClassVar[NssTokenType] = ...
    DO: ClassVar[NssTokenType] = ...
    DOT: ClassVar[NssTokenType] = ...
    EFFECT: ClassVar[NssTokenType] = ...
    ELSE: ClassVar[NssTokenType] = ...
    END: ClassVar[NssTokenType] = ...
    EQ: ClassVar[NssTokenType] = ...
    EQEQ: ClassVar[NssTokenType] = ...
    EVENT: ClassVar[NssTokenType] = ...
    FLOAT: ClassVar[NssTokenType] = ...
    FLOAT_CONST: ClassVar[NssTokenType] = ...
    FOR: ClassVar[NssTokenType] = ...
    GT: ClassVar[NssTokenType] = ...
    GTEQ: ClassVar[NssTokenType] = ...
    IDENTIFIER: ClassVar[NssTokenType] = ...
    IF: ClassVar[NssTokenType] = ...
    INT: ClassVar[NssTokenType] = ...
    INTEGER_CONST: ClassVar[NssTokenType] = ...
    INVALID: ClassVar[NssTokenType] = ...
    ITEMPROPERTY: ClassVar[NssTokenType] = ...
    JSON: ClassVar[NssTokenType] = ...
    LBRACE: ClassVar[NssTokenType] = ...
    LBRACKET: ClassVar[NssTokenType] = ...
    LOCATION: ClassVar[NssTokenType] = ...
    LPAREN: ClassVar[NssTokenType] = ...
    LT: ClassVar[NssTokenType] = ...
    LTEQ: ClassVar[NssTokenType] = ...
    MINUS: ClassVar[NssTokenType] = ...
    MINUSEQ: ClassVar[NssTokenType] = ...
    MINUSMINUS: ClassVar[NssTokenType] = ...
    MOD: ClassVar[NssTokenType] = ...
    MODEQ: ClassVar[NssTokenType] = ...
    NOT: ClassVar[NssTokenType] = ...
    NOTEQ: ClassVar[NssTokenType] = ...
    OBJECT: ClassVar[NssTokenType] = ...
    OBJECT_INVALID_CONST: ClassVar[NssTokenType] = ...
    OBJECT_SELF_CONST: ClassVar[NssTokenType] = ...
    OR: ClassVar[NssTokenType] = ...
    OREQ: ClassVar[NssTokenType] = ...
    OROR: ClassVar[NssTokenType] = ...
    PLUS: ClassVar[NssTokenType] = ...
    PLUSEQ: ClassVar[NssTokenType] = ...
    PLUSPLUS: ClassVar[NssTokenType] = ...
    POUND: ClassVar[NssTokenType] = ...
    QUESTION: ClassVar[NssTokenType] = ...
    RBRACE: ClassVar[NssTokenType] = ...
    RBRACKET: ClassVar[NssTokenType] = ...
    RETURN: ClassVar[NssTokenType] = ...
    RPAREN: ClassVar[NssTokenType] = ...
    SEMICOLON: ClassVar[NssTokenType] = ...
    SL: ClassVar[NssTokenType] = ...
    SLEQ: ClassVar[NssTokenType] = ...
    SQLQUERY: ClassVar[NssTokenType] = ...
    SR: ClassVar[NssTokenType] = ...
    SREQ: ClassVar[NssTokenType] = ...
    STRING: ClassVar[NssTokenType] = ...
    STRING_CONST: ClassVar[NssTokenType] = ...
    STRUCT: ClassVar[NssTokenType] = ...
    SWITCH: ClassVar[NssTokenType] = ...
    TALENT: ClassVar[NssTokenType] = ...
    TILDE: ClassVar[NssTokenType] = ...
    TIMES: ClassVar[NssTokenType] = ...
    TIMESEQ: ClassVar[NssTokenType] = ...
    USR: ClassVar[NssTokenType] = ...
    USREQ: ClassVar[NssTokenType] = ...
    VECTOR: ClassVar[NssTokenType] = ...
    VOID: ClassVar[NssTokenType] = ...
    WHILE: ClassVar[NssTokenType] = ...
    XOR: ClassVar[NssTokenType] = ...
    XOREQ: ClassVar[NssTokenType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class PostfixExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def lhs(self) -> Expression: ...
    @property
    def operator(self) -> NssToken: ...


class Ast:
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, index: int) -> AstNode: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @property
    def defines(self) -> List[Tuple[str, str]]: ...
    @property
    def includes(self) -> List[Nss]: ...
    @property
    def include_resrefs(self) -> StringVector: ...


class Statement(AstNode):
    def __init__(self, *args, **kwargs) -> None: ...


class StructDecl(Declaration):
    def __init__(self, *args, **kwargs) -> None: ...
    def __getitem__(self, index: int) -> VarDecl: ...
    def __len__(self) -> int: ...


class SwitchStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def block(self) -> Statement: ...
    @property
    def target(self) -> Expression: ...


class Type:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def struct_id(self) -> NssToken: ...
    @property
    def type_qualifier(self) -> NssToken: ...
    @property
    def type_specifier(self) -> NssToken: ...


class UnaryExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def operator(self) -> NssToken: ...
    @property
    def rhs(self) -> Expression: ...


class VarDecl(Declaration):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def identifier(self) -> NssToken: ...
    @property
    def init(self) -> Expression: ...


class VariableExpression(Expression):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def var(self) -> NssToken: ...


class WhileStatement(Statement):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def block(self) -> Statement: ...
    @property
    def test(self) -> Expression: ...


def load(script: str) -> Nss: ...
