# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.planned_workout import PlannedWorkout
from .raw_client import AsyncRawPlannedworkoutClient, RawPlannedworkoutClient
from .types.planned_workout_delete_response import PlannedWorkoutDeleteResponse
from .types.planned_workout_fetch_request_start_date import PlannedWorkoutFetchRequestStartDate
from .types.planned_workout_fetch_response import PlannedWorkoutFetchResponse
from .types.planned_workout_write_response import PlannedWorkoutWriteResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PlannedworkoutClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPlannedworkoutClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPlannedworkoutClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPlannedworkoutClient
        """
        return self._raw_client

    def fetch(
        self,
        *,
        user_id: str,
        start_date: PlannedWorkoutFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PlannedWorkoutFetchResponse:
        """
        Used to get workout plans the user has registered on their account. This can be stregnth workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            user ID to query data for

        start_date : PlannedWorkoutFetchRequestStartDate
            start date of data to query for - either ISO8601 date or unix timestamp

        end_date : typing.Optional[int]
            end date of data to query for - either ISO8601 date or unix timestamp

        to_webhook : typing.Optional[bool]
            boolean flag specifying whether to send the data retrieved to the webhook, or in the response

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PlannedWorkoutFetchResponse
            Returned upon successful data request

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.plannedworkout.fetch(
            user_id="user_id",
            start_date=1,
        )
        """
        _response = self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            request_options=request_options,
        )
        return _response.data

    def write(
        self, *, data: typing.Sequence[PlannedWorkout], request_options: typing.Optional[RequestOptions] = None
    ) -> PlannedWorkoutWriteResponse:
        """
        Used to post workout plans users can follow on their wearable. This can be stregnth workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        data : typing.Sequence[PlannedWorkout]
            PlannedWorkout entry to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PlannedWorkoutWriteResponse
            Returned when activity was successfully created on the provider

        Examples
        --------
        from terra import PlannedWorkout, Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.plannedworkout.write(
            data=[PlannedWorkout()],
        )
        """
        _response = self._raw_client.write(data=data, request_options=request_options)
        return _response.data

    def delete(
        self,
        *,
        user_id: str,
        data: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PlannedWorkoutDeleteResponse:
        """
        Used to delete workout plans the user has registered on their account. This can be stregnth workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            user ID to query data for

        data : typing.Optional[typing.Sequence[str]]
            List of identifiers for planned workout entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PlannedWorkoutDeleteResponse
            Returned when all records were deleted successfully

        Examples
        --------
        from terra import Terra

        client = Terra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )
        client.plannedworkout.delete(
            user_id="user_id",
        )
        """
        _response = self._raw_client.delete(user_id=user_id, data=data, request_options=request_options)
        return _response.data


class AsyncPlannedworkoutClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPlannedworkoutClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPlannedworkoutClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPlannedworkoutClient
        """
        return self._raw_client

    async def fetch(
        self,
        *,
        user_id: str,
        start_date: PlannedWorkoutFetchRequestStartDate,
        end_date: typing.Optional[int] = None,
        to_webhook: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PlannedWorkoutFetchResponse:
        """
        Used to get workout plans the user has registered on their account. This can be stregnth workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            user ID to query data for

        start_date : PlannedWorkoutFetchRequestStartDate
            start date of data to query for - either ISO8601 date or unix timestamp

        end_date : typing.Optional[int]
            end date of data to query for - either ISO8601 date or unix timestamp

        to_webhook : typing.Optional[bool]
            boolean flag specifying whether to send the data retrieved to the webhook, or in the response

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PlannedWorkoutFetchResponse
            Returned upon successful data request

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.plannedworkout.fetch(
                user_id="user_id",
                start_date=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.fetch(
            user_id=user_id,
            start_date=start_date,
            end_date=end_date,
            to_webhook=to_webhook,
            request_options=request_options,
        )
        return _response.data

    async def write(
        self, *, data: typing.Sequence[PlannedWorkout], request_options: typing.Optional[RequestOptions] = None
    ) -> PlannedWorkoutWriteResponse:
        """
        Used to post workout plans users can follow on their wearable. This can be stregnth workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        data : typing.Sequence[PlannedWorkout]
            PlannedWorkout entry to post to data provider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PlannedWorkoutWriteResponse
            Returned when activity was successfully created on the provider

        Examples
        --------
        import asyncio

        from terra import AsyncTerra, PlannedWorkout

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.plannedworkout.write(
                data=[PlannedWorkout()],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.write(data=data, request_options=request_options)
        return _response.data

    async def delete(
        self,
        *,
        user_id: str,
        data: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PlannedWorkoutDeleteResponse:
        """
        Used to delete workout plans the user has registered on their account. This can be stregnth workouts (sets, reps, weight lifted) or cardio workouts (warmup, intervals of different intensities, cooldown etc)

        Parameters
        ----------
        user_id : str
            user ID to query data for

        data : typing.Optional[typing.Sequence[str]]
            List of identifiers for planned workout entries to be deleted

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PlannedWorkoutDeleteResponse
            Returned when all records were deleted successfully

        Examples
        --------
        import asyncio

        from terra import AsyncTerra

        client = AsyncTerra(
            dev_id="YOUR_DEV_ID",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.plannedworkout.delete(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id=user_id, data=data, request_options=request_options)
        return _response.data
