# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .activity_level_sample import ActivityLevelSample


class ActiveDurationsData(UncheckedBaseModel):
    activity_levels_samples: typing.Optional[typing.List[ActivityLevelSample]] = pydantic.Field(default=None)
    """
    Array of detailed samples of the intensity the user was in at various points during the workout.
    """

    activity_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in an active state during the workout.
    """

    inactivity_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in an inactive state during the workout.
    """

    low_intensity_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a low intensity state during the workout.
    """

    moderate_intensity_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a moderate intensity state during the workout.
    """

    num_continuous_inactive_periods: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum number of continuous periods spent in an inactive state during the workout.
    """

    rest_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent resting during the workout.
    """

    vigorous_intensity_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total number of seconds spent in a state of vigorous intensity during the workout.
    """

    standing_hours_count: typing.Optional[float] = None
    standing_seconds: typing.Optional[float] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
