# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .active_durations_data import ActiveDurationsData
from .activity_metadata import ActivityMetadata
from .calories_data import CaloriesData
from .data_enrichment import DataEnrichment
from .device_data import DeviceData
from .distance_data import DistanceData
from .energy_data import EnergyData
from .heart_rate_data import HeartRateData
from .lap_data import LapData
from .met_data import MetData
from .movement_data import MovementData
from .oxygen_data import OxygenData
from .polyline_map_data import PolylineMapData
from .position_data import PositionData
from .power_data import PowerData
from .strain_data import StrainData
from .tss_data import TssData
from .work_data import WorkData


class Activity(UncheckedBaseModel):
    active_durations_data: typing.Optional[ActiveDurationsData] = pydantic.Field(default=None)
    """
    Number of minutes spent at various intensities during the workout, as reported by the Fitness Data provider.
    """

    calories_data: typing.Optional[CaloriesData] = pydantic.Field(default=None)
    """
    Object containing calorie-related information for the user during the specific workout.
    """

    cheat_detection: typing.Optional[int] = pydantic.Field(default=None)
    """
    Cheat detection flag.
    """

    data_enrichment: typing.Optional[DataEnrichment] = pydantic.Field(default=None)
    """
    Object containing Terra Scores.
    """

    device_data: typing.Optional[DeviceData] = pydantic.Field(default=None)
    """
    Object containing information on the device which recorded the specific workout.
    """

    distance_data: typing.Optional[DistanceData] = pydantic.Field(default=None)
    """
    Object containing information related to distance covered during the associated workout.
    """

    energy_data: typing.Optional[EnergyData] = pydantic.Field(default=None)
    """
    Object containing information on the energy expended by the user during the workout.
    """

    heart_rate_data: typing.Optional[HeartRateData] = pydantic.Field(default=None)
    """
    Object containing heartrate-related information for the workout.
    """

    lap_data: typing.Optional[LapData] = pydantic.Field(default=None)
    """
    Object containing information on data for each lap performed by the user - mostly relates to track & field running activities, and swimming activities.
    """

    met_data: typing_extensions.Annotated[typing.Optional[MetData], FieldMetadata(alias="MET_data")] = pydantic.Field(
        default=None
    )
    """
    Object containing information on the Metabolic Equivalent of Task for the workout.
    """

    metadata: ActivityMetadata = pydantic.Field()
    """
    Object containing workout metadata.
    """

    movement_data: typing.Optional[MovementData] = pydantic.Field(default=None)
    """
    Object containing information on the user's movement throughout the workout.
    """

    oxygen_data: typing.Optional[OxygenData] = pydantic.Field(default=None)
    """
    Object containing information on oxygen-related metrics for the workout.
    """

    polyline_map_data: typing.Optional[PolylineMapData] = pydantic.Field(default=None)
    """
    Object containing polyline-representation map data, plotting the user's trajectory throughout the workout.
    """

    position_data: typing.Optional[PositionData] = pydantic.Field(default=None)
    """
    Object containing information on the user's position throughout the workout.
    """

    power_data: typing.Optional[PowerData] = pydantic.Field(default=None)
    """
    Object containing information on the power generated by the user during the workout.
    """

    strain_data: typing.Optional[StrainData] = pydantic.Field(default=None)
    """
    Object containing information on the cardiovascular strain imposed on the user during the workout.
    """

    tss_data: typing_extensions.Annotated[typing.Optional[TssData], FieldMetadata(alias="TSS_data")] = pydantic.Field(
        default=None
    )
    """
    Object containing information on the stress put on the user's body from a workout.
    """

    work_data: typing.Optional[WorkData] = pydantic.Field(default=None)
    """
    Object containing information on the work output of the user during the workout.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
