# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class AwakeDurations(UncheckedBaseModel):
    duration_awake_state_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total duration for which the user was awake during the sleep session.
    """

    duration_long_interruption_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total duration for which the user was awake during the sleep session, when the interruption of their sleep was greater than 90 seconds.
    """

    duration_short_interruption_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total duration for which the user was awake during the sleep session, when the interruption of their sleep was less than 90 seconds.
    """

    num_out_of_bed_events: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of times the user got out of bed during the sleep session.
    """

    num_wakeup_events: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of times the user woke up during the sleep session.
    """

    sleep_latency_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Sleep latency, defined as time between the moment the user lays in bed with the intention to sleep and the moment they actually fall asleep.
    """

    wake_up_latency_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Wake up latency, defined as time between the moment the user wakes up and the moment they get out of bed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
