# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .blood_pressure_data import BloodPressureData
from .body_metadata import BodyMetadata
from .device_data import DeviceData
from .glucose_data import GlucoseData
from .heart_data import HeartData
from .hydration_data import HydrationData
from .ketone_data import KetoneData
from .measurements_data import MeasurementsData
from .oxygen_data import OxygenData
from .temperature_data import TemperatureData


class Body(UncheckedBaseModel):
    blood_pressure_data: typing.Optional[BloodPressureData] = pydantic.Field(default=None)
    """
    Object containing information on user's Blood Pressure.
    """

    device_data: typing.Optional[DeviceData] = pydantic.Field(default=None)
    """
    Object containing information on the device which recorded data for the payload.
    """

    heart_data: typing.Optional[HeartData] = pydantic.Field(default=None)
    """
    Object containing information on user's heart metrics.
    """

    hydration_data: typing.Optional[HydrationData] = pydantic.Field(default=None)
    """
    Object containing information on user's hydration (both internal & consumption of water) for the day.
    """

    ketone_data: typing.Optional[KetoneData] = pydantic.Field(default=None)
    """
    Object containing information on user's ketone data for the day.
    """

    measurements_data: typing.Optional[MeasurementsData] = pydantic.Field(default=None)
    """
    Object containing information on body measurements for the day.
    """

    metadata: BodyMetadata = pydantic.Field()
    """
    Object containing daily summary metadata.
    """

    oxygen_data: typing.Optional[OxygenData] = pydantic.Field(default=None)
    """
    Object containing information on user's oxygen-related data.
    """

    temperature_data: typing.Optional[TemperatureData] = pydantic.Field(default=None)
    """
    Object containing temperature information (core, skin, ambient) during the day.
    """

    glucose_data: typing.Optional[GlucoseData] = pydantic.Field(default=None)
    """
    Object containing information on user's blood glucose for the day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
