# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class DeauthEvent(UncheckedBaseModel):
    """
    User deauthentication event
    """

    type: typing.Literal["deauth"] = "deauth"
    user: TerraUser = pydantic.Field()
    """
    User who deauthenticated
    """

    status: typing.Literal["success"] = pydantic.Field(default="success")
    """
    Status of deauthentication
    """

    message: str = pydantic.Field()
    """
    Confirmation message
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
