# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .device_data_type import DeviceDataType
from .other_device_data import OtherDeviceData


class DeviceData(UncheckedBaseModel):
    activation_timestamp: typing.Optional[str] = pydantic.Field(default=None)
    """
    Activation timestamp of the device, if applicable.
    """

    data_provided: typing.Optional[typing.List[DeviceDataType]] = pydantic.Field(default=None)
    """
    Data provided by the device, as enumerated types.
    """

    hardware_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Hardware version of the device.
    """

    last_upload_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Last upload date from the device.
    """

    manufacturer: typing.Optional[str] = pydantic.Field(default=None)
    """
    Device manufacturer name.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Device name - note that this can also be the name of the application/package which the data comes from, if coming from a data aggregator such as Google Fit.
    """

    other_devices: typing.Optional[typing.List[OtherDeviceData]] = pydantic.Field(default=None)
    """
    Data pertaining to other devices which may have contributed data for this workout.
    """

    sensor_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sensor state of the device.
    """

    serial_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Device Serial Number.
    """

    software_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Device Software Version.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
