# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .elevation_data import ElevationData
from .swimming_data import SwimmingData


class DistanceDataSummary(UncheckedBaseModel):
    distance_meters: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total distance covered by the user throughout the workout.
    """

    elevation: typing.Optional[ElevationData] = pydantic.Field(default=None)
    """
    Average elevation of the user throughout the workout.
    """

    floors_climbed: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of elevation gain in floors climbed equivalent throughout the workout, as determined by the fitness data provider.
    """

    steps: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of steps performed during the workout.
    """

    swimming: typing.Optional[SwimmingData] = pydantic.Field(default=None)
    """
    Summary information of the user's swimming statistics for the workout, if applicable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
