# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .a_fib_classification_sample import AFibClassificationSample
from .ecg_reading import EcgReading
from .heart_rate_data import HeartRateData
from .pulse_velocity_sample import PulseVelocitySample
from .rr_interval_sample import RrIntervalSample


class HeartData(UncheckedBaseModel):
    afib_classification_samples: typing.Optional[typing.List[AFibClassificationSample]] = pydantic.Field(default=None)
    """
    List of Atrial Fibrillation classification measurements sampled through the day.
    """

    ecg_signal: typing.Optional[typing.List[EcgReading]] = pydantic.Field(default=None)
    """
    List of ECGReadings sampled through the day.
    """

    heart_rate_data: typing.Optional[HeartRateData] = pydantic.Field(default=None)
    """
    Object containing heart rate data.
    """

    pulse_wave_velocity_samples: typing.Optional[typing.List[PulseVelocitySample]] = pydantic.Field(default=None)
    """
    List of Pulse Wave Velocity measurements sampled throughout the day. This represents a measurement of arterial stiffness that is an independent predictor of cardiovascular risk.
    """

    rr_interval_samples: typing.Optional[typing.List[RrIntervalSample]] = pydantic.Field(default=None)
    """
    List of RR Interval samples throughout the day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
