# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .terra_user import TerraUser


class LargeRequestProcessingEvent(UncheckedBaseModel):
    """
    Large request processing event
    """

    type: typing.Literal["large_request_processing"] = "large_request_processing"
    status: typing.Literal["processing"] = pydantic.Field(default="processing")
    """
    Status of the processing
    """

    message: str = pydantic.Field()
    """
    Information about the processing
    """

    user: TerraUser = pydantic.Field()
    """
    User whose data is being processed
    """

    reference: str = pydantic.Field()
    """
    Reference ID for tracking this request
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
