# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .nutrition_macros import NutritionMacros
from .nutrition_micros import NutritionMicros
from .nutrition_quantity import NutritionQuantity
from .snack import Snack


class Meal(UncheckedBaseModel):
    micros: NutritionMicros = pydantic.Field()
    """
    Micronutrient information for associated food.
    """

    type: Snack = pydantic.Field()
    """
    Enum representing the category the consumed food/meal falls under (i.e. Breakfast/Lunch/Dinner etc).
    """

    id: str = pydantic.Field()
    """
    Identifier for food logged by the user.
    """

    timestamp: str = pydantic.Field()
    """
    Timestamp the food is associated with, in ISO8601 format, with microsecond precision.
    """

    quantity: NutritionQuantity = pydantic.Field()
    """
    Quantity of the food that was consumed, containing information on amount & units in which this was recorded.
    """

    name: str = pydantic.Field()
    """
    Name of food logged by the user.
    """

    macros: NutritionMacros = pydantic.Field()
    """
    Macronutrient information for associated food.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
