# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .cadence_sample import CadenceSample
from .speed_sample import SpeedSample
from .torque_sample import TorqueSample


class MovementData(UncheckedBaseModel):
    adjusted_max_speed_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Adjusted max speed of the user during the workout - generated using Terra's algorithms to remove potential affecting the user's actual max speed measurement.
    """

    avg_cadence_rpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average cadence of the user during the workout, in RPM.
    """

    avg_pace_minutes_per_kilometer: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average pace of the user during the workout.
    """

    avg_speed_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average speed of the user during the workout.
    """

    avg_torque_newton_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average torque generated by the user during the workout - mainly relevant for cycling activities.
    """

    avg_velocity_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average velocity of the user during the workout - only calculated by certain providers, representing a separate quantity from speed.
    """

    cadence_samples: typing.Optional[typing.List[CadenceSample]] = pydantic.Field(default=None)
    """
    Array of cadence values recorded throughout the workout, sampled at intervals determined by the fitness data provider.
    """

    max_cadence_rpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum cadence of the user during the workout - mainly relevant for cycling activities.
    """

    max_pace_minutes_per_kilometer: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum pace of the user during the workout.
    """

    max_speed_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum speed of the user during the workout.
    """

    max_torque_newton_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum torque generated by the user during the workout - mainly relevant for cycling activities.
    """

    max_velocity_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum velocity of the user during the workout - only calculated by certain providers, representing a separate quantity from speed.
    """

    normalized_speed_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average normalized speed of the user during the workout - only calculated by certain providers, representing a separate quantity from speed.
    """

    speed_samples: typing.Optional[typing.List[SpeedSample]] = pydantic.Field(default=None)
    """
    Array of the datapoints for the user's speed sampled throughout the workout.
    """

    torque_samples: typing.Optional[typing.List[TorqueSample]] = pydantic.Field(default=None)
    """
    Array of the datapoints for the user's torque sampled throughout the workout.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
