# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .nutrition import Nutrition
from .terra_user import TerraUser


class NutritionEvent(UncheckedBaseModel):
    """
    Nutrition data event
    """

    type: typing.Literal["nutrition"] = "nutrition"
    data: typing.List[Nutrition] = pydantic.Field()
    """
    Array of nutrition data
    """

    user: TerraUser = pydantic.Field()
    """
    User whose data is being provided
    """

    version: str = pydantic.Field()
    """
    API version
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
