# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .power_sample import PowerSample


class PowerData(UncheckedBaseModel):
    avg_watts: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average power output of the user during the workout.
    """

    max_watts: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum power output of the user during the workout.
    """

    power_samples: typing.Optional[typing.List[PowerSample]] = pydantic.Field(default=None)
    """
    Array containing datapoints of the power output of the user sampled throughout the workout.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
