# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .device_data import DeviceData
from .heart_rate_data import HeartRateData
from .readiness_data import ReadinessData
from .respiration_data import RespirationData
from .sleep_data_enrichment import SleepDataEnrichment
from .sleep_durations_data import SleepDurationsData
from .sleep_metadata import SleepMetadata
from .sleep_scores import SleepScores
from .sleep_temperature_data import SleepTemperatureData


class Sleep(UncheckedBaseModel):
    data_enrichment: typing.Optional[SleepDataEnrichment] = pydantic.Field(default=None)
    """
    Object containing additional enrichment data for the sleep session.
    """

    device_data: typing.Optional[DeviceData] = pydantic.Field(default=None)
    """
    Object containing information on the device which recorded data for the payload.
    """

    heart_rate_data: typing.Optional[HeartRateData] = pydantic.Field(default=None)
    """
    Object containing information on the user's heart rate during the sleep session.
    """

    metadata: SleepMetadata = pydantic.Field()
    """
    Object containing daily summary metadata.
    """

    readiness_data: typing.Optional[ReadinessData] = pydantic.Field(default=None)
    """
    Object containing information on the user's readiness for the day, based off the quality and duration of their sleep.
    """

    respiration_data: typing.Optional[RespirationData] = pydantic.Field(default=None)
    """
    Object containing information on the user's respiration throughout the sleep session.
    """

    scores: typing.Optional[SleepScores] = pydantic.Field(default=None)
    """
    User's sleep score
    """

    sleep_durations_data: typing.Optional[SleepDurationsData] = pydantic.Field(default=None)
    """
    Object containing information on the user's duration spent in various sleep stages.
    """

    temperature_data: typing.Optional[SleepTemperatureData] = pydantic.Field(default=None)
    """
    Object containing body temperature information of the user during the sleep recording session.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
