# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .terra_user import TerraUser


class UserAuthWebhookPayload_Success(UncheckedBaseModel):
    status: typing.Literal["success"] = "success"
    user: TerraUser
    reference_id: str
    widget_session_id: str
    type: typing.Literal["auth"] = "auth"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class UserAuthWebhookPayload_Error(UncheckedBaseModel):
    status: typing.Literal["error"] = "error"
    user: TerraUser
    provider: str
    message: str
    reason: str
    reference_id: str
    widget_session_id: str
    type: typing.Literal["auth"] = "auth"

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


UserAuthWebhookPayload = typing_extensions.Annotated[
    typing.Union[UserAuthWebhookPayload_Success, UserAuthWebhookPayload_Error], UnionMetadata(discriminant="status")
]
