"""
Class object for CasaTunesSystem
Documentation: https://github.com/jonkristian/pycasatunes

Generated by generator/generator.py - 2021-07-31 12:29:43.406741
"""
from .base import CasaBase, CasaBaseClient


class Eqsettings(CasaBase):
    @property
    def Minimum(self):
        return self.attributes.get("Minimum", None)

    @property
    def Maximum(self):
        return self.attributes.get("Maximum", None)

    @property
    def Increment(self):
        return self.attributes.get("Increment", None)


class Volumesettings(CasaBase):
    @property
    def Minimum(self):
        return self.attributes.get("Minimum", None)

    @property
    def Maximum(self):
        return self.attributes.get("Maximum", None)

    @property
    def Increment(self):
        return self.attributes.get("Increment", None)


class Values(CasaBase):
    @property
    def Name(self):
        return self.attributes.get("Name", "")

    @property
    def Value(self):
        return self.attributes.get("Value", "")

    @property
    def IsError(self):
        return self.attributes.get("IsError", False)


class Matrixinfo(CasaBase):
    @property
    def Title(self):
        return self.attributes.get("Title", "")

    @property
    def Values(self):
        return [Values(x) for x in self.attributes.get("Values", [])]


class CasaTunesSystem(CasaBaseClient):
    @property
    def AppName(self):
        return self.attributes.get("AppName", "")

    @property
    def ControllerFeatures(self):
        return self.attributes.get("ControllerFeatures", None)

    @property
    def EQSettings(self):
        return Eqsettings(self.attributes.get("EQSettings", {}))

    @property
    def VolumeSettings(self):
        return Volumesettings(self.attributes.get("VolumeSettings", {}))

    @property
    def MACAddress(self):
        return self.attributes.get("MACAddress", "")

    @property
    def TeamViewerMACAddress(self):
        return self.attributes.get("TeamViewerMACAddress", "")

    @property
    def IPAddress(self):
        return self.attributes.get("IPAddress", "")

    @property
    def CasaTunesVersion(self):
        return self.attributes.get("CasaTunesVersion", "")

    @property
    def WebServicesVersion(self):
        return self.attributes.get("WebServicesVersion", "")

    @property
    def RESTServicesVersion(self):
        return self.attributes.get("RESTServicesVersion", "")

    @property
    def IsLicenseValid(self):
        return self.attributes.get("IsLicenseValid", True)

    @property
    def IsCAMSupported(self):
        return self.attributes.get("IsCAMSupported", None)

    @property
    def IsAirableLicensed(self):
        return self.attributes.get("IsAirableLicensed", False)

    @property
    def IsSystemSleepEnabled(self):
        return self.attributes.get("IsSystemSleepEnabled", False)

    @property
    def IsPasswordRequired(self):
        return self.attributes.get("IsPasswordRequired", False)

    @property
    def StreamerModeEnabled(self):
        return self.attributes.get("StreamerModeEnabled", False)

    @property
    def IsSettingsPasswordRequired(self):
        return self.attributes.get("IsSettingsPasswordRequired", False)

    @property
    def IsPrayersEnabled(self):
        return self.attributes.get("IsPrayersEnabled", True)

    @property
    def IndexerPort(self):
        return self.attributes.get("IndexerPort", None)

    @property
    def MatrixInfo(self):
        return [Matrixinfo(x) for x in self.attributes.get("MatrixInfo", [])]
