#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Hardcoded values for the wavelength.
{pixel_value: wavelength}
Taken from original software.
Pixel value is relative to 5461 Å Mercury line.
5461 Å Mercury line is at key 0.
Wavelength measured in Ångström (Å).
"""
WAVELENGTH_PER_PIXEL = {
    -399: 4242.7, -398: 4244.3, -397: 4245.9, -396: 4247.5, -395: 4249.1,
    -394: 4250.7, -393: 4252.3, -392: 4253.9, -391: 4255.6, -390: 4257.2,
    -389: 4258.8, -388: 4260.5, -387: 4262.1, -386: 4263.8, -385: 4265.4,
    -384: 4267.1, -383: 4268.7, -382: 4270.4, -381: 4272.0, -380: 4273.7,
    -379: 4275.4, -378: 4277.1, -377: 4278.8, -376: 4280.4, -375: 4282.1,
    -374: 4283.8, -373: 4285.5, -372: 4287.2, -371: 4288.9, -370: 4290.7,
    -369: 4292.4, -368: 4294.1, -367: 4295.8, -366: 4297.6, -365: 4299.3,
    -364: 4301.0, -363: 4302.8, -362: 4304.5, -361: 4306.3, -360: 4308.0,
    -359: 4309.8, -358: 4311.6, -357: 4313.4, -356: 4315.1, -355: 4316.9,
    -354: 4318.7, -353: 4320.5, -352: 4322.3, -351: 4324.1, -350: 4325.9,
    -349: 4327.7, -348: 4329.5, -347: 4331.3, -346: 4333.2, -345: 4335.0,
    -344: 4336.8, -343: 4338.7, -342: 4340.5, -341: 4342.3, -340: 4344.2,
    -339: 4346.1, -338: 4347.9, -337: 4349.8, -336: 4351.7, -335: 4353.5,
    -334: 4355.4, -333: 4357.3, -332: 4359.2, -331: 4361.1, -330: 4363.0,
    -329: 4364.9, -328: 4366.8, -327: 4368.7, -326: 4370.7, -325: 4372.6,
    -324: 4374.5, -323: 4376.5, -322: 4378.4, -321: 4380.4, -320: 4382.3,
    -319: 4384.3, -318: 4386.2, -317: 4388.2, -316: 4390.2, -315: 4392.2,
    -314: 4394.1, -313: 4396.1, -312: 4398.1, -311: 4400.1, -310: 4402.1,
    -309: 4404.2, -308: 4406.2, -307: 4408.2, -306: 4410.2, -305: 4412.3,
    -304: 4414.3, -303: 4416.3, -302: 4418.4, -301: 4420.5, -300: 4422.5,
    -299: 4424.6, -298: 4426.7, -297: 4428.7, -296: 4430.8, -295: 4432.9,
    -294: 4435.0, -293: 4437.1, -292: 4439.2, -291: 4441.4, -290: 4443.5,
    -289: 4445.6, -288: 4447.7, -287: 4449.9, -286: 4452.0, -285: 4454.2,
    -284: 4456.3, -283: 4458.5, -282: 4460.7, -281: 4462.8, -280: 4465.0,
    -279: 4467.2, -278: 4469.4, -277: 4471.6, -276: 4473.8, -275: 4476.0,
    -274: 4478.2, -273: 4480.5, -272: 4482.7, -271: 4484.9, -270: 4487.2,
    -269: 4489.4, -268: 4491.7, -267: 4494.0, -266: 4496.2, -265: 4498.5,
    -264: 4500.8, -263: 4503.1, -262: 4505.4, -261: 4507.7, -260: 4510.0,
    -259: 4512.3, -258: 4514.6, -257: 4517.0, -256: 4519.3, -255: 4521.6,
    -254: 4524.0, -253: 4526.3, -252: 4528.7, -251: 4531.1, -250: 4533.5,
    -249: 4535.8, -248: 4538.2, -247: 4540.6, -246: 4543.0, -245: 4545.4,
    -244: 4547.9, -243: 4550.3, -242: 4552.7, -241: 4555.2, -240: 4557.6,
    -239: 4560.1, -238: 4562.5, -237: 4565.0, -236: 4567.5, -235: 4570.0,
    -234: 4572.5, -233: 4575.0, -232: 4577.5, -231: 4580.0, -230: 4582.5,
    -229: 4585.0, -228: 4587.6, -227: 4590.1, -226: 4592.7, -225: 4595.2,
    -224: 4597.8, -223: 4600.4, -222: 4603.0, -221: 4605.6, -220: 4608.2,
    -219: 4610.8, -218: 4613.4, -217: 4616.0, -216: 4618.6, -215: 4621.3,
    -214: 4623.9, -213: 4626.6, -212: 4629.3, -211: 4631.9, -210: 4634.6,
    -209: 4637.3, -208: 4640.0, -207: 4642.7, -206: 4645.4, -205: 4648.1,
    -204: 4650.9, -203: 4653.6, -202: 4656.4, -201: 4659.1, -200: 4661.9,
    -199: 4664.7, -198: 4667.4, -197: 4670.2, -196: 4673.0, -195: 4675.8,
    -194: 4678.7, -193: 4681.5, -192: 4684.3, -191: 4687.2, -190: 4690.0,
    -189: 4692.9, -188: 4695.7, -187: 4698.6, -186: 4701.5, -185: 4704.4,
    -184: 4707.3, -183: 4710.2, -182: 4713.2, -181: 4716.1, -180: 4719.1,
    -179: 4722.0, -178: 4725.0, -177: 4727.9, -176: 4730.9, -175: 4733.9,
    -174: 4736.9, -173: 4739.9, -172: 4743.0, -171: 4746.0, -170: 4749.0,
    -169: 4752.1, -168: 4755.1, -167: 4758.2, -166: 4761.3, -165: 4764.4,
    -164: 4767.5, -163: 4770.6, -162: 4773.7, -161: 4776.9, -160: 4780.0,
    -159: 4783.2, -158: 4786.3, -157: 4789.5, -156: 4792.7, -155: 4795.9,
    -154: 4799.1, -153: 4802.3, -152: 4805.5, -151: 4808.8, -150: 4812.0,
    -149: 4815.3, -148: 4818.5, -147: 4821.8, -146: 4825.1, -145: 4828.4,
    -144: 4831.7, -143: 4835.1, -142: 4838.4, -141: 4841.7, -140: 4845.1,
    -139: 4848.5, -138: 4851.9, -137: 4855.2, -136: 4858.6, -135: 4862.1,
    -134: 4865.5, -133: 4868.9, -132: 4872.4, -131: 4875.9, -130: 4879.3,
    -129: 4882.8, -128: 4886.3, -127: 4889.8, -126: 4893.4, -125: 4896.9,
    -124: 4900.4, -123: 4904.0, -122: 4907.6, -121: 4911.2, -120: 4914.8,
    -119: 4918.4, -118: 4922.0, -117: 4925.6, -116: 4929.3, -115: 4932.9,
    -114: 4936.6, -113: 4940.3, -112: 4944.0, -111: 4947.7, -110: 4951.4,
    -109: 4955.2, -108: 4958.9, -107: 4962.7, -106: 4966.5, -105: 4970.3,
    -104: 4974.1, -103: 4977.9, -102: 4981.7, -101: 4985.6, -100: 4989.4,
    -99: 4993.3, -98: 4997.2, -97: 5001.1, -96: 5005.0, -95: 5009.0,
    -94: 5012.9, -93: 5016.9, -92: 5020.8, -91: 5024.8, -90: 5028.8,
    -89: 5032.8, -88: 5036.9, -87: 5040.9, -86: 5045.0, -85: 5049.1,
    -84: 5053.2, -83: 5057.3, -82: 5061.4, -81: 5065.5, -80: 5069.7,
    -79: 5073.9, -78: 5078.0, -77: 5082.2, -76: 5086.5, -75: 5090.7,
    -74: 5094.9, -73: 5099.2, -72: 5103.5, -71: 5107.8, -70: 5112.1,
    -69: 5116.4, -68: 5120.8, -67: 5125.1, -66: 5129.5, -65: 5133.9,
    -64: 5138.3, -63: 5142.7, -62: 5147.2, -61: 5151.6, -60: 5156.1,
    -59: 5160.6, -58: 5165.1, -57: 5169.6, -56: 5174.2, -55: 5178.8,
    -54: 5183.3, -53: 5187.9, -52: 5192.6, -51: 5197.2, -50: 5201.8,
    -49: 5206.5, -48: 5211.2, -47: 5215.9, -46: 5220.6, -45: 5225.4,
    -44: 5230.2, -43: 5234.9, -42: 5239.7, -41: 5244.6, -40: 5249.4,
    -39: 5254.3, -38: 5259.1, -37: 5264.0, -36: 5269.0, -35: 5273.9,
    -34: 5278.9, -33: 5283.8, -32: 5288.8, -31: 5293.8, -30: 5298.9,
    -29: 5303.9, -28: 5309.0, -27: 5314.1, -26: 5319.2, -25: 5324.4,
    -24: 5329.5, -23: 5334.7, -22: 5339.9, -21: 5345.2, -20: 5350.4,
    -19: 5355.7, -18: 5361.0, -17: 5366.3, -16: 5371.6, -15: 5377.0,
    -14: 5382.3, -13: 5387.7, -12: 5393.2, -11: 5398.6, -10: 5404.1,
    -9: 5409.6, -8: 5415.1, -7: 5420.6, -6: 5426.2, -5: 5431.8,
    -4: 5437.4, -3: 5443.0, -2: 5448.7, -1: 5454.3, 0: 5460.0,
    1: 5465.8, 2: 5471.5, 3: 5477.3, 4: 5483.1, 5: 5488.9,
    6: 5494.8, 7: 5500.7, 8: 5506.6, 9: 5512.5, 10: 5518.5,
    11: 5524.4, 12: 5530.4, 13: 5536.5, 14: 5542.5, 15: 5548.6,
    16: 5554.7, 17: 5560.9, 18: 5567.0, 19: 5573.2, 20: 5579.5,
    21: 5585.7, 22: 5592.0, 23: 5598.3, 24: 5604.6, 25: 5611.0,
    26: 5617.4, 27: 5623.8, 28: 5630.2, 29: 5636.7, 30: 5643.2,
    31: 5649.8, 32: 5656.3, 33: 5662.9, 34: 5669.5, 35: 5676.2,
    36: 5682.9, 37: 5689.6, 38: 5696.4, 39: 5703.1, 40: 5709.9,
    41: 5716.8, 42: 5723.7, 43: 5730.6, 44: 5737.5, 45: 5744.5,
    46: 5751.5, 47: 5758.5, 48: 5765.6, 49: 5772.7, 50: 5779.8,
    51: 5787.0, 52: 5794.2, 53: 5801.4, 54: 5808.7, 55: 5816.0,
    56: 5823.4, 57: 5830.7, 58: 5838.2, 59: 5845.6, 60: 5853.1,
    61: 5860.6, 62: 5868.2, 63: 5875.8, 64: 5883.4, 65: 5891.1,
    66: 5898.8, 67: 5906.5, 68: 5914.3, 69: 5922.1, 70: 5930.0,
    71: 5937.9, 72: 5945.8, 73: 5953.8, 74: 5961.8, 75: 5969.9,
    76: 5978.0, 77: 5986.1, 78: 5994.3, 79: 6002.5, 80: 6010.8,
    81: 6019.1, 82: 6027.5, 83: 6035.9, 84: 6044.3, 85: 6052.8,
    86: 6061.3, 87: 6069.9, 88: 6078.5, 89: 6087.1, 90: 6095.8,
    91: 6104.6, 92: 6113.4, 93: 6122.2, 94: 6131.1, 95: 6140.0,
    96: 6149.0, 97: 6158.0, 98: 6167.1, 99: 6176.2, 100: 6185.4,
    101: 6194.6, 102: 6203.9, 103: 6213.2, 104: 6222.6, 105: 6232.0,
    106: 6241.5, 107: 6251.0, 108: 6260.6, 109: 6270.2, 110: 6279.9,
    111: 6289.6, 112: 6299.4, 113: 6309.3, 114: 6319.2, 115: 6329.1,
    116: 6339.1, 117: 6349.2, 118: 6359.3, 119: 6369.5, 120: 6379.7,
    121: 6390.0, 122: 6400.4, 123: 6410.8, 124: 6421.3, 125: 6431.8,
    126: 6442.4, 127: 6453.0, 128: 6463.7, 129: 6474.5, 130: 6485.4,
    131: 6496.3, 132: 6507.2, 133: 6518.3, 134: 6529.4, 135: 6540.5,
    136: 6551.8, 137: 6563.1, 138: 6574.4, 139: 6585.9, 140: 6597.4,
    141: 6608.9, 142: 6620.6, 143: 6632.3, 144: 6644.1, 145: 6655.9,
    146: 6667.8, 147: 6679.8, 148: 6691.9, 149: 6704.1, 150: 6716.3,
    151: 6728.6, 152: 6740.9, 153: 6753.4, 154: 6765.9, 155: 6778.5,
    156: 6791.2, 157: 6804.0, 158: 6816.9, 159: 6829.8, 160: 6842.8,
    161: 6855.9, 162: 6869.1, 163: 6882.4, 164: 6895.7, 165: 6909.2,
    166: 6922.7, 167: 6936.3, 168: 6950.0, 169: 6963.8, 170: 6977.7,
    171: 6991.7, 172: 7005.8, 173: 7020.0, 174: 7034.2, 175: 7048.6,
    176: 7063.0, 177: 7077.6, 178: 7092.3, 179: 7107.0, 180: 7121.9,
    181: 7136.8, 182: 7151.9, 183: 7167.1, 184: 7182.4, 185: 7197.7,
    186: 7213.2, 187: 7228.8, 188: 7244.5, 189: 7260.4, 190: 7276.3,
    191: 7292.3, 192: 7308.5, 193: 7324.8, 194: 7341.2, 195: 7357.7,
    196: 7374.3, 197: 7391.1, 198: 7408.0, 199: 7425.0, 200: 7442.1,
    201: 7459.3, 202: 7476.7, 203: 7494.2, 204: 7511.9, 205: 7529.7,
    206: 7547.6, 207: 7565.6, 208: 7583.8, 209: 7602.1, 210: 7620.6,
    211: 7639.2, 212: 7657.9, 213: 7676.8, 214: 7695.8, 215: 7715.0,
    216: 7734.4, 217: 7753.9, 218: 7773.5, 219: 7793.3, 220: 7813.2,
    221: 7833.3, 222: 7853.6, 223: 7874.0, 224: 7894.6, 225: 7915.4,
    226: 7936.3, 227: 7957.4, 228: 7978.7, 229: 8000.1, 230: 8021.7,
    231: 8043.5, 232: 8065.5, 233: 8087.7, 234: 8110.0, 235: 8132.5,
    236: 8155.2, 237: 8178.1, 238: 8201.2, 239: 8224.5, 240: 8248.0,
    241: 8271.7, 242: 8295.6, 243: 8319.7, 244: 8344.0, 245: 8368.5,
    246: 8393.2, 247: 8418.1, 248: 8443.3, 249: 8468.6, 250: 8494.2,
    251: 8520.0, 252: 8546.0, 253: 8572.3, 254: 8598.7, 255: 8625.4,
    256: 8652.4, 257: 8679.6, 258: 8707.0, 259: 8734.7, 260: 8762.6,
    261: 8790.7, 262: 8819.1, 263: 8847.8, 264: 8876.7, 265: 8905.9,
    266: 8935.3, 267: 8965.0, 268: 8995.0, 269: 9025.2, 270: 9055.7,
    271: 9086.5, 272: 9117.5, 273: 9148.9, 274: 9180.5, 275: 9212.4,
    276: 9244.6, 277: 9277.0, 278: 9309.8, 279: 9342.9, 280: 9376.2,
    281: 9409.9, 282: 9443.8, 283: 9478.1, 284: 9512.7, 285: 9547.6,
    286: 9582.8, 287: 9618.3, 288: 9654.1, 289: 9690.3, 290: 9726.8,
    291: 9763.6, 292: 9800.7, 293: 9838.2, 294: 9876.0, 295: 9914.2,
    296: 9952.7, 297: 9991.5, 298: 10030.7, 299: 10070.3, 300: 10110.2,
    301: 10150.5, 302: 10191.1, 303: 10232.2, 304: 10273.6, 305: 10315.4,
    306: 10357.5, 307: 10400.1, 308: 10443.1, 309: 10486.5, 310: 10530.3,
    311: 10574.6, 312: 10619.3, 313: 10664.4, 314: 10710.1, 315: 10756.2,
    316: 10802.8, 317: 10849.9, 318: 10897.6, 319: 10945.9, 320: 10994.7,
    321: 11044.2, 322: 11094.3, 323: 11145.1
}
