import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AvailabilitySetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#location AvailabilitySet#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#managed AvailabilitySet#managed}.
     *
     * @stability stable
     */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#name AvailabilitySet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#platform_fault_domain_count AvailabilitySet#platform_fault_domain_count}.
     *
     * @stability stable
     */
    readonly platformFaultDomainCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#platform_update_domain_count AvailabilitySet#platform_update_domain_count}.
     *
     * @stability stable
     */
    readonly platformUpdateDomainCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#proximity_placement_group_id AvailabilitySet#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#resource_group_name AvailabilitySet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#tags AvailabilitySet#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#timeouts AvailabilitySet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AvailabilitySetTimeouts;
}
/**
 * @stability stable
 */
export interface AvailabilitySetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#create AvailabilitySet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#delete AvailabilitySet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#read AvailabilitySet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html#update AvailabilitySet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function availabilitySetTimeoutsToTerraform(struct?: AvailabilitySetTimeoutsOutputReference | AvailabilitySetTimeouts): any;
/**
 * @stability stable
 */
export declare class AvailabilitySetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AvailabilitySetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AvailabilitySetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html azurerm_availability_set}.
 *
 * @stability stable
 */
export declare class AvailabilitySet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/availability_set.html azurerm_availability_set} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AvailabilitySetConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managed?;
    /**
     * @stability stable
     */
    get managed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set managed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManaged(): void;
    /**
     * @stability stable
     */
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _platformFaultDomainCount?;
    /**
     * @stability stable
     */
    get platformFaultDomainCount(): number;
    /**
     * @stability stable
     */
    set platformFaultDomainCount(value: number);
    /**
     * @stability stable
     */
    resetPlatformFaultDomainCount(): void;
    /**
     * @stability stable
     */
    get platformFaultDomainCountInput(): number | undefined;
    private _platformUpdateDomainCount?;
    /**
     * @stability stable
     */
    get platformUpdateDomainCount(): number;
    /**
     * @stability stable
     */
    set platformUpdateDomainCount(value: number);
    /**
     * @stability stable
     */
    resetPlatformUpdateDomainCount(): void;
    /**
     * @stability stable
     */
    get platformUpdateDomainCountInput(): number | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AvailabilitySetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AvailabilitySetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AvailabilitySetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
