# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApplianceFirewallFirewalledServicesArgs', 'ApplianceFirewallFirewalledServices']

@pulumi.input_type
class ApplianceFirewallFirewalledServicesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 service: pulumi.Input[str],
                 access: Optional[pulumi.Input[str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ApplianceFirewallFirewalledServices resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] service: Appliance service name
        :param pulumi.Input[str] access: A string indicating the rule for which IPs are allowed to use the specified service
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_ips: An array of allowed IPs that can access the service
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "service", service)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        Appliance service name
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        A string indicating the rule for which IPs are allowed to use the specified service
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of allowed IPs that can access the service
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_ips", value)


@pulumi.input_type
class _ApplianceFirewallFirewalledServicesState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplianceFirewallFirewalledServices resources.
        :param pulumi.Input[str] access: A string indicating the rule for which IPs are allowed to use the specified service
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_ips: An array of allowed IPs that can access the service
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] service: Appliance service name
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allowed_ips is not None:
            pulumi.set(__self__, "allowed_ips", allowed_ips)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        A string indicating the rule for which IPs are allowed to use the specified service
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of allowed IPs that can access the service
        """
        return pulumi.get(self, "allowed_ips")

    @allowed_ips.setter
    def allowed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_ips", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Appliance service name
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


class ApplianceFirewallFirewalledServices(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceFirewallFirewalledServices("example",
            access="restricted",
            allowed_ips=["123.123.123.1"],
            network_id="string",
            service="string")
        pulumi.export("merakiNetworksApplianceFirewallFirewalledServicesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceFirewallFirewalledServices:ApplianceFirewallFirewalledServices example "network_id,service"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: A string indicating the rule for which IPs are allowed to use the specified service
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_ips: An array of allowed IPs that can access the service
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] service: Appliance service name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceFirewallFirewalledServicesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ApplianceFirewallFirewalledServices("example",
            access="restricted",
            allowed_ips=["123.123.123.1"],
            network_id="string",
            service="string")
        pulumi.export("merakiNetworksApplianceFirewallFirewalledServicesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceFirewallFirewalledServices:ApplianceFirewallFirewalledServices example "network_id,service"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceFirewallFirewalledServicesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceFirewallFirewalledServicesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceFirewallFirewalledServicesArgs.__new__(ApplianceFirewallFirewalledServicesArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["allowed_ips"] = allowed_ips
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
        super(ApplianceFirewallFirewalledServices, __self__).__init__(
            'meraki:networks/applianceFirewallFirewalledServices:ApplianceFirewallFirewalledServices',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            allowed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None) -> 'ApplianceFirewallFirewalledServices':
        """
        Get an existing ApplianceFirewallFirewalledServices resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: A string indicating the rule for which IPs are allowed to use the specified service
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_ips: An array of allowed IPs that can access the service
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] service: Appliance service name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceFirewallFirewalledServicesState.__new__(_ApplianceFirewallFirewalledServicesState)

        __props__.__dict__["access"] = access
        __props__.__dict__["allowed_ips"] = allowed_ips
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["service"] = service
        return ApplianceFirewallFirewalledServices(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[str]:
        """
        A string indicating the rule for which IPs are allowed to use the specified service
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="allowedIps")
    def allowed_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of allowed IPs that can access the service
        """
        return pulumi.get(self, "allowed_ips")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        Appliance service name
        """
        return pulumi.get(self, "service")

