# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClientsResult',
    'AwaitableGetClientsResult',
    'get_clients',
    'get_clients_output',
]

@pulumi.output_type
class GetClientsResult:
    """
    A collection of values returned by getClients.
    """
    def __init__(__self__, client_id=None, id=None, item=None, network_id=None):
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        clientId path parameter. Client ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetClientsItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")


class AwaitableGetClientsResult(GetClientsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientsResult(
            client_id=self.client_id,
            id=self.id,
            item=self.item,
            network_id=self.network_id)


def get_clients(client_id: Optional[str] = None,
                network_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_clients(client_id="string",
        network_id="string")
    pulumi.export("merakiNetworksClientsExample", example.item)
    ```


    :param str client_id: clientId path parameter. Client ID
    :param str network_id: networkId path parameter. Network ID
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['networkId'] = network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:networks/getClients:getClients', __args__, opts=opts, typ=GetClientsResult).value

    return AwaitableGetClientsResult(
        client_id=pulumi.get(__ret__, 'client_id'),
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        network_id=pulumi.get(__ret__, 'network_id'))
def get_clients_output(client_id: Optional[pulumi.Input[str]] = None,
                       network_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClientsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_clients(client_id="string",
        network_id="string")
    pulumi.export("merakiNetworksClientsExample", example.item)
    ```


    :param str client_id: clientId path parameter. Client ID
    :param str network_id: networkId path parameter. Network ID
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['networkId'] = network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:networks/getClients:getClients', __args__, opts=opts, typ=GetClientsResult)
    return __ret__.apply(lambda __response__: GetClientsResult(
        client_id=pulumi.get(__response__, 'client_id'),
        id=pulumi.get(__response__, 'id'),
        item=pulumi.get(__response__, 'item'),
        network_id=pulumi.get(__response__, 'network_id')))
