# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDevicesStatusesOverviewResult',
    'AwaitableGetDevicesStatusesOverviewResult',
    'get_devices_statuses_overview',
    'get_devices_statuses_overview_output',
]

@pulumi.output_type
class GetDevicesStatusesOverviewResult:
    """
    A collection of values returned by getDevicesStatusesOverview.
    """
    def __init__(__self__, id=None, item=None, network_ids=None, organization_id=None, product_types=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if network_ids and not isinstance(network_ids, list):
            raise TypeError("Expected argument 'network_ids' to be a list")
        pulumi.set(__self__, "network_ids", network_ids)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if product_types and not isinstance(product_types, list):
            raise TypeError("Expected argument 'product_types' to be a list")
        pulumi.set(__self__, "product_types", product_types)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetDevicesStatusesOverviewItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> Optional[Sequence[str]]:
        """
        networkIds query parameter. An optional parameter to filter device statuses by network.
        """
        return pulumi.get(self, "network_ids")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[Sequence[str]]:
        """
        productTypes query parameter. An optional parameter to filter device statuses by product type. Valid types are wireless, appliance, switch, systemsManager, camera, cellularGateway, and sensor.
        """
        return pulumi.get(self, "product_types")


class AwaitableGetDevicesStatusesOverviewResult(GetDevicesStatusesOverviewResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDevicesStatusesOverviewResult(
            id=self.id,
            item=self.item,
            network_ids=self.network_ids,
            organization_id=self.organization_id,
            product_types=self.product_types)


def get_devices_statuses_overview(network_ids: Optional[Sequence[str]] = None,
                                  organization_id: Optional[str] = None,
                                  product_types: Optional[Sequence[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDevicesStatusesOverviewResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_devices_statuses_overview(network_ids=["string"],
        organization_id="string",
        product_types=["string"])
    pulumi.export("merakiOrganizationsDevicesStatusesOverviewExample", example.item)
    ```


    :param Sequence[str] network_ids: networkIds query parameter. An optional parameter to filter device statuses by network.
    :param str organization_id: organizationId path parameter. Organization ID
    :param Sequence[str] product_types: productTypes query parameter. An optional parameter to filter device statuses by product type. Valid types are wireless, appliance, switch, systemsManager, camera, cellularGateway, and sensor.
    """
    __args__ = dict()
    __args__['networkIds'] = network_ids
    __args__['organizationId'] = organization_id
    __args__['productTypes'] = product_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getDevicesStatusesOverview:getDevicesStatusesOverview', __args__, opts=opts, typ=GetDevicesStatusesOverviewResult).value

    return AwaitableGetDevicesStatusesOverviewResult(
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        network_ids=pulumi.get(__ret__, 'network_ids'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        product_types=pulumi.get(__ret__, 'product_types'))
def get_devices_statuses_overview_output(network_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                         organization_id: Optional[pulumi.Input[str]] = None,
                                         product_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDevicesStatusesOverviewResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_devices_statuses_overview(network_ids=["string"],
        organization_id="string",
        product_types=["string"])
    pulumi.export("merakiOrganizationsDevicesStatusesOverviewExample", example.item)
    ```


    :param Sequence[str] network_ids: networkIds query parameter. An optional parameter to filter device statuses by network.
    :param str organization_id: organizationId path parameter. Organization ID
    :param Sequence[str] product_types: productTypes query parameter. An optional parameter to filter device statuses by product type. Valid types are wireless, appliance, switch, systemsManager, camera, cellularGateway, and sensor.
    """
    __args__ = dict()
    __args__['networkIds'] = network_ids
    __args__['organizationId'] = organization_id
    __args__['productTypes'] = product_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:organizations/getDevicesStatusesOverview:getDevicesStatusesOverview', __args__, opts=opts, typ=GetDevicesStatusesOverviewResult)
    return __ret__.apply(lambda __response__: GetDevicesStatusesOverviewResult(
        id=pulumi.get(__response__, 'id'),
        item=pulumi.get(__response__, 'item'),
        network_ids=pulumi.get(__response__, 'network_ids'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        product_types=pulumi.get(__response__, 'product_types')))
