import * as lambda from '@aws-cdk/aws-lambda';
/**
 * Options for Parcel bundling
 */
export interface ParcelOptions {
    /**
     * Entry file
     */
    readonly entry: string;
    /**
     * Expose modules as UMD under this name
     */
    readonly global: string;
    /**
     * Minify
     */
    readonly minify?: boolean;
    /**
     * Include source maps
     */
    readonly sourceMaps?: boolean;
    /**
     * The cache directory
     */
    readonly cacheDir?: string;
    /**
     * The node version to use as target for Babel
     */
    readonly nodeVersion: string;
    /**
     * The docker tag of the node base image to use in the parcel-bundler docker image
     *
     * @see https://hub.docker.com/_/node/?tab=tags
     */
    readonly nodeDockerTag: string;
    /**
     * The root of the project. This will be used as the source for the volume
     * mounted in the Docker container.
     */
    readonly projectRoot: string;
    /**
     * The environment variables to pass to the container running Parcel.
     *
     * @default - no environment variables are passed to the container
     */
    readonly environment?: {
        [key: string]: string;
    };
}
/**
 * Parcel code
 */
export declare class Bundling {
    static parcel(options: ParcelOptions): lambda.AssetCode;
}
