from jsonrpc2_base.client import Client
from metal_cloud_sdk.objects.utils.deserializer import Deserializer
from metal_cloud_sdk.objects.utils.serializer import Serializer
from jsonrpc2_base.jsonrpc_exception import JSONRPCException

class Developer(Client):
	__instance = None

	def __init__(self, dictParams, arrFilterPlugins = []):
		super(Developer, self).__init__(dictParams, arrFilterPlugins)

	@staticmethod
	def getInstance(dictParams, arrFilterPlugins = []):
		"""
		This is a static function for using the Developer class as a singleton.
		In order to work with only an instance, instead of instantiating the class,
		call this method.

		@return object Developer.__instance. It will return the same instance, no matter
		how many times this function is called.
		"""
		if Developer.__instance is None :
			Developer.__instance = Developer(dictParams, arrFilterPlugins)

		return Developer.__instance


	""" 838 functions available on endpoint. """

	def storage_pool_create(self, objStoragePoo):

		objStoragePool = Serializer.serialize(objStoragePool)

		arrParams = [
			objStoragePool,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_create", arrParams))

	def storage_pool_get(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_get", arrParams))

	def network_create(self, strInfrastructureID, objNetwor):

		objNetwork = Serializer.serialize(objNetwork)

		arrParams = [
			strInfrastructureID,
			objNetwork,
		]

		return Deserializer.deserialize(self.rpc("network_create", arrParams))

	def network_edit(self, strNetworkID, objNetworkOperatio):

		objNetworkOperation = Serializer.serialize(objNetworkOperation)

		arrParams = [
			strNetworkID,
			objNetworkOperation,
		]

		return Deserializer.deserialize(self.rpc("network_edit", arrParams))

	def network_get(self, strNetworkI):

		arrParams = [
			strNetworkID,
		]

		return Deserializer.deserialize(self.rpc("network_get", arrParams))

	def network_delete(self, strNetworkI):

		arrParams = [
			strNetworkID,
		]

		return Deserializer.deserialize(self.rpc("network_delete", arrParams))

	def subnet_get(self, strSubnetI):

		arrParams = [
			strSubnetID,
		]

		return Deserializer.deserialize(self.rpc("subnet_get", arrParams))

	def subnet_create(self, strNetworkID, objSubne):

		objSubnet = Serializer.serialize(objSubnet)

		arrParams = [
			strNetworkID,
			objSubnet,
		]

		return Deserializer.deserialize(self.rpc("subnet_create", arrParams))

	def subnet_delete(self, strSubnetI):

		arrParams = [
			strSubnetID,
		]

		return Deserializer.deserialize(self.rpc("subnet_delete", arrParams))

	def dhcp_lease_get(self, strMACAddress, nServerID = Non):

		arrParams = [
			strMACAddress,
			nServerID,
		]

		return self.rpc("dhcp_lease_get", arrParams)


	def dhcp_lease_create(self, strMACAddress, strSwitchHostname = None, nExpiryMinutes = 60, strDatacenterName = None, nServerID = Non):

		arrParams = [
			strMACAddress,
			strSwitchHostname,
			nExpiryMinutes,
			strDatacenterName,
			nServerID,
		]

		return self.rpc("dhcp_lease_create", arrParams)


	def instance_get(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return Deserializer.deserialize(self.rpc("instance_get", arrParams))

	def instance_edit(self, strInstanceID, objInstanceOperatio):

		objInstanceOperation = Serializer.serialize(objInstanceOperation)

		arrParams = [
			strInstanceID,
			objInstanceOperation,
		]

		return Deserializer.deserialize(self.rpc("instance_edit", arrParams))

	def instance_delete(self, strInstanceID, bKeepDetachingDrive):

		arrParams = [
			strInstanceID,
			bKeepDetachingDrives,
		]

		return Deserializer.deserialize(self.rpc("instance_delete", arrParams))

	def instance_interface_get(self, nInstanceInterfaceI):

		arrParams = [
			nInstanceInterfaceID,
		]

		return Deserializer.deserialize(self.rpc("instance_interface_get", arrParams))

	def server_with_uuid_get(self, strUUI):

		arrParams = [
			strUUID,
		]

		return self.rpc("server_with_uuid_get", arrParams)


	def server_edit(self, nServerID, objServer, strServerEditType = "complete):

		objServer = Serializer.serialize(objServer)

		arrParams = [
			nServerID,
			objServer,
			strServerEditType,
		]

		return self.rpc("server_edit", arrParams)


	def server_delete(self, nServerID, bSkipIPMI = Fals):

		arrParams = [
			nServerID,
			bSkipIPMI,
		]

		self.rpc("server_delete", arrParams)


	def server_power_set(self, nServerID, strPowerComman):

		arrParams = [
			nServerID,
			strPowerCommand,
		]

		self.rpc("server_power_set", arrParams)


	def server_power_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_power_get", arrParams)


	def server_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return Deserializer.deserialize(self.rpc("server_get", arrParams))

	def user_get(self, strUserI):

		arrParams = [
			strUserID,
		]

		return Deserializer.deserialize(self.rpc("user_get", arrParams))

	def user_authenticate_password(self, strLoginEmail, strPassword, strOneTimePassword = None, bRememberLogin = True, bTestCredentials = False, bRenewKerberosTicket = Fals):

		arrParams = [
			strLoginEmail,
			strPassword,
			strOneTimePassword,
			bRememberLogin,
			bTestCredentials,
			bRenewKerberosTicket,
		]

		return self.rpc("user_authenticate_password", arrParams)


	def user_email_to_user_id(self, strLoginEmai):

		arrParams = [
			strLoginEmail,
		]

		return self.rpc("user_email_to_user_id", arrParams)


	def infrastructure_get(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_get", arrParams))

	def infrastructure_create(self, strUserID, objInfrastructure, strInfrastructureIDAsTemplate = Non):

		objInfrastructure = Serializer.serialize(objInfrastructure)

		arrParams = [
			strUserID,
			objInfrastructure,
			strInfrastructureIDAsTemplate,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_create", arrParams))

	def user_password_change_required_set(self, strUserID, bPasswordChangeRequire):

		arrParams = [
			strUserID,
			bPasswordChangeRequired,
		]

		return self.rpc("user_password_change_required_set", arrParams)


	def infrastructure_users(self, strInfrastructureID, arrUserIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrUserIDs,
		]

		objUser = self.rpc("infrastructure_users", arrParams)
		for strKeyUser in objUser:
			objUser[strKeyUser] = Deserializer.deserialize(objUser[strKeyUser])
		return objUser

	def networks(self, strInfrastructureID, arrNetworkIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrNetworkIDs,
		]

		objNetwork = self.rpc("networks", arrParams)
		for strKeyNetwork in objNetwork:
			objNetwork[strKeyNetwork] = Deserializer.deserialize(objNetwork[strKeyNetwork])
		return objNetwork

	def instance_server_power_get(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return self.rpc("instance_server_power_get", arrParams)


	def instance_server_power_set(self, strInstanceID, strPowerComman):

		arrParams = [
			strInstanceID,
			strPowerCommand,
		]

		self.rpc("instance_server_power_set", arrParams)


	def drive_get(self, strDriveI):

		arrParams = [
			strDriveID,
		]

		return Deserializer.deserialize(self.rpc("drive_get", arrParams))

	def drive_edit(self, strDriveID, objDriveOperatio):

		objDriveOperation = Serializer.serialize(objDriveOperation)

		arrParams = [
			strDriveID,
			objDriveOperation,
		]

		return Deserializer.deserialize(self.rpc("drive_edit", arrParams))

	def drive_delete(self, strDriveI):

		arrParams = [
			strDriveID,
		]

		return Deserializer.deserialize(self.rpc("drive_delete", arrParams))

	def instance_drives(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		objDrive = self.rpc("instance_drives", arrParams)
		for strKeyDrive in objDrive:
			objDrive[strKeyDrive] = Deserializer.deserialize(objDrive[strKeyDrive])
		return objDrive

	def volume_template_delete(self, nVolumeTemplateI):

		arrParams = [
			nVolumeTemplateID,
		]

		self.rpc("volume_template_delete", arrParams)


	def drive_snapshot_create(self, strDriveI):

		arrParams = [
			strDriveID,
		]

		return Deserializer.deserialize(self.rpc("drive_snapshot_create", arrParams))

	def drive_snapshot_rollback(self, strSnapshotI):

		arrParams = [
			strSnapshotID,
		]

		self.rpc("drive_snapshot_rollback", arrParams)


	def drive_snapshots(self, strDriveID, arrSnapshotIDs = Non):

		arrParams = [
			strDriveID,
			arrSnapshotIDs,
		]

		objSnapshot = self.rpc("drive_snapshots", arrParams)
		for strKeySnapshot in objSnapshot:
			objSnapshot[strKeySnapshot] = Deserializer.deserialize(objSnapshot[strKeySnapshot])
		return objSnapshot

	def infrastructure_user_add(self, strInfrastructureID, strUserEmail, objInfrastructurePermissions = None, bCreateUserIfNotExists = Fals):

		objInfrastructurePermissions = Serializer.serialize(objInfrastructurePermissions)

		arrParams = [
			strInfrastructureID,
			strUserEmail,
			objInfrastructurePermissions,
			bCreateUserIfNotExists,
		]

		self.rpc("infrastructure_user_add", arrParams)


	def user_ssh_key_create(self, strUserID, strSSHKe):

		arrParams = [
			strUserID,
			strSSHKey,
		]

		return Deserializer.deserialize(self.rpc("user_ssh_key_create", arrParams))

	def user_ssh_key_delete(self, nSSHKeyI):

		arrParams = [
			nSSHKeyID,
		]

		self.rpc("user_ssh_key_delete", arrParams)


	def volume_templates_public(self, arrVolumeTemplateIDs = Non):

		arrParams = [
			arrVolumeTemplateIDs,
		]

		objVolumeTemplate = self.rpc("volume_templates_public", arrParams)
		for strKeyVolumeTemplate in objVolumeTemplate:
			objVolumeTemplate[strKeyVolumeTemplate] = Deserializer.deserialize(objVolumeTemplate[strKeyVolumeTemplate])
		return objVolumeTemplate

	def user_blocked_update(self, nUserID, bBlocke):

		arrParams = [
			nUserID,
			bBlocked,
		]

		return self.rpc("user_blocked_update", arrParams)


	def user_api_key_regenerate(self, strUserI):

		arrParams = [
			strUserID,
		]

		self.rpc("user_api_key_regenerate", arrParams)


	def user_ssh_keys(self, strUserI):

		arrParams = [
			strUserID,
		]

		arrSSHKeys = self.rpc("user_ssh_keys", arrParams)
		for index in range(len(arrSSHKeys)):
			arrSSHKeys[index] = Deserializer.deserialize(arrSSHKeys[index])
		return arrSSHKeys

	def user_password_recovery(self, strLoginEmail, strRedirectURL = None, strAESKey = Non):

		arrParams = [
			strLoginEmail,
			strRedirectURL,
			strAESKey,
		]

		self.rpc("user_password_recovery", arrParams)


	def user_authenticate_password_encrypted(self, strLoginEmail, strAESCipherPassword, strRSACipherAESKey, strOneTimePassword = None, bRememberLogin = True, bTestCredentials = False, bRenewKerberosTicket = Fals):

		arrParams = [
			strLoginEmail,
			strAESCipherPassword,
			strRSACipherAESKey,
			strOneTimePassword,
			bRememberLogin,
			bTestCredentials,
			bRenewKerberosTicket,
		]

		return self.rpc("user_authenticate_password_encrypted", arrParams)


	def user_update_email(self, strUserID, strNewLoginEmail, strRedirectURL = None, strAESKey = Non):

		arrParams = [
			strUserID,
			strNewLoginEmail,
			strRedirectURL,
			strAESKey,
		]

		return self.rpc("user_update_email", arrParams)


	def infrastructure_operation_cancel(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		self.rpc("infrastructure_operation_cancel", arrParams)


	def instance_array_create(self, strInfrastructureID, objInstanceArra):

		objInstanceArray = Serializer.serialize(objInstanceArray)

		arrParams = [
			strInfrastructureID,
			objInstanceArray,
		]

		return Deserializer.deserialize(self.rpc("instance_array_create", arrParams))

	def instance_array_get(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_get", arrParams))

	def instance_array_edit(self, strInstanceArrayID, objInstanceArrayOperation, bSwapExistingInstancesHardware = False, bKeepDetachingDrives = None, objServerTypeMatches = None, arrInstanceIDsPreferredForDelete = Non):

		objInstanceArrayOperation = Serializer.serialize(objInstanceArrayOperation)
		objServerTypeMatches = Serializer.serialize(objServerTypeMatches)

		arrParams = [
			strInstanceArrayID,
			objInstanceArrayOperation,
			bSwapExistingInstancesHardware,
			bKeepDetachingDrives,
			objServerTypeMatches,
			arrInstanceIDsPreferredForDelete,
		]

		return Deserializer.deserialize(self.rpc("instance_array_edit", arrParams))

	def instance_array_delete(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_delete", arrParams))

	def instance_arrays(self, strInfrastructureID, arrInstanceArrayIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrInstanceArrayIDs,
		]

		objInstanceArray = self.rpc("instance_arrays", arrParams)
		for strKeyInstanceArray in objInstanceArray:
			objInstanceArray[strKeyInstanceArray] = Deserializer.deserialize(objInstanceArray[strKeyInstanceArray])
		return objInstanceArray

	def instance_array_instances(self, strInstanceArrayID, arrInstanceIDs = Non):

		arrParams = [
			strInstanceArrayID,
			arrInstanceIDs,
		]

		objInstance = self.rpc("instance_array_instances", arrParams)
		for strKeyInstance in objInstance:
			objInstance[strKeyInstance] = Deserializer.deserialize(objInstance[strKeyInstance])
		return objInstance

	def infrastructures(self, strUserID, arrInfrastructureIDs = Non):

		arrParams = [
			strUserID,
			arrInfrastructureIDs,
		]

		objInfrastructure = self.rpc("infrastructures", arrParams)
		for strKeyInfrastructure in objInfrastructure:
			objInfrastructure[strKeyInfrastructure] = Deserializer.deserialize(objInfrastructure[strKeyInfrastructure])
		return objInfrastructure

	def infrastructure_user_remove(self, strInfrastructureID, strUserI):

		arrParams = [
			strInfrastructureID,
			strUserID,
		]

		return self.rpc("infrastructure_user_remove", arrParams)


	def user_create_retry_mail(self, strLoginEmail, strRedirectURL = None, strAESKey = Non):

		arrParams = [
			strLoginEmail,
			strRedirectURL,
			strAESKey,
		]

		self.rpc("user_create_retry_mail", arrParams)


	def transport_request_public_key(self, bGenerateNewIfNotFound = Tru):

		arrParams = [
			bGenerateNewIfNotFound,
		]

		return self.rpc("transport_request_public_key", arrParams)


	def afc_get(self, nAFCI):

		arrParams = [
			nAFCID,
		]

		return self.rpc("afc_get", arrParams)


	def afc_make_call(self, nAFCID, bIgnoreMaxRetry = Fals):

		arrParams = [
			nAFCID,
			bIgnoreMaxRetry,
		]

		return self.rpc("afc_make_call", arrParams)


	def afc_delete(self, nAFCI):

		arrParams = [
			nAFCID,
		]

		self.rpc("afc_delete", arrParams)


	def afc_counters(self, objAFCCountersFilter = Non):

		objAFCCountersFilter = Serializer.serialize(objAFCCountersFilter)

		arrParams = [
			objAFCCountersFilter,
		]

		return self.rpc("afc_counters", arrParams)


	def subnets(self, strNetworkID, arrSubnetIDs = Non):

		arrParams = [
			strNetworkID,
			arrSubnetIDs,
		]

		objSubnet = self.rpc("subnets", arrParams)
		for strKeySubnet in objSubnet:
			objSubnet[strKeySubnet] = Deserializer.deserialize(objSubnet[strKeySubnet])
		return objSubnet

	def user_change_password_encrypted(self, strUserID, strAESCipherPassword, strRSACipherAESKey, strOldPassword = Non):

		arrParams = [
			strUserID,
			strAESCipherPassword,
			strRSACipherAESKey,
			strOldPassword,
		]

		self.rpc("user_change_password_encrypted", arrParams)


	def instance_array_interface_get(self, nInstanceArrayInterfaceI):

		arrParams = [
			nInstanceArrayInterfaceID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_interface_get", arrParams))

	def instance_interface_ips(self, nInstanceInterfaceI):

		arrParams = [
			nInstanceInterfaceID,
		]

		return self.rpc("instance_interface_ips", arrParams)


	def infrastructure_user_update(self, strInfrastructureID, strUserEmail, objInfrastructurePermission):

		objInfrastructurePermissions = Serializer.serialize(objInfrastructurePermissions)

		arrParams = [
			strInfrastructureID,
			strUserEmail,
			objInfrastructurePermissions,
		]

		self.rpc("infrastructure_user_update", arrParams)


	def infrastructure_user_ssh_keys(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return self.rpc("infrastructure_user_ssh_keys", arrParams)


	def user_delegate_add(self, strUserID, strDelegateUserEmail, bCreateUserIfNotExists = Fals):

		arrParams = [
			strUserID,
			strDelegateUserEmail,
			bCreateUserIfNotExists,
		]

		self.rpc("user_delegate_add", arrParams)


	def user_delegate_remove(self, strUserID, strDelegateUserEmai):

		arrParams = [
			strUserID,
			strDelegateUserEmail,
		]

		self.rpc("user_delegate_remove", arrParams)


	def user_delegate_children(self, strUserI):

		arrParams = [
			strUserID,
		]

		objUser = self.rpc("user_delegate_children", arrParams)
		for strKeyUser in objUser:
			objUser[strKeyUser] = Deserializer.deserialize(objUser[strKeyUser])
		return objUser

	def event_counters(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return self.rpc("event_counters", arrParams)


	def event_counters_developer(self):

		arrParams = [
		]

		return self.rpc("event_counters_developer", arrParams)


	def events_delete(self, strInfrastructureID, arrEventID):

		arrParams = [
			strInfrastructureID,
			arrEventIDs,
		]

		self.rpc("events_delete", arrParams)


	def event_delete(self, nEventI):

		arrParams = [
			nEventID,
		]

		self.rpc("event_delete", arrParams)


	def instance_array_stop(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_stop", arrParams))

	def user_create(self, strDisplayName, strLoginEmail, strRedirectURL = None, strAESKey = Non):

		arrParams = [
			strDisplayName,
			strLoginEmail,
			strRedirectURL,
			strAESKey,
		]

		return Deserializer.deserialize(self.rpc("user_create", arrParams))

	def instance_array_start(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_start", arrParams))

	def volume_templates(self, strUserID, arrVolumeTemplateIDs = Non):

		arrParams = [
			strUserID,
			arrVolumeTemplateIDs,
		]

		objVolumeTemplate = self.rpc("volume_templates", arrParams)
		for strKeyVolumeTemplate in objVolumeTemplate:
			objVolumeTemplate[strKeyVolumeTemplate] = Deserializer.deserialize(objVolumeTemplate[strKeyVolumeTemplate])
		return objVolumeTemplate

	def throw_error(self, nErrorCod):

		arrParams = [
			nErrorCode,
		]

		self.rpc("throw_error", arrParams)


	def network_stop(self, strNetworkI):

		arrParams = [
			strNetworkID,
		]

		return Deserializer.deserialize(self.rpc("network_stop", arrParams))

	def network_start(self, strNetworkI):

		arrParams = [
			strNetworkID,
		]

		return Deserializer.deserialize(self.rpc("network_start", arrParams))

	def instance_array_interface_attach_network(self, strInstanceArrayID, nInstanceArrayInterfaceIndex, strNetworkI):

		arrParams = [
			strInstanceArrayID,
			nInstanceArrayInterfaceIndex,
			strNetworkID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_interface_attach_network", arrParams))

	def afc_error_codes_not_documented(self):

		arrParams = [
		]

		return self.rpc("afc_error_codes_not_documented", arrParams)


	def afc_error_codes_never_fired(self):

		arrParams = [
		]

		return self.rpc("afc_error_codes_never_fired", arrParams)


	def afc_error_codes_code_comments(self):

		arrParams = [
		]

		return self.rpc("afc_error_codes_code_comments", arrParams)


	def resource_utilization_summary(self, strUserIDOwner, strStartTimestamp, strEndTimestamp, arrInfrastructureIDs = Non):

		arrParams = [
			strUserIDOwner,
			strStartTimestamp,
			strEndTimestamp,
			arrInfrastructureIDs,
		]

		return self.rpc("resource_utilization_summary", arrParams)


	def servers(self, strInfrastructureID, arrServerIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrServerIDs,
		]

		arrServers = self.rpc("servers", arrParams)
		for index in range(len(arrServers)):
			arrServers[index] = Deserializer.deserialize(arrServers[index])
		return arrServers

	def query_parse(self, strSQ):

		arrParams = [
			strSQL,
		]

		return self.rpc("query_parse", arrParams)


	def afc_retry_call(self, nAFCID, bIgnoreMaxRetry = False, pdo = Non):

		pdo = Serializer.serialize(pdo)

		arrParams = [
			nAFCID,
			bIgnoreMaxRetry,
			pdo,
		]

		return self.rpc("afc_retry_call", arrParams)


	def server_match_hardware_configuration(self, nUserID, strDatacenterName, objHardwareTarget, arrMustKeepServerIDs = [], arrAlreadyAllocatedServerIDs = [], arrIgnoreServerIDs = [], nMaximumResults = ):

		objHardwareTarget = Serializer.serialize(objHardwareTarget)

		arrParams = [
			nUserID,
			strDatacenterName,
			objHardwareTarget,
			arrMustKeepServerIDs,
			arrAlreadyAllocatedServerIDs,
			arrIgnoreServerIDs,
			nMaximumResults,
		]

		return self.rpc("server_match_hardware_configuration", arrParams)


	def server_identify(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_identify", arrParams)


	def server_reregister(self, nServerID, bSkipIPMI = False, bUseBDKAgent = Fals):

		arrParams = [
			nServerID,
			bSkipIPMI,
			bUseBDKAgent,
		]

		self.rpc("server_reregister", arrParams)


	def resource_reservation_cancel(self, strProductName, nResourceReservationID, strCancelTimestamp = Non):

		arrParams = [
			strProductName,
			nResourceReservationID,
			strCancelTimestamp,
		]

		self.rpc("resource_reservation_cancel", arrParams)


	def user_billable_set(self, nUserID, bBillabl):

		arrParams = [
			nUserID,
			bBillable,
		]

		return self.rpc("user_billable_set", arrParams)


	def dns_deploy(self, nInfrastructureID = Non):

		arrParams = [
			nInfrastructureID,
		]

		self.rpc("dns_deploy", arrParams)


	def instance_array_interface_detach(self, strInstanceArrayID, nInstanceArrayInterfaceInde):

		arrParams = [
			strInstanceArrayID,
			nInstanceArrayInterfaceIndex,
		]

		return Deserializer.deserialize(self.rpc("instance_array_interface_detach", arrParams))

	def resource_utilization_summary_start_timestamp_default(self, strUserI):

		arrParams = [
			strUserID,
		]

		return self.rpc("resource_utilization_summary_start_timestamp_default", arrParams)


	def user_delegate_parents(self, strUserI):

		arrParams = [
			strUserID,
		]

		objUser = self.rpc("user_delegate_parents", arrParams)
		for strKeyUser in objUser:
			objUser[strKeyUser] = Deserializer.deserialize(objUser[strKeyUser])
		return objUser

	def server_types(self, strDatacenterName = None, bOnlyAvailable = Fals):

		arrParams = [
			strDatacenterName,
			bOnlyAvailable,
		]

		objServerType = self.rpc("server_types", arrParams)
		for strKeyServerType in objServerType:
			objServerType[strKeyServerType] = Deserializer.deserialize(objServerType[strKeyServerType])
		return objServerType

	def user_update_language(self, strUserID, strLanguag):

		arrParams = [
			strUserID,
			strLanguage,
		]

		return Deserializer.deserialize(self.rpc("user_update_language", arrParams))

	def server_type_matches(self, strInfrastructureID, objHardwareConfiguration, strInstanceArrayID = None, bAllowServerSwap = Fals):

		objHardwareConfiguration = Serializer.serialize(objHardwareConfiguration)

		arrParams = [
			strInfrastructureID,
			objHardwareConfiguration,
			strInstanceArrayID,
			bAllowServerSwap,
		]

		return self.rpc("server_type_matches", arrParams)


	def monitoring_instance_measurement_value_get(self, nInstanceMeasurementI):

		arrParams = [
			nInstanceMeasurementID,
		]

		return self.rpc("monitoring_instance_measurement_value_get", arrParams)


	def drive_array_create(self, strInfrastructureID, objDriveArra):

		objDriveArray = Serializer.serialize(objDriveArray)

		arrParams = [
			strInfrastructureID,
			objDriveArray,
		]

		return Deserializer.deserialize(self.rpc("drive_array_create", arrParams))

	def drive_array_stop(self, strDriveArrayI):

		arrParams = [
			strDriveArrayID,
		]

		return Deserializer.deserialize(self.rpc("drive_array_stop", arrParams))

	def drive_array_start(self, strDriveArrayI):

		arrParams = [
			strDriveArrayID,
		]

		return Deserializer.deserialize(self.rpc("drive_array_start", arrParams))

	def drive_array_edit(self, strDriveArrayID, objDriveArrayOperation, objDriveArrayEditOptions = {"update_active_drives_size":False):

		objDriveArrayOperation = Serializer.serialize(objDriveArrayOperation)
		objDriveArrayEditOptions = Serializer.serialize(objDriveArrayEditOptions)

		arrParams = [
			strDriveArrayID,
			objDriveArrayOperation,
			objDriveArrayEditOptions,
		]

		return Deserializer.deserialize(self.rpc("drive_array_edit", arrParams))

	def drive_array_delete(self, strDriveArrayI):

		arrParams = [
			strDriveArrayID,
		]

		return Deserializer.deserialize(self.rpc("drive_array_delete", arrParams))

	def drive_array_drives(self, strDriveArrayID, arrDriveIDs = Non):

		arrParams = [
			strDriveArrayID,
			arrDriveIDs,
		]

		objDrive = self.rpc("drive_array_drives", arrParams)
		for strKeyDrive in objDrive:
			objDrive[strKeyDrive] = Deserializer.deserialize(objDrive[strKeyDrive])
		return objDrive

	def drive_snapshot_delete(self, strSnapshotI):

		arrParams = [
			strSnapshotID,
		]

		self.rpc("drive_snapshot_delete", arrParams)


	def resource_utilization_price_changes_apply(self, nUserID = Non):

		arrParams = [
			nUserID,
		]

		self.rpc("resource_utilization_price_changes_apply", arrParams)


	def drive_array_get(self, strDriveArrayI):

		arrParams = [
			strDriveArrayID,
		]

		return Deserializer.deserialize(self.rpc("drive_array_get", arrParams))

	def switch_device_get(self, mxNetworkEquipmentI):

		mxNetworkEquipmentID = Serializer.serialize(mxNetworkEquipmentID)

		arrParams = [
			mxNetworkEquipmentID,
		]

		return self.rpc("switch_device_get", arrParams)


	def switch_device_vpls_get(self, nNetworkID, nNetworkEquipmentI):

		arrParams = [
			nNetworkID,
			nNetworkEquipmentID,
		]

		return self.rpc("switch_device_vpls_get", arrParams)


	def monitoring_network_measurements_rendering_get(self, strNetworkID, strNetworkTrafficType, arrMeasurements, objRenderingOptions = [], bEncodeBase64 = Tru):

		objRenderingOptions = Serializer.serialize(objRenderingOptions)

		arrParams = [
			strNetworkID,
			strNetworkTrafficType,
			arrMeasurements,
			objRenderingOptions,
			bEncodeBase64,
		]

		return self.rpc("monitoring_network_measurements_rendering_get", arrParams)


	def resource_reservation_renew_recurring(self):

		arrParams = [
		]

		self.rpc("resource_reservation_renew_recurring", arrParams)


	def drive_arrays(self, strInfrastructureID, arrDriveArrayIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrDriveArrayIDs,
		]

		objDriveArray = self.rpc("drive_arrays", arrParams)
		for strKeyDriveArray in objDriveArray:
			objDriveArray[strKeyDriveArray] = Deserializer.deserialize(objDriveArray[strKeyDriveArray])
		return objDriveArray

	def user_sync_push_all_users_to_billing2(self):

		arrParams = [
		]

		self.rpc("user_sync_push_all_users_to_billing2", arrParams)


	def instance_array_gui_settings_save(self, strInstanceArrayID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strInstanceArrayID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("instance_array_gui_settings_save", arrParams)


	def drive_array_gui_settings_save(self, strDriveArrayID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strDriveArrayID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("drive_array_gui_settings_save", arrParams)


	def infrastructure_hang_until_touched(self, nInfrastructureID, strKnownValu):

		arrParams = [
			nInfrastructureID,
			strKnownValue,
		]

		return self.rpc("infrastructure_hang_until_touched", arrParams)


	def subnet_oob_get(self, nSubnetI):

		arrParams = [
			nSubnetID,
		]

		return Deserializer.deserialize(self.rpc("subnet_oob_get", arrParams))

	def infrastructure_deploy_shutdown_required(self, strInfrastructureID, strPowerCommand = "none", bOnlyPoweredOn = Tru):

		arrParams = [
			strInfrastructureID,
			strPowerCommand,
			bOnlyPoweredOn,
		]

		return self.rpc("infrastructure_deploy_shutdown_required", arrParams)


	def infrastructure_edit(self, strInfrastructureID, objInfrastructureOperatio):

		objInfrastructureOperation = Serializer.serialize(objInfrastructureOperation)

		arrParams = [
			strInfrastructureID,
			objInfrastructureOperation,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_edit", arrParams))

	def instance_server_power_set_batch(self, strInfrastructureID, arrInstanceIDs, strPowerComman):

		arrParams = [
			strInfrastructureID,
			arrInstanceIDs,
			strPowerCommand,
		]

		self.rpc("instance_server_power_set_batch", arrParams)


	def instance_server_power_get_batch(self, strInfrastructureID, arrInstanceID):

		arrParams = [
			strInfrastructureID,
			arrInstanceIDs,
		]

		return self.rpc("instance_server_power_get_batch", arrParams)


	def network_traffic_summary_get(self, nInfrastructureID, strStartTimestamp, strEndTimestam):

		arrParams = [
			nInfrastructureID,
			strStartTimestamp,
			strEndTimestamp,
		]

		return self.rpc("network_traffic_summary_get", arrParams)


	def subnet_pool_create(self, objSubnetPoo):

		objSubnetPool = Serializer.serialize(objSubnetPool)

		arrParams = [
			objSubnetPool,
		]

		return self.rpc("subnet_pool_create", arrParams)


	def switch_device_create(self, objNetworkEquipmentData, bAutoDescribe = Tru):

		objNetworkEquipmentData = Serializer.serialize(objNetworkEquipmentData)

		arrParams = [
			objNetworkEquipmentData,
			bAutoDescribe,
		]

		return self.rpc("switch_device_create", arrParams)


	def switch_devices(self, strDatacenter = None, strSwitchDeviceType = Non):

		arrParams = [
			strDatacenter,
			strSwitchDeviceType,
		]

		return self.rpc("switch_devices", arrParams)


	def switch_device_info(self, mxNetworkEquipmentI):

		mxNetworkEquipmentID = Serializer.serialize(mxNetworkEquipmentID)

		arrParams = [
			mxNetworkEquipmentID,
		]

		return self.rpc("switch_device_info", arrParams)


	def monitoring_instance_measurements_get_for_instance(self, strInstanceID, bIgnoreVirtualEthernetInterfaces = Fals):

		arrParams = [
			strInstanceID,
			bIgnoreVirtualEthernetInterfaces,
		]

		return self.rpc("monitoring_instance_measurements_get_for_instance", arrParams)


	def monitoring_instance_measurements_rendering_get(self, strInstanceID, arrMeasurements, objRenderingOptions = [], bEncodeBase64 = Tru):

		objRenderingOptions = Serializer.serialize(objRenderingOptions)

		arrParams = [
			strInstanceID,
			arrMeasurements,
			objRenderingOptions,
			bEncodeBase64,
		]

		return self.rpc("monitoring_instance_measurements_rendering_get", arrParams)


	def monitoring_instance_interface_measurements_rendering_get(self, nInstanceInterfaceID, arrMeasurements, objRenderingOptions = [], bEncodeBase64 = Tru):

		objRenderingOptions = Serializer.serialize(objRenderingOptions)

		arrParams = [
			nInstanceInterfaceID,
			arrMeasurements,
			objRenderingOptions,
			bEncodeBase64,
		]

		return self.rpc("monitoring_instance_interface_measurements_rendering_get", arrParams)


	def drive_attach_instance(self, strDriveID, strInstanceI):

		arrParams = [
			strDriveID,
			strInstanceID,
		]

		return Deserializer.deserialize(self.rpc("drive_attach_instance", arrParams))

	def drive_detach_instance(self, strDriveI):

		arrParams = [
			strDriveID,
		]

		return Deserializer.deserialize(self.rpc("drive_detach_instance", arrParams))

	def servers_instances_counters(self, arrDatacentersFilter = [):

		arrParams = [
			arrDatacentersFilter,
		]

		return self.rpc("servers_instances_counters", arrParams)


	def exceptions_sort_by_type(self, bShowAuthors = Fals):

		arrParams = [
			bShowAuthors,
		]

		return self.rpc("exceptions_sort_by_type", arrParams)


	def afc_delete_non_asynchronous_calls(self, arrAFCID):

		arrParams = [
			arrAFCIDs,
		]

		self.rpc("afc_delete_non_asynchronous_calls", arrParams)


	def afc_silence(self, nAFCI):

		arrParams = [
			nAFCID,
		]

		self.rpc("afc_silence", arrParams)


	def events_get_code(self, bShowAuthors = Fals):

		arrParams = [
			bShowAuthors,
		]

		return self.rpc("events_get_code", arrParams)


	def server_power_set_batch(self, arrServerIDs, strPowerComman):

		arrParams = [
			arrServerIDs,
			strPowerCommand,
		]

		self.rpc("server_power_set_batch", arrParams)


	def server_power_get_batch(self, arrServerID):

		arrParams = [
			arrServerIDs,
		]

		return self.rpc("server_power_get_batch", arrParams)


	def server_bdk_debug_toggle(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_bdk_debug_toggle", arrParams)


	def servers_get_by_status(self, strServerStatu):

		arrParams = [
			strServerStatus,
		]

		return self.rpc("servers_get_by_status", arrParams)


	def switch_device_network_allocate_primary_subnet(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("switch_device_network_allocate_primary_subnet", arrParams)


	def switch_device_create_auto(self, objNetworkEquipmentData, bAutoDescribe = Tru):

		objNetworkEquipmentData = Serializer.serialize(objNetworkEquipmentData)

		arrParams = [
			objNetworkEquipmentData,
			bAutoDescribe,
		]

		return self.rpc("switch_device_create_auto", arrParams)


	def cache_destroy(self):

		arrParams = [
		]

		self.rpc("cache_destroy", arrParams)


	def server_status_update(self, nServerID, strServerStatu):

		arrParams = [
			nServerID,
			strServerStatus,
		]

		return self.rpc("server_status_update", arrParams)


	def afc_max_retries_increase(self, arrAFCID):

		arrParams = [
			arrAFCIDs,
		]

		return self.rpc("afc_max_retries_increase", arrParams)


	def afc_silence_non_asynchronous_calls(self, arrAFCID):

		arrParams = [
			arrAFCIDs,
		]

		self.rpc("afc_silence_non_asynchronous_calls", arrParams)


	def server_type_create(self, objServerTypeParam):

		objServerTypeParams = Serializer.serialize(objServerTypeParams)

		arrParams = [
			objServerTypeParams,
		]

		return Deserializer.deserialize(self.rpc("server_type_create", arrParams))

	def server_type_clean_unused(self):

		arrParams = [
		]

		self.rpc("server_type_clean_unused", arrParams)


	def instance_info(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("instance_info", arrParams)


	def user_infrastructure_default_set(self, strUserID, strInfrastructureI):

		arrParams = [
			strUserID,
			strInfrastructureID,
		]

		return self.rpc("user_infrastructure_default_set", arrParams)


	def user_infrastructure_default_unset(self, strUserI):

		arrParams = [
			strUserID,
		]

		self.rpc("user_infrastructure_default_unset", arrParams)


	def instance_server_replace(self, nInstanceID, nNewServerID, strFaultyServerStatus = "defective):

		arrParams = [
			nInstanceID,
			nNewServerID,
			strFaultyServerStatus,
		]

		return self.rpc("instance_server_replace", arrParams)


	def infrastructure_deploy_options(self, strInfrastructureID, bReplaceServerTypes = Fals):

		arrParams = [
			strInfrastructureID,
			bReplaceServerTypes,
		]

		return self.rpc("infrastructure_deploy_options", arrParams)


	def infrastructure_delete(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_delete", arrParams))

	def cluster_create(self, strInfrastructureID, objCluste):

		objCluster = Serializer.serialize(objCluster)

		arrParams = [
			strInfrastructureID,
			objCluster,
		]

		return Deserializer.deserialize(self.rpc("cluster_create", arrParams))

	def cluster_get(self, strClusterID, bAccessSaaSAPI = True, nAccessSaaSAPITimeoutSeconds = 1):

		arrParams = [
			strClusterID,
			bAccessSaaSAPI,
			nAccessSaaSAPITimeoutSeconds,
		]

		return Deserializer.deserialize(self.rpc("cluster_get", arrParams))

	def cluster_edit(self, strClusterID, objClusterOperatio):

		objClusterOperation = Serializer.serialize(objClusterOperation)

		arrParams = [
			strClusterID,
			objClusterOperation,
		]

		return Deserializer.deserialize(self.rpc("cluster_edit", arrParams))

	def cluster_stop(self, strClusterI):

		arrParams = [
			strClusterID,
		]

		return Deserializer.deserialize(self.rpc("cluster_stop", arrParams))

	def cluster_start(self, strClusterI):

		arrParams = [
			strClusterID,
		]

		return Deserializer.deserialize(self.rpc("cluster_start", arrParams))

	def cluster_delete(self, strClusterI):

		arrParams = [
			strClusterID,
		]

		return Deserializer.deserialize(self.rpc("cluster_delete", arrParams))

	def clusters(self, strInfrastructureID, arrClusterIDs = None, bAccessSaaSAPI = False, nAccessSaaSAPITimeoutSeconds = 1):

		arrParams = [
			strInfrastructureID,
			arrClusterIDs,
			bAccessSaaSAPI,
			nAccessSaaSAPITimeoutSeconds,
		]

		objCluster = self.rpc("clusters", arrParams)
		for strKeyCluster in objCluster:
			objCluster[strKeyCluster] = Deserializer.deserialize(objCluster[strKeyCluster])
		return objCluster

	def cluster_gui_settings_save(self, strClusterID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strClusterID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("cluster_gui_settings_save", arrParams)


	def infrastructure_servers(self, nInfrastructureID, bChanges, bMainTabl):

		arrParams = [
			nInfrastructureID,
			bChanges,
			bMainTable,
		]

		return self.rpc("infrastructure_servers", arrParams)


	def resource_reservation_delete(self, strProductName, nResourceReservationI):

		arrParams = [
			strProductName,
			nResourceReservationID,
		]

		self.rpc("resource_reservation_delete", arrParams)


	def server_type_reservation_create(self, strUserID, objReservation, nQuantity = ):

		objReservation = Serializer.serialize(objReservation)

		arrParams = [
			strUserID,
			objReservation,
			nQuantity,
		]

		arrServerTypeReservations = self.rpc("server_type_reservation_create", arrParams)
		for index in range(len(arrServerTypeReservations)):
			arrServerTypeReservations[index] = Deserializer.deserialize(arrServerTypeReservations[index])
		return arrServerTypeReservations

	def server_type_reservation_get(self, nServerTypeReservationI):

		arrParams = [
			nServerTypeReservationID,
		]

		return Deserializer.deserialize(self.rpc("server_type_reservation_get", arrParams))

	def server_type_reservation_edit(self, nServerTypeReservationID, objServerTypeReservatio):

		objServerTypeReservation = Serializer.serialize(objServerTypeReservation)

		arrParams = [
			nServerTypeReservationID,
			objServerTypeReservation,
		]

		return Deserializer.deserialize(self.rpc("server_type_reservation_edit", arrParams))

	def server_type_reservation_cancel(self, nServerTypeReservationID, strCancelTimestam):

		arrParams = [
			nServerTypeReservationID,
			strCancelTimestamp,
		]

		self.rpc("server_type_reservation_cancel", arrParams)


	def user_server_type_reservations(self, strUserI):

		arrParams = [
			strUserID,
		]

		return self.rpc("user_server_type_reservations", arrParams)


	def server_type_prices(self, strDatacenter, strFranchise, nUserID = Non):

		arrParams = [
			strDatacenter,
			strFranchise,
			nUserID,
		]

		return self.rpc("server_type_prices", arrParams)


	def server_type_reservation_delete(self, nServerTypeReservationI):

		arrParams = [
			nServerTypeReservationID,
		]

		self.rpc("server_type_reservation_delete", arrParams)


	def server_type_reservation_delete_all(self):

		arrParams = [
		]

		self.rpc("server_type_reservation_delete_all", arrParams)


	def user_server_type_reservations_internal(self, nUserID, strUserPlanType = Non):

		arrParams = [
			nUserID,
			strUserPlanType,
		]

		return self.rpc("user_server_type_reservations_internal", arrParams)


	def server_type_reservation_create_internal(self, strUserID, objReservation, nQuantity = 1, nServerID = Non):

		objReservation = Serializer.serialize(objReservation)

		arrParams = [
			strUserID,
			objReservation,
			nQuantity,
			nServerID,
		]

		arrServerTypeReservations = self.rpc("server_type_reservation_create_internal", arrParams)
		for index in range(len(arrServerTypeReservations)):
			arrServerTypeReservations[index] = Deserializer.deserialize(arrServerTypeReservations[index])
		return arrServerTypeReservations

	def switch_device_simulator_initialize(self, nSwitchDeviceID = Non):

		arrParams = [
			nSwitchDeviceID,
		]

		self.rpc("switch_device_simulator_initialize", arrParams)


	def search(self, strUserID, strKeywords, arrTables = None, objTablesColumns = None, strCollapseType = "array_subrows", arrOrderBy = [], arrLimit = Non):

		objTablesColumns = Serializer.serialize(objTablesColumns)

		arrParams = [
			strUserID,
			strKeywords,
			arrTables,
			objTablesColumns,
			strCollapseType,
			arrOrderBy,
			arrLimit,
		]

		return self.rpc("search", arrParams)


	def shared_drive_create(self, strInfrastructureID, objSharedDriv):

		objSharedDrive = Serializer.serialize(objSharedDrive)

		arrParams = [
			strInfrastructureID,
			objSharedDrive,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_create", arrParams))

	def shared_drive_edit(self, strSharedDriveID, objSharedDriveOperatio):

		objSharedDriveOperation = Serializer.serialize(objSharedDriveOperation)

		arrParams = [
			strSharedDriveID,
			objSharedDriveOperation,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_edit", arrParams))

	def shared_drive_delete(self, strSharedDriveI):

		arrParams = [
			strSharedDriveID,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_delete", arrParams))

	def shared_drive_stop(self, strSharedDriveI):

		arrParams = [
			strSharedDriveID,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_stop", arrParams))

	def shared_drive_start(self, strSharedDriveI):

		arrParams = [
			strSharedDriveID,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_start", arrParams))

	def shared_drive_get(self, strSharedDriveI):

		arrParams = [
			strSharedDriveID,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_get", arrParams))

	def shared_drives(self, strInfrastructureID, arrSharedDriveIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrSharedDriveIDs,
		]

		objSharedDrive = self.rpc("shared_drives", arrParams)
		for strKeySharedDrive in objSharedDrive:
			objSharedDrive[strKeySharedDrive] = Deserializer.deserialize(objSharedDrive[strKeySharedDrive])
		return objSharedDrive

	def instance_array_shared_drives(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return self.rpc("instance_array_shared_drives", arrParams)


	def shared_drive_instance_arrays(self, strSharedDriveI):

		arrParams = [
			strSharedDriveID,
		]

		return self.rpc("shared_drive_instance_arrays", arrParams)


	def provisioner_cleanup(self):

		arrParams = [
		]

		self.rpc("provisioner_cleanup", arrParams)


	def switch_device_reprovision(self, nSwitchDeviceID, bIgnoreDirtyBit = True, bForceIPCleanup = Fals):

		arrParams = [
			nSwitchDeviceID,
			bIgnoreDirtyBit,
			bForceIPCleanup,
		]

		return self.rpc("switch_device_reprovision", arrParams)


	def server_bios_info_refresh(self, strServerI):

		arrParams = [
			strServerID,
		]

		return self.rpc("server_bios_info_refresh", arrParams)


	def volume_upload_target_url(self, strInfrastructureID, arrFileInf):

		arrParams = [
			strInfrastructureID,
			arrFileInfo,
		]

		return self.rpc("volume_upload_target_url", arrParams)


	def volume_upload_max_size(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return self.rpc("volume_upload_max_size", arrParams)


	def volume_template_get(self, strVolumeTemplateI):

		arrParams = [
			strVolumeTemplateID,
		]

		return Deserializer.deserialize(self.rpc("volume_template_get", arrParams))

	def provisioner_volume_import(self, nUploadI):

		arrParams = [
			nUploadID,
		]

		self.rpc("provisioner_volume_import", arrParams)


	def server_class_update(self, nServerID, strServerClas):

		arrParams = [
			nServerID,
			strServerClass,
		]

		return self.rpc("server_class_update", arrParams)


	def shared_drive_gui_settings_save(self, strSharedDriveID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strSharedDriveID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("shared_drive_gui_settings_save", arrParams)


	def volume_template_make_public(self, strVolumeTemplateID, strBootstrapFunctionNam):

		arrParams = [
			strVolumeTemplateID,
			strBootstrapFunctionName,
		]

		self.rpc("volume_template_make_public", arrParams)


	def database_sanitize_query(self):

		arrParams = [
		]

		return self.rpc("database_sanitize_query", arrParams)


	def servers_type_utilization_report(self, strGroupByColumnName, strDatacenterName, bTestingMode = None, bDeveloper = Non):

		arrParams = [
			strGroupByColumnName,
			strDatacenterName,
			bTestingMode,
			bDeveloper,
		]

		return self.rpc("servers_type_utilization_report", arrParams)


	def switch_device_reprovision_infrastructure(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("switch_device_reprovision_infrastructure", arrParams)


	def switch_device_reprovision_quarantine(self, nSwitchDeviceI):

		arrParams = [
			nSwitchDeviceID,
		]

		return self.rpc("switch_device_reprovision_quarantine", arrParams)


	def switch_device_reprovision_instance(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("switch_device_reprovision_instance", arrParams)


	def dns_subdomains_regenerate(self):

		arrParams = [
		]

		self.rpc("dns_subdomains_regenerate", arrParams)


	def infrastructure_user_limits(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_user_limits", arrParams))

	def dns_subdomains_regenerate_records(self, nInfrastructureID = None, bRebuilding = Tru):

		arrParams = [
			nInfrastructureID,
			bRebuilding,
		]

		self.rpc("dns_subdomains_regenerate_records", arrParams)


	def switch_device_reprovision_interfaces(self, arrSwitchInterfaceID):

		arrParams = [
			arrSwitchInterfaceIDs,
		]

		return self.rpc("switch_device_reprovision_interfaces", arrParams)


	def volume_template_replicate(self, nVolumeTemplateID, nSrcStoragePoolID, nDstStoragePoolI):

		arrParams = [
			nVolumeTemplateID,
			nSrcStoragePoolID,
			nDstStoragePoolID,
		]

		return self.rpc("volume_template_replicate", arrParams)


	def dns_infrastructure_provision_callback(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		self.rpc("dns_infrastructure_provision_callback", arrParams)


	def dns_infrastructure_provision_callback_all_infrastructures(self, bOnlyActiveOrOngoin):

		arrParams = [
			bOnlyActiveOrOngoing,
		]

		self.rpc("dns_infrastructure_provision_callback_all_infrastructures", arrParams)


	def network_join(self, strNetworkID, strNetworkToBeDeletedI):

		arrParams = [
			strNetworkID,
			strNetworkToBeDeletedID,
		]

		return Deserializer.deserialize(self.rpc("network_join", arrParams))

	def resource_utilization_detailed(self, strUserIDOwner, strStartTimestamp, strEndTimestamp, arrInfrastructureIDs = Non):

		arrParams = [
			strUserIDOwner,
			strStartTimestamp,
			strEndTimestamp,
			arrInfrastructureIDs,
		]

		return self.rpc("resource_utilization_detailed", arrParams)


	def infrastructure_owner_change(self, nInfrastructureID, nNewOwnerID, bSkipSubnetPoolsChange = Fals):

		arrParams = [
			nInfrastructureID,
			nNewOwnerID,
			bSkipSubnetPoolsChange,
		]

		self.rpc("infrastructure_owner_change", arrParams)


	def datacenters(self, strUserID = None, bOnlyActive = False, bIncludeConfigProperties = Fals):

		arrParams = [
			strUserID,
			bOnlyActive,
			bIncludeConfigProperties,
		]

		objDatacenter = self.rpc("datacenters", arrParams)
		for strKeyDatacenter in objDatacenter:
			objDatacenter[strKeyDatacenter] = Deserializer.deserialize(objDatacenter[strKeyDatacenter])
		return objDatacenter

	def data_lake_create(self, strInfrastructureID, objDataLak):

		objDataLake = Serializer.serialize(objDataLake)

		arrParams = [
			strInfrastructureID,
			objDataLake,
		]

		return Deserializer.deserialize(self.rpc("data_lake_create", arrParams))

	def data_lake_get(self, strDataLakeI):

		arrParams = [
			strDataLakeID,
		]

		return Deserializer.deserialize(self.rpc("data_lake_get", arrParams))

	def data_lake_stop(self, strDataLakeI):

		arrParams = [
			strDataLakeID,
		]

		return Deserializer.deserialize(self.rpc("data_lake_stop", arrParams))

	def data_lake_start(self, strDataLakeI):

		arrParams = [
			strDataLakeID,
		]

		return Deserializer.deserialize(self.rpc("data_lake_start", arrParams))

	def data_lake_delete(self, strDataLakeI):

		arrParams = [
			strDataLakeID,
		]

		return Deserializer.deserialize(self.rpc("data_lake_delete", arrParams))

	def data_lakes(self, strInfrastructureID, arrDataLakeIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrDataLakeIDs,
		]

		objDataLake = self.rpc("data_lakes", arrParams)
		for strKeyDataLake in objDataLake:
			objDataLake[strKeyDataLake] = Deserializer.deserialize(objDataLake[strKeyDataLake])
		return objDataLake

	def data_lake_gui_settings_save(self, strDataLakeID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strDataLakeID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("data_lake_gui_settings_save", arrParams)


	def network_gui_settings_save(self, strNetworkID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strNetworkID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("network_gui_settings_save", arrParams)


	def data_lake_edit(self, strDataLakeID, objDataLakeOperatio):

		objDataLakeOperation = Serializer.serialize(objDataLakeOperation)

		arrParams = [
			strDataLakeID,
			objDataLakeOperation,
		]

		return self.rpc("data_lake_edit", arrParams)


	def user_change_password(self, strUserID, strNewPassword, strOldPassword = Non):

		arrParams = [
			strUserID,
			strNewPassword,
			strOldPassword,
		]

		self.rpc("user_change_password", arrParams)


	def ip_allocate_oob(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("ip_allocate_oob", arrParams)


	def subnet_oob_create(self, objSubne):

		objSubnet = Serializer.serialize(objSubnet)

		arrParams = [
			objSubnet,
		]

		return Deserializer.deserialize(self.rpc("subnet_oob_create", arrParams))

	def user_cookie_session(self, bFetchUserLoginSessionData = Fals):

		arrParams = [
			bFetchUserLoginSessionData,
		]

		return Deserializer.deserialize(self.rpc("user_cookie_session", arrParams))

	def user_logout(self):

		arrParams = [
		]

		return self.rpc("user_logout", arrParams)


	def hdfs_cluster_get(self, strDatacenter = Non):

		arrParams = [
			strDatacenter,
		]

		return self.rpc("hdfs_cluster_get", arrParams)


	def volume_template_storage_pool_get(self, nVolumeTemplateStoragePoolI):

		arrParams = [
			nVolumeTemplateStoragePoolID,
		]

		return self.rpc("volume_template_storage_pool_get", arrParams)


	def volume_template_storage_pools_for_volume_template(self, nVolumeTemplateI):

		arrParams = [
			nVolumeTemplateID,
		]

		return self.rpc("volume_template_storage_pools_for_volume_template", arrParams)


	def switch_device_interface_counters(self, objSwitchDeviceInterfaceCountersFilter = Non):

		objSwitchDeviceInterfaceCountersFilter = Serializer.serialize(objSwitchDeviceInterfaceCountersFilter)

		arrParams = [
			objSwitchDeviceInterfaceCountersFilter,
		]

		return self.rpc("switch_device_interface_counters", arrParams)


	def query(self, strUserID, strSQLQuery, strCollapseType = "array_subrows):

		arrParams = [
			strUserID,
			strSQLQuery,
			strCollapseType,
		]

		return self.rpc("query", arrParams)


	def query_structured(self, strUserID, strTableName, objQueryConditions, strCollapseType = "array_subrows):

		objQueryConditions = Serializer.serialize(objQueryConditions)

		arrParams = [
			strUserID,
			strTableName,
			objQueryConditions,
			strCollapseType,
		]

		return self.rpc("query_structured", arrParams)


	def switch_device_delete(self, nNetworkEquipmentI):

		arrParams = [
			nNetworkEquipmentID,
		]

		self.rpc("switch_device_delete", arrParams)


	def switch_device_interface_get(self, mxSwitchDeviceInterface, nSwitchDeviceID = Non):

		mxSwitchDeviceInterface = Serializer.serialize(mxSwitchDeviceInterface)

		arrParams = [
			mxSwitchDeviceInterface,
			nSwitchDeviceID,
		]

		return self.rpc("switch_device_interface_get", arrParams)


	def user_jwt_check(self, strEncodedCookie, nUserIdBS):

		arrParams = [
			strEncodedCookie,
			nUserIdBSI,
		]

		return self.rpc("user_jwt_check", arrParams)


	def volume_template_replicate_all(self, strVolumeTemplateI):

		arrParams = [
			strVolumeTemplateID,
		]

		return self.rpc("volume_template_replicate_all", arrParams)


	def storage_usage_report(self, bPerStorage, bPhysicalSiz):

		arrParams = [
			bPerStorage,
			bPhysicalSize,
		]

		return self.rpc("storage_usage_report", arrParams)


	def infrastructure_deploy_overview(self, strInfrastructureID, objDeployOptions = Non):

		objDeployOptions = Serializer.serialize(objDeployOptions)

		arrParams = [
			strInfrastructureID,
			objDeployOptions,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_deploy_overview", arrParams))

	def afc_exceptions(self, nAFCI):

		arrParams = [
			nAFCID,
		]

		return self.rpc("afc_exceptions", arrParams)


	def volume_template_drives(self, nVolumeTemplateI):

		arrParams = [
			nVolumeTemplateID,
		]

		return self.rpc("volume_template_drives", arrParams)


	def volume_templates_created_from_drive(self, strDriveI):

		arrParams = [
			strDriveID,
		]

		return self.rpc("volume_templates_created_from_drive", arrParams)


	def server_type_available_server_count(self, strUserIDOwner, strDatacenterName, strServerTypeID, nMaximumResult):

		arrParams = [
			strUserIDOwner,
			strDatacenterName,
			strServerTypeID,
			nMaximumResults,
		]

		return self.rpc("server_type_available_server_count", arrParams)


	def server_type_reservation_owner_change(self, nServerTypeReservationID, nUserIDOwner, strToday = Non):

		arrParams = [
			nServerTypeReservationID,
			nUserIDOwner,
			strToday,
		]

		return self.rpc("server_type_reservation_owner_change", arrParams)


	def dns_ptr_records_clear(self):

		arrParams = [
		]

		self.rpc("dns_ptr_records_clear", arrParams)


	def server_type_get(self, strServerTypeI):

		arrParams = [
			strServerTypeID,
		]

		return Deserializer.deserialize(self.rpc("server_type_get", arrParams))

	def infrastructure_gui_settings_save(self, strInfrastructureID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strInfrastructureID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("infrastructure_gui_settings_save", arrParams)


	def user_gui_settings_save(self, strUserID, objGUIUserSettings, arrPropertyName):

		objGUIUserSettings = Serializer.serialize(objGUIUserSettings)

		arrParams = [
			strUserID,
			objGUIUserSettings,
			arrPropertyNames,
		]

		self.rpc("user_gui_settings_save", arrParams)


	def server_get_internal(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_get_internal", arrParams)


	def storage_types(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return self.rpc("storage_types", arrParams)


	def switch_device_reprovision_server(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("switch_device_reprovision_server", arrParams)


	def server_type_matches_internal(self, strInfrastructureID, objHardwareConfiguration, nInstanceArrayID = None, arrMustKeepServerIDs = [], arrAlreadyAllocatedServerIDs = [], arrServerClasses = ["bigdata"):

		objHardwareConfiguration = Serializer.serialize(objHardwareConfiguration)

		arrParams = [
			strInfrastructureID,
			objHardwareConfiguration,
			nInstanceArrayID,
			arrMustKeepServerIDs,
			arrAlreadyAllocatedServerIDs,
			arrServerClasses,
		]

		return self.rpc("server_type_matches_internal", arrParams)


	def drive_hook_toggle(self, nDriveI):

		arrParams = [
			nDriveID,
		]

		return self.rpc("drive_hook_toggle", arrParams)


	def server_vendor_firmware_version_update(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_vendor_firmware_version_update", arrParams)


	def server_vendor_firmware_version_update_all(self):

		arrParams = [
		]

		self.rpc("server_vendor_firmware_version_update_all", arrParams)


	def drive_snapshot_get(self, strSnapshotI):

		arrParams = [
			strSnapshotID,
		]

		return Deserializer.deserialize(self.rpc("drive_snapshot_get", arrParams))

	def datacenter_base_urls(self):

		arrParams = [
		]

		return self.rpc("datacenter_base_urls", arrParams)


	def volume_template_storage_pool_delete(self, nVolumeTemplateStoragePoolI):

		arrParams = [
			nVolumeTemplateStoragePoolID,
		]

		self.rpc("volume_template_storage_pool_delete", arrParams)


	def user_authenticate_api_key(self, strUserID, strAPIKey, strOneTimePassword = None, bRememberLogin = Tru):

		arrParams = [
			strUserID,
			strAPIKey,
			strOneTimePassword,
			bRememberLogin,
		]

		return Deserializer.deserialize(self.rpc("user_authenticate_api_key", arrParams))

	def subnet_pool_get(self, nSubnetPoolI):

		arrParams = [
			nSubnetPoolID,
		]

		return self.rpc("subnet_pool_get", arrParams)


	def storage_pool_delete(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		self.rpc("storage_pool_delete", arrParams)


	def data_lake_krb_conf_download_url(self):

		arrParams = [
		]

		return self.rpc("data_lake_krb_conf_download_url", arrParams)


	def infrastructure_instances_info(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("infrastructure_instances_info", arrParams)


	def network_traffic_sflow_parse(self):

		arrParams = [
		]

		self.rpc("network_traffic_sflow_parse", arrParams)


	def test_development_network_traffic_sflow_generate(self):

		arrParams = [
		]

		self.rpc("test_development_network_traffic_sflow_generate", arrParams)


	def drive_move_to_storage(self, nDriveID, nDstStoragePoolID, bAllowDatacenterChange = False, bAllowStorageTypeChange = Tru):

		arrParams = [
			nDriveID,
			nDstStoragePoolID,
			bAllowDatacenterChange,
			bAllowStorageTypeChange,
		]

		return Deserializer.deserialize(self.rpc("drive_move_to_storage", arrParams))

	def user_server_type_reservations_optimize(self, nUserID, strDatacenterName, bInstanceChanges = Fals):

		arrParams = [
			nUserID,
			strDatacenterName,
			bInstanceChanges,
		]

		self.rpc("user_server_type_reservations_optimize", arrParams)


	def dns_iana_ipv4_ranges_generate_reverse(self):

		arrParams = [
		]

		self.rpc("dns_iana_ipv4_ranges_generate_reverse", arrParams)


	def storage_pool_iqn_cleanup(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		self.rpc("storage_pool_iqn_cleanup", arrParams)


	def storage_pool_virtual_size_occupied_mb(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return self.rpc("storage_pool_virtual_size_occupied_mb", arrParams)


	def storage_pool_physical_size_occupied_mb(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return self.rpc("storage_pool_physical_size_occupied_mb", arrParams)


	def storage_pool_physical_size_mb(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return self.rpc("storage_pool_physical_size_mb", arrParams)


	def storage_pools(self, strDatacenterName = None, arrStoragePoolTypes = [], bIncludeStoragePoolsInMaintenance = False, bAllowExperimental = False, nUserID = Non):

		arrParams = [
			strDatacenterName,
			arrStoragePoolTypes,
			bIncludeStoragePoolsInMaintenance,
			bAllowExperimental,
			nUserID,
		]

		return self.rpc("storage_pools", arrParams)


	def switch_device_provision(self, nSwitchDeviceID, nInfrastructureID = None, arrDirtyInstanceInterfaceIDs = [], arrDirtySwitchInterfaceIDs = [], bIgnoreDirtyBit = False, arrEnableSwitchInterfaceIDs = [):

		arrParams = [
			nSwitchDeviceID,
			nInfrastructureID,
			arrDirtyInstanceInterfaceIDs,
			arrDirtySwitchInterfaceIDs,
			bIgnoreDirtyBit,
			arrEnableSwitchInterfaceIDs,
		]

		return self.rpc("switch_device_provision", arrParams)


	def switch_device_provision_vpls_north(self, nSwitchDeviceID, nInfrastructureID = Non):

		arrParams = [
			nSwitchDeviceID,
			nInfrastructureID,
		]

		return self.rpc("switch_device_provision_vpls_north", arrParams)


	def switch_device_interfaces_dirty_bit_set(self, arrSwitchDeviceInterfaceIDs, nInfrastructureID = ):

		arrParams = [
			arrSwitchDeviceInterfaceIDs,
			nInfrastructureID,
		]

		self.rpc("switch_device_interfaces_dirty_bit_set", arrParams)


	def user_delete(self, strUserI):

		arrParams = [
			strUserID,
		]

		return self.rpc("user_delete", arrParams)


	def data_lakes_traffic_update(self, arrDataLakesTrafficDat):

		arrParams = [
			arrDataLakesTrafficData,
		]

		self.rpc("data_lakes_traffic_update", arrParams)


	def sync_tables_in_guest_mode(self):

		arrParams = [
		]

		self.rpc("sync_tables_in_guest_mode", arrParams)


	def server_type_reservation_reactivate(self, nServerTypeReservationI):

		arrParams = [
			nServerTypeReservationID,
		]

		self.rpc("server_type_reservation_reactivate", arrParams)


	def user_jwt_salt_regenerate(self, nUserI):

		arrParams = [
			nUserID,
		]

		return self.rpc("user_jwt_salt_regenerate", arrParams)


	def infrastructure_deploy_blockers(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		arrInfrastructureDeployBlockers = self.rpc("infrastructure_deploy_blockers", arrParams)
		for index in range(len(arrInfrastructureDeployBlockers)):
			arrInfrastructureDeployBlockers[index] = Deserializer.deserialize(arrInfrastructureDeployBlockers[index])
		return arrInfrastructureDeployBlockers

	def cluster_suspend(self, strClusterI):

		arrParams = [
			strClusterID,
		]

		return Deserializer.deserialize(self.rpc("cluster_suspend", arrParams))

	def shared_drive_move_to_storage(self, nSharedDriveID, nDstStoragePoolID, bAllowDatacenterChange = False, bAllowStorageTypeChange = Tru):

		arrParams = [
			nSharedDriveID,
			nDstStoragePoolID,
			bAllowDatacenterChange,
			bAllowStorageTypeChange,
		]

		return Deserializer.deserialize(self.rpc("shared_drive_move_to_storage", arrParams))

	def user_suspend_reason_add(self, nUserID, strSuspendReasonType, strSuspendReasonPublicComment, strSuspendReasonPrivateComment = "):

		arrParams = [
			nUserID,
			strSuspendReasonType,
			strSuspendReasonPublicComment,
			strSuspendReasonPrivateComment,
		]

		return Deserializer.deserialize(self.rpc("user_suspend_reason_add", arrParams))

	def user_suspend_reason_remove(self, nUserID, strSuspendReasonTyp):

		arrParams = [
			nUserID,
			strSuspendReasonType,
		]

		self.rpc("user_suspend_reason_remove", arrParams)


	def user_suspend_reason_get(self, nUserSuspendReasonI):

		arrParams = [
			nUserSuspendReasonID,
		]

		return Deserializer.deserialize(self.rpc("user_suspend_reason_get", arrParams))

	def user_suspend_reasons(self, nUserI):

		arrParams = [
			nUserID,
		]

		arrUserSuspendReasons = self.rpc("user_suspend_reasons", arrParams)
		for index in range(len(arrUserSuspendReasons)):
			arrUserSuspendReasons[index] = Deserializer.deserialize(arrUserSuspendReasons[index])
		return arrUserSuspendReasons

	def server_disk_wipe_toggle(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_disk_wipe_toggle", arrParams)


	def storage_pool_maintenance_set(self, nStoragePoolID, bInMaintenanc):

		arrParams = [
			nStoragePoolID,
			bInMaintenance,
		]

		self.rpc("storage_pool_maintenance_set", arrParams)


	def container_platform_create(self, strInfrastructureID, objContainerPlatfor):

		objContainerPlatform = Serializer.serialize(objContainerPlatform)

		arrParams = [
			strInfrastructureID,
			objContainerPlatform,
		]

		return Deserializer.deserialize(self.rpc("container_platform_create", arrParams))

	def container_platform_delete(self, strContainerPlatformI):

		arrParams = [
			strContainerPlatformID,
		]

		return Deserializer.deserialize(self.rpc("container_platform_delete", arrParams))

	def volume_templates_private(self, strUserID, arrVolumeTemplateIDs = Non):

		arrParams = [
			strUserID,
			arrVolumeTemplateIDs,
		]

		objVolumeTemplate = self.rpc("volume_templates_private", arrParams)
		for strKeyVolumeTemplate in objVolumeTemplate:
			objVolumeTemplate[strKeyVolumeTemplate] = Deserializer.deserialize(objVolumeTemplate[strKeyVolumeTemplate])
		return objVolumeTemplate

	def volume_template_public_create_from_storage(self, strVolumeTemplateStorageImageName, nStoragePoolID, strVolumeTemplateLabel, strVolumeTemplateDisplayName, strDescription, strBootstrapFunctionName, objOperatingSystem, strVolumeTemplateBootType = "legacy_only", strVolumeTemplateDeprecationStatus = "not_deprecated):

		objOperatingSystem = Serializer.serialize(objOperatingSystem)

		arrParams = [
			strVolumeTemplateStorageImageName,
			nStoragePoolID,
			strVolumeTemplateLabel,
			strVolumeTemplateDisplayName,
			strDescription,
			strBootstrapFunctionName,
			objOperatingSystem,
			strVolumeTemplateBootType,
			strVolumeTemplateDeprecationStatus,
		]

		return self.rpc("volume_template_public_create_from_storage", arrParams)


	def server_disks(self, nServerI):

		arrParams = [
			nServerID,
		]

		arrServerDisks = self.rpc("server_disks", arrParams)
		for index in range(len(arrServerDisks)):
			arrServerDisks[index] = Deserializer.deserialize(arrServerDisks[index])
		return arrServerDisks

	def jwt_session_cookies_types_to_cookies_names(self):

		arrParams = [
		]

		return self.rpc("jwt_session_cookies_types_to_cookies_names", arrParams)


	def container_array_create(self, strInfrastructureID, objContainerArra):

		objContainerArray = Serializer.serialize(objContainerArray)

		arrParams = [
			strInfrastructureID,
			objContainerArray,
		]

		return Deserializer.deserialize(self.rpc("container_array_create", arrParams))

	def container_array_get(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		return Deserializer.deserialize(self.rpc("container_array_get", arrParams))

	def container_array_edit(self, strContainerArrayID, objContainerArrayOperation, bKeepDetachingDrives = Non):

		objContainerArrayOperation = Serializer.serialize(objContainerArrayOperation)

		arrParams = [
			strContainerArrayID,
			objContainerArrayOperation,
			bKeepDetachingDrives,
		]

		return Deserializer.deserialize(self.rpc("container_array_edit", arrParams))

	def container_array_delete(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		return Deserializer.deserialize(self.rpc("container_array_delete", arrParams))

	def container_array_stop(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		return Deserializer.deserialize(self.rpc("container_array_stop", arrParams))

	def container_array_start(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		return Deserializer.deserialize(self.rpc("container_array_start", arrParams))

	def container_arrays(self, strInfrastructureID, arrContainerArrayIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrContainerArrayIDs,
		]

		objContainerArray = self.rpc("container_arrays", arrParams)
		for strKeyContainerArray in objContainerArray:
			objContainerArray[strKeyContainerArray] = Deserializer.deserialize(objContainerArray[strKeyContainerArray])
		return objContainerArray

	def container_platform_get(self, strContainerPlatformI):

		arrParams = [
			strContainerPlatformID,
		]

		return Deserializer.deserialize(self.rpc("container_platform_get", arrParams))

	def container_platform_edit(self, strContainerPlatformID, objContainerPlatformOperation, objServerTypeMatches = Non):

		objContainerPlatformOperation = Serializer.serialize(objContainerPlatformOperation)
		objServerTypeMatches = Serializer.serialize(objServerTypeMatches)

		arrParams = [
			strContainerPlatformID,
			objContainerPlatformOperation,
			objServerTypeMatches,
		]

		return Deserializer.deserialize(self.rpc("container_platform_edit", arrParams))

	def container_platform_stop(self, strContainerPlatformI):

		arrParams = [
			strContainerPlatformID,
		]

		return Deserializer.deserialize(self.rpc("container_platform_stop", arrParams))

	def container_platform_start(self, strContainerPlatformI):

		arrParams = [
			strContainerPlatformID,
		]

		return Deserializer.deserialize(self.rpc("container_platform_start", arrParams))

	def container_platforms(self, strInfrastructureID, arrContainerPlatformIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrContainerPlatformIDs,
		]

		objContainerPlatform = self.rpc("container_platforms", arrParams)
		for strKeyContainerPlatform in objContainerPlatform:
			objContainerPlatform[strKeyContainerPlatform] = Deserializer.deserialize(objContainerPlatform[strKeyContainerPlatform])
		return objContainerPlatform

	def container_platform_suspend(self, strContainerPlatformI):

		arrParams = [
			strContainerPlatformID,
		]

		return Deserializer.deserialize(self.rpc("container_platform_suspend", arrParams))

	def container_array_gui_settings_save(self, strContainerArrayID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strContainerArrayID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("container_array_gui_settings_save", arrParams)


	def container_platform_gui_settings_save(self, strContainerPlatformID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strContainerPlatformID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("container_platform_gui_settings_save", arrParams)


	def container_array_interface_get(self, nContainerArrayInterfaceI):

		arrParams = [
			nContainerArrayInterfaceID,
		]

		return Deserializer.deserialize(self.rpc("container_array_interface_get", arrParams))

	def subnet_oob_delete(self, nSubnetI):

		arrParams = [
			nSubnetID,
		]

		self.rpc("subnet_oob_delete", arrParams)


	def switch_device_test(self, nSwitchDeviceI):

		arrParams = [
			nSwitchDeviceID,
		]

		return self.rpc("switch_device_test", arrParams)


	def container_platform_container_arrays(self, strContainerPlatformID, arrContainerArrayIDs = Non):

		arrParams = [
			strContainerPlatformID,
			arrContainerArrayIDs,
		]

		objContainerArray = self.rpc("container_platform_container_arrays", arrParams)
		for strKeyContainerArray in objContainerArray:
			objContainerArray[strKeyContainerArray] = Deserializer.deserialize(objContainerArray[strKeyContainerArray])
		return objContainerArray

	def container_array_containers(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		objContainer = self.rpc("container_array_containers", arrParams)
		for strKeyContainer in objContainer:
			objContainer[strKeyContainer] = Deserializer.deserialize(objContainer[strKeyContainer])
		return objContainer

	def cluster_password_change(self, strClusterID, strNewPasswor):

		arrParams = [
			strClusterID,
			strNewPassword,
		]

		self.rpc("cluster_password_change", arrParams)


	def cluster_public_key_get(self, strClusterI):

		arrParams = [
			strClusterID,
		]

		return self.rpc("cluster_public_key_get", arrParams)


	def server_requires_manual_cleaning_toggle(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_requires_manual_cleaning_toggle", arrParams)


	def infrastructure_experimental_priority_set(self, nInfrastructureID, strExperimentalPriorit):

		arrParams = [
			nInfrastructureID,
			strExperimentalPriority,
		]

		self.rpc("infrastructure_experimental_priority_set", arrParams)


	def infrastructure_experimental_priority_get(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("infrastructure_experimental_priority_get", arrParams)


	def switch_device_interfaces_enable_set(self, arrSwitchInterfaceIDsToLinkStat):

		arrParams = [
			arrSwitchInterfaceIDsToLinkState,
		]

		self.rpc("switch_device_interfaces_enable_set", arrParams)


	def instance_public_key_get(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return self.rpc("instance_public_key_get", arrParams)


	def client_ip(self):

		arrParams = [
		]

		return self.rpc("client_ip", arrParams)


	def clusters_software_version_get(self, arrClusterTypes = [):

		arrParams = [
			arrClusterTypes,
		]

		return self.rpc("clusters_software_version_get", arrParams)


	def license_create(self, nLicenseContractID, objLicens):

		objLicense = Serializer.serialize(objLicense)

		arrParams = [
			nLicenseContractID,
			objLicense,
		]

		return Deserializer.deserialize(self.rpc("license_create", arrParams))

	def license_get(self, nLicenseID, bSelectForUpdate = Fals):

		arrParams = [
			nLicenseID,
			bSelectForUpdate,
		]

		return Deserializer.deserialize(self.rpc("license_get", arrParams))

	def license_edit(self, nLicenseID, objLicens):

		objLicense = Serializer.serialize(objLicense)

		arrParams = [
			nLicenseID,
			objLicense,
		]

		return Deserializer.deserialize(self.rpc("license_edit", arrParams))

	def licenses(self, nLicenseContractID, bIncludeStopped = Fals):

		arrParams = [
			nLicenseContractID,
			bIncludeStopped,
		]

		return self.rpc("licenses", arrParams)


	def license_installment_create(self, strLicenseType, objLicenseInstallmen):

		objLicenseInstallment = Serializer.serialize(objLicenseInstallment)

		arrParams = [
			strLicenseType,
			objLicenseInstallment,
		]

		return Deserializer.deserialize(self.rpc("license_installment_create", arrParams))

	def license_installments_create(self, nLicenseI):

		arrParams = [
			nLicenseID,
		]

		self.rpc("license_installments_create", arrParams)


	def license_installment_get(self, nLicenseInstallmentID, bSelectForUpdate = Fals):

		arrParams = [
			nLicenseInstallmentID,
			bSelectForUpdate,
		]

		return Deserializer.deserialize(self.rpc("license_installment_get", arrParams))

	def license_installment_edit(self, nLicenseInstallmentID, objLicenseInstallmen):

		objLicenseInstallment = Serializer.serialize(objLicenseInstallment)

		arrParams = [
			nLicenseInstallmentID,
			objLicenseInstallment,
		]

		return Deserializer.deserialize(self.rpc("license_installment_edit", arrParams))

	def license_installments(self, nLicenseI):

		arrParams = [
			nLicenseID,
		]

		return self.rpc("license_installments", arrParams)


	def license_contract_create(self, nUserID, strLicenseType, strCycleStartTimestamp = None, bLicenseContractRecurring = Tru):

		arrParams = [
			nUserID,
			strLicenseType,
			strCycleStartTimestamp,
			bLicenseContractRecurring,
		]

		return Deserializer.deserialize(self.rpc("license_contract_create", arrParams))

	def license_contract_get(self, nLicenseContractID, bSelectForUpdate = Fals):

		arrParams = [
			nLicenseContractID,
			bSelectForUpdate,
		]

		return Deserializer.deserialize(self.rpc("license_contract_get", arrParams))

	def license_contract_edit(self, nLicenseContract, objLicenseContrac):

		objLicenseContract = Serializer.serialize(objLicenseContract)

		arrParams = [
			nLicenseContract,
			objLicenseContract,
		]

		return Deserializer.deserialize(self.rpc("license_contract_edit", arrParams))

	def license_contracts(self, nUserID = None, strLicenseType = Non):

		arrParams = [
			nUserID,
			strLicenseType,
		]

		return self.rpc("license_contracts", arrParams)


	def license_contract_delete(self, nLicenseContractI):

		arrParams = [
			nLicenseContractID,
		]

		return self.rpc("license_contract_delete", arrParams)


	def sqlselection_views_create(self):

		arrParams = [
		]

		self.rpc("sqlselection_views_create", arrParams)


	def instance_server_type_reservation_create(self, strInstanceID, bRecurring, nReservationCycleMonths, nInstallmentCycleMonth):

		arrParams = [
			strInstanceID,
			bRecurring,
			nReservationCycleMonths,
			nInstallmentCycleMonths,
		]

		return Deserializer.deserialize(self.rpc("instance_server_type_reservation_create", arrParams))

	def prices(self):

		arrParams = [
		]

		return self.rpc("prices", arrParams)


	def infrastructure_deployments(self, nInfrastructureID, strStartTimestamp = None, strEndTimestamp = Non):

		arrParams = [
			nInfrastructureID,
			strStartTimestamp,
			strEndTimestamp,
		]

		return self.rpc("infrastructure_deployments", arrParams)


	def infrastructure_public_designs(self):

		arrParams = [
		]

		return self.rpc("infrastructure_public_designs", arrParams)


	def infrastructure_design_lock_set(self, strInfrastructureID, bLockStatu):

		arrParams = [
			strInfrastructureID,
			bLockStatus,
		]

		self.rpc("infrastructure_design_lock_set", arrParams)


	def volume_template_experimental_toggle(self, nVolumeTemplateI):

		arrParams = [
			nVolumeTemplateID,
		]

		return self.rpc("volume_template_experimental_toggle", arrParams)


	def infrastructure_public_designs_member_set(self, strInfrastructureID, bPublicDesig):

		arrParams = [
			strInfrastructureID,
			bPublicDesign,
		]

		self.rpc("infrastructure_public_designs_member_set", arrParams)


	def cluster_automatic_management_status_set(self, strClusterID, bStatu):

		arrParams = [
			strClusterID,
			bStatus,
		]

		self.rpc("cluster_automatic_management_status_set", arrParams)


	def server_type_available_server_count_batch(self, strUserIDOwner, strDatacenterName, arrServerTypeIDs, nMaximumResults, bIncludeReservedForUser = False, nInstanceArrayID = Non):

		arrParams = [
			strUserIDOwner,
			strDatacenterName,
			arrServerTypeIDs,
			nMaximumResults,
			bIncludeReservedForUser,
			nInstanceArrayID,
		]

		return self.rpc("server_type_available_server_count_batch", arrParams)


	def server_types_match_hardware_configuration(self, strDatacenterName, objHardwareConfiguratio):

		objHardwareConfiguration = Serializer.serialize(objHardwareConfiguration)

		arrParams = [
			strDatacenterName,
			objHardwareConfiguration,
		]

		objServerType = self.rpc("server_types_match_hardware_configuration", arrParams)
		for strKeyServerType in objServerType:
			objServerType[strKeyServerType] = Deserializer.deserialize(objServerType[strKeyServerType])
		return objServerType

	def production_config_secret_encrypt(self, strSecre):

		arrParams = [
			strSecret,
		]

		return self.rpc("production_config_secret_encrypt", arrParams)


	def license_delete(self, nLicenseI):

		arrParams = [
			nLicenseID,
		]

		return self.rpc("license_delete", arrParams)


	def server_comments_set(self, nServerID, strCommentsTex):

		arrParams = [
			nServerID,
			strCommentsText,
		]

		return Deserializer.deserialize(self.rpc("server_comments_set", arrParams))

	def integration_config_secret_encrypt(self, strSecre):

		arrParams = [
			strSecret,
		]

		return self.rpc("integration_config_secret_encrypt", arrParams)


	def user_server_type_reservations_unused(self, strUserID, strDatacenterNam):

		arrParams = [
			strUserID,
			strDatacenterName,
		]

		return self.rpc("user_server_type_reservations_unused", arrParams)


	def user_infrastructure_deployments(self, strUserIDOwner, strStartTimestamp = None, strEndTimestamp = Non):

		arrParams = [
			strUserIDOwner,
			strStartTimestamp,
			strEndTimestamp,
		]

		return self.rpc("user_infrastructure_deployments", arrParams)


	def infrastructure_deployment_get(self, nInfrastructureDeployI):

		arrParams = [
			nInfrastructureDeployID,
		]

		return self.rpc("infrastructure_deployment_get", arrParams)


	def user_promotions(self, nUserI):

		arrParams = [
			nUserID,
		]

		return self.rpc("user_promotions", arrParams)


	def users_with_promotion(self, strPromotionNam):

		arrParams = [
			strPromotionName,
		]

		return self.rpc("users_with_promotion", arrParams)


	def afc_skip(self, nAFCI):

		arrParams = [
			nAFCID,
		]

		self.rpc("afc_skip", arrParams)


	def product_get_internal(self, strProductName, nProductID, bPublic = Fals):

		arrParams = [
			strProductName,
			nProductID,
			bPublic,
		]

		return self.rpc("product_get_internal", arrParams)


	def product_children_internal(self, strProductType, nProductID, strChildProductType, bAllowDeleted = Fals):

		arrParams = [
			strProductType,
			nProductID,
			strChildProductType,
			bAllowDeleted,
		]

		return self.rpc("product_children_internal", arrParams)


	def shared_drive_container_arrays(self, strSharedDriveI):

		arrParams = [
			strSharedDriveID,
		]

		return self.rpc("shared_drive_container_arrays", arrParams)


	def storage_pool_physical_size_free_mb(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return self.rpc("storage_pool_physical_size_free_mb", arrParams)


	def storages_update_database_cache_in_parallel(self, arrStoragePoolIDs = None, bLockMustBeBlocking = Fals):

		arrParams = [
			arrStoragePoolIDs,
			bLockMustBeBlocking,
		]

		return self.rpc("storages_update_database_cache_in_parallel", arrParams)


	def storage_update_database_cache(self, nStoragePoolID, bLockMustBeBlocking = Fals):

		arrParams = [
			nStoragePoolID,
			bLockMustBeBlocking,
		]

		return self.rpc("storage_update_database_cache", arrParams)


	def storage_pool_experimental_set(self, nStoragePoolID, bIsExperimenta):

		arrParams = [
			nStoragePoolID,
			bIsExperimental,
		]

		self.rpc("storage_pool_experimental_set", arrParams)


	def dev_env_create_vmware(self, nDatacenterIndex, nUserID = Non):

		arrParams = [
			nDatacenterIndex,
			nUserID,
		]

		self.rpc("dev_env_create_vmware", arrParams)


	def nics_information_generate(self, nNoNIC):

		arrParams = [
			nNoNICs,
		]

		return self.rpc("nics_information_generate", arrParams)


	def nic_lua_script_generate_url(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("nic_lua_script_generate_url", arrParams)


	def nic_confirm_existance_url(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("nic_confirm_existance_url", arrParams)


	def subnet_create_from_owned_subnet_pool(self, strNetworkID, objSubne):

		objSubnet = Serializer.serialize(objSubnet)

		arrParams = [
			strNetworkID,
			objSubnet,
		]

		return self.rpc("subnet_create_from_owned_subnet_pool", arrParams)


	def user_franchise_get(self, strUserI):

		arrParams = [
			strUserID,
		]

		return self.rpc("user_franchise_get", arrParams)


	def switch_device_complete_driver_dump(self, nSwitchI):

		arrParams = [
			nSwitchID,
		]

		return self.rpc("switch_device_complete_driver_dump", arrParams)


	def switch_update_database_cache(self, nSwitchI):

		arrParams = [
			nSwitchID,
		]

		return self.rpc("switch_update_database_cache", arrParams)


	def switch_update_database_cache_in_parallel(self):

		arrParams = [
		]

		return self.rpc("switch_update_database_cache_in_parallel", arrParams)


	def cluster_app(self, strClusterID, bAccessSaaSAPI = True, nAccessSaaSAPITimeoutSeconds = 1):

		arrParams = [
			strClusterID,
			bAccessSaaSAPI,
			nAccessSaaSAPITimeoutSeconds,
		]

		return Deserializer.deserialize(self.rpc("cluster_app", arrParams))

	def subnet_pool_prefix_sizes_stats(self, nSubnetPoolI):

		arrParams = [
			nSubnetPoolID,
		]

		return self.rpc("subnet_pool_prefix_sizes_stats", arrParams)


	def subnet_pool_delete(self, nSubnetPoolI):

		arrParams = [
			nSubnetPoolID,
		]

		self.rpc("subnet_pool_delete", arrParams)


	def subnet_pool_update_database_cache(self, nSubnetPoolI):

		arrParams = [
			nSubnetPoolID,
		]

		self.rpc("subnet_pool_update_database_cache", arrParams)


	def subnet_pools_update_database_cache(self):

		arrParams = [
		]

		return self.rpc("subnet_pools_update_database_cache", arrParams)


	def subnet_allocation_conflicts(self):

		arrParams = [
		]

		return self.rpc("subnet_allocation_conflicts", arrParams)


	def datacenter_master(self):

		arrParams = [
		]

		return self.rpc("datacenter_master", arrParams)


	def fs_create(self, strFSURL, strType, strPermission = Non):

		arrParams = [
			strFSURL,
			strType,
			strPermission,
		]

		self.rpc("fs_create", arrParams)


	def fs_delete(self, strFSURL, bRecursive = Fals):

		arrParams = [
			strFSURL,
			bRecursive,
		]

		self.rpc("fs_delete", arrParams)


	def fs_write(self, strFSURL, strContents, strEncoding, nOffset = None, bTruncate = Tru):

		arrParams = [
			strFSURL,
			strContents,
			strEncoding,
			nOffset,
			bTruncate,
		]

		self.rpc("fs_write", arrParams)


	def fs_truncate(self, strFSURL, nLengthNew = ):

		arrParams = [
			strFSURL,
			nLengthNew,
		]

		self.rpc("fs_truncate", arrParams)


	def fs_read(self, strFSURL, strEncoding, nOffset, nLengt):

		arrParams = [
			strFSURL,
			strEncoding,
			nOffset,
			nLength,
		]

		self.rpc("fs_read", arrParams)


	def fs_rename(self, strFSURL, strFilenameNe):

		arrParams = [
			strFSURL,
			strFilenameNew,
		]

		self.rpc("fs_rename", arrParams)


	def fs_info(self, strFSUR):

		arrParams = [
			strFSURL,
		]

		self.rpc("fs_info", arrParams)


	def fs_list(self, strFSUR):

		arrParams = [
			strFSURL,
		]

		self.rpc("fs_list", arrParams)


	def fs_owner_set(self, strFSURL, strOwne):

		arrParams = [
			strFSURL,
			strOwner,
		]

		self.rpc("fs_owner_set", arrParams)


	def fs_move(self, strFSURL, strPathNe):

		arrParams = [
			strFSURL,
			strPathNew,
		]

		self.rpc("fs_move", arrParams)


	def switch_device_iscsi_boot_servers(self, nSwitchDeviceI):

		arrParams = [
			nSwitchDeviceID,
		]

		return self.rpc("switch_device_iscsi_boot_servers", arrParams)


	def storage_pool_iscsi_boot_servers(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return self.rpc("storage_pool_iscsi_boot_servers", arrParams)


	def user_authenticator_has(self, strUserI):

		arrParams = [
			strUserID,
		]

		return self.rpc("user_authenticator_has", arrParams)


	def server_types_datacenter(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("server_types_datacenter", arrParams)


	def data_lake_usage(self):

		arrParams = [
		]

		return self.rpc("data_lake_usage", arrParams)


	def prices_history(self, bExcludeFuturePrices = False, bOnlyActivePrices = Fals):

		arrParams = [
			bExcludeFuturePrices,
			bOnlyActivePrices,
		]

		return self.rpc("prices_history", arrParams)


	def events_expire(self):

		arrParams = [
		]

		self.rpc("events_expire", arrParams)


	def license_vendor_report(self, strLicenseType, strStartTimestamp, strEndTimestamp, objLicenseFilter = Non):

		objLicenseFilter = Serializer.serialize(objLicenseFilter)

		arrParams = [
			strLicenseType,
			strStartTimestamp,
			strEndTimestamp,
			objLicenseFilter,
		]

		return self.rpc("license_vendor_report", arrParams)


	def subnet_pool_available_intervals(self, nSubnetPoolID, bLockRow = Tru):

		arrParams = [
			nSubnetPoolID,
			bLockRow,
		]

		return self.rpc("subnet_pool_available_intervals", arrParams)


	def database_build_000000_sql_url(self):

		arrParams = [
		]

		return self.rpc("database_build_000000_sql_url", arrParams)


	def container_cluster_gui_settings_save(self, strContainerClusterID, objGUIProductSettings, arrPropertyName):

		objGUIProductSettings = Serializer.serialize(objGUIProductSettings)

		arrParams = [
			strContainerClusterID,
			objGUIProductSettings,
			arrPropertyNames,
		]

		self.rpc("container_cluster_gui_settings_save", arrParams)


	def container_cluster_create(self, strInfrastructureID, objContainerCluste):

		objContainerCluster = Serializer.serialize(objContainerCluster)

		arrParams = [
			strInfrastructureID,
			objContainerCluster,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_create", arrParams))

	def container_cluster_get(self, strContainerClusterID, bAccessSaaSAPI = True, nAccessSaaSAPITimeoutSeconds = 1):

		arrParams = [
			strContainerClusterID,
			bAccessSaaSAPI,
			nAccessSaaSAPITimeoutSeconds,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_get", arrParams))

	def container_cluster_edit(self, strContainerClusterID, objContainerClusterOperatio):

		objContainerClusterOperation = Serializer.serialize(objContainerClusterOperation)

		arrParams = [
			strContainerClusterID,
			objContainerClusterOperation,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_edit", arrParams))

	def container_cluster_stop(self, strContainerClusterI):

		arrParams = [
			strContainerClusterID,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_stop", arrParams))

	def container_cluster_start(self, strContainerClusterI):

		arrParams = [
			strContainerClusterID,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_start", arrParams))

	def container_cluster_delete(self, strContainerClusterI):

		arrParams = [
			strContainerClusterID,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_delete", arrParams))

	def container_clusters(self, strInfrastructureID, arrContainerClusterIDs = Non):

		arrParams = [
			strInfrastructureID,
			arrContainerClusterIDs,
		]

		objContainerCluster = self.rpc("container_clusters", arrParams)
		for strKeyContainerCluster in objContainerCluster:
			objContainerCluster[strKeyContainerCluster] = Deserializer.deserialize(objContainerCluster[strKeyContainerCluster])
		return objContainerCluster

	def container_cluster_suspend(self, strContainerClusterI):

		arrParams = [
			strContainerClusterID,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_suspend", arrParams))

	def container_cluster_automatic_management_status_set(self, strContainerClusterID, bStatu):

		arrParams = [
			strContainerClusterID,
			bStatus,
		]

		self.rpc("container_cluster_automatic_management_status_set", arrParams)


	def fs_download_url(self, strFSUR):

		arrParams = [
			strFSURL,
		]

		self.rpc("fs_download_url", arrParams)


	def storage_pool_usage_batch_for_storage_type(self, strDriveStorageType, strDatacenterName, strInfrastructureExperimentalPriority = "disallow", nUserID = Non):

		arrParams = [
			strDriveStorageType,
			strDatacenterName,
			strInfrastructureExperimentalPriority,
			nUserID,
		]

		return self.rpc("storage_pool_usage_batch_for_storage_type", arrParams)


	def user_custom_prices_update(self, nUserID, objUserCustomPrice):

		objUserCustomPrices = Serializer.serialize(objUserCustomPrices)

		arrParams = [
			nUserID,
			objUserCustomPrices,
		]

		self.rpc("user_custom_prices_update", arrParams)


	def user_prices_history(self, strUserID, bExcludeFuturePrices = False, bOnlyActivePrices = False, bExpandWithPrivateDatacenters = Tru):

		arrParams = [
			strUserID,
			bExcludeFuturePrices,
			bOnlyActivePrices,
			bExpandWithPrivateDatacenters,
		]

		return self.rpc("user_prices_history", arrParams)


	def user_prices(self, strUserI):

		arrParams = [
			strUserID,
		]

		return self.rpc("user_prices", arrParams)


	def license_stop(self, nLicenseI):

		arrParams = [
			nLicenseID,
		]

		return self.rpc("license_stop", arrParams)


	def container_clusters_software_version_get(self, arrContainerClusterTypes = [):

		arrParams = [
			arrContainerClusterTypes,
		]

		return self.rpc("container_clusters_software_version_get", arrParams)


	def user_access_level_set(self, nUserID, strAccessLeve):

		arrParams = [
			nUserID,
			strAccessLevel,
		]

		return self.rpc("user_access_level_set", arrParams)


	def afc_queue_asynchronous_archive_and_delete_old(self, nMaxRowsDelete = 5000):

		arrParams = [
			nMaxRowsDelete,
		]

		return self.rpc("afc_queue_asynchronous_archive_and_delete_old", arrParams)


	def afc_queue_non_asynchronous_archive_and_delete_old(self):

		arrParams = [
		]

		self.rpc("afc_queue_non_asynchronous_archive_and_delete_old", arrParams)


	def licenses_non_recurring_stop(self):

		arrParams = [
		]

		return self.rpc("licenses_non_recurring_stop", arrParams)


	def server_type_reservations_stopped_unset_reallocated_server_ids(self):

		arrParams = [
		]

		self.rpc("server_type_reservations_stopped_unset_reallocated_server_ids", arrParams)


	def franchises(self):

		arrParams = [
		]

		return self.rpc("franchises", arrParams)


	def user_password_reveal_set(self, nUserID, strResourceType, bEnable):

		arrParams = [
			nUserID,
			strResourceType,
			bEnabled,
		]

		return self.rpc("user_password_reveal_set", arrParams)


	def user_permissions_config(self, nUserID = Non):

		arrParams = [
			nUserID,
		]

		return self.rpc("user_permissions_config", arrParams)


	def user_password_reveal_has(self, nUserID, strResourceTyp):

		arrParams = [
			nUserID,
			strResourceType,
		]

		return self.rpc("user_password_reveal_has", arrParams)


	def user_update_email_status(self, strUserID, strUserEmailStatu):

		arrParams = [
			strUserID,
			strUserEmailStatus,
		]

		return Deserializer.deserialize(self.rpc("user_update_email_status", arrParams))

	def dns_subdomains_anomalies_fix(self):

		arrParams = [
		]

		self.rpc("dns_subdomains_anomalies_fix", arrParams)


	def server_power_get_batch_datacenter_used(self, strDatacenter, bOnlySANConnecte):

		arrParams = [
			strDatacenter,
			bOnlySANConnected,
		]

		return self.rpc("server_power_get_batch_datacenter_used", arrParams)


	def server_power_set_batch_datacenter_used(self, strDatacenter, strPowerCommand, bThrowIfPowerGetFails = Tru):

		arrParams = [
			strDatacenter,
			strPowerCommand,
			bThrowIfPowerGetFails,
		]

		return self.rpc("server_power_set_batch_datacenter_used", arrParams)


	def port_connect_test(self, strIPAddress, nPort, strClientLibrary = "fsockopen):

		arrParams = [
			strIPAddress,
			nPort,
			strClientLibrary,
		]

		return self.rpc("port_connect_test", arrParams)


	def datacenter_create(self, objDatacenter, objDatacenterConfi):

		objDatacenter = Serializer.serialize(objDatacenter)
		objDatacenterConfig = Serializer.serialize(objDatacenterConfig)

		arrParams = [
			objDatacenter,
			objDatacenterConfig,
		]

		return Deserializer.deserialize(self.rpc("datacenter_create", arrParams))

	def datacenter_maintenance_set(self, strDatacenterName, bMaintenanc):

		arrParams = [
			strDatacenterName,
			bMaintenance,
		]

		self.rpc("datacenter_maintenance_set", arrParams)


	def storage_pool_drive_mappings_recreate(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		self.rpc("storage_pool_drive_mappings_recreate", arrParams)


	def infrastructure_experimental_tags(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("infrastructure_experimental_tags", arrParams)


	def infrastructure_experimental_tag_has(self, nInfrastructureID, strExperimentalTa):

		arrParams = [
			nInfrastructureID,
			strExperimentalTag,
		]

		return self.rpc("infrastructure_experimental_tag_has", arrParams)


	def infrastructure_experimental_tag_add(self, nInfrastructureID, strExperimentalTa):

		arrParams = [
			nInfrastructureID,
			strExperimentalTag,
		]

		return self.rpc("infrastructure_experimental_tag_add", arrParams)


	def infrastructure_experimental_tag_remove(self, nInfrastructureID, strExperimentalTa):

		arrParams = [
			nInfrastructureID,
			strExperimentalTag,
		]

		self.rpc("infrastructure_experimental_tag_remove", arrParams)


	def infrastructures_with_experimental_tag(self, strExperimentalTa):

		arrParams = [
			strExperimentalTag,
		]

		return self.rpc("infrastructures_with_experimental_tag", arrParams)


	def user_experimental_tags(self, nUserI):

		arrParams = [
			nUserID,
		]

		return self.rpc("user_experimental_tags", arrParams)


	def user_experimental_tag_has(self, nUserID, strExperimentalTa):

		arrParams = [
			nUserID,
			strExperimentalTag,
		]

		return self.rpc("user_experimental_tag_has", arrParams)


	def user_experimental_tag_add(self, nUserID, strExperimentalTa):

		arrParams = [
			nUserID,
			strExperimentalTag,
		]

		return self.rpc("user_experimental_tag_add", arrParams)


	def user_experimental_tag_remove(self, nUserID, strExperimentalTa):

		arrParams = [
			nUserID,
			strExperimentalTag,
		]

		self.rpc("user_experimental_tag_remove", arrParams)


	def users_with_experimental_tag(self, strExperimentalTa):

		arrParams = [
			strExperimentalTag,
		]

		return self.rpc("users_with_experimental_tag", arrParams)


	def data_lake_promotion_has(self, nDataLakeID, strPromotionNam):

		arrParams = [
			nDataLakeID,
			strPromotionName,
		]

		return self.rpc("data_lake_promotion_has", arrParams)


	def user_promotion_has(self, nUserID, strPromotionNam):

		arrParams = [
			nUserID,
			strPromotionName,
		]

		return self.rpc("user_promotion_has", arrParams)


	def user_promotion_add(self, nUserID, strPromotionNam):

		arrParams = [
			nUserID,
			strPromotionName,
		]

		return self.rpc("user_promotion_add", arrParams)


	def user_promotion_remove(self, nUserID, strPromotionNam):

		arrParams = [
			nUserID,
			strPromotionName,
		]

		self.rpc("user_promotion_remove", arrParams)


	def data_lake_usage_store(self, nDataLakeI):

		arrParams = [
			nDataLakeID,
		]

		return self.rpc("data_lake_usage_store", arrParams)


	def fs_upload_url(self, strFSUR):

		arrParams = [
			strFSURL,
		]

		return self.rpc("fs_upload_url", arrParams)


	def infrastructure_experimental_tags_allowed(self):

		arrParams = [
		]

		return self.rpc("infrastructure_experimental_tags_allowed", arrParams)


	def user_experimental_tags_allowed(self):

		arrParams = [
		]

		return self.rpc("user_experimental_tags_allowed", arrParams)


	def san_ip_search(self, strDatacenterName, strSearchIPAddres):

		arrParams = [
			strDatacenterName,
			strSearchIPAddress,
		]

		self.rpc("san_ip_search", arrParams)


	def chassis_rack_create(self, objChassisRackDat):

		objChassisRackData = Serializer.serialize(objChassisRackData)

		arrParams = [
			objChassisRackData,
		]

		return self.rpc("chassis_rack_create", arrParams)


	def chassis_rack_get(self, mxChassisRackI):

		mxChassisRackID = Serializer.serialize(mxChassisRackID)

		arrParams = [
			mxChassisRackID,
		]

		return self.rpc("chassis_rack_get", arrParams)


	def chassis_rack_delete(self, nChassisRackI):

		arrParams = [
			nChassisRackID,
		]

		self.rpc("chassis_rack_delete", arrParams)


	def chassis_racks(self, strDatacenter = Non):

		arrParams = [
			strDatacenter,
		]

		return self.rpc("chassis_racks", arrParams)


	def drives_template_usage_report(self, strStartTimestamp, strEndTimestamp, objFilter = Non):

		objFilter = Serializer.serialize(objFilter)

		arrParams = [
			strStartTimestamp,
			strEndTimestamp,
			objFilter,
		]

		return self.rpc("drives_template_usage_report", arrParams)


	def user_limits_update(self, strUserID, objUserLimit):

		objUserLimits = Serializer.serialize(objUserLimits)

		arrParams = [
			strUserID,
			objUserLimits,
		]

		self.rpc("user_limits_update", arrParams)


	def user_limits_default(self):

		arrParams = [
		]

		return Deserializer.deserialize(self.rpc("user_limits_default", arrParams))

	def user_limits_custom(self, strUserI):

		arrParams = [
			strUserID,
		]

		return Deserializer.deserialize(self.rpc("user_limits_custom", arrParams))

	def infrastructure_deploy_slow_afc_report(self, strSinceTimestamp = Non):

		arrParams = [
			strSinceTimestamp,
		]

		return self.rpc("infrastructure_deploy_slow_afc_report", arrParams)


	def json_schema_get(self, strSchem):

		arrParams = [
			strSchema,
		]

		return self.rpc("json_schema_get", arrParams)


	def user_limits(self, strUserI):

		arrParams = [
			strUserID,
		]

		return Deserializer.deserialize(self.rpc("user_limits", arrParams))

	def instance_agent_reboot(self, nInstanceID, bForce, nTimeoutMillisecond):

		arrParams = [
			nInstanceID,
			bForce,
			nTimeoutMilliseconds,
		]

		return self.rpc("instance_agent_reboot", arrParams)


	def instance_agent_shutdown(self, nInstanceID, bForce, nTimeoutMillisecond):

		arrParams = [
			nInstanceID,
			bForce,
			nTimeoutMilliseconds,
		]

		return self.rpc("instance_agent_shutdown", arrParams)


	def instance_agent_process_exit(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("instance_agent_process_exit", arrParams)


	def instance_agent_test(self, nInstanceID, nSleepSeconds = ):

		arrParams = [
			nInstanceID,
			nSleepSeconds,
		]

		return self.rpc("instance_agent_test", arrParams)


	def users_for_tickets_impersonated_create(self, arrDatacenterLabels, arrSwitchDeviceIDs, arrStoragePoolIDs, bIncludeDataLake, bOnlyWithWAN, arrExtraUserIDs, arrExtraUserEmails, bCCDelegates, bCCInfrastructureAdmin):

		arrParams = [
			arrDatacenterLabels,
			arrSwitchDeviceIDs,
			arrStoragePoolIDs,
			bIncludeDataLake,
			bOnlyWithWAN,
			arrExtraUserIDs,
			arrExtraUserEmails,
			bCCDelegates,
			bCCInfrastructureAdmins,
		]

		return self.rpc("users_for_tickets_impersonated_create", arrParams)


	def user_convert_passwords_now(self):

		arrParams = [
		]

		self.rpc("user_convert_passwords_now", arrParams)


	def instance_agent_update(self, nInstanceID, strUpdateUR):

		arrParams = [
			nInstanceID,
			strUpdateURL,
		]

		return self.rpc("instance_agent_update", arrParams)


	def server_type_boot_type_edit(self, strServerTypeID, strServerTypeBootTyp):

		arrParams = [
			strServerTypeID,
			strServerTypeBootType,
		]

		return self.rpc("server_type_boot_type_edit", arrParams)


	def volume_template_boot_type_edit(self, nVolumeTemplateID, strVolumeTemplateBootTyp):

		arrParams = [
			nVolumeTemplateID,
			strVolumeTemplateBootType,
		]

		self.rpc("volume_template_boot_type_edit", arrParams)


	def volume_template_os_local_disk_clone_function_name_edit(self, nVolumeTemplateID, mxVolumeTemplateOSLocalDiskCloneFunctionName = Non):

		mxVolumeTemplateOSLocalDiskCloneFunctionName = Serializer.serialize(mxVolumeTemplateOSLocalDiskCloneFunctionName)

		arrParams = [
			nVolumeTemplateID,
			mxVolumeTemplateOSLocalDiskCloneFunctionName,
		]

		self.rpc("volume_template_os_local_disk_clone_function_name_edit", arrParams)


	def volume_template_storage_pool_create_from_repo(self, strVolumeTemplateRepoBaseURL, nStoragePoolID, bCreateTemplateIfNotExist):

		arrParams = [
			strVolumeTemplateRepoBaseURL,
			nStoragePoolID,
			bCreateTemplateIfNotExists,
		]

		self.rpc("volume_template_storage_pool_create_from_repo", arrParams)


	def volume_templates_repo_catalog_get(self, strCatalogUR):

		arrParams = [
			strCatalogURL,
		]

		objVolumeTemplate = self.rpc("volume_templates_repo_catalog_get", arrParams)
		for strKeyVolumeTemplate in objVolumeTemplate:
			objVolumeTemplate[strKeyVolumeTemplate] = Deserializer.deserialize(objVolumeTemplate[strKeyVolumeTemplate])
		return objVolumeTemplate

	def volume_templates_repo_catalog_urls(self):

		arrParams = [
		]

		return self.rpc("volume_templates_repo_catalog_urls", arrParams)


	def drive_provision(self, nDriveID, strStage, objOptions = [):

		objOptions = Serializer.serialize(objOptions)

		arrParams = [
			nDriveID,
			strStage,
			objOptions,
		]

		self.rpc("drive_provision", arrParams)


	def volume_templates_populate_from_catalogs(self, arrCatalogURLs = Non):

		arrParams = [
			arrCatalogURLs,
		]

		self.rpc("volume_templates_populate_from_catalogs", arrParams)


	def volume_template_create_empty(self, objVolumeTemplat):

		objVolumeTemplate = Serializer.serialize(objVolumeTemplate)

		arrParams = [
			objVolumeTemplate,
		]

		return Deserializer.deserialize(self.rpc("volume_template_create_empty", arrParams))

	def instance_monitoring_data_get(self, nInstanceID, nGranularityMinutes = 1, strTimestampStart = None, strTimestampEnd = Non):

		arrParams = [
			nInstanceID,
			nGranularityMinutes,
			strTimestampStart,
			strTimestampEnd,
		]

		return self.rpc("instance_monitoring_data_get", arrParams)


	def instance_array_monitoring_data_get(self, nInstanceArrayID, nGranularityMinutes = 1, strTimestampStart = None, strTimestampEnd = Non):

		arrParams = [
			nInstanceArrayID,
			nGranularityMinutes,
			strTimestampStart,
			strTimestampEnd,
		]

		return self.rpc("instance_array_monitoring_data_get", arrParams)


	def container_platform_monitoring_data_get(self, nContainerPlatformID, nGranularityMinutes = 1, strTimestampStart = None, strTimestampEnd = Non):

		arrParams = [
			nContainerPlatformID,
			nGranularityMinutes,
			strTimestampStart,
			strTimestampEnd,
		]

		return self.rpc("container_platform_monitoring_data_get", arrParams)


	def user_test_account_set(self, nUserID, bUserIsTestAccoun):

		arrParams = [
			nUserID,
			bUserIsTestAccount,
		]

		self.rpc("user_test_account_set", arrParams)


	def user_exclude_from_reports_set(self, nUserID, bUserExcludeFromReport):

		arrParams = [
			nUserID,
			bUserExcludeFromReports,
		]

		self.rpc("user_exclude_from_reports_set", arrParams)


	def secure_gateway_config_refresh(self, nSecureGatewayID, bUploadNewConfig = Tru):

		arrParams = [
			nSecureGatewayID,
			bUploadNewConfig,
		]

		self.rpc("secure_gateway_config_refresh", arrParams)


	def secure_gateway_proxy_add(self, proxy, strDatacenterName, nFrontendPor):

		proxy = Serializer.serialize(proxy)

		arrParams = [
			proxy,
			strDatacenterName,
			nFrontendPort,
		]

		self.rpc("secure_gateway_proxy_add", arrParams)


	def licenses_recurring_cycle_extend(self):

		arrParams = [
		]

		self.rpc("licenses_recurring_cycle_extend", arrParams)


	def licenses_expired(self, bRecurrin):

		arrParams = [
			bRecurring,
		]

		return self.rpc("licenses_expired", arrParams)


	def license_recurring_extend(self, nLicenseI):

		arrParams = [
			nLicenseID,
		]

		return self.rpc("license_recurring_extend", arrParams)


	def secure_gateway_proxy_remove(self, nDestinationID, strDiscriminato):

		arrParams = [
			nDestinationID,
			strDiscriminator,
		]

		self.rpc("secure_gateway_proxy_remove", arrParams)


	def secure_gateway_proxy_remove_by_id(self, nI):

		arrParams = [
			nID,
		]

		self.rpc("secure_gateway_proxy_remove_by_id", arrParams)


	def secure_gateway_proxy_update(self, nID, prox):

		proxy = Serializer.serialize(proxy)

		arrParams = [
			nID,
			proxy,
		]

		self.rpc("secure_gateway_proxy_update", arrParams)


	def data_lake_core_site_conf_download_url(self, strUserID, nDataLakeI):

		arrParams = [
			strUserID,
			nDataLakeID,
		]

		return self.rpc("data_lake_core_site_conf_download_url", arrParams)


	def drive_reservation_create(self, strUserID, objReservatio):

		objReservation = Serializer.serialize(objReservation)

		arrParams = [
			strUserID,
			objReservation,
		]

		return Deserializer.deserialize(self.rpc("drive_reservation_create", arrParams))

	def drive_reservation_get(self, nDriveReservationI):

		arrParams = [
			nDriveReservationID,
		]

		return Deserializer.deserialize(self.rpc("drive_reservation_get", arrParams))

	def drive_reservation_edit(self, nDriveReservationID, objDriveReservatio):

		objDriveReservation = Serializer.serialize(objDriveReservation)

		arrParams = [
			nDriveReservationID,
			objDriveReservation,
		]

		return Deserializer.deserialize(self.rpc("drive_reservation_edit", arrParams))

	def user_drive_reservations(self, strUserID, strUserPlanType = Non):

		arrParams = [
			strUserID,
			strUserPlanType,
		]

		arrDriveReservations = self.rpc("user_drive_reservations", arrParams)
		for index in range(len(arrDriveReservations)):
			arrDriveReservations[index] = Deserializer.deserialize(arrDriveReservations[index])
		return arrDriveReservations

	def drive_reservation_plan_type_change(self, nDriveReservationID, strNewUserPlanTyp):

		arrParams = [
			nDriveReservationID,
			strNewUserPlanType,
		]

		return Deserializer.deserialize(self.rpc("drive_reservation_plan_type_change", arrParams))

	def subnet_reservation_create(self, strUserID, objReservatio):

		objReservation = Serializer.serialize(objReservation)

		arrParams = [
			strUserID,
			objReservation,
		]

		return Deserializer.deserialize(self.rpc("subnet_reservation_create", arrParams))

	def subnet_reservation_get(self, nSubnetReservationI):

		arrParams = [
			nSubnetReservationID,
		]

		return Deserializer.deserialize(self.rpc("subnet_reservation_get", arrParams))

	def subnet_reservation_edit(self, nSubnetReservationID, objSubnetReservatio):

		objSubnetReservation = Serializer.serialize(objSubnetReservation)

		arrParams = [
			nSubnetReservationID,
			objSubnetReservation,
		]

		return Deserializer.deserialize(self.rpc("subnet_reservation_edit", arrParams))

	def user_subnet_reservations(self, strUserID, strUserPlanType = Non):

		arrParams = [
			strUserID,
			strUserPlanType,
		]

		arrSubnetReservations = self.rpc("user_subnet_reservations", arrParams)
		for index in range(len(arrSubnetReservations)):
			arrSubnetReservations[index] = Deserializer.deserialize(arrSubnetReservations[index])
		return arrSubnetReservations

	def subnet_reservation_plan_type_change(self, nSubnetReservationID, strNewUserPlanTyp):

		arrParams = [
			nSubnetReservationID,
			strNewUserPlanType,
		]

		return Deserializer.deserialize(self.rpc("subnet_reservation_plan_type_change", arrParams))

	def bdk_agent_reboot(self, nServerID, bForce, nTimeoutMillisecond):

		arrParams = [
			nServerID,
			bForce,
			nTimeoutMilliseconds,
		]

		return self.rpc("bdk_agent_reboot", arrParams)


	def bdk_agent_shutdown(self, nServerID, bForce, nTimeoutMillisecond):

		arrParams = [
			nServerID,
			bForce,
			nTimeoutMilliseconds,
		]

		self.rpc("bdk_agent_shutdown", arrParams)


	def bdk_agent_process_exit(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("bdk_agent_process_exit", arrParams)


	def bdk_agent_test(self, nServerID, nSleepSecond):

		arrParams = [
			nServerID,
			nSleepSeconds,
		]

		return self.rpc("bdk_agent_test", arrParams)


	def user_licenses_unused(self, nUserID, strLicenseType = None, objLicensePropertiesFilter = None, strForTimestamp = None, bSelectForUpdate = Fals):

		objLicensePropertiesFilter = Serializer.serialize(objLicensePropertiesFilter)

		arrParams = [
			nUserID,
			strLicenseType,
			objLicensePropertiesFilter,
			strForTimestamp,
			bSelectForUpdate,
		]

		return self.rpc("user_licenses_unused", arrParams)


	def container_get(self, strContainerI):

		arrParams = [
			strContainerID,
		]

		return Deserializer.deserialize(self.rpc("container_get", arrParams))

	def containers(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		objContainer = self.rpc("containers", arrParams)
		for strKeyContainer in objContainer:
			objContainer[strKeyContainer] = Deserializer.deserialize(objContainer[strKeyContainer])
		return objContainer

	def container_drives(self, strContainerI):

		arrParams = [
			strContainerID,
		]

		objDrive = self.rpc("container_drives", arrParams)
		for strKeyDrive in objDrive:
			objDrive[strKeyDrive] = Deserializer.deserialize(objDrive[strKeyDrive])
		return objDrive

	def container_array_shared_drives(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		return self.rpc("container_array_shared_drives", arrParams)


	def container_logs(self, strContainerID, strSinceTimestamp = None, nLimitBytes = Non):

		arrParams = [
			strContainerID,
			strSinceTimestamp,
			nLimitBytes,
		]

		return self.rpc("container_logs", arrParams)


	def container_interface_get(self, nContainerInterfaceI):

		arrParams = [
			nContainerInterfaceID,
		]

		return Deserializer.deserialize(self.rpc("container_interface_get", arrParams))

	def storage_pool_user_set(self, nStoragePoolID, nUserID = Non):

		arrParams = [
			nStoragePoolID,
			nUserID,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_user_set", arrParams))

	def dataset_create(self, strUserID, nTemporaryUploadID, objDatase):

		objDataset = Serializer.serialize(objDataset)

		arrParams = [
			strUserID,
			nTemporaryUploadID,
			objDataset,
		]

		return Deserializer.deserialize(self.rpc("dataset_create", arrParams))

	def dataset_edit(self, nDatasetID, nTemporaryUploadID, objChangedDatase):

		objChangedDataset = Serializer.serialize(objChangedDataset)

		arrParams = [
			nDatasetID,
			nTemporaryUploadID,
			objChangedDataset,
		]

		return self.rpc("dataset_edit", arrParams)


	def dataset_delete(self, nDatasetI):

		arrParams = [
			nDatasetID,
		]

		self.rpc("dataset_delete", arrParams)


	def dataset_subscription_create(self, strUserIDOwner, datasetI):

		arrParams = [
			strUserIDOwner,
			datasetID,
		]

		return Deserializer.deserialize(self.rpc("dataset_subscription_create", arrParams))

	def dataset_subscription_delete(self, strUserIDOwner, nDatasetSubscriptionI):

		arrParams = [
			strUserIDOwner,
			nDatasetSubscriptionID,
		]

		self.rpc("dataset_subscription_delete", arrParams)


	def user_dataset_subscriptions(self, strUserIDOwne):

		arrParams = [
			strUserIDOwner,
		]

		arrDatasetSubscriptions = self.rpc("user_dataset_subscriptions", arrParams)
		for index in range(len(arrDatasetSubscriptions)):
			arrDatasetSubscriptions[index] = Deserializer.deserialize(arrDatasetSubscriptions[index])
		return arrDatasetSubscriptions

	def container_cluster_app(self, strContainerClusterID, bAccessSaaSAPI = True, nAccessSaaSAPITimeoutSeconds = 1):

		arrParams = [
			strContainerClusterID,
			bAccessSaaSAPI,
			nAccessSaaSAPITimeoutSeconds,
		]

		return Deserializer.deserialize(self.rpc("container_cluster_app", arrParams))

	def hdfs_cluster_app(self, strDatacenter = Non):

		arrParams = [
			strDatacenter,
		]

		return Deserializer.deserialize(self.rpc("hdfs_cluster_app", arrParams))

	def storage_pool_drive_priority_set(self, nStoragePoolID, nStoragePoolDrivePriorit):

		arrParams = [
			nStoragePoolID,
			nStoragePoolDrivePriority,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_drive_priority_set", arrParams))

	def storage_pool_shared_drive_priority_set(self, nStoragePoolID, nStoragePoolSharedDrivePriorit):

		arrParams = [
			nStoragePoolID,
			nStoragePoolSharedDrivePriority,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_shared_drive_priority_set", arrParams))

	def container_array_drive_arrays(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		objDriveArray = self.rpc("container_array_drive_arrays", arrParams)
		for strKeyDriveArray in objDriveArray:
			objDriveArray[strKeyDriveArray] = Deserializer.deserialize(objDriveArray[strKeyDriveArray])
		return objDriveArray

	def server_dhcp_status_update(self, nServerID, strServerDHCPStatu):

		arrParams = [
			nServerID,
			strServerDHCPStatus,
		]

		return self.rpc("server_dhcp_status_update", arrParams)


	def drive_attach_container(self, strDriveID, strContainerI):

		arrParams = [
			strDriveID,
			strContainerID,
		]

		return Deserializer.deserialize(self.rpc("drive_attach_container", arrParams))

	def drive_detach_container(self, strDriveI):

		arrParams = [
			strDriveID,
		]

		return Deserializer.deserialize(self.rpc("drive_detach_container", arrParams))

	def license_reactivate(self, nLicenseI):

		arrParams = [
			nLicenseID,
		]

		return self.rpc("license_reactivate", arrParams)


	def server_decomission(self, nServerID, bSkipIPMI = Tru):

		arrParams = [
			nServerID,
			bSkipIPMI,
		]

		self.rpc("server_decomission", arrParams)


	def cluster_internal_admin_credentials_get(self, nClusterID = Non):

		arrParams = [
			nClusterID,
		]

		return self.rpc("cluster_internal_admin_credentials_get", arrParams)


	def container_platform_information_internal(self, nContainerPlatformI):

		arrParams = [
			nContainerPlatformID,
		]

		return self.rpc("container_platform_information_internal", arrParams)


	def dataset_get(self, publishedDatasetI):

		arrParams = [
			publishedDatasetID,
		]

		return Deserializer.deserialize(self.rpc("dataset_get", arrParams))

	def infrastructure_deploy_changes(self, nInfrastructureDeployI):

		arrParams = [
			nInfrastructureDeployID,
		]

		return self.rpc("infrastructure_deploy_changes", arrParams)


	def license_vendor_report_xls_download_url(self, strLicenseType, strStartTimestamp, strEndTimestamp, objLicenseFilter = Non):

		arrParams = [
			strLicenseType,
			strStartTimestamp,
			strEndTimestamp,
			objLicenseFilter,
		]

		return self.rpc("license_vendor_report_xls_download_url", arrParams)


	def datacenter_get(self, strUserID, strDatacenterNam):

		arrParams = [
			strUserID,
			strDatacenterName,
		]

		return Deserializer.deserialize(self.rpc("datacenter_get", arrParams))

	def datastore_publisher_create(self, nPublisherUserI):

		arrParams = [
			nPublisherUserID,
		]

		self.rpc("datastore_publisher_create", arrParams)


	def datastore_publisher_delete(self, nDatastorePublisherI):

		arrParams = [
			nDatastorePublisherID,
		]

		self.rpc("datastore_publisher_delete", arrParams)


	def datacenter_names_internal(self, bIncludeMaster = Fals):

		arrParams = [
			bIncludeMaster,
		]

		return self.rpc("datacenter_names_internal", arrParams)


	def thresholds(self, strUserIDOwne):

		arrParams = [
			strUserIDOwner,
		]

		arrThresholds = self.rpc("thresholds", arrParams)
		for index in range(len(arrThresholds)):
			arrThresholds[index] = Deserializer.deserialize(arrThresholds[index])
		return arrThresholds

	def threshold_delete(self, nThresholdI):

		arrParams = [
			nThresholdID,
		]

		self.rpc("threshold_delete", arrParams)


	def threshold_get(self, nThresholdI):

		arrParams = [
			nThresholdID,
		]

		return Deserializer.deserialize(self.rpc("threshold_get", arrParams))

	def license_types_for_volume_template(self, strVolumeTemplateI):

		arrParams = [
			strVolumeTemplateID,
		]

		return self.rpc("license_types_for_volume_template", arrParams)


	def support_ticket_options(self, strUserLanguag):

		arrParams = [
			strUserLanguage,
		]

		return self.rpc("support_ticket_options", arrParams)


	def user_get_brand(self, nUserI):

		arrParams = [
			nUserID,
		]

		return self.rpc("user_get_brand", arrParams)


	def datacenter_config(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("datacenter_config", arrParams)


	def user_set_brand(self, nUserID, strUserBran):

		arrParams = [
			nUserID,
			strUserBrand,
		]

		return self.rpc("user_set_brand", arrParams)


	def user_set_is_brand_manager(self, nUserID, bUserIsBrandManage):

		arrParams = [
			nUserID,
			bUserIsBrandManager,
		]

		return self.rpc("user_set_is_brand_manager", arrParams)


	def datacenter_datasets(self, strDatacenterLabe):

		arrParams = [
			strDatacenterLabel,
		]

		arrDatasets = self.rpc("datacenter_datasets", arrParams)
		for index in range(len(arrDatasets)):
			arrDatasets[index] = Deserializer.deserialize(arrDatasets[index])
		return arrDatasets

	def user_datasets_managed(self, strUserIDOwne):

		arrParams = [
			strUserIDOwner,
		]

		return self.rpc("user_datasets_managed", arrParams)


	def datastore_publishers(self):

		arrParams = [
		]

		self.rpc("datastore_publishers", arrParams)


	def datacenter_config_update(self, strDatacenterName, objDatacenterConfi):

		objDatacenterConfig = Serializer.serialize(objDatacenterConfig)

		arrParams = [
			strDatacenterName,
			objDatacenterConfig,
		]

		self.rpc("datacenter_config_update", arrParams)


	def ip_custom_reverse_records(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return self.rpc("ip_custom_reverse_records", arrParams)


	def ip_custom_reverse_record_remove(self, strInfrastructureID, strIPAddres):

		arrParams = [
			strInfrastructureID,
			strIPAddress,
		]

		self.rpc("ip_custom_reverse_record_remove", arrParams)


	def ip_custom_reverse_record_add(self, strInfrastructureID, strIPAddress, strSubdomainName, strRootDomai):

		arrParams = [
			strInfrastructureID,
			strIPAddress,
			strSubdomainName,
			strRootDomain,
		]

		self.rpc("ip_custom_reverse_record_add", arrParams)


	def container_status(self, strContainerI):

		arrParams = [
			strContainerID,
		]

		return Deserializer.deserialize(self.rpc("container_status", arrParams))

	def container_array_status(self, strContainerArrayI):

		arrParams = [
			strContainerArrayID,
		]

		return Deserializer.deserialize(self.rpc("container_array_status", arrParams))

	def cloudinit_json_get_url_generation(self, nDriveI):

		arrParams = [
			nDriveID,
		]

		return self.rpc("cloudinit_json_get_url_generation", arrParams)


	def cloudinit_json_get_server_url_generation(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("cloudinit_json_get_server_url_generation", arrParams)


	def cloudinit_json_get_instance_url_generation(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("cloudinit_json_get_instance_url_generation", arrParams)


	def instance_agent_bonding_configure(self, nInstanceID, strBondName, arrVLANConfiguration):

		arrParams = [
			nInstanceID,
			strBondName,
			arrVLANConfigurations,
		]

		return self.rpc("instance_agent_bonding_configure", arrParams)


	def instance_agent_vlan_add(self, nInstanceID, objVLANConfi):

		objVLANConfig = Serializer.serialize(objVLANConfig)

		arrParams = [
			nInstanceID,
			objVLANConfig,
		]

		return self.rpc("instance_agent_vlan_add", arrParams)


	def instance_agent_vlan_remove(self, nInstanceID, strVLANName, strBondNam):

		arrParams = [
			nInstanceID,
			strVLANName,
			strBondName,
		]

		return self.rpc("instance_agent_vlan_remove", arrParams)


	def instance_agent_network_interface_enable(self, nInstanceID, strNetworkInterfac):

		arrParams = [
			nInstanceID,
			strNetworkInterface,
		]

		return self.rpc("instance_agent_network_interface_enable", arrParams)


	def instance_agent_network_interface_disable(self, nInstanceID, strNetworkInterfac):

		arrParams = [
			nInstanceID,
			strNetworkInterface,
		]

		return self.rpc("instance_agent_network_interface_disable", arrParams)


	def subnet_reservation_billing_day_change(self, nSubnetReservationID, nBillingDa):

		arrParams = [
			nSubnetReservationID,
			nBillingDay,
		]

		self.rpc("subnet_reservation_billing_day_change", arrParams)


	def subnet_reservation_billing_day_change_all_active(self, nBillingDa):

		arrParams = [
			nBillingDay,
		]

		self.rpc("subnet_reservation_billing_day_change_all_active", arrParams)


	def server_type_reservation_billing_day_change(self, nServerTypeReservationID, nBillingDa):

		arrParams = [
			nServerTypeReservationID,
			nBillingDay,
		]

		self.rpc("server_type_reservation_billing_day_change", arrParams)


	def server_type_reservation_billing_day_change_all_active(self, nBillingDa):

		arrParams = [
			nBillingDay,
		]

		self.rpc("server_type_reservation_billing_day_change_all_active", arrParams)


	def volume_template_deprecation_status_edit(self, nVolumeTemplateID, strVolumeTemplateDeprecationStatu):

		arrParams = [
			nVolumeTemplateID,
			strVolumeTemplateDeprecationStatus,
		]

		self.rpc("volume_template_deprecation_status_edit", arrParams)


	def drive_reservation_billing_day_change(self, nDriveReservationID, nBillingDa):

		arrParams = [
			nDriveReservationID,
			nBillingDay,
		]

		self.rpc("drive_reservation_billing_day_change", arrParams)


	def drive_reservation_billing_day_change_all_active(self, nBillingDa):

		arrParams = [
			nBillingDay,
		]

		self.rpc("drive_reservation_billing_day_change_all_active", arrParams)


	def dataset_datapackage_get(self, nDatasetI):

		arrParams = [
			nDatasetID,
		]

		return Deserializer.deserialize(self.rpc("dataset_datapackage_get", arrParams))

	def datastore_publisher_get(self, nPublisherUserI):

		arrParams = [
			nPublisherUserID,
		]

		self.rpc("datastore_publisher_get", arrParams)


	def dataset_publish(self, nDatasetI):

		arrParams = [
			nDatasetID,
		]

		self.rpc("dataset_publish", arrParams)


	def dataset_unpublish(self, nDatasetI):

		arrParams = [
			nDatasetID,
		]

		self.rpc("dataset_unpublish", arrParams)


	def email_send_custom_batch(self, strEmailsTableName, strLanguageCode, strSubject, strHTMLBodyCustomPart, nAtLeastSentCounter = ):

		arrParams = [
			strEmailsTableName,
			strLanguageCode,
			strSubject,
			strHTMLBodyCustomPart,
			nAtLeastSentCounter,
		]

		return self.rpc("email_send_custom_batch", arrParams)


	def server_current_boot_type_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_current_boot_type_get", arrParams)


	def instance_agent_self_reset(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("instance_agent_self_reset", arrParams)


	def instance_agent_persistent_logging_enable(self, nInstanceID, bEnable):

		arrParams = [
			nInstanceID,
			bEnabled,
		]

		return self.rpc("instance_agent_persistent_logging_enable", arrParams)


	def cloudinit_json_get_for_drive(self, nDriveI):

		arrParams = [
			nDriveID,
		]

		return self.rpc("cloudinit_json_get_for_drive", arrParams)


	def cloudinit_json_get_for_server(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("cloudinit_json_get_for_server", arrParams)


	def cloudinit_json_get_for_instance(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("cloudinit_json_get_for_instance", arrParams)


	def infrastructure_agent_allowed_set(self, nInfrastructureID, bIsAllowe):

		arrParams = [
			nInfrastructureID,
			bIsAllowed,
		]

		self.rpc("infrastructure_agent_allowed_set", arrParams)


	def dhcp_ipxe_batch(self, nServerID, bDebugMode = Fals):

		arrParams = [
			nServerID,
			bDebugMode,
		]

		return self.rpc("dhcp_ipxe_batch", arrParams)


	def production_config_secret_public_key(self, strProductionPrivateKeyVersion = Non):

		arrParams = [
			strProductionPrivateKeyVersion,
		]

		return self.rpc("production_config_secret_public_key", arrParams)


	def production_config_secret_private_key_version(self):

		arrParams = [
		]

		return self.rpc("production_config_secret_private_key_version", arrParams)


	def password_decrypt(self, strCiphe):

		arrParams = [
			strCipher,
		]

		return self.rpc("password_decrypt", arrParams)


	def dhcp_regenerate(self, arrServerIDs = None, bRegeneratedCloudInit = True, bRegenerateIPXE = True, arrDatacenterNames = Non):

		arrParams = [
			arrServerIDs,
			bRegeneratedCloudInit,
			bRegenerateIPXE,
			arrDatacenterNames,
		]

		self.rpc("dhcp_regenerate", arrParams)


	def switch_device_update(self, nNetworkEquipmentID, objNetworkEquipmentData, bOverwriteWithHostnameFromFetchedSwitc):

		objNetworkEquipmentData = Serializer.serialize(objNetworkEquipmentData)

		arrParams = [
			nNetworkEquipmentID,
			objNetworkEquipmentData,
			bOverwriteWithHostnameFromFetchedSwitch,
		]

		return self.rpc("switch_device_update", arrParams)


	def instance_agent_iscsi_setup_and_login(self, nInstanceID, arrNodeInformatio):

		arrParams = [
			nInstanceID,
			arrNodeInformation,
		]

		return self.rpc("instance_agent_iscsi_setup_and_login", arrParams)


	def datacenter_agents_config_json_download_url(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("datacenter_agents_config_json_download_url", arrParams)


	def datacenter_keys_rotate_new(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		self.rpc("datacenter_keys_rotate_new", arrParams)


	def datacenter_keys_destroy_index_with_possible_data_loss(self, strDatacenterName, strKeyIndexToDestro):

		arrParams = [
			strDatacenterName,
			strKeyIndexToDestroy,
		]

		self.rpc("datacenter_keys_destroy_index_with_possible_data_loss", arrParams)


	def datacenter_keys_compromised_flag_set(self, strDatacenterName, strCompromisedKeyIndex, bCompromised = Tru):

		arrParams = [
			strDatacenterName,
			strCompromisedKeyIndex,
			bCompromised,
		]

		self.rpc("datacenter_keys_compromised_flag_set", arrParams)


	def afc_group_get(self, nAFCGroupI):

		arrParams = [
			nAFCGroupID,
		]

		return self.rpc("afc_group_get", arrParams)


	def afc_groups(self, arrTypes = [], objContext = [], strCreatedTimestamp = None, strFinishedTimestamp = Non):

		objContext = Serializer.serialize(objContext)

		arrParams = [
			arrTypes,
			objContext,
			strCreatedTimestamp,
			strFinishedTimestamp,
		]

		return self.rpc("afc_groups", arrParams)


	def afc_group_entries(self, nAFCGroupI):

		arrParams = [
			nAFCGroupID,
		]

		return self.rpc("afc_group_entries", arrParams)


	def afc_groups_archive_finished(self, nLimitOverride = Non):

		arrParams = [
			nLimitOverride,
		]

		self.rpc("afc_groups_archive_finished", arrParams)


	def dhcpserver_agent_rules_updated(self, nAgentID, bInvalidateEntireConfig = Fals):

		arrParams = [
			nAgentID,
			bInvalidateEntireConfig,
		]

		self.rpc("dhcpserver_agent_rules_updated", arrParams)


	def server_type_allowed_vendor_sku_ids(self, nServerTypeI):

		arrParams = [
			nServerTypeID,
		]

		return self.rpc("server_type_allowed_vendor_sku_ids", arrParams)


	def server_type_allowed_vendor_sku_id_has(self, nServerTypeID, strServerVendorSKUI):

		arrParams = [
			nServerTypeID,
			strServerVendorSKUID,
		]

		return self.rpc("server_type_allowed_vendor_sku_id_has", arrParams)


	def server_type_allowed_vendor_sku_id_add(self, nServerTypeID, strServerVendorSKUI):

		arrParams = [
			nServerTypeID,
			strServerVendorSKUID,
		]

		return self.rpc("server_type_allowed_vendor_sku_id_add", arrParams)


	def server_type_allowed_vendor_sku_id_remove(self, nServerTypeID, strServerVendorSKUI):

		arrParams = [
			nServerTypeID,
			strServerVendorSKUID,
		]

		self.rpc("server_type_allowed_vendor_sku_id_remove", arrParams)


	def server_types_with_allowed_vendor_sku_id(self, strServerVendorSKUI):

		arrParams = [
			strServerVendorSKUID,
		]

		return self.rpc("server_types_with_allowed_vendor_sku_id", arrParams)


	def datacenter_agent_process_exit(self, nAgentID, strAgentTyp):

		arrParams = [
			nAgentID,
			strAgentType,
		]

		return self.rpc("datacenter_agent_process_exit", arrParams)


	def server_instance_oob_allowed_ips(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return self.rpc("server_instance_oob_allowed_ips", arrParams)


	def server_instance_oob_allow_ip(self, strInstanceID, strAllowedI):

		arrParams = [
			strInstanceID,
			strAllowedIP,
		]

		self.rpc("server_instance_oob_allow_ip", arrParams)


	def server_instance_oob_disallow_ip(self, strInstanceID, strDisallowedI):

		arrParams = [
			strInstanceID,
			strDisallowedIP,
		]

		self.rpc("server_instance_oob_disallow_ip", arrParams)


	def instance_windows_internal_management_credentials_get(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		return self.rpc("instance_windows_internal_management_credentials_get", arrParams)


	def server_oob_allow_ip(self, nServerID, strAllowedI):

		arrParams = [
			nServerID,
			strAllowedIP,
		]

		self.rpc("server_oob_allow_ip", arrParams)


	def server_oob_disallow_ip(self, nServerID, strAllowedI):

		arrParams = [
			nServerID,
			strAllowedIP,
		]

		self.rpc("server_oob_disallow_ip", arrParams)


	def server_oob_allowed_ips(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_oob_allowed_ips", arrParams)


	def firewall_reprovision_without_deploy(self, arrInstanceIDs = [], arrInstanceArrayIDs = [], arrInfrastructureIDs = [], strDatacenterName = None, bAllInstances = False, nMaxInstances = 1):

		arrParams = [
			arrInstanceIDs,
			arrInstanceArrayIDs,
			arrInfrastructureIDs,
			strDatacenterName,
			bAllInstances,
			nMaxInstances,
		]

		return self.rpc("firewall_reprovision_without_deploy", arrParams)


	def instance_array_force_unmanage_firewall(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return self.rpc("instance_array_force_unmanage_firewall", arrParams)


	def instance_agent_config_json_download_url(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return self.rpc("instance_agent_config_json_download_url", arrParams)


	def instance_keys_rotate_new(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return self.rpc("instance_keys_rotate_new", arrParams)


	def instance_keys_destroy_index_with_possible_data_loss(self, strInstanceID, strKeyIndexToDestro):

		arrParams = [
			strInstanceID,
			strKeyIndexToDestroy,
		]

		self.rpc("instance_keys_destroy_index_with_possible_data_loss", arrParams)


	def instance_keys_compromised_flag_set(self, strInstanceID, strCompromisedKeyIndex, bCompromised = Tru):

		arrParams = [
			strInstanceID,
			strCompromisedKeyIndex,
			bCompromised,
		]

		self.rpc("instance_keys_compromised_flag_set", arrParams)


	def secure_gateway_add(self, strDomain, strVRRPIP, strDatacenterName, arrPeers, strSSLCrtPath, strSSLCAPath = None, arrReservedPorts = [):

		arrParams = [
			strDomain,
			strVRRPIP,
			strDatacenterName,
			arrPeers,
			strSSLCrtPath,
			strSSLCAPath,
			arrReservedPorts,
		]

		return Deserializer.deserialize(self.rpc("secure_gateway_add", arrParams))

	def instance_array_drive_arrays(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		objDriveArray = self.rpc("instance_array_drive_arrays", arrParams)
		for strKeyDriveArray in objDriveArray:
			objDriveArray[strKeyDriveArray] = Deserializer.deserialize(objDriveArray[strKeyDriveArray])
		return objDriveArray

	def infrastructure_lan_subnet_pools_available(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("infrastructure_lan_subnet_pools_available", arrParams)


	def infrastructure_lan_subnet_prefix_sizes_available(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("infrastructure_lan_subnet_prefix_sizes_available", arrParams)


	def afc_mark_for_death(self, nAFCID, strTypeOfMar):

		arrParams = [
			nAFCID,
			strTypeOfMark,
		]

		self.rpc("afc_mark_for_death", arrParams)


	def afc_get_process_info(self, nAFCI):

		arrParams = [
			nAFCID,
		]

		return self.rpc("afc_get_process_info", arrParams)


	def agent_version_build_and_upload(self, strRevision = "master", strRemoteRepositoryFolder = "releases):

		arrParams = [
			strRevision,
			strRemoteRepositoryFolder,
		]

		self.rpc("agent_version_build_and_upload", arrParams)


	def agent_version_default_set(self, strVersion, strRemoteRepositoryFolder = "releases", strAgentGITRevisionToUseForPublishing = "d5dfad3908f42011b5f6ed2ac6bb70fd949c28ed):

		arrParams = [
			strVersion,
			strRemoteRepositoryFolder,
			strAgentGITRevisionToUseForPublishing,
		]

		self.rpc("agent_version_default_set", arrParams)


	def dnsserver_agent_entries_updated(self, nAgentID, bInvalidateEntireConfig = Fals):

		arrParams = [
			nAgentID,
			bInvalidateEntireConfig,
		]

		self.rpc("dnsserver_agent_entries_updated", arrParams)


	def agents_counters(self, arrDatacentersFilter = [):

		arrParams = [
			arrDatacentersFilter,
		]

		return self.rpc("agents_counters", arrParams)


	def datacenter_agent_test(self, nAgentID, strAgentType, nSleepSeconds = ):

		arrParams = [
			nAgentID,
			strAgentType,
			nSleepSeconds,
		]

		return self.rpc("datacenter_agent_test", arrParams)


	def dataset_readme_upload_url(self):

		arrParams = [
		]

		return self.rpc("dataset_readme_upload_url", arrParams)


	def dataset_readme_download_url(self, nPublicDatasetI):

		arrParams = [
			nPublicDatasetID,
		]

		return self.rpc("dataset_readme_download_url", arrParams)


	def server_oob_proxy_add(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_oob_proxy_add", arrParams)


	def server_dhcp_packet_sniffing_toggle(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_dhcp_packet_sniffing_toggle", arrParams)


	def server_dhcp_sniffed_packets(self, nServerID, strMACAddres):

		arrParams = [
			nServerID,
			strMACAddress,
		]

		return self.rpc("server_dhcp_sniffed_packets", arrParams)


	def infrastructure_empty_with_active_subnets_get(self, arrSubnetPoolType):

		arrParams = [
			arrSubnetPoolTypes,
		]

		objInfrastructure = self.rpc("infrastructure_empty_with_active_subnets_get", arrParams)
		for strKeyInfrastructure in objInfrastructure:
			objInfrastructure[strKeyInfrastructure] = Deserializer.deserialize(objInfrastructure[strKeyInfrastructure])
		return objInfrastructure

	def infrastructure_agent_repo_folder_set(self, nInfrastructureID, strFolde):

		arrParams = [
			nInfrastructureID,
			strFolder,
		]

		self.rpc("infrastructure_agent_repo_folder_set", arrParams)


	def dataset_readme_delete(self, nDatasetI):

		arrParams = [
			nDatasetID,
		]

		self.rpc("dataset_readme_delete", arrParams)


	def drive_array_filesystem_types_available(self):

		arrParams = [
		]

		return self.rpc("drive_array_filesystem_types_available", arrParams)


	def drive_array_block_sizes_available(self):

		arrParams = [
		]

		return self.rpc("drive_array_block_sizes_available", arrParams)


	def instance_agent_drive_partition(self, nInstanceID, arrDriveCredentials, arrPartitionTabl):

		arrParams = [
			nInstanceID,
			arrDriveCredentials,
			arrPartitionTable,
		]

		return self.rpc("instance_agent_drive_partition", arrParams)


	def instance_agent_drive_partition_format(self, nInstanceID, arrDriveCredentials, nPartitionIndex, arrFilesystemInformatio):

		arrParams = [
			nInstanceID,
			arrDriveCredentials,
			nPartitionIndex,
			arrFilesystemInformation,
		]

		return self.rpc("instance_agent_drive_partition_format", arrParams)


	def instance_agent_drive_partition_mount(self, nInstanceID, arrDriveCredentials, nPartitionIndex, arrFilesystemInformation, strMountPoint = Non):

		arrParams = [
			nInstanceID,
			arrDriveCredentials,
			nPartitionIndex,
			arrFilesystemInformation,
			strMountPoint,
		]

		return self.rpc("instance_agent_drive_partition_mount", arrParams)


	def instance_agent_disk_partition_unmount(self, nInstanceID, strMountPoin):

		arrParams = [
			nInstanceID,
			strMountPoint,
		]

		return self.rpc("instance_agent_disk_partition_unmount", arrParams)


	def cluster_instance_arrays(self, strClusterID, arrInstanceArrayIDs = Non):

		arrParams = [
			strClusterID,
			arrInstanceArrayIDs,
		]

		objInstanceArray = self.rpc("cluster_instance_arrays", arrParams)
		for strKeyInstanceArray in objInstanceArray:
			objInstanceArray[strKeyInstanceArray] = Deserializer.deserialize(objInstanceArray[strKeyInstanceArray])
		return objInstanceArray

	def container_cluster_container_arrays(self, strContainerClusterID, arrContainerArrayIDs = Non):

		arrParams = [
			strContainerClusterID,
			arrContainerArrayIDs,
		]

		objContainerArray = self.rpc("container_cluster_container_arrays", arrParams)
		for strKeyContainerArray in objContainerArray:
			objContainerArray[strKeyContainerArray] = Deserializer.deserialize(objContainerArray[strKeyContainerArray])
		return objContainerArray

	def threshold_create(self, strUserIDOwner, objThreshol):

		objThreshold = Serializer.serialize(objThreshold)

		arrParams = [
			strUserIDOwner,
			objThreshold,
		]

		return Deserializer.deserialize(self.rpc("threshold_create", arrParams))

	def threshold_edit(self, nThresholdID, objThresholdOperatio):

		objThresholdOperation = Serializer.serialize(objThresholdOperation)

		arrParams = [
			nThresholdID,
			objThresholdOperation,
		]

		return Deserializer.deserialize(self.rpc("threshold_edit", arrParams))

	def users_and_infrastructures_cleanup(self):

		arrParams = [
		]

		self.rpc("users_and_infrastructures_cleanup", arrParams)


	def dataset_subscriptions(self, nDatasetI):

		arrParams = [
			nDatasetID,
		]

		self.rpc("dataset_subscriptions", arrParams)


	def instance_cloudinit_dhcp_status_set(self, nInstanceID, bEnable):

		arrParams = [
			nInstanceID,
			bEnabled,
		]

		self.rpc("instance_cloudinit_dhcp_status_set", arrParams)


	def infrastructure_deploy_cleanup(self, nInfrastructureID, objShutdownOptions = None, objDeployOptions = None, bAllowDataLoss = False, bSkipAnsible = Fals):

		objShutdownOptions = Serializer.serialize(objShutdownOptions)
		objDeployOptions = Serializer.serialize(objDeployOptions)

		arrParams = [
			nInfrastructureID,
			objShutdownOptions,
			objDeployOptions,
			bAllowDataLoss,
			bSkipAnsible,
		]

		return self.rpc("infrastructure_deploy_cleanup", arrParams)


	def infrastructure_delete_cleanup(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		self.rpc("infrastructure_delete_cleanup", arrParams)


	def server_dhcp_relay_security_toggle(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_dhcp_relay_security_toggle", arrParams)


	def server_type_search(self, objServerTypeParam):

		objServerTypeParams = Serializer.serialize(objServerTypeParams)

		arrParams = [
			objServerTypeParams,
		]

		return self.rpc("server_type_search", arrParams)


	def independent_instance_create(self, strUserIDOwner, strLabel, strDatacenterName, strServerTypeID, arrFirewallRules = [], strISCSIStorageType = "none", nISCSIStorageSizeMBytes = 0, strVolumeTemplateID = Non):

		arrFirewallRules = Serializer.serialize(arrFirewallRules)

		arrParams = [
			strUserIDOwner,
			strLabel,
			strDatacenterName,
			strServerTypeID,
			arrFirewallRules,
			strISCSIStorageType,
			nISCSIStorageSizeMBytes,
			strVolumeTemplateID,
		]

		return Deserializer.deserialize(self.rpc("independent_instance_create", arrParams))

	def server_dhcp_sniffed_packets_uuid(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_dhcp_sniffed_packets_uuid", arrParams)


	def switch_device_cache_clear(self, nSwitchI):

		arrParams = [
			nSwitchID,
		]

		self.rpc("switch_device_cache_clear", arrParams)


	def independent_instance_delete(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return Deserializer.deserialize(self.rpc("independent_instance_delete", arrParams))

	def independent_instance_storage_expand(self, strInstanceID, nISCSIStorageSizeMByte):

		arrParams = [
			strInstanceID,
			nISCSIStorageSizeMBytes,
		]

		return Deserializer.deserialize(self.rpc("independent_instance_storage_expand", arrParams))

	def instance_rows(self, strUserID, arrInstanceIDs = Non):

		arrParams = [
			strUserID,
			arrInstanceIDs,
		]

		return self.rpc("instance_rows", arrParams)


	def instance_label_is_available_assert(self, strUserIDOwner, strInstanceLabe):

		arrParams = [
			strUserIDOwner,
			strInstanceLabel,
		]

		self.rpc("instance_label_is_available_assert", arrParams)


	def infrastructure_purge(self, nInfrastructureI):

		arrParams = [
			nInfrastructureID,
		]

		return self.rpc("infrastructure_purge", arrParams)


	def independent_instance_firewall_rules_update(self, strInstanceID, arrFirewallRule):

		arrFirewallRules = Serializer.serialize(arrFirewallRules)

		arrParams = [
			strInstanceID,
			arrFirewallRules,
		]

		return Deserializer.deserialize(self.rpc("independent_instance_firewall_rules_update", arrParams))

	def datacenter_agent_monitoring_network_traffic_pull_and_save(self):

		arrParams = [
		]

		self.rpc("datacenter_agent_monitoring_network_traffic_pull_and_save", arrParams)


	def subnet_traffic_data_points_get(self, nSubnetID, nStartUnixTimestamp, nLengthSeconds = Non):

		arrParams = [
			nSubnetID,
			nStartUnixTimestamp,
			nLengthSeconds,
		]

		self.rpc("subnet_traffic_data_points_get", arrParams)


	def server_keys_compromised_flag_set(self, strServerID, strCompromisedKeyIndex, bCompromised = Tru):

		arrParams = [
			strServerID,
			strCompromisedKeyIndex,
			bCompromised,
		]

		self.rpc("server_keys_compromised_flag_set", arrParams)


	def server_agent_config_json_download_url(self, nServerID, strAgentVersion, strDatacenterNam):

		arrParams = [
			nServerID,
			strAgentVersion,
			strDatacenterName,
		]

		return self.rpc("server_agent_config_json_download_url", arrParams)


	def server_keys_destroy_index_with_possible_data_loss(self, strServerID, strKeyIndexToDestro):

		arrParams = [
			strServerID,
			strKeyIndexToDestroy,
		]

		self.rpc("server_keys_destroy_index_with_possible_data_loss", arrParams)


	def server_keys_rotate_new(self, strServerI):

		arrParams = [
			strServerID,
		]

		return self.rpc("server_keys_rotate_new", arrParams)


	def server_register(self, nServerID, nAFCGroupID, bServerInfoAvailable = Fals):

		arrParams = [
			nServerID,
			nAFCGroupID,
			bServerInfoAvailable,
		]

		self.rpc("server_register", arrParams)


	def bdk_agent_register_notify_bsi(self, strAgentVersion, objServer, nAgentIDExistin):

		objServer = Serializer.serialize(objServer)

		arrParams = [
			strAgentVersion,
			objServer,
			nAgentIDExisting,
		]

		self.rpc("bdk_agent_register_notify_bsi", arrParams)


	def bdk_agent_server_info_collect(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_info_collect", arrParams)


	def bdk_agent_IPMI_setup(self, nServerID, arrConfi):

		arrParams = [
			nServerID,
			arrConfig,
		]

		return self.rpc("bdk_agent_IPMI_setup", arrParams)


	def bdk_agent_server_cleanup(self, nServerID, objServer, arrServerInterfaces, objIPOOB, arrDNSServers, arrNTPServer):

		objServer = Serializer.serialize(objServer)
		objIPOOB = Serializer.serialize(objIPOOB)

		arrParams = [
			nServerID,
			objServer,
			arrServerInterfaces,
			objIPOOB,
			arrDNSServers,
			arrNTPServers,
		]

		return self.rpc("bdk_agent_server_cleanup", arrParams)


	def subnet_prefix_sizes_wan(self, strSubnetTyp):

		arrParams = [
			strSubnetType,
		]

		return self.rpc("subnet_prefix_sizes_wan", arrParams)


	def subnet_prefix_sizes_wan_cluster_attached(self, strSubnetTyp):

		arrParams = [
			strSubnetType,
		]

		return self.rpc("subnet_prefix_sizes_wan_cluster_attached", arrParams)


	def datacenter_agent_monitoring_database_get(self, strDatacenterName, strSubnetType, nSubnetI):

		arrParams = [
			strDatacenterName,
			strSubnetType,
			nSubnetID,
		]

		return self.rpc("datacenter_agent_monitoring_database_get", arrParams)


	def datacenter_agent_monitoring_database_persist(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		self.rpc("datacenter_agent_monitoring_database_persist", arrParams)


	def network_traffic_sflow_fail_warning(self):

		arrParams = [
		]

		self.rpc("network_traffic_sflow_fail_warning", arrParams)


	def server_preregister_agent_config_json_download_url(self, nPreregisterID, strAgentVersion, strDatacenterNam):

		arrParams = [
			nPreregisterID,
			strAgentVersion,
			strDatacenterName,
		]

		return self.rpc("server_preregister_agent_config_json_download_url", arrParams)


	def server_agent_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_agent_get", arrParams)


	def server_create(self, objServer, bAutoGenerat):

		objServer = Serializer.serialize(objServer)

		arrParams = [
			objServer,
			bAutoGenerate,
		]

		self.rpc("server_create", arrParams)


	def server_cleanup(self, nServerID, bServerInfoAvailable = Fals):

		arrParams = [
			nServerID,
			bServerInfoAvailable,
		]

		self.rpc("server_cleanup", arrParams)


	def bdk_agent_preregister_install_batch(self, strOSName, strDatacenterName, nPreregisterID = Non):

		arrParams = [
			strOSName,
			strDatacenterName,
			nPreregisterID,
		]

		return self.rpc("bdk_agent_preregister_install_batch", arrParams)


	def bdk_agent_preregister_install_batch_download_url(self, strOSName, strDatacenterName, nPreregisterID = Non):

		arrParams = [
			strOSName,
			strDatacenterName,
			nPreregisterID,
		]

		return self.rpc("bdk_agent_preregister_install_batch_download_url", arrParams)


	def bdk_agent_networking_intel_cleanup(self, nServerID, objServe):

		objServer = Serializer.serialize(objServer)

		arrParams = [
			nServerID,
			objServer,
		]

		self.rpc("bdk_agent_networking_intel_cleanup", arrParams)


	def bdk_agent_server_interfaces_cleanup(self, nServerID, arrServerInterface):

		arrParams = [
			nServerID,
			arrServerInterfaces,
		]

		self.rpc("bdk_agent_server_interfaces_cleanup", arrParams)


	def bdk_agent_ipmi_users_and_networking_cleanup(self, nServerID, objServer, objIPOOB, arrDNSServers, arrNTPServer):

		objServer = Serializer.serialize(objServer)
		objIPOOB = Serializer.serialize(objIPOOB)

		arrParams = [
			nServerID,
			objServer,
			objIPOOB,
			arrDNSServers,
			arrNTPServers,
		]

		self.rpc("bdk_agent_ipmi_users_and_networking_cleanup", arrParams)


	def bdk_agent_efibootmgr_cleanup(self, nServerID, arrNICDetail):

		arrParams = [
			nServerID,
			arrNICDetails,
		]

		self.rpc("bdk_agent_efibootmgr_cleanup", arrParams)


	def bdk_agent_disks_cleanup(self, nServerID, objServe):

		objServer = Serializer.serialize(objServer)

		arrParams = [
			nServerID,
			objServer,
		]

		self.rpc("bdk_agent_disks_cleanup", arrParams)


	def bdk_agent_hba_setup(self, nServerID, arrServerInterfaces, objInstanc):

		objInstance = Serializer.serialize(objInstance)

		arrParams = [
			nServerID,
			arrServerInterfaces,
			objInstance,
		]

		self.rpc("bdk_agent_hba_setup", arrParams)


	def bdk_run_command_batch(self, nServerID, strComman):

		arrParams = [
			nServerID,
			strCommand,
		]

		self.rpc("bdk_run_command_batch", arrParams)


	def prices_config_save(self, strJSONPrice):

		arrParams = [
			strJSONPrices,
		]

		self.rpc("prices_config_save", arrParams)


	def instance_sdp_for_webrtc(self, strInstanceID, strPurpose, strJSONSDPOffe):

		arrParams = [
			strInstanceID,
			strPurpose,
			strJSONSDPOffer,
		]

		return self.rpc("instance_sdp_for_webrtc", arrParams)


	def instance_ice_for_webrtc_set(self, strInstanceID, strPurpose, strICECandidateJSON, strSSHClientI):

		arrParams = [
			strInstanceID,
			strPurpose,
			strICECandidateJSON,
			strSSHClientID,
		]

		self.rpc("instance_ice_for_webrtc_set", arrParams)


	def infrastructure_ansible_inventory_get(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return self.rpc("infrastructure_ansible_inventory_get", arrParams)


	def instance_array_interface_create(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return Deserializer.deserialize(self.rpc("instance_array_interface_create", arrParams))

	def instance_next_boot_config_clear(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		self.rpc("instance_next_boot_config_clear", arrParams)


	def instance_next_boot_config_set(self, nInstanceID, strInstanceReinstallRequiredJSON = "{}):

		arrParams = [
			nInstanceID,
			strInstanceReinstallRequiredJSON,
		]

		self.rpc("instance_next_boot_config_set", arrParams)


	def instance_next_boot_config_is_set(self, nInstanceI):

		arrParams = [
			nInstanceID,
		]

		self.rpc("instance_next_boot_config_is_set", arrParams)


	def server_info_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_info_get", arrParams)


	def server_sdp_for_webrtc(self, nServerID, strPurpose, strJSONSDPOffe):

		arrParams = [
			nServerID,
			strPurpose,
			strJSONSDPOffer,
		]

		return self.rpc("server_sdp_for_webrtc", arrParams)


	def server_ice_for_webrtc_set(self, nServerID, strPurpose, strICECandidateJSON, strSSHClientI):

		arrParams = [
			nServerID,
			strPurpose,
			strICECandidateJSON,
			strSSHClientID,
		]

		self.rpc("server_ice_for_webrtc_set", arrParams)


	def storage_pool_sdp_for_webrtc(self, nStoragePoolID, strPurpose, strJSONSDPOffe):

		arrParams = [
			nStoragePoolID,
			strPurpose,
			strJSONSDPOffer,
		]

		return self.rpc("storage_pool_sdp_for_webrtc", arrParams)


	def storage_pool_ice_for_webrtc_set(self, nStoragePoolID, strPurpose, strICECandidateJSON, strSSHClientI):

		arrParams = [
			nStoragePoolID,
			strPurpose,
			strICECandidateJSON,
			strSSHClientID,
		]

		self.rpc("storage_pool_ice_for_webrtc_set", arrParams)


	def switch_device_san_subnet_pool_create(self, nNetworkEquipmentI):

		arrParams = [
			nNetworkEquipmentID,
		]

		self.rpc("switch_device_san_subnet_pool_create", arrParams)


	def switch_device_sdp_for_webrtc(self, nSwitchDeviceID, strPurpose, strJSONSDPOffe):

		arrParams = [
			nSwitchDeviceID,
			strPurpose,
			strJSONSDPOffer,
		]

		return self.rpc("switch_device_sdp_for_webrtc", arrParams)


	def switch_device_ice_for_webrtc_set(self, nSwitchDeviceID, strPurpose, strICECandidateJSON, strSSHClientI):

		arrParams = [
			nSwitchDeviceID,
			strPurpose,
			strICECandidateJSON,
			strSSHClientID,
		]

		self.rpc("switch_device_ice_for_webrtc_set", arrParams)


	def agent_delete(self, nAgentI):

		arrParams = [
			nAgentID,
		]

		self.rpc("agent_delete", arrParams)


	def bdk_agent_server_general_info(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_general_info", arrParams)


	def bdk_agent_server_cpu_info(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_cpu_info", arrParams)


	def bdk_agent_server_bios_info(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_bios_info", arrParams)


	def bdk_agent_server_disks_info(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_disks_info", arrParams)


	def bdk_agent_server_memory_info(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_memory_info", arrParams)


	def bdk_agent_server_network_info(self, nServerID, nAgentID = None, bForceRegenerate = Fals):

		arrParams = [
			nServerID,
			nAgentID,
			bForceRegenerate,
		]

		return self.rpc("bdk_agent_server_network_info", arrParams)


	def infrastructure_ansible_bundles(self, strInfrastructureID, strAnsibleBundleTyp):

		arrParams = [
			strInfrastructureID,
			strAnsibleBundleType,
		]

		return self.rpc("infrastructure_ansible_bundles", arrParams)


	def infrastructure_ansible_bundle_add_into_runlevel(self, strInfrastructureID, nAnsibleBundleID, nRunLeve):

		arrParams = [
			strInfrastructureID,
			nAnsibleBundleID,
			nRunLevel,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_ansible_bundle_add_into_runlevel", arrParams))

	def infrastructure_ansible_bundle_delete_from_runlevel(self, strInfrastructureID, nAnsibleBundleID, nRunLeve):

		arrParams = [
			strInfrastructureID,
			nAnsibleBundleID,
			nRunLevel,
		]

		self.rpc("infrastructure_ansible_bundle_delete_from_runlevel", arrParams)


	def ansible_bundles(self, strUserI):

		arrParams = [
			strUserID,
		]

		objAnsibleBundle = self.rpc("ansible_bundles", arrParams)
		for strKeyAnsibleBundle in objAnsibleBundle:
			objAnsibleBundle[strKeyAnsibleBundle] = Deserializer.deserialize(objAnsibleBundle[strKeyAnsibleBundle])
		return objAnsibleBundle

	def ansible_bundle_get(self, nAnsibleBundleI):

		arrParams = [
			nAnsibleBundleID,
		]

		return Deserializer.deserialize(self.rpc("ansible_bundle_get", arrParams))

	def ansible_bundle_update(self, nAnsibleBundleID, objAnsibleBundl):

		objAnsibleBundle = Serializer.serialize(objAnsibleBundle)

		arrParams = [
			nAnsibleBundleID,
			objAnsibleBundle,
		]

		return Deserializer.deserialize(self.rpc("ansible_bundle_update", arrParams))

	def ansible_bundle_delete(self, nAnsibleBundleI):

		arrParams = [
			nAnsibleBundleID,
		]

		self.rpc("ansible_bundle_delete", arrParams)


	def infrastructure_ansible_bundle_move_into_runlevel(self, strInfrastructureID, nAnsibleBundleID, nSourceRunLevel, nDestinationRunLeve):

		arrParams = [
			strInfrastructureID,
			nAnsibleBundleID,
			nSourceRunLevel,
			nDestinationRunLevel,
		]

		self.rpc("infrastructure_ansible_bundle_move_into_runlevel", arrParams)


	def secrets(self, strUserID, strUsage = Non):

		arrParams = [
			strUserID,
			strUsage,
		]

		objSecret = self.rpc("secrets", arrParams)
		for strKeySecret in objSecret:
			objSecret[strKeySecret] = Deserializer.deserialize(objSecret[strKeySecret])
		return objSecret

	def secret_get(self, nSecretI):

		arrParams = [
			nSecretID,
		]

		return Deserializer.deserialize(self.rpc("secret_get", arrParams))

	def secret_delete(self, nSecretI):

		arrParams = [
			nSecretID,
		]

		self.rpc("secret_delete", arrParams)


	def server_raid_controller_disks_get(self, nServerID, strRAIDControllerName = "RAID.Integrated.1-1):

		arrParams = [
			nServerID,
			strRAIDControllerName,
		]

		return self.rpc("server_raid_controller_disks_get", arrParams)


	def server_pxe_enabled_interfaces_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_pxe_enabled_interfaces_get", arrParams)


	def server_firmware_inventory_get(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_firmware_inventory_get", arrParams)


	def server_firmware_info_update(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_firmware_info_update", arrParams)


	def server_firmware_component_update_version_preset(self, nServerComponentID, strServerComponentNewVersio):

		arrParams = [
			nServerComponentID,
			strServerComponentNewVersion,
		]

		self.rpc("server_firmware_component_update_version_preset", arrParams)


	def infrastructures_statistics(self):

		arrParams = [
		]

		return self.rpc("infrastructures_statistics", arrParams)


	def subnet_pools_statistics(self):

		arrParams = [
		]

		return self.rpc("subnet_pools_statistics", arrParams)


	def afc_status_counters(self):

		arrParams = [
		]

		return self.rpc("afc_status_counters", arrParams)


	def datacenters_statistics(self):

		arrParams = [
		]

		return self.rpc("datacenters_statistics", arrParams)


	def server_secure_boot_set(self, nServerID, bSecureBoo):

		arrParams = [
			nServerID,
			bSecureBoot,
		]

		self.rpc("server_secure_boot_set", arrParams)


	def server_firmware_upgrade(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_firmware_upgrade", arrParams)


	def server_update_ipmi_credentials(self, nServerID, strIPMIHostname, strIPMIUsername, strIPMIPasswor):

		arrParams = [
			nServerID,
			strIPMIHostname,
			strIPMIUsername,
			strIPMIPassword,
		]

		self.rpc("server_update_ipmi_credentials", arrParams)


	def storage_pools_statistics(self, bIncludeStoragePoolsInMaintenance = False, bAllowExperimental = False, nMinimumSpace = ):

		arrParams = [
			bIncludeStoragePoolsInMaintenance,
			bAllowExperimental,
			nMinimumSpace,
		]

		return self.rpc("storage_pools_statistics", arrParams)


	def switch_devices_statistics(self):

		arrParams = [
		]

		return self.rpc("switch_devices_statistics", arrParams)


	def datacenter_agent_listening_sockets(self, nAgentID, strAgentTyp):

		arrParams = [
			nAgentID,
			strAgentType,
		]

		return self.rpc("datacenter_agent_listening_sockets", arrParams)


	def server_component_get(self, nServerComponentI):

		arrParams = [
			nServerComponentID,
		]

		return self.rpc("server_component_get", arrParams)


	def server_firmware_component_upgrade(self, nServerID, nServerComponentID, strServerComponentFirmwareNewVersion = None, strFirmwareBinaryUrl = Non):

		arrParams = [
			nServerID,
			nServerComponentID,
			strServerComponentFirmwareNewVersion,
			strFirmwareBinaryUrl,
		]

		self.rpc("server_firmware_component_upgrade", arrParams)


	def secret_get_internal(self, nSecretI):

		arrParams = [
			nSecretID,
		]

		return Deserializer.deserialize(self.rpc("secret_get_internal", arrParams))

	def volume_template_create(self, strDriveID, strNewVolumeTemplateLabel, strDescription, strVolumeTemplateDisplayName, strVolumeTemplateBootType = "legacy_only", strVolumeTemplateDeprecationStatus = "not_deprecated", strVolumeTemplateBootMethodsSupported = "pxe_iscsi", arrVolumeTemplateTags = [):

		arrParams = [
			strDriveID,
			strNewVolumeTemplateLabel,
			strDescription,
			strVolumeTemplateDisplayName,
			strVolumeTemplateBootType,
			strVolumeTemplateDeprecationStatus,
			strVolumeTemplateBootMethodsSupported,
			arrVolumeTemplateTags,
		]

		return Deserializer.deserialize(self.rpc("volume_template_create", arrParams))

	def ssh_connect_test(self, strIPAddress, nPort, strClientLibrary = "fsockopen", strDatacenterName = None, strUsername = None, strPassword = "):

		arrParams = [
			strIPAddress,
			nPort,
			strClientLibrary,
			strDatacenterName,
			strUsername,
			strPassword,
		]

		return self.rpc("ssh_connect_test", arrParams)


	def infrastructure_ansible_bundle_exec(self, strInfrastructureID, nInfrastructureAnsibleBundleID, objExtraAnsibleVariables = [):

		objExtraAnsibleVariables = Serializer.serialize(objExtraAnsibleVariables)

		arrParams = [
			strInfrastructureID,
			nInfrastructureAnsibleBundleID,
			objExtraAnsibleVariables,
		]

		return self.rpc("infrastructure_ansible_bundle_exec", arrParams)


	def ansible_bundle_create(self, strUserID, objAnsibleBundl):

		objAnsibleBundle = Serializer.serialize(objAnsibleBundle)

		arrParams = [
			strUserID,
			objAnsibleBundle,
		]

		return Deserializer.deserialize(self.rpc("ansible_bundle_create", arrParams))

	def secret_create(self, strUserID, objSecre):

		objSecret = Serializer.serialize(objSecret)

		arrParams = [
			strUserID,
			objSecret,
		]

		return Deserializer.deserialize(self.rpc("secret_create", arrParams))

	def secret_update(self, nSecretID, objSecre):

		objSecret = Serializer.serialize(objSecret)

		arrParams = [
			nSecretID,
			objSecret,
		]

		return Deserializer.deserialize(self.rpc("secret_update", arrParams))

	def infrastructure_deploy(self, strInfrastructureID, objShutdownOptions = None, objDeployOptions = None, bAllowDataLoss = False, bSkipAnsible = Fals):

		objShutdownOptions = Serializer.serialize(objShutdownOptions)
		objDeployOptions = Serializer.serialize(objDeployOptions)

		arrParams = [
			strInfrastructureID,
			objShutdownOptions,
			objDeployOptions,
			bAllowDataLoss,
			bSkipAnsible,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_deploy", arrParams))

	def os_template_os_assets(self, nOSTemplateI):

		arrParams = [
			nOSTemplateID,
		]

		objOSAsset = self.rpc("os_template_os_assets", arrParams)
		for strKeyOSAsset in objOSAsset:
			objOSAsset[strKeyOSAsset] = Deserializer.deserialize(objOSAsset[strKeyOSAsset])
		return objOSAsset

	def os_template_create(self, strUserID, objOSTemplat):

		objOSTemplate = Serializer.serialize(objOSTemplate)

		arrParams = [
			strUserID,
			objOSTemplate,
		]

		return Deserializer.deserialize(self.rpc("os_template_create", arrParams))

	def os_templates(self, strUserI):

		arrParams = [
			strUserID,
		]

		objVolumeTemplate = self.rpc("os_templates", arrParams)
		for strKeyVolumeTemplate in objVolumeTemplate:
			objVolumeTemplate[strKeyVolumeTemplate] = Deserializer.deserialize(objVolumeTemplate[strKeyVolumeTemplate])
		return objVolumeTemplate

	def os_template_get(self, nOSTemplateI):

		arrParams = [
			nOSTemplateID,
		]

		return Deserializer.deserialize(self.rpc("os_template_get", arrParams))

	def os_template_update(self, nOSTemplateID, objOSTemplat):

		objOSTemplate = Serializer.serialize(objOSTemplate)

		arrParams = [
			nOSTemplateID,
			objOSTemplate,
		]

		return Deserializer.deserialize(self.rpc("os_template_update", arrParams))

	def os_template_delete(self, nOSTemplateI):

		arrParams = [
			nOSTemplateID,
		]

		self.rpc("os_template_delete", arrParams)


	def server_tags_add(self, nServerID, arrServerTagsName):

		arrParams = [
			nServerID,
			arrServerTagsNames,
		]

		return Deserializer.deserialize(self.rpc("server_tags_add", arrParams))

	def infrastructure_tags_add(self, strInfrastructureID, arrInfrastructureTagsName):

		arrParams = [
			strInfrastructureID,
			arrInfrastructureTagsNames,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_tags_add", arrParams))

	def infrastructure_tags_set(self, strInfrastructureID, arrInfrastructureTagsName):

		arrParams = [
			strInfrastructureID,
			arrInfrastructureTagsNames,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_tags_set", arrParams))

	def infrastructure_tags(self, strInfrastructureI):

		arrParams = [
			strInfrastructureID,
		]

		return self.rpc("infrastructure_tags", arrParams)


	def infrastructure_tags_remove(self, strInfrastructureID, arrInfrastructureTagsName):

		arrParams = [
			strInfrastructureID,
			arrInfrastructureTagsNames,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_tags_remove", arrParams))

	def instance_tags_add(self, strInstanceID, arrInstanceTagsName):

		arrParams = [
			strInstanceID,
			arrInstanceTagsNames,
		]

		return Deserializer.deserialize(self.rpc("instance_tags_add", arrParams))

	def instance_tags_set(self, strInstanceID, arrInstanceTagsName):

		arrParams = [
			strInstanceID,
			arrInstanceTagsNames,
		]

		return Deserializer.deserialize(self.rpc("instance_tags_set", arrParams))

	def instance_tags(self, strInstanceI):

		arrParams = [
			strInstanceID,
		]

		return self.rpc("instance_tags", arrParams)


	def instance_tags_remove(self, strInstanceID, arrInstanceTagsName):

		arrParams = [
			strInstanceID,
			arrInstanceTagsNames,
		]

		return Deserializer.deserialize(self.rpc("instance_tags_remove", arrParams))

	def instance_array_tags_add(self, strInstanceArrayID, arrInstanceArrayTagsName):

		arrParams = [
			strInstanceArrayID,
			arrInstanceArrayTagsNames,
		]

		return Deserializer.deserialize(self.rpc("instance_array_tags_add", arrParams))

	def instance_array_tags_set(self, strInstanceArrayID, arrInstanceArrayTagsName):

		arrParams = [
			strInstanceArrayID,
			arrInstanceArrayTagsNames,
		]

		return Deserializer.deserialize(self.rpc("instance_array_tags_set", arrParams))

	def instance_array_tags(self, strInstanceArrayI):

		arrParams = [
			strInstanceArrayID,
		]

		return self.rpc("instance_array_tags", arrParams)


	def instance_array_tags_remove(self, strInstanceArrayID, arrInstanceArrayTag):

		arrParams = [
			strInstanceArrayID,
			arrInstanceArrayTags,
		]

		return Deserializer.deserialize(self.rpc("instance_array_tags_remove", arrParams))

	def os_template_tags_add(self, strVolumeTemplateID, arrOSTemplateTagsName):

		arrParams = [
			strVolumeTemplateID,
			arrOSTemplateTagsNames,
		]

		return Deserializer.deserialize(self.rpc("os_template_tags_add", arrParams))

	def os_template_tags_set(self, strVolumeTemplateID, arrOSTemplateTagsName):

		arrParams = [
			strVolumeTemplateID,
			arrOSTemplateTagsNames,
		]

		return Deserializer.deserialize(self.rpc("os_template_tags_set", arrParams))

	def os_template_tags(self, strVolumeTemplateI):

		arrParams = [
			strVolumeTemplateID,
		]

		return self.rpc("os_template_tags", arrParams)


	def os_template_tags_remove(self, strVolumeTemplateID, arrOSTemplateTagsName):

		arrParams = [
			strVolumeTemplateID,
			arrOSTemplateTagsNames,
		]

		return Deserializer.deserialize(self.rpc("os_template_tags_remove", arrParams))

	def datacenter_tags_add(self, strUserID, strDatacenterName, arrDatacenterTagsName):

		arrParams = [
			strUserID,
			strDatacenterName,
			arrDatacenterTagsNames,
		]

		return Deserializer.deserialize(self.rpc("datacenter_tags_add", arrParams))

	def datacenter_tags_set(self, strUserID, strDatacenterName, arrDatacenterTagsName):

		arrParams = [
			strUserID,
			strDatacenterName,
			arrDatacenterTagsNames,
		]

		return Deserializer.deserialize(self.rpc("datacenter_tags_set", arrParams))

	def datacenter_tags(self, strDatacenterNam):

		arrParams = [
			strDatacenterName,
		]

		return self.rpc("datacenter_tags", arrParams)


	def datacenter_tags_remove(self, strUserID, strDatacenterName, arrDatacenterTagsName):

		arrParams = [
			strUserID,
			strDatacenterName,
			arrDatacenterTagsNames,
		]

		return Deserializer.deserialize(self.rpc("datacenter_tags_remove", arrParams))

	def server_type_tags_add(self, strServerTypeID, arrServerTypeTagsName):

		arrParams = [
			strServerTypeID,
			arrServerTypeTagsNames,
		]

		return Deserializer.deserialize(self.rpc("server_type_tags_add", arrParams))

	def server_type_tags_set(self, strServerTypeID, arrServerTypeTagsName):

		arrParams = [
			strServerTypeID,
			arrServerTypeTagsNames,
		]

		return Deserializer.deserialize(self.rpc("server_type_tags_set", arrParams))

	def server_type_tags(self, strServerTypeI):

		arrParams = [
			strServerTypeID,
		]

		return self.rpc("server_type_tags", arrParams)


	def server_type_tags_remove(self, strServerTypeID, arrServerTypeTagsName):

		arrParams = [
			strServerTypeID,
			arrServerTypeTagsNames,
		]

		return Deserializer.deserialize(self.rpc("server_type_tags_remove", arrParams))

	def server_tags_set(self, nServerID, arrServerTagsName):

		arrParams = [
			nServerID,
			arrServerTagsNames,
		]

		return Deserializer.deserialize(self.rpc("server_tags_set", arrParams))

	def server_tags(self, nServerI):

		arrParams = [
			nServerID,
		]

		return self.rpc("server_tags", arrParams)


	def server_tags_remove(self, nServerID, arrServerTagsName):

		arrParams = [
			nServerID,
			arrServerTagsNames,
		]

		return Deserializer.deserialize(self.rpc("server_tags_remove", arrParams))

	def storage_pool_tags_add(self, nStoragePoolID, arrStoragePoolTagsName):

		arrParams = [
			nStoragePoolID,
			arrStoragePoolTagsNames,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_tags_add", arrParams))

	def storage_pool_tags_set(self, nStoragePoolID, arrStoragePoolTagsName):

		arrParams = [
			nStoragePoolID,
			arrStoragePoolTagsNames,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_tags_set", arrParams))

	def storage_pool_tags(self, nStoragePoolI):

		arrParams = [
			nStoragePoolID,
		]

		return self.rpc("storage_pool_tags", arrParams)


	def storage_pool_tags_remove(self, nStoragePoolID, arrStoragePoolTagsName):

		arrParams = [
			nStoragePoolID,
			arrStoragePoolTagsNames,
		]

		return Deserializer.deserialize(self.rpc("storage_pool_tags_remove", arrParams))

	def volume_template_tags_add(self, strVolumeTemplateID, arrVolumeTemplateTagsName):

		arrParams = [
			strVolumeTemplateID,
			arrVolumeTemplateTagsNames,
		]

		return Deserializer.deserialize(self.rpc("volume_template_tags_add", arrParams))

	def volume_template_tags_set(self, strVolumeTemplateID, arrVolumeTemplateTagsName):

		arrParams = [
			strVolumeTemplateID,
			arrVolumeTemplateTagsNames,
		]

		return Deserializer.deserialize(self.rpc("volume_template_tags_set", arrParams))

	def volume_template_tags(self, strVolumeTemplateI):

		arrParams = [
			strVolumeTemplateID,
		]

		return self.rpc("volume_template_tags", arrParams)


	def volume_template_tags_remove(self, strVolumeTemplateID, arrVolumeTemplateTagsName):

		arrParams = [
			strVolumeTemplateID,
			arrVolumeTemplateTagsNames,
		]

		return Deserializer.deserialize(self.rpc("volume_template_tags_remove", arrParams))

	def switch_device_tags_add(self, nNetworkEquipmentID, arrNetworkEquipmentTagsName):

		arrParams = [
			nNetworkEquipmentID,
			arrNetworkEquipmentTagsNames,
		]

		return Deserializer.deserialize(self.rpc("switch_device_tags_add", arrParams))

	def switch_device_tags_set(self, nNetworkEquipmentID, arrNetworkEquipmentTagsName):

		arrParams = [
			nNetworkEquipmentID,
			arrNetworkEquipmentTagsNames,
		]

		return Deserializer.deserialize(self.rpc("switch_device_tags_set", arrParams))

	def switch_device_tags(self, nNetworkEquipmentI):

		arrParams = [
			nNetworkEquipmentID,
		]

		return self.rpc("switch_device_tags", arrParams)


	def switch_device_tags_remove(self, nNetworkEquipmentID, arrNetworkEquipmentTagsName):

		arrParams = [
			nNetworkEquipmentID,
			arrNetworkEquipmentTagsNames,
		]

		return Deserializer.deserialize(self.rpc("switch_device_tags_remove", arrParams))

	def bdk_exec(self, nServerID, strCommand, nTimeoutSeconds, strTarXZBundleDecrypted, strBundleName, objEnvironmentVariable):

		objEnvironmentVariables = Serializer.serialize(objEnvironmentVariables)

		arrParams = [
			nServerID,
			strCommand,
			nTimeoutSeconds,
			strTarXZBundleDecrypted,
			strBundleName,
			objEnvironmentVariables,
		]

		self.rpc("bdk_exec", arrParams)


	def tftpserver_agent_dhcp_rules_updated(self, nAgentID, bInvalidateEntireConfig = Fals):

		arrParams = [
			nAgentID,
			bInvalidateEntireConfig,
		]

		self.rpc("tftpserver_agent_dhcp_rules_updated", arrParams)


	def tftpserver_agent_os_templates_os_assets_updated(self, nAgentID, arrChanges = Non):

		arrParams = [
			nAgentID,
			arrChanges,
		]

		self.rpc("tftpserver_agent_os_templates_os_assets_updated", arrParams)


	def tftpserver_agent_os_assets_updated(self, nAgentID, bInvalidateEntireConfig = False, bWaitForDownload = Fals):

		arrParams = [
			nAgentID,
			bInvalidateEntireConfig,
			bWaitForDownload,
		]

		self.rpc("tftpserver_agent_os_assets_updated", arrParams)


	def tftpserver_agent_secrets_updated(self, nAgentID, bInvalidateEntireConfig = False, bWaitForDownload = Fals):

		arrParams = [
			nAgentID,
			bInvalidateEntireConfig,
			bWaitForDownload,
		]

		self.rpc("tftpserver_agent_secrets_updated", arrParams)


	def os_template_add_os_asset(self, nOSTemplateID, nOSAssetID, strOSAssetFilePat):

		arrParams = [
			nOSTemplateID,
			nOSAssetID,
			strOSAssetFilePath,
		]

		return self.rpc("os_template_add_os_asset", arrParams)


	def os_template_remove_os_asset(self, nOSTemplateID, nOSAssetI):

		arrParams = [
			nOSTemplateID,
			nOSAssetID,
		]

		self.rpc("os_template_remove_os_asset", arrParams)


	def os_template_update_os_asset_path(self, nOSTemplateID, nOSAssetID, strOSAssetFilePat):

		arrParams = [
			nOSTemplateID,
			nOSAssetID,
			strOSAssetFilePath,
		]

		self.rpc("os_template_update_os_asset_path", arrParams)


	def os_template_has_os_asset(self, nOSTemplateID, nOSAssetI):

		arrParams = [
			nOSTemplateID,
			nOSAssetID,
		]

		return self.rpc("os_template_has_os_asset", arrParams)


	def variables(self, strUserID, strUsage = Non):

		arrParams = [
			strUserID,
			strUsage,
		]

		objVariable = self.rpc("variables", arrParams)
		for strKeyVariable in objVariable:
			objVariable[strKeyVariable] = Deserializer.deserialize(objVariable[strKeyVariable])
		return objVariable

	def variable_get(self, nVariableI):

		arrParams = [
			nVariableID,
		]

		return Deserializer.deserialize(self.rpc("variable_get", arrParams))

	def variable_create(self, strUserID, objVariabl):

		objVariable = Serializer.serialize(objVariable)

		arrParams = [
			strUserID,
			objVariable,
		]

		return Deserializer.deserialize(self.rpc("variable_create", arrParams))

	def variable_update(self, nVariableID, objVariabl):

		objVariable = Serializer.serialize(objVariable)

		arrParams = [
			nVariableID,
			objVariable,
		]

		return Deserializer.deserialize(self.rpc("variable_update", arrParams))

	def variable_delete(self, nVariableI):

		arrParams = [
			nVariableID,
		]

		self.rpc("variable_delete", arrParams)


	def variable_get_internal(self, nVariableI):

		arrParams = [
			nVariableID,
		]

		return Deserializer.deserialize(self.rpc("variable_get_internal", arrParams))

	def server_efibootmgr_cleanup(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_efibootmgr_cleanup", arrParams)


	def server_ipmi_users_and_networking_cleanup(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_ipmi_users_and_networking_cleanup", arrParams)


	def server_interfaces_cleanup(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_interfaces_cleanup", arrParams)


	def server_networking_intel_cleanup(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_networking_intel_cleanup", arrParams)


	def server_disks_cleanup(self, nServerI):

		arrParams = [
			nServerID,
		]

		self.rpc("server_disks_cleanup", arrParams)


	def infrastructure_deploy_custom_stages(self, strInfrastructureID, strStageDefinitionTyp):

		arrParams = [
			strInfrastructureID,
			strStageDefinitionType,
		]

		return self.rpc("infrastructure_deploy_custom_stages", arrParams)


	def infrastructure_deploy_custom_stage_add_into_runlevel(self, strInfrastructureID, nStageDefinitionID, nRunLevel, strStageRunGrou):

		arrParams = [
			strInfrastructureID,
			nStageDefinitionID,
			nRunLevel,
			strStageRunGroup,
		]

		return Deserializer.deserialize(self.rpc("infrastructure_deploy_custom_stage_add_into_runlevel", arrParams))

	def infrastructure_deploy_custom_stage_move_into_runlevel(self, strInfrastructureID, nStageDefinitionID, strStageRunGroup, nSourceRunLevel, nDestinationRunLeve):

		arrParams = [
			strInfrastructureID,
			nStageDefinitionID,
			strStageRunGroup,
			nSourceRunLevel,
			nDestinationRunLevel,
		]

		self.rpc("infrastructure_deploy_custom_stage_move_into_runlevel", arrParams)


	def infrastructure_deploy_custom_stage_delete_from_runlevel(self, strInfrastructureID, nStageDefinitionID, nRunLevel, strStageRunGrou):

		arrParams = [
			strInfrastructureID,
			nStageDefinitionID,
			nRunLevel,
			strStageRunGroup,
		]

		self.rpc("infrastructure_deploy_custom_stage_delete_from_runlevel", arrParams)


	def stage_definitions(self, strUserI):

		arrParams = [
			strUserID,
		]

		objStageDefinition = self.rpc("stage_definitions", arrParams)
		for strKeyStageDefinition in objStageDefinition:
			objStageDefinition[strKeyStageDefinition] = Deserializer.deserialize(objStageDefinition[strKeyStageDefinition])
		return objStageDefinition

	def infrastructure_deploy_custom_stage_exec(self, strInfrastructureID, nInfrastructureCustomDeployStageID, objExtraVariables = [):

		objExtraVariables = Serializer.serialize(objExtraVariables)

		arrParams = [
			strInfrastructureID,
			nInfrastructureCustomDeployStageID,
			objExtraVariables,
		]

		return self.rpc("infrastructure_deploy_custom_stage_exec", arrParams)


	def stage_definition_get(self, nStageDefinitionI):

		arrParams = [
			nStageDefinitionID,
		]

		return Deserializer.deserialize(self.rpc("stage_definition_get", arrParams))

	def stage_definition_create(self, strUserID, objStageDefinitio):

		objStageDefinition = Serializer.serialize(objStageDefinition)

		arrParams = [
			strUserID,
			objStageDefinition,
		]

		return Deserializer.deserialize(self.rpc("stage_definition_create", arrParams))

	def stage_definition_update(self, nStageDefinitionID, objStageDefinitio):

		objStageDefinition = Serializer.serialize(objStageDefinition)

		arrParams = [
			nStageDefinitionID,
			objStageDefinition,
		]

		return Deserializer.deserialize(self.rpc("stage_definition_update", arrParams))

	def stage_definition_delete(self, nStageDefinitionI):

		arrParams = [
			nStageDefinitionID,
		]

		self.rpc("stage_definition_delete", arrParams)


