# This file was auto-generated by Fern from our API Definition.
from typing import Optional
from .client import RulebricksApi, AsyncRulebricksApi
from .errors import BadRequestError, InternalServerError
from .resources import (
    ListResponseItem,
    ListResponseItemRequestSchemaItem,
    ListResponseItemResponseSchemaItem,
    UsageResponse
)
from .resources.rules.client import RulesClient, AsyncRulesClient
from .resources.flows.client import FlowsClient, AsyncFlowsClient

class Config:
    api_key: str = ""
    base_url: str = "https://rulebricks.com"
    timeout: float = 10

# Initialize the API clients immediately when the module is loaded
sync_api = RulebricksApi(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)
async_api = AsyncRulebricksApi(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)

rules = sync_api.rules
flows = sync_api.flows

def configure(api_key: str = "", base_url: str = "https://rulebricks.com", timeout: float = 10.0):
    """Configure your Rulebricks API client. This needs to be called before using other Rulebricks methods."""
    Config.api_key = api_key
    Config.base_url = base_url
    Config.timeout = timeout

    # Reinitialize clients with new config
    global sync_api, async_api
    sync_api = RulebricksApi(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)
    async_api = AsyncRulebricksApi(base_url=Config.base_url, api_key=Config.api_key, timeout=Config.timeout)

    global rules, flows
    rules = sync_api.rules
    flows = sync_api.flows


__all__ = [
    "BadRequestError",
    "InternalServerError",
    "ListResponseItem",
    "ListResponseItemRequestSchemaItem",
    "ListResponseItemResponseSchemaItem",
    "UsageResponse",
    "set_api_key",
    "set_instance_url",
    "set_timeout",
    "rules",
    "flows"
    "async_api",
]
