"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLambdaToolsDefaults = exports.findUp = exports.exec = exports.getDotNetLambdaTools = void 0;
const child_process_1 = require("child_process");
const fs = require("fs");
const path = require("path");
function getDotNetLambdaTools() {
    try {
        const dotnet = (0, child_process_1.spawnSync)('dotnet', ['lambda', '--help']);
        if (dotnet.status !== 0 || dotnet.error) {
            return false;
        }
        return true;
    }
    catch (err) {
        return false;
    }
}
exports.getDotNetLambdaTools = getDotNetLambdaTools;
function exec(cmd, args, options) {
    const proc = (0, child_process_1.spawnSync)(cmd, args, options);
    if (proc.error) {
        throw proc.error;
    }
    if (proc.status !== 0) {
        if (proc.stdout || proc.stderr) {
            throw new Error(`[Status ${proc.status}] stdout: ${proc.stdout
                ?.toString()
                .trim()}\n\n\nstderr: ${proc.stderr?.toString().trim()}`);
        }
        throw new Error(`${cmd} exited with status ${proc.status}`);
    }
    return proc;
}
exports.exec = exec;
function findUp(ext, directory = process.cwd()) {
    const absoluteDirectory = path.resolve(directory);
    const file = fs.readdirSync(absoluteDirectory).find((f) => f.endsWith(ext));
    if (file) {
        return path.join(absoluteDirectory, file);
    }
    const { root } = path.parse(absoluteDirectory);
    return absoluteDirectory == root
        ? undefined
        : findUp(ext, path.dirname(absoluteDirectory));
}
exports.findUp = findUp;
function getLambdaToolsDefaults(projectDir) {
    const lambdaToolsDefaultsFile = path.join(projectDir, 'aws-lambda-tools-defaults.json');
    if (fs.existsSync(lambdaToolsDefaultsFile)) {
        return JSON.parse(fs.readFileSync(lambdaToolsDefaultsFile, 'utf8'));
    }
    return undefined;
}
exports.getLambdaToolsDefaults = getLambdaToolsDefaults;
//# sourceMappingURL=data:application/json;base64,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