"use strict";
(self["webpackChunk_elyra_pipeline_editor_extension"] = self["webpackChunk_elyra_pipeline_editor_extension"] || []).push([["vendors-node_modules_elyra_pipeline-services_dist_index_js"],{

/***/ "../../node_modules/@elyra/pipeline-services/dist/index.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/index.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./migration */ "../../node_modules/@elyra/pipeline-services/dist/migration/index.js"), exports);
__exportStar(__webpack_require__(/*! ./validation */ "../../node_modules/@elyra/pipeline-services/dist/validation/index.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentNotFoundError = void 0;
var ComponentNotFoundError = /** @class */ (function (_super) {
    __extends(ComponentNotFoundError, _super);
    function ComponentNotFoundError() {
        var _this = 
        /* istanbul ignore next */
        _super.call(this, "Component not found in any catalogue") || this;
        Object.setPrototypeOf(_this, ComponentNotFoundError.prototype);
        return _this;
    }
    return ComponentNotFoundError;
}(Error));
exports.ComponentNotFoundError = ComponentNotFoundError;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/index.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/index.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.migrate = void 0;
var immer_1 = __importDefault(__webpack_require__(/*! immer */ "../../node_modules/immer/dist/immer.esm.js"));
var migrateV1_1 = __importDefault(__webpack_require__(/*! ./migrateV1 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV1/index.js"));
var migrateV2_1 = __importDefault(__webpack_require__(/*! ./migrateV2 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV2/index.js"));
var migrateV3_1 = __importDefault(__webpack_require__(/*! ./migrateV3 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV3/index.js"));
var migrateV4_1 = __importDefault(__webpack_require__(/*! ./migrateV4 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV4/index.js"));
var migrateV5_1 = __importDefault(__webpack_require__(/*! ./migrateV5 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV5/index.js"));
var migrateV6_1 = __importDefault(__webpack_require__(/*! ./migrateV6 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js"));
var migrateV7_1 = __importDefault(__webpack_require__(/*! ./migrateV7 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV7/index.js"));
__exportStar(__webpack_require__(/*! ./errors */ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js"), exports);
function migrate(pipelineJSON, palette, setNodePathsRelativeToPipelineV2) {
    return immer_1.default(pipelineJSON, function (draft) {
        var _a, _b;
        var version = (_b = (_a = draft.pipelines[0].app_data) === null || _a === void 0 ? void 0 : _a.version) !== null && _b !== void 0 ? _b : 0;
        if (version < 1) {
            console.debug("migrating pipeline from v0 to v1");
            migrateV1_1.default(draft);
        }
        if (version < 2) {
            console.debug("migrating pipeline from v1 to v2");
            migrateV2_1.default(draft, setNodePathsRelativeToPipelineV2);
        }
        if (version < 3) {
            console.debug("migrating pipeline from v2 to v3");
            migrateV3_1.default(draft);
        }
        if (version < 4) {
            console.debug("migrating pipeline from v3 to v4");
            migrateV4_1.default(draft);
        }
        if (version < 5) {
            console.debug("migrating pipeline from v4 to v5");
            migrateV5_1.default(draft);
        }
        if (version < 6) {
            console.debug("migrating pipeline from v5 to v6");
            migrateV6_1.default(draft, palette);
        }
        if (version < 7) {
            console.debug("migrating pipeline from v6 to v7");
            migrateV7_1.default(draft, palette);
        }
    });
}
exports.migrate = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV1/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV1/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var hasAppdataField = function (node, fieldName) {
    var _a;
    return !!((_a = node.app_data) === null || _a === void 0 ? void 0 : _a.hasOwnProperty(fieldName));
};
var deleteAppdataField = function (node, fieldName) {
    if (hasAppdataField(node, fieldName)) {
        delete node.app_data[fieldName];
    }
};
var renameAppdataField = function (node, currentFieldName, newFieldName) {
    if (hasAppdataField(node, currentFieldName)) {
        node.app_data[newFieldName] = node.app_data[currentFieldName];
        deleteAppdataField(node, currentFieldName);
    }
};
function migrate(pipeline) {
    var e_1, _a;
    renameAppdataField(pipeline.pipelines[0], "title", "name");
    deleteAppdataField(pipeline.pipelines[0], "export");
    deleteAppdataField(pipeline.pipelines[0], "export_format");
    deleteAppdataField(pipeline.pipelines[0], "export_path");
    try {
        for (var _b = __values(pipeline.pipelines[0].nodes), _c = _b.next(); !_c.done; _c = _b.next()) {
            var node = _c.value;
            if (node.type === "pipeline_node") {
                node.type = "execution_node";
            }
            node.op = "execute-notebook-node";
            renameAppdataField(node, "notebook", "filename");
            renameAppdataField(node, "artifact", "filename");
            renameAppdataField(node, "docker_image", "runtime_image");
            renameAppdataField(node, "image", "runtime_image");
            renameAppdataField(node, "vars", "env_vars");
            renameAppdataField(node, "file_dependencies", "dependencies");
            renameAppdataField(node, "recursive_dependencies", "include_subdirectories");
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (pipeline.pipelines[0].app_data) {
        pipeline.pipelines[0].app_data.version = 1;
    }
    else {
        pipeline.pipelines[0].app_data = { version: 1 };
    }
    return pipeline;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV2/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV2/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var path_1 = __importDefault(__webpack_require__(/*! path */ "../../node_modules/path-browserify/index.js"));
// NOTE: technically a pipeline can have a missing app_data field however, if
// this is really an Elyra v1 pipeline, it should be guaranteed to have app_data
// otherwise we wouldn't know this is a v1 pipeline.
function migrate(pipeline, setNodePathsRelativeToPipelineV2) {
    var e_1, _a;
    if (setNodePathsRelativeToPipelineV2) {
        pipeline.pipelines[0] = setNodePathsRelativeToPipelineV2(pipeline.pipelines[0]);
    }
    else {
        try {
            for (var _b = __values(pipeline.pipelines[0].nodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                if (node.app_data) {
                    // If setNodePathsRelativeToPipeline is not given then just set
                    // filename to the basename and the user will have to update the correct
                    // path in node properties
                    node.app_data.filename = path_1.default.basename(node.app_data.filename);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    pipeline.pipelines[0].app_data.version = 2;
    return pipeline;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV3/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV3/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
// NOTE: technically a pipeline can have a missing app_data field however, if
// this is really an Elyra v2 pipeline, it should be guaranteed to have app_data
// otherwise we wouldn't know this is a v2 pipeline.
function migrate(pipeline) {
    // No-Op this is to disable old versions of Elyra
    // to see a pipeline with Python Script nodes
    pipeline.pipelines[0].app_data.version = 3;
    return pipeline;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV4/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV4/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
function migrate(pipelineFlow) {
    var e_1, _a, e_2, _b;
    var _c, _d, _e;
    try {
        for (var _f = __values(pipelineFlow.pipelines), _g = _f.next(); !_g.done; _g = _f.next()) {
            var pipeline = _g.value;
            try {
                for (var _h = (e_2 = void 0, __values(pipeline.nodes)), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var node = _j.value;
                    if (node.type === "execution_node") {
                        node.app_data = {
                            label: (_d = (_c = node.app_data.ui_data) === null || _c === void 0 ? void 0 : _c.label) !== null && _d !== void 0 ? _d : "",
                            component_parameters: node.app_data,
                            ui_data: (_e = node.app_data.ui_data) !== null && _e !== void 0 ? _e : {},
                        };
                        delete node.app_data.component_parameters.ui_data;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_j && !_j.done && (_b = _h.return)) _b.call(_h);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_g && !_g.done && (_a = _f.return)) _a.call(_f);
        }
        finally { if (e_1) throw e_1.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 4;
    return pipelineFlow;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV5/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV5/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var opMap = {
    "run-notebook-using-papermill": "run_notebook_using_papermill_Runnotebookusingpapermill",
    "filter-text": "filter_text_using_shell_and_grep_Filtertext",
    "bash-operator_BashOperator": "bash_operator_BashOperator",
    "email-operator_EmailOperator": "email_operator_EmailOperator",
    "http-operator_SimpleHttpOperator": "http_operator_SimpleHttpOperator",
    "spark-sql-operator_SparkSqlOperator": "spark_sql_operator_SparkSqlOperator",
    "spark-submit-operator_SparkSubmitOperator": "spark_submit_operator_SparkSubmitOperator",
    "slack-operator_SlackAPIPostOperator": "slack_operator_SlackAPIPostOperator",
};
function migrate(pipelineFlow) {
    var e_1, _a, e_2, _b;
    try {
        for (var _c = __values(pipelineFlow.pipelines), _d = _c.next(); !_d.done; _d = _c.next()) {
            var pipeline = _d.value;
            try {
                for (var _e = (e_2 = void 0, __values(pipeline.nodes)), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var node = _f.value;
                    var newOp = opMap[node.op];
                    if (newOp) {
                        node.op = newOp;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_1) throw e_1.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 5;
    return pipelineFlow;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var path_1 = __importDefault(__webpack_require__(/*! path */ "../../node_modules/path-browserify/index.js"));
var errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js");
var opMap = {
    run_notebook_using_papermill_Runnotebookusingpapermill: "elyra-kfp-examples-catalog:61e6f4141f65",
    filter_text_using_shell_and_grep_Filtertext: "elyra-kfp-examples-catalog:737915b826e9",
    component_Downloaddata: "elyra-kfp-examples-catalog:a08014f9252f",
    component_Calculatedatahash: "elyra-kfp-examples-catalog:d68ec7fcdf46",
    bash_operator_BashOperator: "elyra-airflow-examples-catalog:3a55d015ea96",
    email_operator_EmailOperator: "elyra-airflow-examples-catalog:a043648d3897",
    http_operator_SimpleHttpOperator: "elyra-airflow-examples-catalog:b94cd49692e2",
    spark_sql_operator_SparkSqlOperator: "elyra-airflow-examples-catalog:3b639742748f",
    spark_submit_operator_SparkSubmitOperator: "elyra-airflow-examples-catalog:b29c25ec8bd6",
    slack_operator_SlackAPIPostOperator: "elyra-airflow-examples-catalog:16a204f716a2",
};
var runtimeTypeMap = {
    kfp: "KUBEFLOW_PIPELINES",
    airflow: "APACHE_AIRFLOW",
};
function migrate(pipelineFlow, palette) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d;
    var paletteNodes = [];
    try {
        for (var _e = __values((palette === null || palette === void 0 ? void 0 : palette.categories) || []), _f = _e.next(); !_f.done; _f = _e.next()) {
            var c = _f.value;
            if (c.node_types) {
                paletteNodes.push.apply(paletteNodes, __spread(c.node_types));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
        }
        finally { if (e_1) throw e_1.error; }
    }
    // Add runtime type based on previous runtime property
    pipelineFlow.pipelines[0].app_data.runtime_type =
        runtimeTypeMap[pipelineFlow.pipelines[0].app_data.runtime];
    delete pipelineFlow.pipelines[0].app_data.runtime;
    try {
        for (var _g = __values(pipelineFlow.pipelines), _h = _g.next(); !_h.done; _h = _g.next()) {
            var pipeline = _h.value;
            var _loop_1 = function (node) {
                var newOp = opMap[node.op];
                if (newOp) {
                    // update op string
                    node.op = newOp;
                    // update component_source from string to json
                    var opParts = newOp.split(":");
                    var catalog_type = opParts[0];
                    var component_ref = {};
                    component_ref["component-id"] = path_1.default.basename(node.app_data.component_source);
                    // handle the two cases where the filename changed
                    if (component_ref["component-id"] === "component.yaml") {
                        switch (opParts[1]) {
                            case "a08014f9252f":
                                component_ref["component-id"] = "download_data.yaml";
                                break;
                            case "d68ec7fcdf46":
                                component_ref["component-id"] = "calculate_hash.yaml";
                        }
                    }
                    node.app_data.component_source = JSON.stringify({
                        catalog_type: catalog_type,
                        component_ref: component_ref,
                    });
                    // update format of values that have switch to using OneOfControl
                    // running this inside the if since only those nodes use OneOfControl
                    // only running on airflow components since kfp migration is handled in v7
                    if (pipelineFlow.pipelines[0].app_data.runtime_type === "APACHE_AIRFLOW") {
                        var nodePropertiesSchema = paletteNodes.find(function (n) { return n.op === node.op; });
                        if (nodePropertiesSchema === undefined) {
                            throw new errors_1.ComponentNotFoundError();
                        }
                        var propertyDefs_1 = nodePropertiesSchema.app_data.properties.uihints.parameter_info;
                        Object.keys((_d = node.app_data.component_parameters) !== null && _d !== void 0 ? _d : {}).forEach(function (key) {
                            var _a;
                            var propDef = propertyDefs_1.find(function (p) { return p.parameter_ref === "elyra_" + key; });
                            if ((propDef === null || propDef === void 0 ? void 0 : propDef.custom_control_id) === "OneOfControl") {
                                var activeControl = Object.keys(propDef.data.controls).find(function (c) { return c !== "NestedEnumControl"; }) || "";
                                node.app_data.component_parameters[key] = (_a = {
                                        activeControl: activeControl
                                    },
                                    _a[activeControl] = node.app_data.component_parameters[key],
                                    _a);
                            }
                        });
                    }
                }
            };
            try {
                for (var _j = (e_3 = void 0, __values(pipeline.nodes)), _k = _j.next(); !_k.done; _k = _j.next()) {
                    var node = _k.value;
                    _loop_1(node);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
        }
        finally { if (e_2) throw e_2.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 6;
    return pipelineFlow;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV7/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV7/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js");
function migrate(pipelineFlow, palette) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d;
    var paletteNodes = [];
    try {
        for (var _e = __values((palette === null || palette === void 0 ? void 0 : palette.categories) || []), _f = _e.next(); !_f.done; _f = _e.next()) {
            var c = _f.value;
            if (c.node_types) {
                paletteNodes.push.apply(paletteNodes, __spread(c.node_types));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (pipelineFlow.pipelines[0].app_data.runtime_type === "KUBEFLOW_PIPELINES") {
        try {
            for (var _g = __values(pipelineFlow.pipelines), _h = _g.next(); !_h.done; _h = _g.next()) {
                var pipeline = _h.value;
                var _loop_1 = function (node) {
                    // update format of inputvalue properties to using OneOfControl format
                    var nodePropertiesSchema = paletteNodes.find(function (n) { return n.op === node.op; });
                    if (nodePropertiesSchema === undefined) {
                        throw new errors_1.ComponentNotFoundError();
                    }
                    var propertyDefs = nodePropertiesSchema.app_data.properties.uihints.parameter_info;
                    Object.keys((_d = node.app_data.component_parameters) !== null && _d !== void 0 ? _d : {}).forEach(function (key) {
                        var _a;
                        var propDef = propertyDefs.find(function (p) { return p.parameter_ref === "elyra_" + key; });
                        if ((propDef === null || propDef === void 0 ? void 0 : propDef.custom_control_id) === "OneOfControl") {
                            var activeControl = Object.keys(propDef.data.controls).find(function (c) { return c !== "NestedEnumControl"; }) || "";
                            node.app_data.component_parameters[key] = (_a = {
                                    activeControl: activeControl
                                },
                                _a[activeControl] = node.app_data.component_parameters[key],
                                _a);
                        }
                    });
                };
                try {
                    for (var _j = (e_3 = void 0, __values(pipeline.nodes)), _k = _j.next(); !_k.done; _k = _j.next()) {
                        var node = _k.value;
                        _loop_1(node);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    pipelineFlow.pipelines[0].app_data.version = 7;
    return pipelineFlow;
}
exports["default"] = migrate;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/check-circular-references/index.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/check-circular-references/index.js ***!
  \******************************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.checkCircularReferences = void 0;
var TIMEOUT = 3000;
function checkCircularReferences(links) {
    var e_1, _a, e_2, _b;
    var startTime = Date.now();
    // filter out comment links.
    links = links.filter(function (l) { return l.type !== "commentLink"; });
    // organize links into easily indexable map:
    // {srcNodeId: link[]}
    var linkMap = {};
    try {
        for (var links_1 = __values(links), links_1_1 = links_1.next(); !links_1_1.done; links_1_1 = links_1.next()) {
            var l = links_1_1.value;
            if (linkMap[l.srcNodeId] === undefined) {
                linkMap[l.srcNodeId] = [];
            }
            linkMap[l.srcNodeId].push(l);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (links_1_1 && !links_1_1.done && (_a = links_1.return)) _a.call(links_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var orderedChain = [];
    var taintedLinks = new Set();
    var seen = new Set();
    var stack = [];
    var _loop_1 = function (l) {
        if (seen.has(l.id)) {
            return "continue";
        }
        seen.add(l.id);
        orderedChain = [];
        orderedChain.push(l.id);
        var linksToVisit = linkMap[l.trgNodeId];
        if (linksToVisit === undefined) {
            return "continue";
        }
        stack.push.apply(stack, __spread(linksToVisit));
        var forkStack = [];
        var chainLength = orderedChain.length;
        forkStack.push.apply(forkStack, __spread(linksToVisit.map(function () { return chainLength; })));
        var _loop_2 = function () {
            var e_3, _a;
            forkStack.pop();
            var l_1 = stack.pop(); // we should be gauranteed an item.
            seen.add(l_1.id);
            var seenLinkIndex = orderedChain.indexOf(l_1.id);
            // We hit a link we've already seen in the chain. This means there is a
            // cycle from the seen link to the end of the chain.
            if (seenLinkIndex > -1) {
                try {
                    for (var _b = (e_3 = void 0, __values(orderedChain.slice(seenLinkIndex))), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var item = _c.value;
                        taintedLinks.add(item);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                // This is completely useless, but it makes me feel better that this is
                // here.
                var position = forkStack.slice(-1).pop();
                if (position !== undefined) {
                    orderedChain = orderedChain.slice(0, position);
                }
                return "continue";
            }
            orderedChain.push(l_1.id);
            var linksToVisit_1 = linkMap[l_1.trgNodeId];
            // We reached the end of a chain.
            if (linksToVisit_1 === undefined) {
                // This is 100% necessary unlike the other example.
                var position = forkStack.slice(-1).pop();
                if (position !== undefined) {
                    orderedChain = orderedChain.slice(0, position);
                }
                return "continue";
            }
            // Uncharted teritory, add it to the stack to be explored.
            stack.push.apply(stack, __spread(linksToVisit_1));
            var chainLength_1 = orderedChain.length;
            forkStack.push.apply(forkStack, __spread(linksToVisit_1.map(function () { return chainLength_1; })));
        };
        while (stack.length > 0 && Date.now() - startTime < TIMEOUT) {
            _loop_2();
        }
    };
    try {
        for (var links_2 = __values(links), links_2_1 = links_2.next(); !links_2_1.done; links_2_1 = links_2.next()) {
            var l = links_2_1.value;
            _loop_1(l);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (links_2_1 && !links_2_1.done && (_b = links_2.return)) _b.call(links_2);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return __spread(taintedLinks);
}
exports.checkCircularReferences = checkCircularReferences;
exports["default"] = checkCircularReferences;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/index.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/index.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validate = exports.getNodeProblems = exports.getPipelineProblems = exports.getLinkProblems = void 0;
var jsonc_parser_1 = __webpack_require__(/*! jsonc-parser */ "../../node_modules/jsonc-parser/lib/esm/main.js");
var check_circular_references_1 = __importDefault(__webpack_require__(/*! ./check-circular-references */ "../../node_modules/@elyra/pipeline-services/dist/validation/check-circular-references/index.js"));
var utils_1 = __webpack_require__(/*! ./utils */ "../../node_modules/@elyra/pipeline-services/dist/validation/utils.js");
var validators_1 = __webpack_require__(/*! ./validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js");
function getLinkProblems(pipeline) {
    var e_1, _a;
    var links = utils_1.getLinks(pipeline);
    var taintedLinks = check_circular_references_1.default(links);
    var problems = [];
    var _loop_1 = function (linkID) {
        // linkID should be guaranteed to be found.
        var link = links.find(function (l) { return l.id === linkID; });
        var source = utils_1.findNode(pipeline, link.srcNodeId);
        var target = utils_1.findNode(pipeline, link.trgNodeId);
        problems.push({
            message: "The connection between nodes '" + source.app_data.ui_data.label + "' and '" + target.app_data.ui_data.label + "' is part of a circular reference.",
            path: __spread(link.path, ["id"]),
            info: {
                type: "circularReference",
                pipelineID: pipeline.id,
                linkID: linkID,
            },
        });
    };
    try {
        for (var taintedLinks_1 = __values(taintedLinks), taintedLinks_1_1 = taintedLinks_1.next(); !taintedLinks_1_1.done; taintedLinks_1_1 = taintedLinks_1.next()) {
            var linkID = taintedLinks_1_1.value;
            _loop_1(linkID);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (taintedLinks_1_1 && !taintedLinks_1_1.done && (_a = taintedLinks_1.return)) _a.call(taintedLinks_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return problems;
}
exports.getLinkProblems = getLinkProblems;
function getPropertyValidationErrors(prop, value) {
    var _a, _b, _c, _d;
    var errorMessages = [];
    switch (prop.custom_control_id) {
        case "EnumControl":
            var enumValidators = validators_1.getEnumValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(value, enumValidators);
            break;
        case "NestedEnumControl":
            var nestedEnumValidators = validators_1.getNestedEnumValidators(prop.data);
            errorMessages = ((_a = prop.data) === null || _a === void 0 ? void 0 : _a.required) ? validators_1.getErrorMessages(value, nestedEnumValidators)
                : [];
            break;
        case "NumberControl":
            var trimmedNumber = ((_b = value === null || value === void 0 ? void 0 : value.toString()) !== null && _b !== void 0 ? _b : "").trim();
            if (!((_c = prop.data) === null || _c === void 0 ? void 0 : _c.required) && trimmedNumber === "") {
                break;
            }
            var numberValidators = validators_1.getNumberValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(trimmedNumber, numberValidators);
            break;
        case "StringArrayControl":
            var stringArrayValidators = validators_1.getStringArrayValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(value !== null && value !== void 0 ? value : [], stringArrayValidators);
            break;
        case "StringControl":
            var trimmedString = (value !== null && value !== void 0 ? value : "").trim();
            if (!((_d = prop.data) === null || _d === void 0 ? void 0 : _d.required) && trimmedString === "") {
                break;
            }
            var stringValidators = validators_1.getStringValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(trimmedString, stringValidators);
            break;
    }
    return errorMessages;
}
function getPipelineProblems(pipeline, pipelineProperties) {
    var e_2, _a;
    var _b, _c, _d, _e, _f, _g;
    var problems = [];
    try {
        for (var _h = __values((_b = pipelineProperties === null || pipelineProperties === void 0 ? void 0 : pipelineProperties.uihints.parameter_info) !== null && _b !== void 0 ? _b : []), _j = _h.next(); !_j.done; _j = _h.next()) {
            var prop = _j.value;
            // If the property isn't in the json, report the error one level higher.
            var path = ["pipeline", "0", "app_data"];
            if (((_c = pipeline.app_data) === null || _c === void 0 ? void 0 : _c[prop.parameter_ref]) !== undefined) {
                path.push(prop.parameter_ref);
            }
            // this should be safe because a boolean can't be required
            // otherwise we would need to check strings for undefined or empty string
            // NOTE: 0 is also falsy, but we don't have any number inputs right now?
            // TODO: We should update this to do type checking.
            var value = utils_1.getValue((_d = pipeline.app_data) === null || _d === void 0 ? void 0 : _d.properties, prop.parameter_ref, (_f = (_e = pipeline.app_data) === null || _e === void 0 ? void 0 : _e.properties) === null || _f === void 0 ? void 0 : _f.pipeline_defaults);
            if (((_g = prop.data) === null || _g === void 0 ? void 0 : _g.required) && !value) {
                problems.push({
                    message: "The pipeline property '" + prop.label.default + "' is required.",
                    path: path,
                    info: {
                        type: "missingProperty",
                        pipelineID: pipeline.id,
                        // do not strip elyra here, we need to differentiate between pipeline_defaults still.
                        property: prop.parameter_ref,
                    },
                });
            }
            var errorMessages = getPropertyValidationErrors(prop, value);
            if (errorMessages[0] !== undefined) {
                problems.push({
                    message: "The pipeline property '" + prop.label.default + "' is invalid: " + errorMessages[0],
                    path: path,
                    info: {
                        type: "invalidProperty",
                        pipelineID: pipeline.id,
                        // do not strip elyra here, we need to differentiate between pipeline_defaults still.
                        property: prop.parameter_ref,
                        message: errorMessages[0],
                    },
                });
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_j && !_j.done && (_a = _h.return)) _a.call(_h);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return problems;
}
exports.getPipelineProblems = getPipelineProblems;
function getNodeProblems(pipeline, nodeDefinitions) {
    var e_3, _a;
    var _b, _c, _d, _e, _f;
    var nodes = utils_1.getNodes(pipeline);
    var problems = [];
    var _loop_2 = function (n, node) {
        var e_4, _a;
        if (node.type !== "execution_node") {
            return "continue";
        }
        var nodeDef = nodeDefinitions.find(function (n) { return n.op === node.op; });
        if (nodeDef === undefined) {
            problems.push({
                message: "The component '" + node.op + "' cannot be found.",
                path: ["nodes", n],
                info: {
                    type: "missingComponent",
                    pipelineID: pipeline.id,
                    nodeID: node.id,
                    op: node.op,
                },
            });
            return "continue";
        }
        try {
            for (var _b = (e_4 = void 0, __values((_c = (_b = nodeDef.app_data.properties) === null || _b === void 0 ? void 0 : _b.uihints.parameter_info) !== null && _c !== void 0 ? _c : [])), _c = _b.next(); !_c.done; _c = _b.next()) {
                var prop = _c.value;
                // If the property isn't in the json, report the error one level higher.
                var path = ["nodes", n, "app_data"];
                if (node.app_data[prop.parameter_ref] !== undefined) {
                    path.push(prop.parameter_ref);
                }
                // this should be safe because a boolean can't be required
                // otherwise we would need to check strings for undefined or empty string
                // NOTE: 0 is also falsy, but we don't have any number inputs right now?
                // TODO: We should update this to do type checking.
                var value = utils_1.getValue(node.app_data, prop.parameter_ref, (_e = (_d = pipeline.app_data) === null || _d === void 0 ? void 0 : _d.properties) === null || _e === void 0 ? void 0 : _e.pipeline_defaults);
                if (((_f = prop.data) === null || _f === void 0 ? void 0 : _f.required) && !value) {
                    problems.push({
                        message: "The property '" + prop.label.default + "' on node '" + node.app_data.ui_data.label + "' is required.",
                        path: path,
                        info: {
                            type: "missingProperty",
                            pipelineID: pipeline.id,
                            nodeID: node.id,
                            // do not strip elyra here, we need to differentiate between component_parameters still.
                            property: prop.parameter_ref,
                        },
                    });
                }
                var errorMessages = getPropertyValidationErrors(prop, value);
                if (errorMessages[0] !== undefined) {
                    problems.push({
                        message: "The property '" + prop.label.default + "' on node '" + node.app_data.ui_data.label + "' is invalid: " + errorMessages[0],
                        path: path,
                        info: {
                            type: "invalidProperty",
                            pipelineID: pipeline.id,
                            nodeID: node.id,
                            // do not strip elyra here, we need to differentiate between component_parameters still.
                            property: prop.parameter_ref,
                            message: errorMessages[0],
                        },
                    });
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
    };
    try {
        for (var _g = __values(nodes.entries()), _h = _g.next(); !_h.done; _h = _g.next()) {
            var _j = __read(_h.value, 2), n = _j[0], node = _j[1];
            _loop_2(n, node);
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_h && !_h.done && (_a = _g.return)) _a.call(_g);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return problems;
}
exports.getNodeProblems = getNodeProblems;
function validate(pipeline, nodeDefinitions, pipelineProperties) {
    var e_5, _a;
    var pipelineTreeRoot = jsonc_parser_1.parseTree(pipeline);
    if (pipelineTreeRoot === undefined) {
        return [];
    }
    var pipelineJSON = JSON.parse(pipeline);
    var problems = [];
    var _loop_3 = function (p, pipeline_1) {
        var partials = [];
        partials.push.apply(partials, __spread(getPipelineProblems(pipeline_1, pipelineProperties)));
        partials.push.apply(partials, __spread(getLinkProblems(pipeline_1)));
        partials.push.apply(partials, __spread(getNodeProblems(pipeline_1, nodeDefinitions)));
        problems.push.apply(problems, __spread(partials.map(function (partial) {
            var path = partial.path, rest = __rest(partial, ["path"]);
            var location = jsonc_parser_1.findNodeAtLocation(pipelineTreeRoot, __spread([
                "pipelines",
                p
            ], path));
            return __assign(__assign({}, rest), { severity: 1, range: utils_1.rangeForLocation(location) });
        })));
    };
    try {
        for (var _b = __values(pipelineJSON.pipelines.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var _d = __read(_c.value, 2), p = _d[0], pipeline_1 = _d[1];
            _loop_3(p, pipeline_1);
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_5) throw e_5.error; }
    }
    return problems;
}
exports.validate = validate;
__exportStar(__webpack_require__(/*! ./validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js"), exports);
__exportStar(__webpack_require__(/*! ./types */ "../../node_modules/@elyra/pipeline-services/dist/validation/types.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/types.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/types.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=types.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/utils.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/utils.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getValue = exports.rangeForLocation = exports.findNode = exports.getNodes = exports.getLinks = void 0;
function getLinks(pipeline) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d, _e;
    var links = [];
    try {
        for (var _f = __values(pipeline.nodes.entries()), _g = _f.next(); !_g.done; _g = _f.next()) {
            var _h = __read(_g.value, 2), n = _h[0], node = _h[1];
            try {
                for (var _j = (e_2 = void 0, __values((_e = (_d = node.inputs) === null || _d === void 0 ? void 0 : _d.entries()) !== null && _e !== void 0 ? _e : [])), _k = _j.next(); !_k.done; _k = _j.next()) {
                    var _l = __read(_k.value, 2), i = _l[0], input = _l[1];
                    if (input.links !== undefined) {
                        try {
                            for (var _m = (e_3 = void 0, __values(input.links.entries())), _o = _m.next(); !_o.done; _o = _m.next()) {
                                var _p = __read(_o.value, 2), l = _p[0], link = _p[1];
                                if (findNode(pipeline, link.node_id_ref) !== undefined) {
                                    links.push({
                                        id: link.id,
                                        trgNodeId: node.id,
                                        srcNodeId: link.node_id_ref,
                                        // TODO: handle link type
                                        type: "",
                                        path: ["nodes", n, "inputs", i, "links", l],
                                    });
                                }
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (_o && !_o.done && (_c = _m.return)) _c.call(_m);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_k && !_k.done && (_b = _j.return)) _b.call(_j);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_g && !_g.done && (_a = _f.return)) _a.call(_f);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return links;
}
exports.getLinks = getLinks;
function getNodes(pipeline) {
    return pipeline.nodes;
}
exports.getNodes = getNodes;
function findNode(pipeline, id) {
    return pipeline.nodes.find(function (node) { return node.id === id; });
}
exports.findNode = findNode;
function rangeForLocation(location) {
    var _a, _b, _c, _d;
    var offset = (_b = (_a = location === null || location === void 0 ? void 0 : location.parent) === null || _a === void 0 ? void 0 : _a.offset) !== null && _b !== void 0 ? _b : 0;
    var length = ((_d = (_c = location === null || location === void 0 ? void 0 : location.parent) === null || _c === void 0 ? void 0 : _c.colonOffset) !== null && _d !== void 0 ? _d : 0) - offset;
    return { offset: offset, length: length };
}
exports.rangeForLocation = rangeForLocation;
function getValue(app_data, key, pipelineDefaults) {
    var _a, _b;
    if (key.startsWith("elyra_")) {
        var stripped = key.replace(/^elyra_/, "");
        return ((_b = (_a = app_data.component_parameters) === null || _a === void 0 ? void 0 : _a[stripped]) !== null && _b !== void 0 ? _b : pipelineDefaults === null || pipelineDefaults === void 0 ? void 0 : pipelineDefaults[stripped]);
    }
    return app_data[key];
}
exports.getValue = getValue;
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/enum-validators.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/enum-validators.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnumValidators = void 0;
function getEnumValidators(_a) {
    var required = _a.required, pipeline_default = _a.pipeline_default;
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) {
                return value !== undefined || !!pipeline_default;
            },
        },
    ];
    return validators;
}
exports.getEnumValidators = getEnumValidators;
//# sourceMappingURL=enum-validators.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getErrorMessages = void 0;
function getErrorMessages(value, validators) {
    return validators
        .filter(function (v) { return v.enabled && !v.isValid(value); })
        .map(function (v) { return v.message; });
}
exports.getErrorMessages = getErrorMessages;
__exportStar(__webpack_require__(/*! ./string-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./number-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/number-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./string-array-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-array-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./enum-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/enum-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./nested-enum-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/nested-enum-validators.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/nested-enum-validators.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/nested-enum-validators.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNestedEnumValidators = void 0;
function getNestedEnumValidators(_a) {
    var data = _a.data, allownooptions = _a.allownooptions, required = _a.required;
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) { return value !== undefined; },
        },
        {
            enabled: data !== undefined,
            isValid: function (value) {
                var _a;
                var selected = data.find(function (item) { return item.value === (value === null || value === void 0 ? void 0 : value.value); });
                var option = (_a = selected === null || selected === void 0 ? void 0 : selected.options) === null || _a === void 0 ? void 0 : _a.find(function (item) { return item.value === (value === null || value === void 0 ? void 0 : value.option); });
                return !!selected && (allownooptions || !!option);
            },
            message: "Value must be a valid option",
        },
    ];
    return validators;
}
exports.getNestedEnumValidators = getNestedEnumValidators;
//# sourceMappingURL=nested-enum-validators.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/number-validators.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/number-validators.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNumberValidators = void 0;
function getNumberValidators(_a) {
    var type = _a.type, multipleOf = _a.multipleOf, minimum = _a.minimum, maximum = _a.maximum, exclusiveMinimum = _a.exclusiveMinimum, exclusiveMaximum = _a.exclusiveMaximum, required = _a.required;
    // JSON schema allows `exclusive min/max` to be a boolean to indicate min/max
    // are exclusive or a number.
    var exclusiveMax;
    var exclusiveMin;
    if (typeof exclusiveMaximum === "boolean") {
        exclusiveMax = exclusiveMaximum ? maximum : undefined;
    }
    else {
        exclusiveMax = exclusiveMaximum;
    }
    if (typeof exclusiveMinimum === "boolean") {
        exclusiveMin = exclusiveMinimum ? minimum : undefined;
    }
    else {
        exclusiveMin = exclusiveMinimum;
    }
    var isNumber = function (value) { return !isNaN(+value) && !isNaN(parseFloat(value)); };
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) { return value !== ""; },
        },
        {
            enabled: true,
            isValid: function (value) { return value === "" || isNumber(value); },
            message: "Value must be a number.",
        },
        {
            enabled: exclusiveMax !== undefined &&
                (maximum === undefined || exclusiveMax <= maximum),
            isValid: function (value) { return +value < exclusiveMax; },
            message: "Value must be strictly less than " + exclusiveMax + ".",
        },
        {
            enabled: exclusiveMin !== undefined &&
                (minimum === undefined || exclusiveMin >= minimum),
            isValid: function (value) { return +value > exclusiveMin; },
            message: "Value must be strictly greater than " + exclusiveMin + ".",
        },
        {
            enabled: maximum !== undefined &&
                (exclusiveMax === undefined || exclusiveMax > maximum),
            isValid: function (value) { return +value <= maximum; },
            message: "Value must be less than or equal to " + maximum + ".",
        },
        {
            enabled: minimum !== undefined &&
                (exclusiveMin === undefined || exclusiveMin < minimum),
            isValid: function (value) { return +value >= minimum; },
            message: "Value must be greater than or equal to " + minimum + ".",
        },
        {
            enabled: multipleOf !== undefined,
            isValid: function (value) { return +value % multipleOf === 0; },
            message: "Value must be a multiple of " + multipleOf + ".",
        },
        {
            enabled: type === "integer",
            // check if the string includes a decimal to prevent something like "10.0"
            isValid: function (value) { return +value % 1 === 0 && !value.includes("."); },
            message: "Value must be an integer.",
        },
    ];
    return validators;
}
exports.getNumberValidators = getNumberValidators;
//# sourceMappingURL=number-validators.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-array-validators.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-array-validators.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStringArrayValidators = void 0;
var isKeyValueFormat = function (item) {
    var parts = item.split("=");
    return parts.length >= 2 && parts[0] !== "";
};
function getStringArrayValidators(_a) {
    var uniqueItems = _a.uniqueItems, minItems = _a.minItems, maxItems = _a.maxItems, keyValueEntries = _a.keyValueEntries;
    var validators = [
        {
            enabled: uniqueItems === true,
            isValid: function (value) { return new Set(value).size === value.length; },
            message: "Array has duplicate items.",
        },
        {
            enabled: minItems !== undefined,
            isValid: function (value) { return value.length < minItems; },
            message: "Array must have at least " + minItems + " items.",
        },
        {
            enabled: maxItems !== undefined,
            isValid: function (value) { return value.length < maxItems; },
            message: "Array must have at most " + maxItems + " items.",
        },
        {
            enabled: keyValueEntries === true,
            isValid: function (value) {
                return !value.some(function (item) { return !isKeyValueFormat(item); });
            },
            message: "Array items must be in key=value format.",
        },
    ];
    return validators;
}
exports.getStringArrayValidators = getStringArrayValidators;
//# sourceMappingURL=string-array-validators.js.map

/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-validators.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-validators.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStringValidators = void 0;
function getStringValidators(_a) {
    var required = _a.required, pattern = _a.pattern, patternErrorMessage = _a.patternErrorMessage, maxLength = _a.maxLength, minLength = _a.minLength, format = _a.format;
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) { return value !== ""; },
        },
        {
            enabled: maxLength !== undefined,
            isValid: function (value) { return value.length <= maxLength; },
            message: "Value must be " + maxLength + " or fewer characters long.",
        },
        {
            enabled: minLength !== undefined,
            isValid: function (value) { return value.length >= minLength; },
            message: "Value must be " + minLength + " or more characters long.",
        },
        {
            enabled: pattern !== undefined,
            isValid: function (value) { return new RegExp(pattern).test(value); },
            message: patternErrorMessage !== null && patternErrorMessage !== void 0 ? patternErrorMessage : "Value must match regex `" + pattern + "`.",
        },
        // We don't have any format validation yet, but when we do they will go here
        {
            enabled: format === "file",
            isValid: function () { return true; },
        },
    ];
    return validators;
}
exports.getStringValidators = getStringValidators;
//# sourceMappingURL=string-validators.js.map

/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/edit.js":
/*!************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/edit.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applyEdit": () => (/* binding */ applyEdit),
/* harmony export */   "isWS": () => (/* binding */ isWS),
/* harmony export */   "removeProperty": () => (/* binding */ removeProperty),
/* harmony export */   "setProperty": () => (/* binding */ setProperty)
/* harmony export */ });
/* harmony import */ var _format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./format */ "../../node_modules/jsonc-parser/lib/esm/impl/format.js");
/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parser */ "../../node_modules/jsonc-parser/lib/esm/impl/parser.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



function removeProperty(text, path, options) {
    return setProperty(text, path, void 0, options);
}
function setProperty(text, originalPath, value, options) {
    var _a;
    var path = originalPath.slice();
    var errors = [];
    var root = (0,_parser__WEBPACK_IMPORTED_MODULE_1__.parseTree)(text, errors);
    var parent = void 0;
    var lastSegment = void 0;
    while (path.length > 0) {
        lastSegment = path.pop();
        parent = (0,_parser__WEBPACK_IMPORTED_MODULE_1__.findNodeAtLocation)(root, path);
        if (parent === void 0 && value !== void 0) {
            if (typeof lastSegment === 'string') {
                value = (_a = {}, _a[lastSegment] = value, _a);
            }
            else {
                value = [value];
            }
        }
        else {
            break;
        }
    }
    if (!parent) {
        // empty document
        if (value === void 0) { // delete
            throw new Error('Can not delete in empty document');
        }
        return withFormatting(text, { offset: root ? root.offset : 0, length: root ? root.length : 0, content: JSON.stringify(value) }, options);
    }
    else if (parent.type === 'object' && typeof lastSegment === 'string' && Array.isArray(parent.children)) {
        var existing = (0,_parser__WEBPACK_IMPORTED_MODULE_1__.findNodeAtLocation)(parent, [lastSegment]);
        if (existing !== void 0) {
            if (value === void 0) { // delete
                if (!existing.parent) {
                    throw new Error('Malformed AST');
                }
                var propertyIndex = parent.children.indexOf(existing.parent);
                var removeBegin = void 0;
                var removeEnd = existing.parent.offset + existing.parent.length;
                if (propertyIndex > 0) {
                    // remove the comma of the previous node
                    var previous = parent.children[propertyIndex - 1];
                    removeBegin = previous.offset + previous.length;
                }
                else {
                    removeBegin = parent.offset + 1;
                    if (parent.children.length > 1) {
                        // remove the comma of the next node
                        var next = parent.children[1];
                        removeEnd = next.offset;
                    }
                }
                return withFormatting(text, { offset: removeBegin, length: removeEnd - removeBegin, content: '' }, options);
            }
            else {
                // set value of existing property
                return withFormatting(text, { offset: existing.offset, length: existing.length, content: JSON.stringify(value) }, options);
            }
        }
        else {
            if (value === void 0) { // delete
                return []; // property does not exist, nothing to do
            }
            var newProperty = JSON.stringify(lastSegment) + ": " + JSON.stringify(value);
            var index = options.getInsertionIndex ? options.getInsertionIndex(parent.children.map(function (p) { return p.children[0].value; })) : parent.children.length;
            var edit = void 0;
            if (index > 0) {
                var previous = parent.children[index - 1];
                edit = { offset: previous.offset + previous.length, length: 0, content: ',' + newProperty };
            }
            else if (parent.children.length === 0) {
                edit = { offset: parent.offset + 1, length: 0, content: newProperty };
            }
            else {
                edit = { offset: parent.offset + 1, length: 0, content: newProperty + ',' };
            }
            return withFormatting(text, edit, options);
        }
    }
    else if (parent.type === 'array' && typeof lastSegment === 'number' && Array.isArray(parent.children)) {
        var insertIndex = lastSegment;
        if (insertIndex === -1) {
            // Insert
            var newProperty = "" + JSON.stringify(value);
            var edit = void 0;
            if (parent.children.length === 0) {
                edit = { offset: parent.offset + 1, length: 0, content: newProperty };
            }
            else {
                var previous = parent.children[parent.children.length - 1];
                edit = { offset: previous.offset + previous.length, length: 0, content: ',' + newProperty };
            }
            return withFormatting(text, edit, options);
        }
        else if (value === void 0 && parent.children.length >= 0) {
            // Removal
            var removalIndex = lastSegment;
            var toRemove = parent.children[removalIndex];
            var edit = void 0;
            if (parent.children.length === 1) {
                // only item
                edit = { offset: parent.offset + 1, length: parent.length - 2, content: '' };
            }
            else if (parent.children.length - 1 === removalIndex) {
                // last item
                var previous = parent.children[removalIndex - 1];
                var offset = previous.offset + previous.length;
                var parentEndOffset = parent.offset + parent.length;
                edit = { offset: offset, length: parentEndOffset - 2 - offset, content: '' };
            }
            else {
                edit = { offset: toRemove.offset, length: parent.children[removalIndex + 1].offset - toRemove.offset, content: '' };
            }
            return withFormatting(text, edit, options);
        }
        else if (value !== void 0) {
            var edit = void 0;
            var newProperty = "" + JSON.stringify(value);
            if (!options.isArrayInsertion && parent.children.length > lastSegment) {
                var toModify = parent.children[lastSegment];
                edit = { offset: toModify.offset, length: toModify.length, content: newProperty };
            }
            else if (parent.children.length === 0 || lastSegment === 0) {
                edit = { offset: parent.offset + 1, length: 0, content: parent.children.length === 0 ? newProperty : newProperty + ',' };
            }
            else {
                var index = lastSegment > parent.children.length ? parent.children.length : lastSegment;
                var previous = parent.children[index - 1];
                edit = { offset: previous.offset + previous.length, length: 0, content: ',' + newProperty };
            }
            return withFormatting(text, edit, options);
        }
        else {
            throw new Error("Can not " + (value === void 0 ? 'remove' : (options.isArrayInsertion ? 'insert' : 'modify')) + " Array index " + insertIndex + " as length is not sufficient");
        }
    }
    else {
        throw new Error("Can not add " + (typeof lastSegment !== 'number' ? 'index' : 'property') + " to parent of type " + parent.type);
    }
}
function withFormatting(text, edit, options) {
    if (!options.formattingOptions) {
        return [edit];
    }
    // apply the edit
    var newText = applyEdit(text, edit);
    // format the new text
    var begin = edit.offset;
    var end = edit.offset + edit.content.length;
    if (edit.length === 0 || edit.content.length === 0) { // insert or remove
        while (begin > 0 && !(0,_format__WEBPACK_IMPORTED_MODULE_0__.isEOL)(newText, begin - 1)) {
            begin--;
        }
        while (end < newText.length && !(0,_format__WEBPACK_IMPORTED_MODULE_0__.isEOL)(newText, end)) {
            end++;
        }
    }
    var edits = (0,_format__WEBPACK_IMPORTED_MODULE_0__.format)(newText, { offset: begin, length: end - begin }, options.formattingOptions);
    // apply the formatting edits and track the begin and end offsets of the changes
    for (var i = edits.length - 1; i >= 0; i--) {
        var edit_1 = edits[i];
        newText = applyEdit(newText, edit_1);
        begin = Math.min(begin, edit_1.offset);
        end = Math.max(end, edit_1.offset + edit_1.length);
        end += edit_1.content.length - edit_1.length;
    }
    // create a single edit with all changes
    var editLength = text.length - (newText.length - end) - begin;
    return [{ offset: begin, length: editLength, content: newText.substring(begin, end) }];
}
function applyEdit(text, edit) {
    return text.substring(0, edit.offset) + edit.content + text.substring(edit.offset + edit.length);
}
function isWS(text, offset) {
    return '\r\n \t'.indexOf(text.charAt(offset)) !== -1;
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/format.js":
/*!**************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/format.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "format": () => (/* binding */ format),
/* harmony export */   "isEOL": () => (/* binding */ isEOL)
/* harmony export */ });
/* harmony import */ var _scanner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scanner */ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


function format(documentText, range, options) {
    var initialIndentLevel;
    var formatText;
    var formatTextStart;
    var rangeStart;
    var rangeEnd;
    if (range) {
        rangeStart = range.offset;
        rangeEnd = rangeStart + range.length;
        formatTextStart = rangeStart;
        while (formatTextStart > 0 && !isEOL(documentText, formatTextStart - 1)) {
            formatTextStart--;
        }
        var endOffset = rangeEnd;
        while (endOffset < documentText.length && !isEOL(documentText, endOffset)) {
            endOffset++;
        }
        formatText = documentText.substring(formatTextStart, endOffset);
        initialIndentLevel = computeIndentLevel(formatText, options);
    }
    else {
        formatText = documentText;
        initialIndentLevel = 0;
        formatTextStart = 0;
        rangeStart = 0;
        rangeEnd = documentText.length;
    }
    var eol = getEOL(options, documentText);
    var lineBreak = false;
    var indentLevel = 0;
    var indentValue;
    if (options.insertSpaces) {
        indentValue = repeat(' ', options.tabSize || 4);
    }
    else {
        indentValue = '\t';
    }
    var scanner = (0,_scanner__WEBPACK_IMPORTED_MODULE_0__.createScanner)(formatText, false);
    var hasError = false;
    function newLineAndIndent() {
        return eol + repeat(indentValue, initialIndentLevel + indentLevel);
    }
    function scanNext() {
        var token = scanner.scan();
        lineBreak = false;
        while (token === 15 /* Trivia */ || token === 14 /* LineBreakTrivia */) {
            lineBreak = lineBreak || (token === 14 /* LineBreakTrivia */);
            token = scanner.scan();
        }
        hasError = token === 16 /* Unknown */ || scanner.getTokenError() !== 0 /* None */;
        return token;
    }
    var editOperations = [];
    function addEdit(text, startOffset, endOffset) {
        if (!hasError && (!range || (startOffset < rangeEnd && endOffset > rangeStart)) && documentText.substring(startOffset, endOffset) !== text) {
            editOperations.push({ offset: startOffset, length: endOffset - startOffset, content: text });
        }
    }
    var firstToken = scanNext();
    if (firstToken !== 17 /* EOF */) {
        var firstTokenStart = scanner.getTokenOffset() + formatTextStart;
        var initialIndent = repeat(indentValue, initialIndentLevel);
        addEdit(initialIndent, formatTextStart, firstTokenStart);
    }
    while (firstToken !== 17 /* EOF */) {
        var firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
        var secondToken = scanNext();
        var replaceContent = '';
        var needsLineBreak = false;
        while (!lineBreak && (secondToken === 12 /* LineCommentTrivia */ || secondToken === 13 /* BlockCommentTrivia */)) {
            // comments on the same line: keep them on the same line, but ignore them otherwise
            var commentTokenStart = scanner.getTokenOffset() + formatTextStart;
            addEdit(' ', firstTokenEnd, commentTokenStart);
            firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
            needsLineBreak = secondToken === 12 /* LineCommentTrivia */;
            replaceContent = needsLineBreak ? newLineAndIndent() : '';
            secondToken = scanNext();
        }
        if (secondToken === 2 /* CloseBraceToken */) {
            if (firstToken !== 1 /* OpenBraceToken */) {
                indentLevel--;
                replaceContent = newLineAndIndent();
            }
        }
        else if (secondToken === 4 /* CloseBracketToken */) {
            if (firstToken !== 3 /* OpenBracketToken */) {
                indentLevel--;
                replaceContent = newLineAndIndent();
            }
        }
        else {
            switch (firstToken) {
                case 3 /* OpenBracketToken */:
                case 1 /* OpenBraceToken */:
                    indentLevel++;
                    replaceContent = newLineAndIndent();
                    break;
                case 5 /* CommaToken */:
                case 12 /* LineCommentTrivia */:
                    replaceContent = newLineAndIndent();
                    break;
                case 13 /* BlockCommentTrivia */:
                    if (lineBreak) {
                        replaceContent = newLineAndIndent();
                    }
                    else if (!needsLineBreak) {
                        // symbol following comment on the same line: keep on same line, separate with ' '
                        replaceContent = ' ';
                    }
                    break;
                case 6 /* ColonToken */:
                    if (!needsLineBreak) {
                        replaceContent = ' ';
                    }
                    break;
                case 10 /* StringLiteral */:
                    if (secondToken === 6 /* ColonToken */) {
                        if (!needsLineBreak) {
                            replaceContent = '';
                        }
                        break;
                    }
                // fall through
                case 7 /* NullKeyword */:
                case 8 /* TrueKeyword */:
                case 9 /* FalseKeyword */:
                case 11 /* NumericLiteral */:
                case 2 /* CloseBraceToken */:
                case 4 /* CloseBracketToken */:
                    if (secondToken === 12 /* LineCommentTrivia */ || secondToken === 13 /* BlockCommentTrivia */) {
                        if (!needsLineBreak) {
                            replaceContent = ' ';
                        }
                    }
                    else if (secondToken !== 5 /* CommaToken */ && secondToken !== 17 /* EOF */) {
                        hasError = true;
                    }
                    break;
                case 16 /* Unknown */:
                    hasError = true;
                    break;
            }
            if (lineBreak && (secondToken === 12 /* LineCommentTrivia */ || secondToken === 13 /* BlockCommentTrivia */)) {
                replaceContent = newLineAndIndent();
            }
        }
        if (secondToken === 17 /* EOF */) {
            replaceContent = options.insertFinalNewline ? eol : '';
        }
        var secondTokenStart = scanner.getTokenOffset() + formatTextStart;
        addEdit(replaceContent, firstTokenEnd, secondTokenStart);
        firstToken = secondToken;
    }
    return editOperations;
}
function repeat(s, count) {
    var result = '';
    for (var i = 0; i < count; i++) {
        result += s;
    }
    return result;
}
function computeIndentLevel(content, options) {
    var i = 0;
    var nChars = 0;
    var tabSize = options.tabSize || 4;
    while (i < content.length) {
        var ch = content.charAt(i);
        if (ch === ' ') {
            nChars++;
        }
        else if (ch === '\t') {
            nChars += tabSize;
        }
        else {
            break;
        }
        i++;
    }
    return Math.floor(nChars / tabSize);
}
function getEOL(options, text) {
    for (var i = 0; i < text.length; i++) {
        var ch = text.charAt(i);
        if (ch === '\r') {
            if (i + 1 < text.length && text.charAt(i + 1) === '\n') {
                return '\r\n';
            }
            return '\r';
        }
        else if (ch === '\n') {
            return '\n';
        }
    }
    return (options && options.eol) || '\n';
}
function isEOL(text, offset) {
    return '\r\n'.indexOf(text.charAt(offset)) !== -1;
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/parser.js":
/*!**************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/parser.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "contains": () => (/* binding */ contains),
/* harmony export */   "findNodeAtLocation": () => (/* binding */ findNodeAtLocation),
/* harmony export */   "findNodeAtOffset": () => (/* binding */ findNodeAtOffset),
/* harmony export */   "getLocation": () => (/* binding */ getLocation),
/* harmony export */   "getNodePath": () => (/* binding */ getNodePath),
/* harmony export */   "getNodeType": () => (/* binding */ getNodeType),
/* harmony export */   "getNodeValue": () => (/* binding */ getNodeValue),
/* harmony export */   "parse": () => (/* binding */ parse),
/* harmony export */   "parseTree": () => (/* binding */ parseTree),
/* harmony export */   "stripComments": () => (/* binding */ stripComments),
/* harmony export */   "visit": () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _scanner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scanner */ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var ParseOptions;
(function (ParseOptions) {
    ParseOptions.DEFAULT = {
        allowTrailingComma: false
    };
})(ParseOptions || (ParseOptions = {}));
/**
 * For a given offset, evaluate the location in the JSON document. Each segment in the location path is either a property name or an array index.
 */
function getLocation(text, position) {
    var segments = []; // strings or numbers
    var earlyReturnException = new Object();
    var previousNode = undefined;
    var previousNodeInst = {
        value: {},
        offset: 0,
        length: 0,
        type: 'object',
        parent: undefined
    };
    var isAtPropertyKey = false;
    function setPreviousNode(value, offset, length, type) {
        previousNodeInst.value = value;
        previousNodeInst.offset = offset;
        previousNodeInst.length = length;
        previousNodeInst.type = type;
        previousNodeInst.colonOffset = undefined;
        previousNode = previousNodeInst;
    }
    try {
        visit(text, {
            onObjectBegin: function (offset, length) {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                isAtPropertyKey = position > offset;
                segments.push(''); // push a placeholder (will be replaced)
            },
            onObjectProperty: function (name, offset, length) {
                if (position < offset) {
                    throw earlyReturnException;
                }
                setPreviousNode(name, offset, length, 'property');
                segments[segments.length - 1] = name;
                if (position <= offset + length) {
                    throw earlyReturnException;
                }
            },
            onObjectEnd: function (offset, length) {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.pop();
            },
            onArrayBegin: function (offset, length) {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.push(0);
            },
            onArrayEnd: function (offset, length) {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.pop();
            },
            onLiteralValue: function (value, offset, length) {
                if (position < offset) {
                    throw earlyReturnException;
                }
                setPreviousNode(value, offset, length, getNodeType(value));
                if (position <= offset + length) {
                    throw earlyReturnException;
                }
            },
            onSeparator: function (sep, offset, length) {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                if (sep === ':' && previousNode && previousNode.type === 'property') {
                    previousNode.colonOffset = offset;
                    isAtPropertyKey = false;
                    previousNode = undefined;
                }
                else if (sep === ',') {
                    var last = segments[segments.length - 1];
                    if (typeof last === 'number') {
                        segments[segments.length - 1] = last + 1;
                    }
                    else {
                        isAtPropertyKey = true;
                        segments[segments.length - 1] = '';
                    }
                    previousNode = undefined;
                }
            }
        });
    }
    catch (e) {
        if (e !== earlyReturnException) {
            throw e;
        }
    }
    return {
        path: segments,
        previousNode: previousNode,
        isAtPropertyKey: isAtPropertyKey,
        matches: function (pattern) {
            var k = 0;
            for (var i = 0; k < pattern.length && i < segments.length; i++) {
                if (pattern[k] === segments[i] || pattern[k] === '*') {
                    k++;
                }
                else if (pattern[k] !== '**') {
                    return false;
                }
            }
            return k === pattern.length;
        }
    };
}
/**
 * Parses the given text and returns the object the JSON content represents. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 * Therefore always check the errors list to find out if the input was valid.
 */
function parse(text, errors, options) {
    if (errors === void 0) { errors = []; }
    if (options === void 0) { options = ParseOptions.DEFAULT; }
    var currentProperty = null;
    var currentParent = [];
    var previousParents = [];
    function onValue(value) {
        if (Array.isArray(currentParent)) {
            currentParent.push(value);
        }
        else if (currentProperty !== null) {
            currentParent[currentProperty] = value;
        }
    }
    var visitor = {
        onObjectBegin: function () {
            var object = {};
            onValue(object);
            previousParents.push(currentParent);
            currentParent = object;
            currentProperty = null;
        },
        onObjectProperty: function (name) {
            currentProperty = name;
        },
        onObjectEnd: function () {
            currentParent = previousParents.pop();
        },
        onArrayBegin: function () {
            var array = [];
            onValue(array);
            previousParents.push(currentParent);
            currentParent = array;
            currentProperty = null;
        },
        onArrayEnd: function () {
            currentParent = previousParents.pop();
        },
        onLiteralValue: onValue,
        onError: function (error, offset, length) {
            errors.push({ error: error, offset: offset, length: length });
        }
    };
    visit(text, visitor, options);
    return currentParent[0];
}
/**
 * Parses the given text and returns a tree representation the JSON content. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 */
function parseTree(text, errors, options) {
    if (errors === void 0) { errors = []; }
    if (options === void 0) { options = ParseOptions.DEFAULT; }
    var currentParent = { type: 'array', offset: -1, length: -1, children: [], parent: undefined }; // artificial root
    function ensurePropertyComplete(endOffset) {
        if (currentParent.type === 'property') {
            currentParent.length = endOffset - currentParent.offset;
            currentParent = currentParent.parent;
        }
    }
    function onValue(valueNode) {
        currentParent.children.push(valueNode);
        return valueNode;
    }
    var visitor = {
        onObjectBegin: function (offset) {
            currentParent = onValue({ type: 'object', offset: offset, length: -1, parent: currentParent, children: [] });
        },
        onObjectProperty: function (name, offset, length) {
            currentParent = onValue({ type: 'property', offset: offset, length: -1, parent: currentParent, children: [] });
            currentParent.children.push({ type: 'string', value: name, offset: offset, length: length, parent: currentParent });
        },
        onObjectEnd: function (offset, length) {
            ensurePropertyComplete(offset + length); // in case of a missing value for a property: make sure property is complete
            currentParent.length = offset + length - currentParent.offset;
            currentParent = currentParent.parent;
            ensurePropertyComplete(offset + length);
        },
        onArrayBegin: function (offset, length) {
            currentParent = onValue({ type: 'array', offset: offset, length: -1, parent: currentParent, children: [] });
        },
        onArrayEnd: function (offset, length) {
            currentParent.length = offset + length - currentParent.offset;
            currentParent = currentParent.parent;
            ensurePropertyComplete(offset + length);
        },
        onLiteralValue: function (value, offset, length) {
            onValue({ type: getNodeType(value), offset: offset, length: length, parent: currentParent, value: value });
            ensurePropertyComplete(offset + length);
        },
        onSeparator: function (sep, offset, length) {
            if (currentParent.type === 'property') {
                if (sep === ':') {
                    currentParent.colonOffset = offset;
                }
                else if (sep === ',') {
                    ensurePropertyComplete(offset);
                }
            }
        },
        onError: function (error, offset, length) {
            errors.push({ error: error, offset: offset, length: length });
        }
    };
    visit(text, visitor, options);
    var result = currentParent.children[0];
    if (result) {
        delete result.parent;
    }
    return result;
}
/**
 * Finds the node at the given path in a JSON DOM.
 */
function findNodeAtLocation(root, path) {
    if (!root) {
        return undefined;
    }
    var node = root;
    for (var _i = 0, path_1 = path; _i < path_1.length; _i++) {
        var segment = path_1[_i];
        if (typeof segment === 'string') {
            if (node.type !== 'object' || !Array.isArray(node.children)) {
                return undefined;
            }
            var found = false;
            for (var _a = 0, _b = node.children; _a < _b.length; _a++) {
                var propertyNode = _b[_a];
                if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment) {
                    node = propertyNode.children[1];
                    found = true;
                    break;
                }
            }
            if (!found) {
                return undefined;
            }
        }
        else {
            var index = segment;
            if (node.type !== 'array' || index < 0 || !Array.isArray(node.children) || index >= node.children.length) {
                return undefined;
            }
            node = node.children[index];
        }
    }
    return node;
}
/**
 * Gets the JSON path of the given JSON DOM node
 */
function getNodePath(node) {
    if (!node.parent || !node.parent.children) {
        return [];
    }
    var path = getNodePath(node.parent);
    if (node.parent.type === 'property') {
        var key = node.parent.children[0].value;
        path.push(key);
    }
    else if (node.parent.type === 'array') {
        var index = node.parent.children.indexOf(node);
        if (index !== -1) {
            path.push(index);
        }
    }
    return path;
}
/**
 * Evaluates the JavaScript object of the given JSON DOM node
 */
function getNodeValue(node) {
    switch (node.type) {
        case 'array':
            return node.children.map(getNodeValue);
        case 'object':
            var obj = Object.create(null);
            for (var _i = 0, _a = node.children; _i < _a.length; _i++) {
                var prop = _a[_i];
                var valueNode = prop.children[1];
                if (valueNode) {
                    obj[prop.children[0].value] = getNodeValue(valueNode);
                }
            }
            return obj;
        case 'null':
        case 'string':
        case 'number':
        case 'boolean':
            return node.value;
        default:
            return undefined;
    }
}
function contains(node, offset, includeRightBound) {
    if (includeRightBound === void 0) { includeRightBound = false; }
    return (offset >= node.offset && offset < (node.offset + node.length)) || includeRightBound && (offset === (node.offset + node.length));
}
/**
 * Finds the most inner node at the given offset. If includeRightBound is set, also finds nodes that end at the given offset.
 */
function findNodeAtOffset(node, offset, includeRightBound) {
    if (includeRightBound === void 0) { includeRightBound = false; }
    if (contains(node, offset, includeRightBound)) {
        var children = node.children;
        if (Array.isArray(children)) {
            for (var i = 0; i < children.length && children[i].offset <= offset; i++) {
                var item = findNodeAtOffset(children[i], offset, includeRightBound);
                if (item) {
                    return item;
                }
            }
        }
        return node;
    }
    return undefined;
}
/**
 * Parses the given text and invokes the visitor functions for each object, array and literal reached.
 */
function visit(text, visitor, options) {
    if (options === void 0) { options = ParseOptions.DEFAULT; }
    var _scanner = (0,_scanner__WEBPACK_IMPORTED_MODULE_0__.createScanner)(text, false);
    function toNoArgVisit(visitFunction) {
        return visitFunction ? function () { return visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()); } : function () { return true; };
    }
    function toOneArgVisit(visitFunction) {
        return visitFunction ? function (arg) { return visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()); } : function () { return true; };
    }
    var onObjectBegin = toNoArgVisit(visitor.onObjectBegin), onObjectProperty = toOneArgVisit(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisit(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisit(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
    var disallowComments = options && options.disallowComments;
    var allowTrailingComma = options && options.allowTrailingComma;
    function scanNext() {
        while (true) {
            var token = _scanner.scan();
            switch (_scanner.getTokenError()) {
                case 4 /* InvalidUnicode */:
                    handleError(14 /* InvalidUnicode */);
                    break;
                case 5 /* InvalidEscapeCharacter */:
                    handleError(15 /* InvalidEscapeCharacter */);
                    break;
                case 3 /* UnexpectedEndOfNumber */:
                    handleError(13 /* UnexpectedEndOfNumber */);
                    break;
                case 1 /* UnexpectedEndOfComment */:
                    if (!disallowComments) {
                        handleError(11 /* UnexpectedEndOfComment */);
                    }
                    break;
                case 2 /* UnexpectedEndOfString */:
                    handleError(12 /* UnexpectedEndOfString */);
                    break;
                case 6 /* InvalidCharacter */:
                    handleError(16 /* InvalidCharacter */);
                    break;
            }
            switch (token) {
                case 12 /* LineCommentTrivia */:
                case 13 /* BlockCommentTrivia */:
                    if (disallowComments) {
                        handleError(10 /* InvalidCommentToken */);
                    }
                    else {
                        onComment();
                    }
                    break;
                case 16 /* Unknown */:
                    handleError(1 /* InvalidSymbol */);
                    break;
                case 15 /* Trivia */:
                case 14 /* LineBreakTrivia */:
                    break;
                default:
                    return token;
            }
        }
    }
    function handleError(error, skipUntilAfter, skipUntil) {
        if (skipUntilAfter === void 0) { skipUntilAfter = []; }
        if (skipUntil === void 0) { skipUntil = []; }
        onError(error);
        if (skipUntilAfter.length + skipUntil.length > 0) {
            var token = _scanner.getToken();
            while (token !== 17 /* EOF */) {
                if (skipUntilAfter.indexOf(token) !== -1) {
                    scanNext();
                    break;
                }
                else if (skipUntil.indexOf(token) !== -1) {
                    break;
                }
                token = scanNext();
            }
        }
    }
    function parseString(isValue) {
        var value = _scanner.getTokenValue();
        if (isValue) {
            onLiteralValue(value);
        }
        else {
            onObjectProperty(value);
        }
        scanNext();
        return true;
    }
    function parseLiteral() {
        switch (_scanner.getToken()) {
            case 11 /* NumericLiteral */:
                var tokenValue = _scanner.getTokenValue();
                var value = Number(tokenValue);
                if (isNaN(value)) {
                    handleError(2 /* InvalidNumberFormat */);
                    value = 0;
                }
                onLiteralValue(value);
                break;
            case 7 /* NullKeyword */:
                onLiteralValue(null);
                break;
            case 8 /* TrueKeyword */:
                onLiteralValue(true);
                break;
            case 9 /* FalseKeyword */:
                onLiteralValue(false);
                break;
            default:
                return false;
        }
        scanNext();
        return true;
    }
    function parseProperty() {
        if (_scanner.getToken() !== 10 /* StringLiteral */) {
            handleError(3 /* PropertyNameExpected */, [], [2 /* CloseBraceToken */, 5 /* CommaToken */]);
            return false;
        }
        parseString(false);
        if (_scanner.getToken() === 6 /* ColonToken */) {
            onSeparator(':');
            scanNext(); // consume colon
            if (!parseValue()) {
                handleError(4 /* ValueExpected */, [], [2 /* CloseBraceToken */, 5 /* CommaToken */]);
            }
        }
        else {
            handleError(5 /* ColonExpected */, [], [2 /* CloseBraceToken */, 5 /* CommaToken */]);
        }
        return true;
    }
    function parseObject() {
        onObjectBegin();
        scanNext(); // consume open brace
        var needsComma = false;
        while (_scanner.getToken() !== 2 /* CloseBraceToken */ && _scanner.getToken() !== 17 /* EOF */) {
            if (_scanner.getToken() === 5 /* CommaToken */) {
                if (!needsComma) {
                    handleError(4 /* ValueExpected */, [], []);
                }
                onSeparator(',');
                scanNext(); // consume comma
                if (_scanner.getToken() === 2 /* CloseBraceToken */ && allowTrailingComma) {
                    break;
                }
            }
            else if (needsComma) {
                handleError(6 /* CommaExpected */, [], []);
            }
            if (!parseProperty()) {
                handleError(4 /* ValueExpected */, [], [2 /* CloseBraceToken */, 5 /* CommaToken */]);
            }
            needsComma = true;
        }
        onObjectEnd();
        if (_scanner.getToken() !== 2 /* CloseBraceToken */) {
            handleError(7 /* CloseBraceExpected */, [2 /* CloseBraceToken */], []);
        }
        else {
            scanNext(); // consume close brace
        }
        return true;
    }
    function parseArray() {
        onArrayBegin();
        scanNext(); // consume open bracket
        var needsComma = false;
        while (_scanner.getToken() !== 4 /* CloseBracketToken */ && _scanner.getToken() !== 17 /* EOF */) {
            if (_scanner.getToken() === 5 /* CommaToken */) {
                if (!needsComma) {
                    handleError(4 /* ValueExpected */, [], []);
                }
                onSeparator(',');
                scanNext(); // consume comma
                if (_scanner.getToken() === 4 /* CloseBracketToken */ && allowTrailingComma) {
                    break;
                }
            }
            else if (needsComma) {
                handleError(6 /* CommaExpected */, [], []);
            }
            if (!parseValue()) {
                handleError(4 /* ValueExpected */, [], [4 /* CloseBracketToken */, 5 /* CommaToken */]);
            }
            needsComma = true;
        }
        onArrayEnd();
        if (_scanner.getToken() !== 4 /* CloseBracketToken */) {
            handleError(8 /* CloseBracketExpected */, [4 /* CloseBracketToken */], []);
        }
        else {
            scanNext(); // consume close bracket
        }
        return true;
    }
    function parseValue() {
        switch (_scanner.getToken()) {
            case 3 /* OpenBracketToken */:
                return parseArray();
            case 1 /* OpenBraceToken */:
                return parseObject();
            case 10 /* StringLiteral */:
                return parseString(true);
            default:
                return parseLiteral();
        }
    }
    scanNext();
    if (_scanner.getToken() === 17 /* EOF */) {
        if (options.allowEmptyContent) {
            return true;
        }
        handleError(4 /* ValueExpected */, [], []);
        return false;
    }
    if (!parseValue()) {
        handleError(4 /* ValueExpected */, [], []);
        return false;
    }
    if (_scanner.getToken() !== 17 /* EOF */) {
        handleError(9 /* EndOfFileExpected */, [], []);
    }
    return true;
}
/**
 * Takes JSON with JavaScript-style comments and remove
 * them. Optionally replaces every none-newline character
 * of comments with a replaceCharacter
 */
function stripComments(text, replaceCh) {
    var _scanner = (0,_scanner__WEBPACK_IMPORTED_MODULE_0__.createScanner)(text), parts = [], kind, offset = 0, pos;
    do {
        pos = _scanner.getPosition();
        kind = _scanner.scan();
        switch (kind) {
            case 12 /* LineCommentTrivia */:
            case 13 /* BlockCommentTrivia */:
            case 17 /* EOF */:
                if (offset !== pos) {
                    parts.push(text.substring(offset, pos));
                }
                if (replaceCh !== undefined) {
                    parts.push(_scanner.getTokenValue().replace(/[^\r\n]/g, replaceCh));
                }
                offset = _scanner.getPosition();
                break;
        }
    } while (kind !== 17 /* EOF */);
    return parts.join('');
}
function getNodeType(value) {
    switch (typeof value) {
        case 'boolean': return 'boolean';
        case 'number': return 'number';
        case 'string': return 'string';
        case 'object': {
            if (!value) {
                return 'null';
            }
            else if (Array.isArray(value)) {
                return 'array';
            }
            return 'object';
        }
        default: return 'null';
    }
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js":
/*!***************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/scanner.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createScanner": () => (/* binding */ createScanner)
/* harmony export */ });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

/**
 * Creates a JSON scanner on the given text.
 * If ignoreTrivia is set, whitespaces or comments are ignored.
 */
function createScanner(text, ignoreTrivia) {
    if (ignoreTrivia === void 0) { ignoreTrivia = false; }
    var len = text.length;
    var pos = 0, value = '', tokenOffset = 0, token = 16 /* Unknown */, lineNumber = 0, lineStartOffset = 0, tokenLineStartOffset = 0, prevTokenLineStartOffset = 0, scanError = 0 /* None */;
    function scanHexDigits(count, exact) {
        var digits = 0;
        var value = 0;
        while (digits < count || !exact) {
            var ch = text.charCodeAt(pos);
            if (ch >= 48 /* _0 */ && ch <= 57 /* _9 */) {
                value = value * 16 + ch - 48 /* _0 */;
            }
            else if (ch >= 65 /* A */ && ch <= 70 /* F */) {
                value = value * 16 + ch - 65 /* A */ + 10;
            }
            else if (ch >= 97 /* a */ && ch <= 102 /* f */) {
                value = value * 16 + ch - 97 /* a */ + 10;
            }
            else {
                break;
            }
            pos++;
            digits++;
        }
        if (digits < count) {
            value = -1;
        }
        return value;
    }
    function setPosition(newPosition) {
        pos = newPosition;
        value = '';
        tokenOffset = 0;
        token = 16 /* Unknown */;
        scanError = 0 /* None */;
    }
    function scanNumber() {
        var start = pos;
        if (text.charCodeAt(pos) === 48 /* _0 */) {
            pos++;
        }
        else {
            pos++;
            while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
            }
        }
        if (pos < text.length && text.charCodeAt(pos) === 46 /* dot */) {
            pos++;
            if (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
                while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                    pos++;
                }
            }
            else {
                scanError = 3 /* UnexpectedEndOfNumber */;
                return text.substring(start, pos);
            }
        }
        var end = pos;
        if (pos < text.length && (text.charCodeAt(pos) === 69 /* E */ || text.charCodeAt(pos) === 101 /* e */)) {
            pos++;
            if (pos < text.length && text.charCodeAt(pos) === 43 /* plus */ || text.charCodeAt(pos) === 45 /* minus */) {
                pos++;
            }
            if (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
                while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                    pos++;
                }
                end = pos;
            }
            else {
                scanError = 3 /* UnexpectedEndOfNumber */;
            }
        }
        return text.substring(start, end);
    }
    function scanString() {
        var result = '', start = pos;
        while (true) {
            if (pos >= len) {
                result += text.substring(start, pos);
                scanError = 2 /* UnexpectedEndOfString */;
                break;
            }
            var ch = text.charCodeAt(pos);
            if (ch === 34 /* doubleQuote */) {
                result += text.substring(start, pos);
                pos++;
                break;
            }
            if (ch === 92 /* backslash */) {
                result += text.substring(start, pos);
                pos++;
                if (pos >= len) {
                    scanError = 2 /* UnexpectedEndOfString */;
                    break;
                }
                var ch2 = text.charCodeAt(pos++);
                switch (ch2) {
                    case 34 /* doubleQuote */:
                        result += '\"';
                        break;
                    case 92 /* backslash */:
                        result += '\\';
                        break;
                    case 47 /* slash */:
                        result += '/';
                        break;
                    case 98 /* b */:
                        result += '\b';
                        break;
                    case 102 /* f */:
                        result += '\f';
                        break;
                    case 110 /* n */:
                        result += '\n';
                        break;
                    case 114 /* r */:
                        result += '\r';
                        break;
                    case 116 /* t */:
                        result += '\t';
                        break;
                    case 117 /* u */:
                        var ch3 = scanHexDigits(4, true);
                        if (ch3 >= 0) {
                            result += String.fromCharCode(ch3);
                        }
                        else {
                            scanError = 4 /* InvalidUnicode */;
                        }
                        break;
                    default:
                        scanError = 5 /* InvalidEscapeCharacter */;
                }
                start = pos;
                continue;
            }
            if (ch >= 0 && ch <= 0x1f) {
                if (isLineBreak(ch)) {
                    result += text.substring(start, pos);
                    scanError = 2 /* UnexpectedEndOfString */;
                    break;
                }
                else {
                    scanError = 6 /* InvalidCharacter */;
                    // mark as error but continue with string
                }
            }
            pos++;
        }
        return result;
    }
    function scanNext() {
        value = '';
        scanError = 0 /* None */;
        tokenOffset = pos;
        lineStartOffset = lineNumber;
        prevTokenLineStartOffset = tokenLineStartOffset;
        if (pos >= len) {
            // at the end
            tokenOffset = len;
            return token = 17 /* EOF */;
        }
        var code = text.charCodeAt(pos);
        // trivia: whitespace
        if (isWhiteSpace(code)) {
            do {
                pos++;
                value += String.fromCharCode(code);
                code = text.charCodeAt(pos);
            } while (isWhiteSpace(code));
            return token = 15 /* Trivia */;
        }
        // trivia: newlines
        if (isLineBreak(code)) {
            pos++;
            value += String.fromCharCode(code);
            if (code === 13 /* carriageReturn */ && text.charCodeAt(pos) === 10 /* lineFeed */) {
                pos++;
                value += '\n';
            }
            lineNumber++;
            tokenLineStartOffset = pos;
            return token = 14 /* LineBreakTrivia */;
        }
        switch (code) {
            // tokens: []{}:,
            case 123 /* openBrace */:
                pos++;
                return token = 1 /* OpenBraceToken */;
            case 125 /* closeBrace */:
                pos++;
                return token = 2 /* CloseBraceToken */;
            case 91 /* openBracket */:
                pos++;
                return token = 3 /* OpenBracketToken */;
            case 93 /* closeBracket */:
                pos++;
                return token = 4 /* CloseBracketToken */;
            case 58 /* colon */:
                pos++;
                return token = 6 /* ColonToken */;
            case 44 /* comma */:
                pos++;
                return token = 5 /* CommaToken */;
            // strings
            case 34 /* doubleQuote */:
                pos++;
                value = scanString();
                return token = 10 /* StringLiteral */;
            // comments
            case 47 /* slash */:
                var start = pos - 1;
                // Single-line comment
                if (text.charCodeAt(pos + 1) === 47 /* slash */) {
                    pos += 2;
                    while (pos < len) {
                        if (isLineBreak(text.charCodeAt(pos))) {
                            break;
                        }
                        pos++;
                    }
                    value = text.substring(start, pos);
                    return token = 12 /* LineCommentTrivia */;
                }
                // Multi-line comment
                if (text.charCodeAt(pos + 1) === 42 /* asterisk */) {
                    pos += 2;
                    var safeLength = len - 1; // For lookahead.
                    var commentClosed = false;
                    while (pos < safeLength) {
                        var ch = text.charCodeAt(pos);
                        if (ch === 42 /* asterisk */ && text.charCodeAt(pos + 1) === 47 /* slash */) {
                            pos += 2;
                            commentClosed = true;
                            break;
                        }
                        pos++;
                        if (isLineBreak(ch)) {
                            if (ch === 13 /* carriageReturn */ && text.charCodeAt(pos) === 10 /* lineFeed */) {
                                pos++;
                            }
                            lineNumber++;
                            tokenLineStartOffset = pos;
                        }
                    }
                    if (!commentClosed) {
                        pos++;
                        scanError = 1 /* UnexpectedEndOfComment */;
                    }
                    value = text.substring(start, pos);
                    return token = 13 /* BlockCommentTrivia */;
                }
                // just a single slash
                value += String.fromCharCode(code);
                pos++;
                return token = 16 /* Unknown */;
            // numbers
            case 45 /* minus */:
                value += String.fromCharCode(code);
                pos++;
                if (pos === len || !isDigit(text.charCodeAt(pos))) {
                    return token = 16 /* Unknown */;
                }
            // found a minus, followed by a number so
            // we fall through to proceed with scanning
            // numbers
            case 48 /* _0 */:
            case 49 /* _1 */:
            case 50 /* _2 */:
            case 51 /* _3 */:
            case 52 /* _4 */:
            case 53 /* _5 */:
            case 54 /* _6 */:
            case 55 /* _7 */:
            case 56 /* _8 */:
            case 57 /* _9 */:
                value += scanNumber();
                return token = 11 /* NumericLiteral */;
            // literals and unknown symbols
            default:
                // is a literal? Read the full word.
                while (pos < len && isUnknownContentCharacter(code)) {
                    pos++;
                    code = text.charCodeAt(pos);
                }
                if (tokenOffset !== pos) {
                    value = text.substring(tokenOffset, pos);
                    // keywords: true, false, null
                    switch (value) {
                        case 'true': return token = 8 /* TrueKeyword */;
                        case 'false': return token = 9 /* FalseKeyword */;
                        case 'null': return token = 7 /* NullKeyword */;
                    }
                    return token = 16 /* Unknown */;
                }
                // some
                value += String.fromCharCode(code);
                pos++;
                return token = 16 /* Unknown */;
        }
    }
    function isUnknownContentCharacter(code) {
        if (isWhiteSpace(code) || isLineBreak(code)) {
            return false;
        }
        switch (code) {
            case 125 /* closeBrace */:
            case 93 /* closeBracket */:
            case 123 /* openBrace */:
            case 91 /* openBracket */:
            case 34 /* doubleQuote */:
            case 58 /* colon */:
            case 44 /* comma */:
            case 47 /* slash */:
                return false;
        }
        return true;
    }
    function scanNextNonTrivia() {
        var result;
        do {
            result = scanNext();
        } while (result >= 12 /* LineCommentTrivia */ && result <= 15 /* Trivia */);
        return result;
    }
    return {
        setPosition: setPosition,
        getPosition: function () { return pos; },
        scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
        getToken: function () { return token; },
        getTokenValue: function () { return value; },
        getTokenOffset: function () { return tokenOffset; },
        getTokenLength: function () { return pos - tokenOffset; },
        getTokenStartLine: function () { return lineStartOffset; },
        getTokenStartCharacter: function () { return tokenOffset - prevTokenLineStartOffset; },
        getTokenError: function () { return scanError; },
    };
}
function isWhiteSpace(ch) {
    return ch === 32 /* space */ || ch === 9 /* tab */ || ch === 11 /* verticalTab */ || ch === 12 /* formFeed */ ||
        ch === 160 /* nonBreakingSpace */ || ch === 5760 /* ogham */ || ch >= 8192 /* enQuad */ && ch <= 8203 /* zeroWidthSpace */ ||
        ch === 8239 /* narrowNoBreakSpace */ || ch === 8287 /* mathematicalSpace */ || ch === 12288 /* ideographicSpace */ || ch === 65279 /* byteOrderMark */;
}
function isLineBreak(ch) {
    return ch === 10 /* lineFeed */ || ch === 13 /* carriageReturn */ || ch === 8232 /* lineSeparator */ || ch === 8233 /* paragraphSeparator */;
}
function isDigit(ch) {
    return ch >= 48 /* _0 */ && ch <= 57 /* _9 */;
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/main.js":
/*!*******************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/main.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applyEdits": () => (/* binding */ applyEdits),
/* harmony export */   "createScanner": () => (/* binding */ createScanner),
/* harmony export */   "findNodeAtLocation": () => (/* binding */ findNodeAtLocation),
/* harmony export */   "findNodeAtOffset": () => (/* binding */ findNodeAtOffset),
/* harmony export */   "format": () => (/* binding */ format),
/* harmony export */   "getLocation": () => (/* binding */ getLocation),
/* harmony export */   "getNodePath": () => (/* binding */ getNodePath),
/* harmony export */   "getNodeValue": () => (/* binding */ getNodeValue),
/* harmony export */   "modify": () => (/* binding */ modify),
/* harmony export */   "parse": () => (/* binding */ parse),
/* harmony export */   "parseTree": () => (/* binding */ parseTree),
/* harmony export */   "printParseErrorCode": () => (/* binding */ printParseErrorCode),
/* harmony export */   "stripComments": () => (/* binding */ stripComments),
/* harmony export */   "visit": () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _impl_format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./impl/format */ "../../node_modules/jsonc-parser/lib/esm/impl/format.js");
/* harmony import */ var _impl_edit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./impl/edit */ "../../node_modules/jsonc-parser/lib/esm/impl/edit.js");
/* harmony import */ var _impl_scanner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./impl/scanner */ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js");
/* harmony import */ var _impl_parser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./impl/parser */ "../../node_modules/jsonc-parser/lib/esm/impl/parser.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/





/**
 * Creates a JSON scanner on the given text.
 * If ignoreTrivia is set, whitespaces or comments are ignored.
 */
var createScanner = _impl_scanner__WEBPACK_IMPORTED_MODULE_2__.createScanner;
/**
 * For a given offset, evaluate the location in the JSON document. Each segment in the location path is either a property name or an array index.
 */
var getLocation = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.getLocation;
/**
 * Parses the given text and returns the object the JSON content represents. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 * Therefore, always check the errors list to find out if the input was valid.
 */
var parse = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.parse;
/**
 * Parses the given text and returns a tree representation the JSON content. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 */
var parseTree = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.parseTree;
/**
 * Finds the node at the given path in a JSON DOM.
 */
var findNodeAtLocation = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.findNodeAtLocation;
/**
 * Finds the innermost node at the given offset. If includeRightBound is set, also finds nodes that end at the given offset.
 */
var findNodeAtOffset = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.findNodeAtOffset;
/**
 * Gets the JSON path of the given JSON DOM node
 */
var getNodePath = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.getNodePath;
/**
 * Evaluates the JavaScript object of the given JSON DOM node
 */
var getNodeValue = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.getNodeValue;
/**
 * Parses the given text and invokes the visitor functions for each object, array and literal reached.
 */
var visit = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.visit;
/**
 * Takes JSON with JavaScript-style comments and remove
 * them. Optionally replaces every none-newline character
 * of comments with a replaceCharacter
 */
var stripComments = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.stripComments;
function printParseErrorCode(code) {
    switch (code) {
        case 1 /* InvalidSymbol */: return 'InvalidSymbol';
        case 2 /* InvalidNumberFormat */: return 'InvalidNumberFormat';
        case 3 /* PropertyNameExpected */: return 'PropertyNameExpected';
        case 4 /* ValueExpected */: return 'ValueExpected';
        case 5 /* ColonExpected */: return 'ColonExpected';
        case 6 /* CommaExpected */: return 'CommaExpected';
        case 7 /* CloseBraceExpected */: return 'CloseBraceExpected';
        case 8 /* CloseBracketExpected */: return 'CloseBracketExpected';
        case 9 /* EndOfFileExpected */: return 'EndOfFileExpected';
        case 10 /* InvalidCommentToken */: return 'InvalidCommentToken';
        case 11 /* UnexpectedEndOfComment */: return 'UnexpectedEndOfComment';
        case 12 /* UnexpectedEndOfString */: return 'UnexpectedEndOfString';
        case 13 /* UnexpectedEndOfNumber */: return 'UnexpectedEndOfNumber';
        case 14 /* InvalidUnicode */: return 'InvalidUnicode';
        case 15 /* InvalidEscapeCharacter */: return 'InvalidEscapeCharacter';
        case 16 /* InvalidCharacter */: return 'InvalidCharacter';
    }
    return '<unknown ParseErrorCode>';
}
/**
 * Computes the edits needed to format a JSON document.
 *
 * @param documentText The input text
 * @param range The range to format or `undefined` to format the full content
 * @param options The formatting options
 * @returns A list of edit operations describing the formatting changes to the original document. Edits can be either inserts, replacements or
 * removals of text segments. All offsets refer to the original state of the document. No two edits must change or remove the same range of
 * text in the original document. However, multiple edits can have
 * the same offset, for example multiple inserts, or an insert followed by a remove or replace. The order in the array defines which edit is applied first.
 * To apply edits to an input, you can use `applyEdits`.
 */
function format(documentText, range, options) {
    return _impl_format__WEBPACK_IMPORTED_MODULE_0__.format(documentText, range, options);
}
/**
 * Computes the edits needed to modify a value in the JSON document.
 *
 * @param documentText The input text
 * @param path The path of the value to change. The path represents either to the document root, a property or an array item.
 * If the path points to an non-existing property or item, it will be created.
 * @param value The new value for the specified property or item. If the value is undefined,
 * the property or item will be removed.
 * @param options Options
 * @returns A list of edit operations describing the formatting changes to the original document. Edits can be either inserts, replacements or
 * removals of text segments. All offsets refer to the original state of the document. No two edits must change or remove the same range of
 * text in the original document. However, multiple edits can have
 * the same offset, for example multiple inserts, or an insert followed by a remove or replace. The order in the array defines which edit is applied first.
 * To apply edits to an input, you can use `applyEdits`.
 */
function modify(text, path, value, options) {
    return _impl_edit__WEBPACK_IMPORTED_MODULE_1__.setProperty(text, path, value, options);
}
/**
 * Applies edits to a input string.
 */
function applyEdits(text, edits) {
    for (var i = edits.length - 1; i >= 0; i--) {
        text = _impl_edit__WEBPACK_IMPORTED_MODULE_1__.applyEdit(text, edits[i]);
    }
    return text;
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_elyra_pipeline-services_dist_index_js.a92702858491a7982926.js.map