# coding: utf-8

"""
    REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Contact: support@apibricks.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from api_bricks_sec_api_rest.models.dto_filing_metadata_dto import DTOFilingMetadataDto
from api_bricks_sec_api_rest.models.dto_filing_sort_by import DTOFilingSortBy

from api_bricks_sec_api_rest.api_client import ApiClient, RequestSerialized
from api_bricks_sec_api_rest.api_response import ApiResponse
from api_bricks_sec_api_rest.rest import RESTResponseType


class FilingMetadataApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v1_filings_get(
        self,
        cik: Annotated[Optional[StrictInt], Field(description="Filter by Central Index Key (CIK)")] = None,
        form_type: Annotated[Optional[StrictStr], Field(description="Filter by form type(s) (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated")] = None,
        filling_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date start (inclusive), format YYYY-MM-DD")] = None,
        filling_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date end (inclusive), format YYYY-MM-DD")] = None,
        report_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by report date start (inclusive), format YYYY-MM-DD")] = None,
        report_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by report date end (inclusive), format YYYY-MM-DD")] = None,
        items_contain: Annotated[Optional[StrictStr], Field(description="Filter filings where the 'Items' field contains the specified text")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Number of results per page (default: 50, max: 200)")] = None,
        page_number: Annotated[Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]], Field(description="Page number to retrieve (default: 1)")] = None,
        sort_by: Annotated[Optional[DTOFilingSortBy], Field(description="Field to sort results by (default: AccessionNumber)")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Sort order (asc or desc, default: desc)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[DTOFilingMetadataDto]:
        """Query SEC filing metadata

        Retrieves metadata for SEC filings based on various filter criteria with pagination and sorting support.    ### Available Sort Fields    Field Name | Description  -----------|-------------  AccessionNumber | SEC filing accession number  FilingDate | Date when filing was submitted  AcceptanceDateTime | Date and time of filing acceptance  ReportDate | Date of the report  Size | Size of the filing document    ### Date Format  All dates must be provided in YYYY-MM-DD format    ### Form Types  Form types can be provided as comma-separated values, e.g.: \"10-K,8-K,10-Q\"    :::tip  For optimal performance, use date ranges and form types to narrow down your search  :::

        :param cik: Filter by Central Index Key (CIK)
        :type cik: int
        :param form_type: Filter by form type(s) (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated
        :type form_type: str
        :param filling_date_start: Filter by filling date start (inclusive), format YYYY-MM-DD
        :type filling_date_start: str
        :param filling_date_end: Filter by filling date end (inclusive), format YYYY-MM-DD
        :type filling_date_end: str
        :param report_date_start: Filter by report date start (inclusive), format YYYY-MM-DD
        :type report_date_start: str
        :param report_date_end: Filter by report date end (inclusive), format YYYY-MM-DD
        :type report_date_end: str
        :param items_contain: Filter filings where the 'Items' field contains the specified text
        :type items_contain: str
        :param page_size: Number of results per page (default: 50, max: 200)
        :type page_size: int
        :param page_number: Page number to retrieve (default: 1)
        :type page_number: int
        :param sort_by: Field to sort results by (default: AccessionNumber)
        :type sort_by: DTOFilingSortBy
        :param sort_order: Sort order (asc or desc, default: desc)
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_filings_get_serialize(
            cik=cik,
            form_type=form_type,
            filling_date_start=filling_date_start,
            filling_date_end=filling_date_end,
            report_date_start=report_date_start,
            report_date_end=report_date_end,
            items_contain=items_contain,
            page_size=page_size,
            page_number=page_number,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[DTOFilingMetadataDto]",
            '400': "MvcValidationProblemDetails",
            '500': "MvcProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_filings_get_with_http_info(
        self,
        cik: Annotated[Optional[StrictInt], Field(description="Filter by Central Index Key (CIK)")] = None,
        form_type: Annotated[Optional[StrictStr], Field(description="Filter by form type(s) (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated")] = None,
        filling_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date start (inclusive), format YYYY-MM-DD")] = None,
        filling_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date end (inclusive), format YYYY-MM-DD")] = None,
        report_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by report date start (inclusive), format YYYY-MM-DD")] = None,
        report_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by report date end (inclusive), format YYYY-MM-DD")] = None,
        items_contain: Annotated[Optional[StrictStr], Field(description="Filter filings where the 'Items' field contains the specified text")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Number of results per page (default: 50, max: 200)")] = None,
        page_number: Annotated[Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]], Field(description="Page number to retrieve (default: 1)")] = None,
        sort_by: Annotated[Optional[DTOFilingSortBy], Field(description="Field to sort results by (default: AccessionNumber)")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Sort order (asc or desc, default: desc)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[DTOFilingMetadataDto]]:
        """Query SEC filing metadata

        Retrieves metadata for SEC filings based on various filter criteria with pagination and sorting support.    ### Available Sort Fields    Field Name | Description  -----------|-------------  AccessionNumber | SEC filing accession number  FilingDate | Date when filing was submitted  AcceptanceDateTime | Date and time of filing acceptance  ReportDate | Date of the report  Size | Size of the filing document    ### Date Format  All dates must be provided in YYYY-MM-DD format    ### Form Types  Form types can be provided as comma-separated values, e.g.: \"10-K,8-K,10-Q\"    :::tip  For optimal performance, use date ranges and form types to narrow down your search  :::

        :param cik: Filter by Central Index Key (CIK)
        :type cik: int
        :param form_type: Filter by form type(s) (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated
        :type form_type: str
        :param filling_date_start: Filter by filling date start (inclusive), format YYYY-MM-DD
        :type filling_date_start: str
        :param filling_date_end: Filter by filling date end (inclusive), format YYYY-MM-DD
        :type filling_date_end: str
        :param report_date_start: Filter by report date start (inclusive), format YYYY-MM-DD
        :type report_date_start: str
        :param report_date_end: Filter by report date end (inclusive), format YYYY-MM-DD
        :type report_date_end: str
        :param items_contain: Filter filings where the 'Items' field contains the specified text
        :type items_contain: str
        :param page_size: Number of results per page (default: 50, max: 200)
        :type page_size: int
        :param page_number: Page number to retrieve (default: 1)
        :type page_number: int
        :param sort_by: Field to sort results by (default: AccessionNumber)
        :type sort_by: DTOFilingSortBy
        :param sort_order: Sort order (asc or desc, default: desc)
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_filings_get_serialize(
            cik=cik,
            form_type=form_type,
            filling_date_start=filling_date_start,
            filling_date_end=filling_date_end,
            report_date_start=report_date_start,
            report_date_end=report_date_end,
            items_contain=items_contain,
            page_size=page_size,
            page_number=page_number,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[DTOFilingMetadataDto]",
            '400': "MvcValidationProblemDetails",
            '500': "MvcProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_filings_get_without_preload_content(
        self,
        cik: Annotated[Optional[StrictInt], Field(description="Filter by Central Index Key (CIK)")] = None,
        form_type: Annotated[Optional[StrictStr], Field(description="Filter by form type(s) (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated")] = None,
        filling_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date start (inclusive), format YYYY-MM-DD")] = None,
        filling_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date end (inclusive), format YYYY-MM-DD")] = None,
        report_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by report date start (inclusive), format YYYY-MM-DD")] = None,
        report_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by report date end (inclusive), format YYYY-MM-DD")] = None,
        items_contain: Annotated[Optional[StrictStr], Field(description="Filter filings where the 'Items' field contains the specified text")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=200, strict=True, ge=1)]], Field(description="Number of results per page (default: 50, max: 200)")] = None,
        page_number: Annotated[Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]], Field(description="Page number to retrieve (default: 1)")] = None,
        sort_by: Annotated[Optional[DTOFilingSortBy], Field(description="Field to sort results by (default: AccessionNumber)")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Sort order (asc or desc, default: desc)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Query SEC filing metadata

        Retrieves metadata for SEC filings based on various filter criteria with pagination and sorting support.    ### Available Sort Fields    Field Name | Description  -----------|-------------  AccessionNumber | SEC filing accession number  FilingDate | Date when filing was submitted  AcceptanceDateTime | Date and time of filing acceptance  ReportDate | Date of the report  Size | Size of the filing document    ### Date Format  All dates must be provided in YYYY-MM-DD format    ### Form Types  Form types can be provided as comma-separated values, e.g.: \"10-K,8-K,10-Q\"    :::tip  For optimal performance, use date ranges and form types to narrow down your search  :::

        :param cik: Filter by Central Index Key (CIK)
        :type cik: int
        :param form_type: Filter by form type(s) (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated
        :type form_type: str
        :param filling_date_start: Filter by filling date start (inclusive), format YYYY-MM-DD
        :type filling_date_start: str
        :param filling_date_end: Filter by filling date end (inclusive), format YYYY-MM-DD
        :type filling_date_end: str
        :param report_date_start: Filter by report date start (inclusive), format YYYY-MM-DD
        :type report_date_start: str
        :param report_date_end: Filter by report date end (inclusive), format YYYY-MM-DD
        :type report_date_end: str
        :param items_contain: Filter filings where the 'Items' field contains the specified text
        :type items_contain: str
        :param page_size: Number of results per page (default: 50, max: 200)
        :type page_size: int
        :param page_number: Page number to retrieve (default: 1)
        :type page_number: int
        :param sort_by: Field to sort results by (default: AccessionNumber)
        :type sort_by: DTOFilingSortBy
        :param sort_order: Sort order (asc or desc, default: desc)
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_filings_get_serialize(
            cik=cik,
            form_type=form_type,
            filling_date_start=filling_date_start,
            filling_date_end=filling_date_end,
            report_date_start=report_date_start,
            report_date_end=report_date_end,
            items_contain=items_contain,
            page_size=page_size,
            page_number=page_number,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[DTOFilingMetadataDto]",
            '400': "MvcValidationProblemDetails",
            '500': "MvcProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_filings_get_serialize(
        self,
        cik,
        form_type,
        filling_date_start,
        filling_date_end,
        report_date_start,
        report_date_end,
        items_contain,
        page_size,
        page_number,
        sort_by,
        sort_order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if cik is not None:
            
            _query_params.append(('cik', cik))
            
        if form_type is not None:
            
            _query_params.append(('form_type', form_type))
            
        if filling_date_start is not None:
            
            _query_params.append(('filling_date_start', filling_date_start))
            
        if filling_date_end is not None:
            
            _query_params.append(('filling_date_end', filling_date_end))
            
        if report_date_start is not None:
            
            _query_params.append(('report_date_start', report_date_start))
            
        if report_date_end is not None:
            
            _query_params.append(('report_date_end', report_date_end))
            
        if items_contain is not None:
            
            _query_params.append(('items_contain', items_contain))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_number is not None:
            
            _query_params.append(('page_number', page_number))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by.value))
            
        if sort_order is not None:
            
            _query_params.append(('sort_order', sort_order))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/filings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


