# coding: utf-8

"""
    REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Contact: support@apibricks.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from api_bricks_sec_api_rest.models.dto_sec_filing_result_dto import DTOSecFilingResultDto

from api_bricks_sec_api_rest.api_client import ApiClient, RequestSerialized
from api_bricks_sec_api_rest.api_response import ApiResponse
from api_bricks_sec_api_rest.rest import RESTResponseType


class FullTextSearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v1_full_text_get(
        self,
        form_type: Annotated[Optional[StrictStr], Field(description="Filter by form type (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated")] = None,
        filling_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date start (inclusive), format YYYY-MM-DD")] = None,
        filling_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date end (inclusive), format YYYY-MM-DD")] = None,
        text_contains: Annotated[Optional[StrictStr], Field(description="Keywords that the text must contain. Multiple values can be comma-separated")] = None,
        text_not_contain: Annotated[Optional[StrictStr], Field(description="Keywords that the text must not contain. Multiple values can be comma-separated")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 100)")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to retrieve (default: 1)")] = None,
        sort_by: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Field to sort by (default: AccessionNumber)")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Sort order (asc or desc). Defaults to asc")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[DTOSecFilingResultDto]:
        """Full-text search of SEC filing documents

        Search across SEC filing documents with advanced filtering and sorting capabilities.    ### Available Sort Fields    Field Name | Description  -----------|-------------  AccessionNumber | SEC filing accession number  FormType | Type of the filing document  FilingDate | Date when filing was submitted  CompanyName | Name of the company  CIK | Central Index Key  DocumentFilename | Name of the filing document  DocumentDescription | Description of the document    ### Search Options    Option | Description  --------|-------------  text_contains | Keywords that must appear in the document  text_not_contain | Keywords that must not appear in the document    ### Date Format  All dates must be provided in YYYY-MM-DD format    :::tip  Use text_contains and text_not_contain with multiple keywords separated by commas for more precise searches  :::    :::note  The search is case-insensitive and supports partial word matches  :::

        :param form_type: Filter by form type (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated
        :type form_type: str
        :param filling_date_start: Filter by filling date start (inclusive), format YYYY-MM-DD
        :type filling_date_start: str
        :param filling_date_end: Filter by filling date end (inclusive), format YYYY-MM-DD
        :type filling_date_end: str
        :param text_contains: Keywords that the text must contain. Multiple values can be comma-separated
        :type text_contains: str
        :param text_not_contain: Keywords that the text must not contain. Multiple values can be comma-separated
        :type text_not_contain: str
        :param page_size: Number of results per page (default: 100)
        :type page_size: int
        :param page_number: Page number to retrieve (default: 1)
        :type page_number: int
        :param sort_by: Field to sort by (default: AccessionNumber)
        :type sort_by: str
        :param sort_order: Sort order (asc or desc). Defaults to asc
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_full_text_get_serialize(
            form_type=form_type,
            filling_date_start=filling_date_start,
            filling_date_end=filling_date_end,
            text_contains=text_contains,
            text_not_contain=text_not_contain,
            page_size=page_size,
            page_number=page_number,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[DTOSecFilingResultDto]",
            '400': "MvcValidationProblemDetails",
            '500': "MvcProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v1_full_text_get_with_http_info(
        self,
        form_type: Annotated[Optional[StrictStr], Field(description="Filter by form type (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated")] = None,
        filling_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date start (inclusive), format YYYY-MM-DD")] = None,
        filling_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date end (inclusive), format YYYY-MM-DD")] = None,
        text_contains: Annotated[Optional[StrictStr], Field(description="Keywords that the text must contain. Multiple values can be comma-separated")] = None,
        text_not_contain: Annotated[Optional[StrictStr], Field(description="Keywords that the text must not contain. Multiple values can be comma-separated")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 100)")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to retrieve (default: 1)")] = None,
        sort_by: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Field to sort by (default: AccessionNumber)")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Sort order (asc or desc). Defaults to asc")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[DTOSecFilingResultDto]]:
        """Full-text search of SEC filing documents

        Search across SEC filing documents with advanced filtering and sorting capabilities.    ### Available Sort Fields    Field Name | Description  -----------|-------------  AccessionNumber | SEC filing accession number  FormType | Type of the filing document  FilingDate | Date when filing was submitted  CompanyName | Name of the company  CIK | Central Index Key  DocumentFilename | Name of the filing document  DocumentDescription | Description of the document    ### Search Options    Option | Description  --------|-------------  text_contains | Keywords that must appear in the document  text_not_contain | Keywords that must not appear in the document    ### Date Format  All dates must be provided in YYYY-MM-DD format    :::tip  Use text_contains and text_not_contain with multiple keywords separated by commas for more precise searches  :::    :::note  The search is case-insensitive and supports partial word matches  :::

        :param form_type: Filter by form type (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated
        :type form_type: str
        :param filling_date_start: Filter by filling date start (inclusive), format YYYY-MM-DD
        :type filling_date_start: str
        :param filling_date_end: Filter by filling date end (inclusive), format YYYY-MM-DD
        :type filling_date_end: str
        :param text_contains: Keywords that the text must contain. Multiple values can be comma-separated
        :type text_contains: str
        :param text_not_contain: Keywords that the text must not contain. Multiple values can be comma-separated
        :type text_not_contain: str
        :param page_size: Number of results per page (default: 100)
        :type page_size: int
        :param page_number: Page number to retrieve (default: 1)
        :type page_number: int
        :param sort_by: Field to sort by (default: AccessionNumber)
        :type sort_by: str
        :param sort_order: Sort order (asc or desc). Defaults to asc
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_full_text_get_serialize(
            form_type=form_type,
            filling_date_start=filling_date_start,
            filling_date_end=filling_date_end,
            text_contains=text_contains,
            text_not_contain=text_not_contain,
            page_size=page_size,
            page_number=page_number,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[DTOSecFilingResultDto]",
            '400': "MvcValidationProblemDetails",
            '500': "MvcProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v1_full_text_get_without_preload_content(
        self,
        form_type: Annotated[Optional[StrictStr], Field(description="Filter by form type (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated")] = None,
        filling_date_start: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date start (inclusive), format YYYY-MM-DD")] = None,
        filling_date_end: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Filter by filling date end (inclusive), format YYYY-MM-DD")] = None,
        text_contains: Annotated[Optional[StrictStr], Field(description="Keywords that the text must contain. Multiple values can be comma-separated")] = None,
        text_not_contain: Annotated[Optional[StrictStr], Field(description="Keywords that the text must not contain. Multiple values can be comma-separated")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 100)")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="Page number to retrieve (default: 1)")] = None,
        sort_by: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Field to sort by (default: AccessionNumber)")] = None,
        sort_order: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Sort order (asc or desc). Defaults to asc")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Full-text search of SEC filing documents

        Search across SEC filing documents with advanced filtering and sorting capabilities.    ### Available Sort Fields    Field Name | Description  -----------|-------------  AccessionNumber | SEC filing accession number  FormType | Type of the filing document  FilingDate | Date when filing was submitted  CompanyName | Name of the company  CIK | Central Index Key  DocumentFilename | Name of the filing document  DocumentDescription | Description of the document    ### Search Options    Option | Description  --------|-------------  text_contains | Keywords that must appear in the document  text_not_contain | Keywords that must not appear in the document    ### Date Format  All dates must be provided in YYYY-MM-DD format    :::tip  Use text_contains and text_not_contain with multiple keywords separated by commas for more precise searches  :::    :::note  The search is case-insensitive and supports partial word matches  :::

        :param form_type: Filter by form type (e.g., \"10-K\", \"8-K\"). Multiple values can be comma-separated
        :type form_type: str
        :param filling_date_start: Filter by filling date start (inclusive), format YYYY-MM-DD
        :type filling_date_start: str
        :param filling_date_end: Filter by filling date end (inclusive), format YYYY-MM-DD
        :type filling_date_end: str
        :param text_contains: Keywords that the text must contain. Multiple values can be comma-separated
        :type text_contains: str
        :param text_not_contain: Keywords that the text must not contain. Multiple values can be comma-separated
        :type text_not_contain: str
        :param page_size: Number of results per page (default: 100)
        :type page_size: int
        :param page_number: Page number to retrieve (default: 1)
        :type page_number: int
        :param sort_by: Field to sort by (default: AccessionNumber)
        :type sort_by: str
        :param sort_order: Sort order (asc or desc). Defaults to asc
        :type sort_order: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_full_text_get_serialize(
            form_type=form_type,
            filling_date_start=filling_date_start,
            filling_date_end=filling_date_end,
            text_contains=text_contains,
            text_not_contain=text_not_contain,
            page_size=page_size,
            page_number=page_number,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[DTOSecFilingResultDto]",
            '400': "MvcValidationProblemDetails",
            '500': "MvcProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_full_text_get_serialize(
        self,
        form_type,
        filling_date_start,
        filling_date_end,
        text_contains,
        text_not_contain,
        page_size,
        page_number,
        sort_by,
        sort_order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if form_type is not None:
            
            _query_params.append(('form_type', form_type))
            
        if filling_date_start is not None:
            
            _query_params.append(('filling_date_start', filling_date_start))
            
        if filling_date_end is not None:
            
            _query_params.append(('filling_date_end', filling_date_end))
            
        if text_contains is not None:
            
            _query_params.append(('text_contains', text_contains))
            
        if text_not_contain is not None:
            
            _query_params.append(('text_not_contain', text_not_contain))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if page_number is not None:
            
            _query_params.append(('page_number', page_number))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if sort_order is not None:
            
            _query_params.append(('sort_order', sort_order))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/full-text',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


