# coding: utf-8

"""
    REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Contact: support@apibricks.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DTOFilingMetadataDto(BaseModel):
    """
    Represents the response for a single SEC filing metadata record.  Maps fields from the edgar_submissions table.
    """ # noqa: E501
    cik: Optional[StrictInt] = None
    accession_number: Optional[StrictStr] = None
    filing_date: Optional[date] = None
    report_date: Optional[date] = None
    acceptance_date_time: Optional[datetime] = None
    act: Optional[StrictStr] = None
    form: Optional[StrictStr] = None
    file_number: Optional[StrictStr] = None
    film_number: Optional[StrictStr] = None
    items: Optional[StrictStr] = None
    core_type: Optional[StrictStr] = None
    size: Optional[StrictInt] = None
    is_xbrl: Optional[StrictBool] = None
    is_inline_xbrl: Optional[StrictBool] = None
    primary_document: Optional[StrictStr] = None
    primary_doc_description: Optional[StrictStr] = None
    source_file: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["cik", "accession_number", "filing_date", "report_date", "acceptance_date_time", "act", "form", "file_number", "film_number", "items", "core_type", "size", "is_xbrl", "is_inline_xbrl", "primary_document", "primary_doc_description", "source_file"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DTOFilingMetadataDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if accession_number (nullable) is None
        # and model_fields_set contains the field
        if self.accession_number is None and "accession_number" in self.model_fields_set:
            _dict['accession_number'] = None

        # set to None if report_date (nullable) is None
        # and model_fields_set contains the field
        if self.report_date is None and "report_date" in self.model_fields_set:
            _dict['report_date'] = None

        # set to None if acceptance_date_time (nullable) is None
        # and model_fields_set contains the field
        if self.acceptance_date_time is None and "acceptance_date_time" in self.model_fields_set:
            _dict['acceptance_date_time'] = None

        # set to None if act (nullable) is None
        # and model_fields_set contains the field
        if self.act is None and "act" in self.model_fields_set:
            _dict['act'] = None

        # set to None if form (nullable) is None
        # and model_fields_set contains the field
        if self.form is None and "form" in self.model_fields_set:
            _dict['form'] = None

        # set to None if file_number (nullable) is None
        # and model_fields_set contains the field
        if self.file_number is None and "file_number" in self.model_fields_set:
            _dict['file_number'] = None

        # set to None if film_number (nullable) is None
        # and model_fields_set contains the field
        if self.film_number is None and "film_number" in self.model_fields_set:
            _dict['film_number'] = None

        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['items'] = None

        # set to None if core_type (nullable) is None
        # and model_fields_set contains the field
        if self.core_type is None and "core_type" in self.model_fields_set:
            _dict['core_type'] = None

        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict['size'] = None

        # set to None if is_xbrl (nullable) is None
        # and model_fields_set contains the field
        if self.is_xbrl is None and "is_xbrl" in self.model_fields_set:
            _dict['is_xbrl'] = None

        # set to None if is_inline_xbrl (nullable) is None
        # and model_fields_set contains the field
        if self.is_inline_xbrl is None and "is_inline_xbrl" in self.model_fields_set:
            _dict['is_inline_xbrl'] = None

        # set to None if primary_document (nullable) is None
        # and model_fields_set contains the field
        if self.primary_document is None and "primary_document" in self.model_fields_set:
            _dict['primary_document'] = None

        # set to None if primary_doc_description (nullable) is None
        # and model_fields_set contains the field
        if self.primary_doc_description is None and "primary_doc_description" in self.model_fields_set:
            _dict['primary_doc_description'] = None

        # set to None if source_file (nullable) is None
        # and model_fields_set contains the field
        if self.source_file is None and "source_file" in self.model_fields_set:
            _dict['source_file'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DTOFilingMetadataDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cik": obj.get("cik"),
            "accession_number": obj.get("accession_number"),
            "filing_date": obj.get("filing_date"),
            "report_date": obj.get("report_date"),
            "acceptance_date_time": obj.get("acceptance_date_time"),
            "act": obj.get("act"),
            "form": obj.get("form"),
            "file_number": obj.get("file_number"),
            "film_number": obj.get("film_number"),
            "items": obj.get("items"),
            "core_type": obj.get("core_type"),
            "size": obj.get("size"),
            "is_xbrl": obj.get("is_xbrl"),
            "is_inline_xbrl": obj.get("is_inline_xbrl"),
            "primary_document": obj.get("primary_document"),
            "primary_doc_description": obj.get("primary_doc_description"),
            "source_file": obj.get("source_file")
        })
        return _obj


