import { JsiiProjectOptions, JsiiProject } from "projen/lib/cdk";
/**
 * Configurable knobs for Awesome Lists
 */
export interface AwesomeListProjectOptions extends JsiiProjectOptions {
    /**
     * What e-mail address to list for the Code of Conduct Point of Contact
     *
     * @default - `project.authorAddress`
     */
    readonly contactEmail?: string;
}
/**
 * Awesome List project
 *
 * @pjid awesome-list
 */
export declare class AwesomeList extends JsiiProject {
    constructor(options: AwesomeListProjectOptions);
    private _awesomeLint;
    private codeOfConduct;
    private contributing;
}
