"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwesomeList = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
const cdk_1 = require("projen/lib/cdk");
/**
 * Awesome List project
 *
 * @pjid awesome-list
 */
class AwesomeList extends cdk_1.JsiiProject {
    constructor(options) {
        var _b;
        super({
            ...options,
            readme: {
                filename: "readme.md",
                contents: readmeContents(),
            },
            defaultReleaseBranch: "main",
            gitpod: true,
            releaseToNpm: false,
        });
        new projen_1.SampleFile(this, "code-of-conduct.md", {
            contents: this.codeOfConduct().replace("CONTACTEMAIL", (_b = options.contactEmail) !== null && _b !== void 0 ? _b : "noreply@example.com"),
        });
        new projen_1.SampleFile(this, "contributing.md", {
            contents: this.contributing(),
        });
        this._awesomeLint();
    }
    _awesomeLint() {
        this.addDevDeps("awesome-lint");
        const awesomeLintTask = this.addTask("awesome-lint");
        awesomeLintTask.exec("npx awesome-lint");
        this.buildTask.spawn(awesomeLintTask);
    }
    codeOfConduct() {
        return `# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, gender identity and expression, level of experience,
nationality, personal appearance, race, religion, or sexual identity and
orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at CONTACTEMAIL. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
    `;
    }
    contributing() {
        return `# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](code-of-conduct.md). By participating in this
project you agree to abide by its terms.

## Adding an awesome list

Please ensure your pull request adheres to the [list guidelines](pull_request_template.md).

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one. If you're not sure how to do that,
[here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md)
on the different ways you can update your PR so that we can merge it.
    `;
    }
}
exports.AwesomeList = AwesomeList;
_a = JSII_RTTI_SYMBOL_1;
AwesomeList[_a] = { fqn: "p6-projen-project-awesome-list.AwesomeList", version: "0.1.6" };
function readmeContents() {
    return `# Awesome Projen [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

  > Curated list of awesome [PROJECT](REPOSITORY) SHORTDESC.

  LONGDESC

  ## Contents

  ## Contributing

  Contributions welcome! Read the [contribution guidelines](contributing.md) first.`;
}
//# sourceMappingURL=data:application/json;base64,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