from datetime import datetime
from typing import List, Optional

from pydantic import ConfigDict, Field
from pydantic.dataclasses import dataclass

from ltiaas.utils.serialization import Serializable, Submittable


@dataclass(config=ConfigDict(extra="allow"))
class LineItem(Submittable):
    label: str = Field()
    score_maximum: int | float = Field()
    resource_link_id: Optional[str] = None
    resource_id: Optional[str] = None
    start_date_time: Optional[datetime] = None
    end_date_time: Optional[datetime] = None
    grades_released: Optional[bool] = None
    tag: Optional[str] = None


# Have to redefine line item object due to pydantic weird
#   typehint behavior when using aliases
@dataclass(config=ConfigDict(extra="allow", populate_by_name=True))
class LineItemWithId(Serializable):
    id: str = Field()
    label: str = Field()
    score_maximum: int | float = Field(alias="scoreMaximum")
    resource_link_id: Optional[str] = Field(default=None, alias="resourceLinkId")
    resource_id: Optional[str] = Field(default=None, alias="resourceId")
    start_date_time: Optional[datetime] = Field(default=None, alias="startDateTime")
    end_date_time: Optional[datetime] = Field(default=None, alias="endDateTime")
    grades_released: Optional[bool] = Field(default=None, alias="gradesReleased")
    tag: Optional[str] = None


@dataclass(config=ConfigDict(populate_by_name=True))
class LineItemContainer(Serializable):
    line_items: List[LineItemWithId] = Field(alias="lineItems")
    next: Optional[str] = None
    first: Optional[str] = None
    last: Optional[str] = None
    prev: Optional[str] = None
