from typing import List, Optional

from pydantic import ConfigDict, Field
from pydantic.dataclasses import dataclass

from ltiaas.utils.serialization import Serializable


@dataclass(config=ConfigDict(extra="allow", populate_by_name=True))
class Membership(Serializable):
    user_id: str = Field(alias="userId", coerce_numbers_to_str=True)
    roles: List[str] = Field()
    status: Optional[str] = None
    email: Optional[str] = None
    name: Optional[str] = None
    given_name: Optional[str] = Field(default=None, alias="givenName")
    family_name: Optional[str] = Field(default=None, alias="familyName")
    middle_name: Optional[str] = Field(default=None, alias="middleName")
    picture: Optional[str] = None
    lis_person_sourced_id: Optional[str] = Field(default=None, alias="lisPersonSourcedId")
    lti11_legacy_user_id: Optional[str] = Field(default=None, alias="lti11LegacyUserId")


@dataclass
class Context(Serializable):
    id: str = Field()
    label: Optional[str] = None
    title: Optional[str] = None


@dataclass
class MembershipContainer(Serializable):
    id: str = Field()
    context: Context = Field()
    members: List[Membership] = Field()
    next: Optional[str] = None
