# Copyright 2025 PhonePe Private Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from enum import Enum

class CallbackType(str, Enum):
    PG_ORDER_COMPLETED = "PG_ORDER_COMPLETED"
    PG_ORDER_FAILED = "PG_ORDER_FAILED"
    PG_TRANSACTION_ATTEMPT_FAILED = "PG_TRANSACTION_ATTEMPT_FAILED"

    CHECKOUT_ORDER_COMPLETED = "CHECKOUT_ORDER_COMPLETED"
    CHECKOUT_ORDER_FAILED = "CHECKOUT_ORDER_FAILED"
    CHECKOUT_TRANSACTION_ATTEMPT_FAILED = "CHECKOUT_TRANSACTION_ATTEMPT_FAILED"

    PG_REFUND_COMPLETED = "PG_REFUND_COMPLETED"
    PG_REFUND_FAILED = "PG_REFUND_FAILED"
    PG_REFUND_ACCEPTED = "PG_REFUND_ACCEPTED"

    SUBSCRIPTION_SETUP_ORDER_COMPLETED = "SUBSCRIPTION_SETUP_ORDER_COMPLETED"
    SUBSCRIPTION_SETUP_ORDER_FAILED = "SUBSCRIPTION_SETUP_ORDER_FAILED"
    SUBSCRIPTION_NOTIFICATION_COMPLETED = "SUBSCRIPTION_NOTIFICATION_COMPLETED"
    SUBSCRIPTION_NOTIFICATION_FAILED = "SUBSCRIPTION_NOTIFICATION_FAILED"
    SUBSCRIPTION_CANCELLED = "SUBSCRIPTION_CANCELLED"
    SUBSCRIPTION_PAUSED = "SUBSCRIPTION_PAUSED"
    SUBSCRIPTION_UNPAUSED = "SUBSCRIPTION_UNPAUSED"
    SUBSCRIPTION_REVOKED = "SUBSCRIPTION_REVOKED"
    SUBSCRIPTION_REDEMPTION_ORDER_COMPLETED = "SUBSCRIPTION_REDEMPTION_ORDER_COMPLETED"
    SUBSCRIPTION_REDEMPTION_ORDER_FAILED = "SUBSCRIPTION_REDEMPTION_ORDER_FAILED"
    SUBSCRIPTION_REDEMPTION_TRANSACTION_COMPLETED = "SUBSCRIPTION_REDEMPTION_TRANSACTION_COMPLETED"
    SUBSCRIPTION_REDEMPTION_TRANSACTION_FAILED = "SUBSCRIPTION_REDEMPTION_TRANSACTION_FAILED"