# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Disbursement API

    API for doing disbursement operations in DANA, including DANA account inquiry, transfer to DANA, and transfer to bank disbursement

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.disbursement.v1.models.money import Money
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class TransferToDanaResponse(BaseModel, BaseSdkModel):
    """
    TransferToDanaResponse
    """ # noqa: E501
    response_code: Annotated[str, Field(strict=True, max_length=7)] = Field(description="Refer to response code list")
    response_message: Annotated[str, Field(strict=True, max_length=150)] = Field(description="Refer to response code list")
    reference_no: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Transaction identifier on DANA system")
    partner_reference_no: Annotated[str, Field(strict=True, max_length=64)] = Field(description="Unique transaction identifier on partner system which assigned to each transaction<br> Notes:<br> If the partner receives a timeout or an unexpected response from DANA and partner expects to perform retry request to DANA, please use the partnerReferenceNo that is the same as the one used in the transaction request process before ")
    session_id: Optional[Annotated[str, Field(strict=True, max_length=25)]] = Field(default=None, description="Session identifier")
    customer_number: Optional[Annotated[str, Field(strict=True, max_length=32)]] = Field(default=None, description="Customer account number, in format 628xxx")
    customer_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Customer account name")
    amount: Money = Field(description="Amount. Contains two sub-fields:<br> 1. Value: Transaction amount, including the cents<br> 2. Currency: Currency code based on ISO ")
    additional_info: Optional[Dict[str, Any]] = Field(default=None, description="Additional information")
    __properties: ClassVar[List[str]] = ["responseCode", "responseMessage", "referenceNo", "partnerReferenceNo", "sessionId", "customerNumber", "customerName", "amount", "additionalInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransferToDanaResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransferToDanaResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "responseCode": obj.get("responseCode"),
            "responseMessage": obj.get("responseMessage"),
            "referenceNo": obj.get("referenceNo"),
            "partnerReferenceNo": obj.get("partnerReferenceNo"),
            "sessionId": obj.get("sessionId"),
            "customerNumber": obj.get("customerNumber"),
            "customerName": obj.get("customerName"),
            "amount": Money.from_dict(obj["amount"]) if obj.get("amount") is not None else None,
            "additionalInfo": obj.get("additionalInfo")
        })
        return _obj


