# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Merchant Management API

    API for merchant management operations in DANA

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dana.merchant_management.v1.models.address_info import AddressInfo
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class DivisionResourceInfo(BaseModel, BaseSdkModel):
    """
    DivisionResourceInfo
    """ # noqa: E501
    division_id: Optional[StrictStr] = Field(default=None, description="Division identifier")
    merchant_id: Optional[StrictStr] = Field(default=None, description="Merchant identifier")
    parent_role_type: Optional[StrictStr] = Field(default=None, description="Parent role type")
    contact_address: Optional[AddressInfo] = Field(default=None)
    division_description: Optional[StrictStr] = Field(default=None, description="Division description")
    division_type: Optional[StrictStr] = Field(default=None, description="Division type")
    division_name: Optional[StrictStr] = Field(default=None, description="Division name")
    external_division_id: Optional[StrictStr] = Field(default=None, description="External division identifier")
    pg_division_flag: Optional[StrictStr] = Field(default=None, description="Flag if division is type PG")
    __properties: ClassVar[List[str]] = ["divisionId", "merchantId", "parentRoleType", "contactAddress", "divisionDescription", "divisionType", "divisionName", "externalDivisionId", "pgDivisionFlag"]

    @field_validator('parent_role_type')
    def parent_role_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MERCHANT', 'DIVISION', 'EXTERNAL_DIVISION']):
            raise ValueError("must be one of enum values ('MERCHANT', 'DIVISION', 'EXTERNAL_DIVISION')")
        return value

    @field_validator('division_type')
    def division_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['REGION', 'AREA', 'BRANCH', 'OUTLET', 'STORE', 'KIOSK', 'STALL', 'COUNTER', 'BOOTH', 'POINT_OF_SALE', 'VENDING_MACHINE']):
            raise ValueError("must be one of enum values ('REGION', 'AREA', 'BRANCH', 'OUTLET', 'STORE', 'KIOSK', 'STALL', 'COUNTER', 'BOOTH', 'POINT_OF_SALE', 'VENDING_MACHINE')")
        return value

    @field_validator('pg_division_flag')
    def pg_division_flag_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DivisionResourceInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of contact_address
        if self.contact_address:
            _dict['contactAddress'] = self.contact_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DivisionResourceInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            # If it's a string (JSON), try to parse it
            if isinstance(obj, str):
                try:
                    obj = json.loads(obj)
                except json.JSONDecodeError:
                    return cls.model_validate(obj)
            else:
                return cls.model_validate(obj)

        
        # Handle OPEN_API nested response format: {"response": {"head": {...}, "body": {...}}}
        # Check if this is a response model and has nested structure
        if "DivisionResourceInfo".endswith("Response") and "response" in obj and "body" in obj["response"]:
            # For OPEN_API nested format, pass the nested response structure directly
            _obj = cls.model_validate({
                "divisionId": obj.get("divisionId"),
                "merchantId": obj.get("merchantId"),
                "parentRoleType": obj.get("parentRoleType"),
                "contactAddress": AddressInfo.from_dict(obj["contactAddress"]) if obj.get("contactAddress") is not None else None,
                "divisionDescription": obj.get("divisionDescription"),
                "divisionType": obj.get("divisionType"),
                "divisionName": obj.get("divisionName"),
                "externalDivisionId": obj.get("externalDivisionId"),
                "pgDivisionFlag": obj.get("pgDivisionFlag")
            })
        else:
            # For flat format, pass the object as-is
            _obj = cls.model_validate({
                "divisionId": obj.get("divisionId"),
                "merchantId": obj.get("merchantId"),
                "parentRoleType": obj.get("parentRoleType"),
                "contactAddress": AddressInfo.from_dict(obj["contactAddress"]) if obj.get("contactAddress") is not None else None,
                "divisionDescription": obj.get("divisionDescription"),
                "divisionType": obj.get("divisionType"),
                "divisionName": obj.get("divisionName"),
                "externalDivisionId": obj.get("externalDivisionId"),
                "pgDivisionFlag": obj.get("pgDivisionFlag")
            })
        
        return _obj


