# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Merchant Management API

    API for merchant management operations in DANA

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class UserName(BaseModel, BaseSdkModel):
    """
    UserName
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, description="First name")
    last_name: Optional[StrictStr] = Field(default=None, description="Last name")
    __properties: ClassVar[List[str]] = ["firstName", "lastName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserName from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserName from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            # If it's a string (JSON), try to parse it
            if isinstance(obj, str):
                try:
                    obj = json.loads(obj)
                except json.JSONDecodeError:
                    return cls.model_validate(obj)
            else:
                return cls.model_validate(obj)

        
        # Handle OPEN_API nested response format: {"response": {"head": {...}, "body": {...}}}
        # Check if this is a response model and has nested structure
        if "UserName".endswith("Response") and "response" in obj and "body" in obj["response"]:
            # For OPEN_API nested format, pass the nested response structure directly
            _obj = cls.model_validate({
                "firstName": obj.get("firstName"),
                "lastName": obj.get("lastName")
            })
        else:
            # For flat format, pass the object as-is
            _obj = cls.model_validate({
                "firstName": obj.get("firstName"),
                "lastName": obj.get("lastName")
            })
        
        return _obj


