(function(){"use strict";RB.DatagridPage=RB.Page.extend({defaults:_.defaults({count:0,localSiteName:null},RB.Page.prototype.defaults),rowObjectType:null,initialize:function initialize(){var _this=this;this.selection=new Backbone.Collection([],{model:this.rowObjectType});this.listenTo(this.selection,"add remove reset",function(){return _this.set("count",_this.selection.length)})},select:function select(id){var localSiteName=this.get("localSiteName");this.selection.add({id:id,localSitePrefix:localSiteName?"s/".concat(localSiteName,"/"):null})},unselect:function unselect(id){this.selection.remove(this.selection.get(id))},clearSelection:function clearSelection(){this.selection.reset()}});"use strict";RB.Dashboard=RB.DatagridPage.extend({rowObjectType:RB.ReviewRequest,closeReviewRequests:function closeReviewRequests(options){var reviewRequests=this.selection.clone();var successes=[];var failures=[];function closeNext(){if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");options.onDone(successes,failures);return}var reviewRequest=reviewRequests.shift();reviewRequest.close({type:options.closeType,success:function success(){return successes.push(reviewRequest)},error:function error(){return failures.push(reviewRequest)},complete:closeNext.bind(this)})}closeNext.call(this)},updateVisibility:function updateVisibility(visibilityFunc){var reviewRequests=this.selection.clone();var successes=[];var failures=[];function hideNext(){var _this=this;if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");return}var reviewRequest=reviewRequests.shift();visibilityFunc(reviewRequest,{success:function success(){successes.push(reviewRequest);hideNext.call(_this)},error:function error(){failures.push(reviewRequest);hideNext.call(_this)}})}hideNext.call(this)}});"use strict";RB.DatagridPageView=RB.PageView.extend({RELOAD_INTERVAL_MS:5*60*1e3,actionsViewType:null,events:{"change tbody input[data-checkbox-name=select]":"_onRowSelected","reloaded .datagrid-wrapper":"_setupDatagrid"},initialize:function initialize(){var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};RB.PageView.prototype.initialize.call(this,options);this.periodicReload=!!options.periodicReload;this._reloadTimer=null;this._datagrid=null;this._$wrapper=null;this._$datagridBody=null;this._$datagridBodyContainer=null;this._menuShown=false},renderPage:function renderPage(){var _this=this;RB.InfoboxManagerView.getInstance().setPositioning(RB.ReviewRequestInfoboxView,{side:"Ll",LDistance:300,lDistance:20,yOffset:-20});if(this.actionsViewType){this._setupActionsDrawer()}this.listenTo(this.model,"refresh",function(){return _this._reload(false)});this._setupDatagrid();if(this.periodicReload){this._startReloadTimer()}return this},onResize:function onResize(){if(this._datagrid!==null){this._datagrid.resizeToFit()}},_setupActionsDrawer:function _setupActionsDrawer(){var _this2=this;var drawer=new RB.DrawerView;this.setDrawer(drawer);this._actionsView=new this.actionsViewType({model:this.model,datagridView:this});this._actionsView.render().$el.appendTo(drawer.$content);this.listenTo(this.model,"change:count",function(model,count){var showMenu=count>0;if(showMenu===_this2._menuShown){return}if(showMenu){_this2._showActions();_this2._stopReloadTimer()}else{_this2._hideActions();if(_this2.periodicReload){_this2._startReloadTimer()}}_this2._menuShown=showMenu})},_setupDatagrid:function _setupDatagrid(){var _this3=this;this._$wrapper=this.$("#content_container");this._$datagrid=this._$wrapper.find(".datagrid-wrapper");this._datagrid=this._$datagrid.data("datagrid");this._$main=this._$wrapper.find(".datagrid-main");this.$("time.timesince").timesince();this.$(".user").user_infobox();this.$(".bugs").find("a").bug_infobox();this.$(".review-request-link").review_request_infobox();this.model.clearSelection();_.each(this.$("input[data-checkbox-name=select]:checked"),function(checkbox){return _this3.model.select($(checkbox).data("object-id"))});if(RB.UserSession.instance.get("authenticated")){this._starManager=new RB.StarManagerView({model:new RB.StarManager,el:this._$main,datagridMode:true})}this._$datagrid.on("reloaded",this._setupDatagrid.bind(this)).on("datagridDisplayModeChanged",this._reselectBatchCheckboxes.bind(this));this._datagrid.resizeToFit()},_reselectBatchCheckboxes:function _reselectBatchCheckboxes(){var checkboxMap={};this.$("input[data-checkbox-name=select]").each(function(idx,checkboxEl){if(checkboxEl.checked){checkboxEl.checked=false}checkboxMap[checkboxEl.dataset.objectId]=checkboxEl});this.model.selection.each(function(selection){checkboxMap[selection.id].checked=true})},_showActions:function _showActions(){this.drawer.show()},_hideActions:function _hideActions(){this.drawer.hide()},_startReloadTimer:function _startReloadTimer(){if(!this._reloadTimer){this._reloadTimer=setInterval(this._reload.bind(this),this.RELOAD_INTERVAL_MS)}},_stopReloadTimer:function _stopReloadTimer(){if(this._reloadTimer){window.clearInterval(this._reloadTimer);this._reloadTimer=null}},_reload:function _reload(periodicReload){var _this4=this;var $editCols=this.$(".edit-columns");if(periodicReload===false){this._stopReloadTimer()}this.model.clearSelection();$editCols.width($editCols.width()-$editCols.getExtents("b","lr")).html('<span class="fa fa-spinner fa-pulse"></span>');this._$wrapper.load(window.location+" #content_container",function(){_this4.$(".datagrid-wrapper").datagrid();_this4._setupDatagrid();if(periodicReload!==false){_this4._startReloadTimer()}})},_onRowSelected:function _onRowSelected(e){var $checkbox=$(e.target);var objectID=$checkbox.data("object-id");if($checkbox.prop("checked")){this.model.select(objectID)}else{this.model.unselect(objectID)}}});"use strict";(function(){var DashboardActionsView=Backbone.View.extend({template:_.template('<p class="rb-c-drawer__summary"></p>\n<% if (!read_only) { %>\n <div class="rb-c-drawer__actions">\n  <ul class="rb-c-drawer__action-group">\n   <li class="rb-c-drawer__action js-action-discard">\n    <%= close_discarded_text %>\n   </li>\n   <li class="rb-c-drawer__action js-action-submit">\n    <%= close_submitted_text %>\n   </li>\n  </ul>\n  <ul class="rb-c-drawer__action-group">\n   <li class="rb-c-drawer__action js-action-archive">\n    <%= archive_text %>\n   </li>\n   <% if (show_archived) { %>\n    <li class="rb-c-drawer__action\n               js-action-unarchive">\n     <%= unarchive_text %>\n    </li>\n   <% } %>\n  </ul>\n  <ul class="rb-c-drawer__action-group">\n   <li class="rb-c-drawer__action js-action-mute">\n    <%= mute_text %></a></li>\n   </li>\n   <% if (show_archived) { %>\n    <li class="rb-c-drawer__action js-action-unmute">\n     <%= unmute_text %>\n    </li>\n   <% } %>\n  </ul>\n </div>\n<% } %>'),events:{"click .js-action-discard":"_onCloseDiscardedClicked","click .js-action-submit":"_onCloseSubmittedClicked","click .js-action-archive":"_onArchiveClicked","click .js-action-unarchive":"_onUnarchiveClicked","click .js-action-mute":"_onMuteClicked","click .js-action-unmute":"_onUnmuteClicked"},render:function render(){var show_archived=(this.model.get("data")||{}).show_archived;this.$el.html(this.template({close_discarded_text:gettext("<b>Close</b> Discarded"),close_submitted_text:gettext("<b>Close</b> Submitted"),archive_text:gettext("<b>Archive</b>"),mute_text:gettext("<b>Mute</b>"),read_only:RB.UserSession.instance.get("readOnly"),unarchive_text:gettext("<b>Unarchive</b>"),unmute_text:gettext("<b>Unmute</b>"),show_archived:show_archived}));var $summary=this.$(".rb-c-drawer__summary");this.listenTo(this.model,"change:count",function(model,count){$summary.text(interpolate(ngettext("%s review request selected","%s review requests selected",count),[count]))});return this},_onCloseDiscardedClicked:function _onCloseDiscardedClicked(ev){ev.stopPropagation();ev.preventDefault();this._closeReviewRequests(RB.ReviewRequest.CLOSE_DISCARDED)},_onCloseSubmittedClicked:function _onCloseSubmittedClicked(ev){ev.stopPropagation();ev.preventDefault();this._closeReviewRequests(RB.ReviewRequest.CLOSE_SUBMITTED)},_closeReviewRequests:function _closeReviewRequests(closeType){var _this=this;this._confirmClose(function(){_this.model.closeReviewRequests({closeType:closeType,onDone:_this._showCloseResults.bind(_this)})})},_showCloseResults:function _showCloseResults(successes,failures){var numSuccesses=successes.length;var numFailures=failures.length;var $dlg=$("<div/>").append($("<p/>").text(interpolate(ngettext("%s review request has been closed.","%s review requests have been closed.",numSuccesses),[numSuccesses])));if(numFailures>0){$dlg.append($("<p/>").text(interpolate(ngettext("%s review request could not be closed.","%s review requests could not be closed.",numFailures),[numFailures]))).append($("<p/>").text(gettext("You may not have permission to close them.")))}$dlg.modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Thanks!"))]})},_confirmClose:function _confirmClose(onConfirmed){$("<div/>").append($("<p/>").text(gettext("If these review requests have unpublished drafts, they will be discarded."))).append($("<p/>").text(gettext("Are you sure you want to close these review requests?"))).modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Close Review Requests")).click(onConfirmed.bind(this))]})},_onArchiveClicked:function _onArchiveClicked(ev){ev.stopPropagation();ev.preventDefault();var collection=RB.UserSession.instance.archivedReviewRequests;this._updateVisibility(collection.addImmediately.bind(collection))},_onUnarchiveClicked:function _onUnarchiveClicked(ev){ev.stopPropagation();ev.preventDefault();var collection=RB.UserSession.instance.archivedReviewRequests;this._updateVisibility(collection.removeImmediately.bind(collection))},_onMuteClicked:function _onMuteClicked(ev){ev.stopPropagation();ev.preventDefault();var collection=RB.UserSession.instance.mutedReviewRequests;var visibilityFunc=collection.addImmediately.bind(collection);$("<div/>").append($("<p/>").text(gettext("Are you sure you want to mute these review requests?"))).modalBox({title:gettext("Mute review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Mute Review Requests")).click(this._updateVisibility.bind(this,visibilityFunc))]})},_onUnmuteClicked:function _onUnmuteClicked(ev){ev.stopPropagation();ev.preventDefault();var collection=RB.UserSession.instance.mutedReviewRequests;this._updateVisibility(collection.removeImmediately.bind(collection))},_updateVisibility:function _updateVisibility(visibilityFunc){this.model.updateVisibility(visibilityFunc)}});RB.DashboardView=RB.DatagridPageView.extend({actionsViewType:DashboardActionsView})})()}).call(this);
