from typing import Any, Callable, Protocol, TypeVar


T = TypeVar("T")


class Channel(Protocol[T]):
    async def send(self, type: str, event: str, payload: T) -> None: ...

    async def on(self, type: str, event: str, callback: Callable[[T], Any]) -> None: ...

    async def subscribe(self): ...

    async def unsubscribe(self): ...

    async def close(self) -> None: ...


class Realtime(Protocol[T]):
    async def channel(self, name: str, opts: dict[str, Any]) -> Channel[T]: ...

    async def get_channels(self) -> list[Channel[T]]: ...

    async def remove_channel(self, channel: Channel[T]) -> None: ...

    async def remove_all_channels(self) -> None: ...
