from .qzss_dcr_definition import QzssDcrDefinition

qzss_dcr_jma_flood_forecast_region = QzssDcrDefinition(
    {
        10175000100: "新川(北海道道央)",
        19999999999: "北海道のその他の河川",
        20036000100: "堤川・駒込川(青森県)",
        29999999999: "青森県のその他の河川",
        39999999999: "岩手県のその他の河川",
        40028000100: "七北田川(宮城県)",
        49999999999: "宮城県のその他の河川",
        59999999999: "秋田県のその他の河川",
        60016000100: "日向川(山形県)",
        69999999999: "山形県のその他の河川",
        70006000100: "宇多川(福島県)",
        70010000100: "新田川(福島県)",
        70028000100: "夏井川(福島県)",
        79999999999: "福島県のその他の河川",
        89999999999: "茨城県のその他の河川",
        99999999999: "栃木県のその他の河川",
        109999999999: "群馬県のその他の河川",
        119999999999: "埼玉県のその他の河川",
        129999999999: "千葉県のその他の河川",
        130005000100: "目黒川(東京都)",
        130006000100: "渋谷川・古川(東京都)",
        139999999999: "東京都のその他の河川",
        140019000100: "酒匂川(神奈川県)",
        149999999999: "神奈川県のその他の河川",
        159999999999: "新潟県のその他の河川",
        169999999999: "富山県のその他の河川",
        179999999999: "石川県のその他の河川",
        180006000100: "南川(福井県)",
        180014000100: "笙の川(福井県)",
        189999999999: "福井県のその他の河川",
        199999999999: "山梨県のその他の河川",
        209999999999: "長野県のその他の河川",
        219999999999: "岐阜県のその他の河川",
        220062000100: "瀬戸川・朝比奈川(静岡県)",
        220079000100: "太田川・原野谷川(静岡県)",
        220081000100: "都田川(静岡県)",
        229999999999: "静岡県のその他の河川",
        230029000100: "境川・逢妻川(愛知県)",
        230052000100: "天白川(愛知県)",
        230054000100: "日光川(愛知県)",
        239999999999: "愛知県のその他の河川",
        249999999999: "三重県のその他の河川",
        259999999999: "滋賀県のその他の河川",
        269999999999: "京都府のその他の河川",
        270013000100: "大津川・槇尾川(大阪府)",
        270013000200: "牛滝川(大阪府)",
        279999999999: "大阪府のその他の河川",
        280014000100: "武庫川(兵庫県)",
        280053000100: "市川(兵庫県)",
        280064000100: "千種川(兵庫県)",
        289999999999: "兵庫県のその他の河川",
        299999999999: "奈良県のその他の河川",
        300013000100: "古座川(和歌山県)",
        300066000100: "日高川(和歌山県)",
        300077000100: "有田川(和歌山県)",
        309999999999: "和歌山県のその他の河川",
        310027000100: "由良川(鳥取県)",
        319999999999: "鳥取県のその他の河川",
        320004000100: "益田川(島根県)",
        320011000100: "周布川(島根県)",
        329999999999: "島根県のその他の河川",
        330009000100: "笹ヶ瀬川・足守川(岡山県)",
        339999999999: "岡山県のその他の河川",
        340013000100: "沼田川(広島県)",
        340021000100: "黒瀬川(広島県)",
        349999999999: "広島県のその他の河川",
        350002000102: "錦川下流部(山口県)",
        350002000103: "錦川中流部(山口県)",
        350019000100: "島田川(山口県)",
        350036000100: "椹野川(山口県)",
        350036001900: "仁保川(山口県)",
        350046000100: "厚東川(山口県)",
        359999999999: "山口県のその他の河川",
        360007000100: "勝浦川(徳島県)",
        369999999999: "徳島県のその他の河川",
        370026000100: "香東川(香川県)",
        379999999999: "香川県のその他の河川",
        389999999999: "愛媛県のその他の河川",
        399999999999: "高知県のその他の河川",
        400018000100: "御笠川(福岡県)",
        409999999999: "福岡県のその他の河川",
        419999999999: "佐賀県のその他の河川",
        429999999999: "長崎県のその他の河川",
        439999999999: "熊本県のその他の河川",
        440008000100: "駅館川(大分県)",
        449999999999: "大分県のその他の河川",
        450026000100: "清武川(宮崎県)",
        450040000100: "広渡川(宮崎県)",
        450040000700: "酒谷川(宮崎県)",
        459999999999: "宮崎県のその他の河川",
        460060000100: "万之瀬川・加世田川(鹿児島県)",
        469999999999: "鹿児島県のその他の河川",
        479999999999: "沖縄県のその他の河川",
        809999999999: "沖縄県のその他の河川",
        810101000100: "天塩川(北海道道北)",
        810101008500: "名寄川(北海道道北)",
        810102000100: "留萌川(北海道道北)",
        810103000101: "石狩川上流(北海道道北)",
        810103000102: "石狩川下流(北海道道央)",
        810103003100: "豊平川(北海道道央)",
        810103003101: "石狩川水系豊平川上流(北海道道央)",
        810103008100: "千歳川(北海道道央)",
        810103011900: "夕張川(北海道道央)",
        810103018200: "幾春別川(北海道道央)",
        810103025001: "空知川上流(北海道道北)",
        810103025002: "空知川下流(北海道道央)",
        810103033400: "雨竜川(北海道道央)",
        810103040900: "忠別川(北海道道北)",
        810103041000: "美瑛川(北海道道北)",
        810103044200: "牛朱別川(北海道道北)",
        810104000100: "尻別川(北海道道央)",
        810105000100: "後志利別川(北海道道南)",
        810106000100: "鵡川(北海道道南)",
        810107000100: "沙流川(北海道道南)",
        810108000100: "十勝川(北海道道東)",
        810108003400: "利別川(北海道道東)",
        810108011400: "札内川(北海道道東)",
        810108013900: "音更川(北海道道東)",
        810108017400: "十勝川水系芽室川(北海道道東)",
        810109000100: "釧路川・新釧路川(北海道道東)",
        810110000100: "網走川(北海道道東)",
        810110001000: "美幌川(北海道道東)",
        810111000100: "常呂川(北海道道東)",
        810111002400: "無加川(北海道道東)",
        810112000100: "湧別川(北海道道東)",
        810113000100: "渚滑川(北海道道東)",
        819999999999: "北海道のその他の河川",
        820201000101: "阿武隈川上流(福島県・宮城県)",
        820201000102: "阿武隈川下流(宮城県)",
        820201000400: "白石川(宮城県)",
        820201009900: "荒川(福島県)",
        820202000100: "名取川(宮城県)",
        820202001100: "広瀬川(宮城県)",
        820203000100: "鳴瀬川(宮城県)",
        820203000400: "吉田川(宮城県)",
        820204000101: "北上川上流(岩手県)",
        820204000102: "北上川下流(宮城県)",
        820204001800: "旧北上川(宮城県)",
        820204001900: "迫川(宮城県)",
        820204007100: "江合川(宮城県)",
        820204035600: "猿ヶ石川(岩手県)",
        820204048200: "雫石川(岩手県)",
        820205000102: "馬淵川下流(青森県)",
        820205000103: "馬淵川中流(青森県)",
        820206000100: "高瀬川(小川原湖)(青森県)",
        820207000100: "岩木川(青森県)",
        820207003500: "十川(青森県)",
        820207006101: "平川上流(青森県)",
        820207006102: "平川下流(青森県)",
        820208000100: "米代川(秋田県)",
        820209000101: "雄物川上流(秋田県)",
        820209000102: "雄物川下流(秋田県)",
        820209000400: "太平川(秋田県)",
        820209005500: "玉川(秋田県)",
        820209018700: "皆瀬川(秋田県)",
        820210000100: "子吉川(秋田県)",
        820211000101: "最上川上流(山形県)",
        820211000102: "最上川下流(山形県)",
        820211000103: "最上川中流(山形県)",
        820211007300: "鮭川(山形県)",
        820211017000: "最上小国川(山形県)",
        820211022100: "丹生川(山形県)",
        820211030701: "須川上流(山形県)",
        820211030702: "須川下流(山形県)",
        820211048700: "屋代川(山形県)",
        820212000100: "赤川(山形県)",
        820212000200: "大山川(山形県)",
        829999999999: "東北地方のその他の河川",
        830301000100: "久慈川(茨城県)",
        830302000100: "那珂川(栃木県・茨城県)",
        830302000101: "那珂川上流部(栃木県)",
        830302008300: "逆川(栃木県)",
        830302009400: "荒川(栃木県)",
        830302014300: "箒川(栃木県)",
        830302014700: "蛇尾川(栃木県)",
        830302018300: "余笹川(栃木県)",
        830303000101: "利根川上流部(群馬県・茨城県・千葉県・埼玉県)",
        830303000102: "利根川下流部(茨城県・千葉県)",
        830303000103: "利根川中流部(茨城県・千葉県)",
        830303002800: "霞ヶ浦・北浦(茨城県・千葉県)",
        830303004600: "桜川(茨城県)",
        830303015200: "小貝川(栃木県・茨城県)",
        830303015201: "小貝川上流部(栃木県)",
        830303017900: "五行川(栃木県)",
        830303020300: "鬼怒川(栃木県・茨城県)",
        830303021100: "田川(栃木県)",
        830303030400: "江戸川(茨城県・埼玉県・東京都・千葉県)",
        830303033900: "中川(埼玉県・東京都)",
        830303033903: "中川中流部(埼玉県)",
        830303036900: "元荒川(埼玉県)",
        830303039200: "新方川(埼玉県)",
        830303039800: "大落古利根川(埼玉県)",
        830303043600: "綾瀬川(谷古宇区間)(埼玉県・東京都)",
        830303043603: "綾瀬川中流部(一の橋区間)(埼玉県)",
        830303046101: "渡良瀬川上流部(群馬県・栃木県)",
        830303046102: "渡良瀬川下流部(栃木県・茨城県・群馬県)",
        830303048000: "思川(栃木県)",
        830303048100: "姿川(栃木県)",
        830303049400: "黒川(栃木県)",
        830303051700: "永野川(栃木県)",
        830303053000: "秋山川(栃木県)",
        830303054800: "袋川(栃木県)",
        830303060000: "石田川(群馬県・埼玉県)",
        830303068900: "烏川流域(群馬県・埼玉県)",
        830303069600: "神流川(群馬県・埼玉県)",
        830304000100: "荒川(埼玉県・東京都)",
        830304000300: "芝川・新芝川(埼玉県・東京都)",
        830304001200: "新河岸川(埼玉県)",
        830304003200: "石神井川(東京都)",
        830304004400: "神田川(東京都)",
        830304004700: "妙正寺川(東京都)",
        830304007000: "越辺川・都幾川・高麗川(埼玉県)",
        830304007100: "入間川・小畔川(埼玉県)",
        830305000100: "多摩川(東京都・神奈川県)",
        830305000500: "野川・仙川(東京都)",
        830305002000: "浅川(東京都)",
        830306000100: "鶴見川(神奈川県)",
        830307000102: "相模川下流(神奈川県)",
        830307000103: "相模川中流(神奈川県)",
        830308000100: "富士川(釜無川を含む)(山梨県・静岡県)",
        830308039500: "笛吹川(山梨県)",
        830308045500: "荒川(山梨県)",
        830308065700: "塩川(山梨県)",
        839999999999: "関東地方のその他の河川",
        840401000100: "荒川(新潟県)",
        840402000100: "阿賀野川(新潟県)",
        840402000101: "阿賀川(福島県)",
        840403000100: "千曲川(長野県)",
        840403000101: "千曲川上流(長野県)",
        840403000102: "信濃川下流・中ノ口川(新潟県)",
        840403000103: "信濃川中流(新潟県)",
        840403000104: "信濃川水系千曲川下流(長野県)",
        840403000105: "信濃川上流(新潟県)",
        840403023700: "魚野川(新潟県)",
        840403070500: "犀川(長野県)",
        840403070600: "裾花川(長野県)",
        840403089800: "奈良井川(長野県)",
        840404000100: "関川(新潟県)",
        840405000100: "姫川(新潟県)",
        840406000100: "黒部川(富山県)",
        840407000100: "常願寺川(富山県)",
        840408000101: "宮川(岐阜県)",
        840408000102: "神通川(富山県)",
        840409000100: "庄川(富山県)",
        840410000100: "小矢部川(富山県)",
        840411000100: "手取川(石川県)",
        840412000100: "梯川(石川県)",
        849999999999: "北陸地方のその他の河川",
        850501000100: "狩野川(静岡県)",
        850502000100: "安倍川(静岡県)",
        850503000100: "大井川(静岡県)",
        850504000100: "菊川(静岡県)",
        850505000101: "天竜川上流(長野県)",
        850505000102: "天竜川下流(静岡県)",
        850505071753: "諏訪湖(長野県)",
        850506000100: "豊川及び豊川放水路(愛知県)",
        850507000100: "矢作川(愛知県)",
        850508000100: "庄内川(岐阜県・愛知県)",
        850508000200: "新川(愛知県)",
        850509000102: "木曽川下流(愛知県・岐阜県・三重県)",
        850509000103: "木曽川中流(岐阜県・愛知県)",
        850509000202: "揖斐川下流(岐阜県・三重県)",
        850509000203: "揖斐川中流(岐阜県)",
        850509000401: "長良川上流(岐阜県)",
        850509000402: "長良川下流(岐阜県・愛知県・三重県)",
        850509000403: "長良川中流(岐阜県)",
        850509025500: "飛騨川(岐阜県)",
        850510000100: "鈴鹿川及び鈴鹿川派川(三重県)",
        850511000100: "雲出川及び雲出古川(三重県)",
        850512000100: "櫛田川(三重県)",
        850513000100: "宮川(三重県)",
        859999999999: "中部地方のその他の河川",
        860601000102: "熊野川下流(三重県・和歌山県)",
        860601000103: "熊野川中流(本宮区間)(和歌山県)",
        860601000105: "熊野川中流(日足区間)(和歌山県)",
        860602000100: "紀の川(奈良県・和歌山県)",
        860603000101: "大和川上流(奈良県・大阪府)",
        860603000102: "大和川下流(奈良県・大阪府)",
        860603001300: "石川(大阪府)",
        860604000101: "瀬田川(滋賀県)",
        860604000102: "淀川(京都府・大阪府)",
        860604000103: "宇治川(京都府・大阪府)",
        860604000600: "寝屋川流域(大阪府)",
        860604004700: "神崎川・安威川(大阪府)",
        860604007300: "猪名川(大阪府・兵庫県)",
        860604016702: "桂川下流(京都府・大阪府)",
        860604016703: "桂川中流・園部川(京都府)",
        860604018200: "鴨川・高野川(京都府)",
        860604037101: "木津川上流(三重県・京都府)",
        860604037102: "木津川下流(京都府)",
        860604051600: "名張川(三重県・奈良県)",
        860604086300: "琵琶湖(滋賀県)",
        860604101200: "姉川(滋賀県)",
        860604101300: "高時川(滋賀県)",
        860604120300: "日野川(滋賀県)",
        860604127501: "野洲川上流(滋賀県)",
        860604127502: "野洲川下流(滋賀県)",
        860604131100: "杣川(滋賀県)",
        860605000101: "加古川上流(兵庫県)",
        860605000102: "加古川下流(兵庫県)",
        860606000101: "揖保川上流(兵庫県)",
        860606000102: "揖保川下流(兵庫県)",
        860607000100: "九頭竜川(福井県)",
        860607000200: "竹田川(福井県)",
        860607001902: "日野川下流(福井県)",
        860607001903: "日野川中流(福井県)",
        860607002200: "足羽川(福井県)",
        860608000100: "北川(福井県)",
        860609000102: "由良川下流(京都府)",
        860609000103: "由良川中流(京都府)",
        860610000100: "円山川(兵庫県)",
        860610002600: "出石川(兵庫県)",
        869999999999: "近畿地方のその他の河川",
        870701000100: "千代川(鳥取県)",
        870701000900: "袋川・新袋川(鳥取県)",
        870702000100: "天神川(鳥取県)",
        870702000300: "小鴨川(鳥取県)",
        870702000400: "国府川(鳥取県)",
        870703000100: "日野川(鳥取県)",
        870703000300: "法勝寺川(鳥取県)",
        870704000100: "斐伊川(島根県)",
        870704002800: "飯梨川(島根県)",
        870704024400: "神戸川(島根県)",
        870705000101: "江の川上流(広島県・島根県)",
        870705000102: "江の川下流(広島県・島根県)",
        870705015700: "神野瀬川(広島県)",
        870705016300: "馬洗川(広島県)",
        870705016400: "西城川(広島県)",
        870706000100: "高津川(島根県)",
        870706001700: "匹見川(島根県)",
        870707000100: "佐波川(山口県)",
        870708000100: "小瀬川(広島県・山口県)",
        870709000101: "太田川上流(広島県)",
        870709000102: "太田川下流(広島県)",
        870709002900: "三篠川(広島県)",
        870709004700: "根谷川(広島県)",
        870710000100: "芦田川(広島県)",
        870710001100: "高屋川(広島県)",
        870711000100: "高梁川(岡山県)",
        870711000500: "小田川(岡山県)",
        870712000100: "旭川(岡山県)",
        870712000103: "旭川水系旭川中流部(岡山県)",
        870712000400: "百間川(岡山県)",
        870713000100: "吉井川(岡山県)",
        870713002800: "金剛川(岡山県)",
        879999999999: "中国地方のその他の河川",
        880801000100: "重信川(愛媛県)",
        880802000100: "肱川(愛媛県)",
        880803000100: "四万十川(高知県)",
        880804000100: "仁淀川(高知県)",
        880805000100: "物部川(高知県)",
        880806000100: "那賀川(徳島県)",
        880807000100: "吉野川(徳島県)",
        880808000100: "土器川(香川県)",
        889999999999: "四国地方のその他の河川",
        890901000101: "遠賀川上流部(福岡県)",
        890901000102: "遠賀川下流部(福岡県)",
        890901010300: "彦山川(福岡県)",
        890902000100: "松浦川(佐賀県)",
        890902001300: "徳須恵川(佐賀県)",
        890902004900: "厳木川(佐賀県)",
        890903000100: "本明川(長崎県)",
        890904000100: "六角川(佐賀県)",
        890904000300: "牛津川(佐賀県)",
        890905000100: "嘉瀬川(佐賀県)",
        890906000102: "筑後川下流部(福岡県・佐賀県)",
        890906000104: "筑後川上中流部(大分県・福岡県)",
        890907000100: "矢部川(福岡県)",
        890908000100: "菊池川水系(熊本県)",
        890909000100: "白川(熊本県)",
        890910000100: "緑川水系(熊本県)",
        890911000100: "球磨川(熊本県)",
        890912000101: "川内川上流部(宮崎県・鹿児島県)",
        890912000102: "川内川下流部(鹿児島県)",
        890913000100: "肝属川水系(鹿児島県)",
        890914000101: "大淀川上流部(宮崎県)",
        890914000102: "大淀川下流部(宮崎県)",
        890914003300: "本庄川(宮崎県)",
        890915000100: "小丸川(宮崎県)",
        890916000100: "五ヶ瀬川・大瀬川(宮崎県)",
        890917000100: "番匠川(大分県)",
        890918000100: "大野川水系(大分県)",
        890919000100: "大分川(大分県)",
        890919001100: "七瀬川(大分県)",
        890920000101: "山国川上流部(大分県・福岡県)",
        890920000102: "山国川下流部(大分県・福岡県)",
        899999999999: "九州地方のその他の河川",
    },
    prefix={
        1: "北海道の河川(コード番号：%d)",
        2: "青森県の河川(コード番号：%d)",
        3: "岩手県の河川(コード番号：%d)",
        4: "宮城県の河川(コード番号：%d)",
        5: "秋田県の河川(コード番号：%d)",
        6: "山形県の河川(コード番号：%d)",
        7: "福島県の河川(コード番号：%d)",
        8: "茨城県の河川(コード番号：%d)",
        9: "栃木県の河川(コード番号：%d)",
        10: "群馬県の河川(コード番号：%d)",
        11: "埼玉県の河川(コード番号：%d)",
        12: "千葉県の河川(コード番号：%d)",
        13: "東京都の河川(コード番号：%d)",
        14: "神奈川県の河川(コード番号：%d)",
        15: "新潟県の河川(コード番号：%d)",
        16: "富山県の河川(コード番号：%d)",
        17: "石川県の河川(コード番号：%d)",
        18: "福井県の河川(コード番号：%d)",
        19: "山梨県の河川(コード番号：%d)",
        20: "長野県の河川(コード番号：%d)",
        21: "岐阜県の河川(コード番号：%d)",
        22: "静岡県の河川(コード番号：%d)",
        23: "愛知県の河川(コード番号：%d)",
        24: "三重県の河川(コード番号：%d)",
        25: "滋賀県の河川(コード番号：%d)",
        26: "京都府の河川(コード番号：%d)",
        27: "大阪府の河川(コード番号：%d)",
        28: "兵庫県の河川(コード番号：%d)",
        29: "奈良県の河川(コード番号：%d)",
        30: "和歌山県の河川(コード番号：%d)",
        31: "鳥取県の河川(コード番号：%d)",
        32: "島根県の河川(コード番号：%d)",
        33: "岡山県の河川(コード番号：%d)",
        34: "広島県の河川(コード番号：%d)",
        35: "山口県の河川(コード番号：%d)",
        36: "徳島県の河川(コード番号：%d)",
        37: "香川県の河川(コード番号：%d)",
        38: "愛媛県の河川(コード番号：%d)",
        39: "高知県の河川(コード番号：%d)",
        40: "福岡県の河川(コード番号：%d)",
        41: "佐賀県の河川(コード番号：%d)",
        42: "長崎県の河川(コード番号：%d)",
        43: "熊本県の河川(コード番号：%d)",
        44: "大分県の河川(コード番号：%d)",
        45: "宮崎県の河川(コード番号：%d)",
        46: "鹿児島県の河川(コード番号：%d)",
        47: "沖縄県の河川(コード番号：%d)",
        80: "沖縄県の河川(コード番号：%d)",
        81: "北海道の河川(コード番号：%d)",
        82: "東北地方の河川(コード番号：%d)",
        83: "関東地方の河川(コード番号：%d)",
        84: "北陸地方の河川(コード番号：%d)",
        85: "中部地方の河川(コード番号：%d)",
        86: "近畿地方の河川(コード番号：%d)",
        87: "中国地方の河川(コード番号：%d)",
        88: "四国地方の河川(コード番号：%d)",
        89: "九州地方の河川(コード番号：%d)",
    },
    prefix_extractor=lambda x:int(x / 10 ** 10),
    undefined="河川(コード番号：%d)"
)
