"""
[summary]

[extended_summary]
"""

# region [Imports]


import gc
import os
import re
import sys
import json
import lzma
import time
import queue
import base64
import pickle
import random
import shelve
import shutil
import asyncio
import logging
import sqlite3
import platform
import importlib
import subprocess
import unicodedata

from io import BytesIO
from abc import ABC, abstractmethod
from copy import copy, deepcopy
from enum import Enum, Flag, auto
from time import time, sleep
from pprint import pprint, pformat
from string import Formatter, digits, printable, whitespace, punctuation, ascii_letters, ascii_lowercase, ascii_uppercase
from timeit import Timer
from typing import Union, Callable, Iterable
from inspect import stack, getdoc, getmodule, getsource, getmembers, getmodulename, getsourcefile, getfullargspec, getsourcelines
from zipfile import ZipFile
from datetime import tzinfo, datetime, timezone, timedelta
from tempfile import TemporaryDirectory
from textwrap import TextWrapper, fill, wrap, dedent, indent, shorten
from functools import wraps, partial, lru_cache, singledispatch, total_ordering
from importlib import import_module, invalidate_caches
from contextlib import contextmanager
from statistics import mean, mode, stdev, median, variance, pvariance, harmonic_mean, median_grouped
from collections import Counter, ChainMap, deque, namedtuple, defaultdict
from urllib.parse import urlparse
from importlib.util import find_spec, module_from_spec, spec_from_file_location
from concurrent.futures import ThreadPoolExecutor, ProcessPoolExecutor
from importlib.machinery import SourceFileLoader
from enum import Enum, Flag, unique, auto


import gidlogger as glog

# endregion[Imports]

# region [TODO]


# endregion [TODO]

# region [AppUserData]


# endregion [AppUserData]

# region [Logging]

log = glog.aux_logger(__name__)
log.info(glog.imported(__name__))

# endregion[Logging]

# region [Constants]

THIS_FILE_DIR = os.path.abspath(os.path.dirname(__file__))

# endregion[Constants]


ModFileItem = namedtuple('ModFileItem', ['html', 'image'])


class DelayedLock(asyncio.Lock):

    def __init__(self, delay: float = 1) -> None:
        super().__init__()
        self.delay = delay

    def release(self) -> None:
        asyncio.create_task(self._release_task())

    async def _release_task(self) -> None:
        await asyncio.sleep(self.delay)
        return super().release()


class DelayedSemaphore(asyncio.Semaphore):

    def __init__(self, value: int, delay: float = 1) -> None:
        super().__init__(value=value)
        self.delay = delay

    def release(self) -> None:
        asyncio.create_task(self._release_task())

    async def _release_task(self) -> None:
        await asyncio.sleep(self.delay)
        return super().release()


@unique
class ServerStatus(Enum):
    ON = auto()
    OFF = auto()

    @classmethod
    def _missing_(cls, value):
        if isinstance(value, bool):
            if value is True:
                return cls.ON
            return cls.OFF
        return super()._missing_(value)


class ServerStatusDeque(deque):

    def __init__(self) -> None:
        super().__init__(iterable=[None, None], maxlen=2)

    @property
    def current_status(self) -> ServerStatus:
        return self[1]

    @property
    def previous_status(self) -> ServerStatus:
        return self[0]

    async def add_new_status(self, status: ServerStatus):
        self.append(status)
        has_changed = await self._check_changed()
        log.debug("added new status, status has changed = %s", has_changed)
        return has_changed

    async def _check_changed(self):
        if None in self:
            return False
        return len(set(self)) != 1

# region[Main_Exec]


if __name__ == '__main__':
    pass

# endregion[Main_Exec]
