"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const core_1 = require("aws-cdk-lib/core");
const bundling_1 = require("./bundling");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
/**
 * A Python Lambda function
 */
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PythonFunction);
            }
            throw error;
        }
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace(/\//g, '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                skip: !core_1.Stack.of(scope).bundlingRequired,
                // define architecture based on the target architecture of the function, possibly overridden in bundling options
                architecture: props.architecture,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonFunction", version: "2.190.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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